/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileReader;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.BlockWithScanInfo;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.io.hfile.PrefetchExecutor;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.io.WritableUtils;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

@InterfaceAudience.Private
public class HFileReaderV2
extends AbstractHFileReader {
    private static final Log LOG = LogFactory.getLog(HFileReaderV2.class);
    public static final int MINOR_VERSION_WITH_CHECKSUM = 1;
    public static final int MINOR_VERSION_NO_CHECKSUM = 0;
    public static final int PBUF_TRAILER_MINOR_VERSION = 2;
    public static final int KEY_VALUE_LEN_SIZE = 8;
    protected boolean includesMemstoreTS = false;
    protected boolean decodeMemstoreTS = false;
    protected HFileBlock.FSReader fsBlockReader;
    private IdLock offsetLock = new IdLock();
    private List<HFileBlock> loadOnOpenBlocks = new ArrayList<HFileBlock>();
    static final int MIN_MINOR_VERSION = 0;
    static final int MAX_MINOR_VERSION = 3;
    static final int MINOR_VERSION_WITH_FAKED_KEY = 3;
    protected HFileContext hfileContext;

    protected boolean shouldIncludeMemstoreTS() {
        return this.includesMemstoreTS;
    }

    public HFileReaderV2(final Path path, FixedFileTrailer trailer, FSDataInputStreamWrapper fsdis, long size, CacheConfig cacheConf, HFileSystem hfs, Configuration conf) throws IOException {
        super(path, trailer, size, cacheConf, hfs, conf);
        HFileBlock b;
        this.conf = conf;
        trailer.expectMajorVersion(this.getMajorVersion());
        this.validateMinorVersion(path, trailer.getMinorVersion());
        this.hfileContext = this.createHFileContext(fsdis, this.fileSize, hfs, path, trailer);
        HFileBlock.FSReaderImpl fsBlockReaderV2 = new HFileBlock.FSReaderImpl(fsdis, this.fileSize, hfs, path, this.hfileContext);
        this.fsBlockReader = fsBlockReaderV2;
        this.comparator = trailer.createComparator();
        this.dataBlockIndexReader = new HFileBlockIndex.BlockIndexReader(this.comparator, trailer.getNumDataIndexLevels(), this);
        this.metaBlockIndexReader = new HFileBlockIndex.BlockIndexReader(KeyValue.RAW_COMPARATOR, 1);
        HFileBlock.BlockIterator blockIter = fsBlockReaderV2.blockRange(trailer.getLoadOnOpenDataOffset(), this.fileSize - (long)trailer.getTrailerSize());
        this.dataBlockIndexReader.readMultiLevelIndexRoot(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), trailer.getDataIndexCount());
        this.metaBlockIndexReader.readRootIndex(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), trailer.getMetaIndexCount());
        this.fileInfo = new HFile.FileInfo();
        this.fileInfo.read(blockIter.nextBlockWithBlockType(BlockType.FILE_INFO).getByteStream());
        this.lastKey = this.fileInfo.get(HFile.FileInfo.LASTKEY);
        this.avgKeyLen = Bytes.toInt((byte[])this.fileInfo.get(HFile.FileInfo.AVG_KEY_LEN));
        this.avgValueLen = Bytes.toInt((byte[])this.fileInfo.get(HFile.FileInfo.AVG_VALUE_LEN));
        byte[] keyValueFormatVersion = this.fileInfo.get(HFileWriterV2.KEY_VALUE_VERSION);
        this.includesMemstoreTS = keyValueFormatVersion != null && Bytes.toInt((byte[])keyValueFormatVersion) == 1;
        fsBlockReaderV2.setIncludesMemstoreTS(this.includesMemstoreTS);
        if (this.includesMemstoreTS) {
            this.decodeMemstoreTS = Bytes.toLong((byte[])this.fileInfo.get(HFileWriterV2.MAX_MEMSTORE_TS_KEY)) > 0L;
        }
        this.dataBlockEncoder = HFileDataBlockEncoderImpl.createFromFileInfo(this.fileInfo);
        fsBlockReaderV2.setDataBlockEncoder(this.dataBlockEncoder);
        while ((b = blockIter.nextBlock()) != null) {
            this.loadOnOpenBlocks.add(b);
        }
        if (cacheConf.shouldPrefetchOnOpen()) {
            PrefetchExecutor.request(path, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HFileBlock block;
                        long end = HFileReaderV2.this.fileSize - (long)HFileReaderV2.this.getTrailer().getTrailerSize();
                        HFileBlock prevBlock = null;
                        for (long offset = 0L; offset < end; offset += (long)block.getOnDiskSizeWithHeader()) {
                            if (Thread.interrupted()) {
                                break;
                            }
                            long onDiskSize = -1L;
                            if (prevBlock != null) {
                                onDiskSize = prevBlock.getNextBlockOnDiskSizeWithHeader();
                            }
                            prevBlock = block = HFileReaderV2.this.readBlock(offset, onDiskSize, true, false, false, false, null, null);
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Exception encountered while prefetching " + path + ":"), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Exception encountered while prefetching " + path + ":"), (Throwable)e);
                    }
                    finally {
                        PrefetchExecutor.complete(path);
                    }
                }
            });
        }
    }

    protected HFileContext createHFileContext(FSDataInputStreamWrapper fsdis, long fileSize, HFileSystem hfs, Path path, FixedFileTrailer trailer) throws IOException {
        return new HFileContextBuilder().withIncludesMvcc(this.includesMemstoreTS).withCompression(this.compressAlgo).withHBaseCheckSum(trailer.getMinorVersion() >= 1).build();
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        if (this.dataBlockEncoder.useEncodedScanner()) {
            return new EncodedScannerV2(this, cacheBlocks, pread, isCompaction, this.hfileContext);
        }
        return new ScannerV2(this, cacheBlocks, pread, isCompaction);
    }

    private HFileBlock getCachedBlock(BlockCacheKey cacheKey, boolean cacheBlock, boolean useLock, boolean isCompaction, boolean updateCacheMetrics, BlockType expectedBlockType, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
        BlockCache cache;
        HFileBlock cachedBlock;
        if (this.cacheConf.isBlockCacheEnabled() && (cachedBlock = (HFileBlock)(cache = this.cacheConf.getBlockCache()).getBlock(cacheKey, cacheBlock, useLock, updateCacheMetrics)) != null) {
            if (this.cacheConf.shouldCacheCompressed(cachedBlock.getBlockType().getCategory())) {
                cachedBlock = cachedBlock.unpack(this.hfileContext, this.fsBlockReader);
            }
            this.validateBlockType(cachedBlock, expectedBlockType);
            if (expectedDataBlockEncoding == null) {
                return cachedBlock;
            }
            DataBlockEncoding actualDataBlockEncoding = cachedBlock.getDataBlockEncoding();
            if (cachedBlock.getBlockType().isData() && !actualDataBlockEncoding.equals((Object)expectedDataBlockEncoding)) {
                if (!expectedDataBlockEncoding.equals((Object)DataBlockEncoding.NONE) && !actualDataBlockEncoding.equals((Object)DataBlockEncoding.NONE)) {
                    LOG.info((Object)("Evicting cached block with key " + cacheKey + " because of a data block encoding mismatch" + "; expected: " + expectedDataBlockEncoding + ", actual: " + actualDataBlockEncoding));
                    cache.evictBlock(cacheKey);
                }
                return null;
            }
            return cachedBlock;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getMetaBlock(String metaBlockName, boolean cacheBlock) throws IOException {
        if (this.trailer.getMetaIndexCount() == 0) {
            return null;
        }
        if (this.metaBlockIndexReader == null) {
            throw new IOException("Meta index not loaded");
        }
        byte[] mbname = Bytes.toBytes((String)metaBlockName);
        int block = this.metaBlockIndexReader.rootBlockContainingKey(mbname, 0, mbname.length);
        if (block == -1) {
            return null;
        }
        long blockSize = this.metaBlockIndexReader.getRootBlockDataSize(block);
        byte[] byArray = this.metaBlockIndexReader.getRootBlockKey(block);
        synchronized (byArray) {
            HFileBlock cachedBlock;
            long metaBlockOffset = this.metaBlockIndexReader.getRootBlockOffset(block);
            BlockCacheKey cacheKey = new BlockCacheKey(this.name, metaBlockOffset);
            if (this.cacheConf.isBlockCacheEnabled() && (cachedBlock = this.getCachedBlock(cacheKey, cacheBlock &= this.cacheConf.shouldCacheDataOnRead(), false, true, true, BlockType.META, null)) != null) {
                assert (cachedBlock.isUnpacked()) : "Packed block leak.";
                return cachedBlock.getBufferWithoutHeader();
            }
            HFileBlock metaBlock = this.fsBlockReader.readBlockData(metaBlockOffset, blockSize, -1, true).unpack(this.hfileContext, this.fsBlockReader);
            if (cacheBlock) {
                this.cacheConf.getBlockCache().cacheBlock(cacheKey, metaBlock, this.cacheConf.isInMemory(), this.cacheConf.isCacheDataInL1());
            }
            return metaBlock.getBufferWithoutHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HFileBlock readBlock(long dataBlockOffset, long onDiskBlockSize, boolean cacheBlock, boolean pread, boolean isCompaction, boolean updateCacheMetrics, BlockType expectedBlockType, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
        if (this.dataBlockIndexReader == null) {
            throw new IOException("Block index not loaded");
        }
        if (dataBlockOffset < 0L || dataBlockOffset >= this.trailer.getLoadOnOpenDataOffset()) {
            throw new IOException("Requested block is out of range: " + dataBlockOffset + ", lastDataBlockOffset: " + this.trailer.getLastDataBlockOffset());
        }
        BlockCacheKey cacheKey = new BlockCacheKey(this.name, dataBlockOffset);
        boolean useLock = false;
        IdLock.Entry lockEntry = null;
        TraceScope traceScope = Trace.startSpan((String)"HFileReaderV2.readBlock");
        try {
            while (true) {
                HFileBlock cachedBlock;
                if (useLock) {
                    lockEntry = this.offsetLock.getLockEntry(dataBlockOffset);
                }
                if (this.cacheConf.isBlockCacheEnabled() && (cachedBlock = this.getCachedBlock(cacheKey, cacheBlock, useLock, isCompaction, updateCacheMetrics, expectedBlockType, expectedDataBlockEncoding)) != null) {
                    assert (cachedBlock.isUnpacked()) : "Packed block leak.";
                    if (cachedBlock.getBlockType().isData()) {
                        if (updateCacheMetrics) {
                            HFile.dataBlockReadCnt.incrementAndGet();
                        }
                        if (cachedBlock.getDataBlockEncoding() != this.dataBlockEncoder.getDataBlockEncoding()) {
                            throw new IOException("Cached block under key " + cacheKey + " " + "has wrong encoding: " + cachedBlock.getDataBlockEncoding() + " (expected: " + this.dataBlockEncoder.getDataBlockEncoding() + ")");
                        }
                    }
                    HFileBlock hFileBlock = cachedBlock;
                    return hFileBlock;
                }
                if (useLock) break;
                useLock = true;
            }
            if (Trace.isTracing()) {
                traceScope.getSpan().addTimelineAnnotation("blockCacheMiss");
            }
            HFileBlock hfileBlock = this.fsBlockReader.readBlockData(dataBlockOffset, onDiskBlockSize, -1, pread);
            this.validateBlockType(hfileBlock, expectedBlockType);
            HFileBlock unpacked = hfileBlock.unpack(this.hfileContext, this.fsBlockReader);
            BlockType.BlockCategory category = hfileBlock.getBlockType().getCategory();
            if (cacheBlock && this.cacheConf.shouldCacheBlockOnRead(category)) {
                this.cacheConf.getBlockCache().cacheBlock(cacheKey, this.cacheConf.shouldCacheCompressed(category) ? hfileBlock : unpacked, this.cacheConf.isInMemory(), this.cacheConf.isCacheDataInL1());
            }
            if (updateCacheMetrics && hfileBlock.getBlockType().isData()) {
                HFile.dataBlockReadCnt.incrementAndGet();
            }
            HFileBlock hFileBlock = unpacked;
            return hFileBlock;
        }
        finally {
            traceScope.close();
            if (lockEntry != null) {
                this.offsetLock.releaseLockEntry(lockEntry);
            }
        }
    }

    @Override
    public boolean hasMVCCInfo() {
        return this.includesMemstoreTS && this.decodeMemstoreTS;
    }

    private void validateBlockType(HFileBlock block, BlockType expectedBlockType) throws IOException {
        if (expectedBlockType == null) {
            return;
        }
        BlockType actualBlockType = block.getBlockType();
        if (expectedBlockType.isData() && actualBlockType.isData()) {
            return;
        }
        if (actualBlockType != expectedBlockType) {
            throw new IOException("Expected block type " + expectedBlockType + ", " + "but got " + actualBlockType + ": " + block);
        }
    }

    @Override
    public byte[] getLastKey() {
        return this.dataBlockIndexReader.isEmpty() ? null : this.lastKey;
    }

    @Override
    public byte[] midkey() throws IOException {
        return this.dataBlockIndexReader.midkey();
    }

    @Override
    public void close() throws IOException {
        this.close(this.cacheConf.shouldEvictOnClose());
    }

    @Override
    public void close(boolean evictOnClose) throws IOException {
        PrefetchExecutor.cancel(this.path);
        if (evictOnClose && this.cacheConf.isBlockCacheEnabled()) {
            int numEvicted = this.cacheConf.getBlockCache().evictBlocksByHfileName(this.name);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("On close, file=" + this.name + " evicted=" + numEvicted + " block(s)"));
            }
        }
        this.fsBlockReader.closeStreams();
    }

    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        return this.dataBlockEncoder.getEffectiveEncodingInCache(isCompaction);
    }

    @Override
    HFileBlock.FSReader getUncachedBlockReader() {
        return this.fsBlockReader;
    }

    @Override
    public DataInput getGeneralBloomFilterMetadata() throws IOException {
        return this.getBloomFilterMetadata(BlockType.GENERAL_BLOOM_META);
    }

    @Override
    public DataInput getDeleteBloomFilterMetadata() throws IOException {
        return this.getBloomFilterMetadata(BlockType.DELETE_FAMILY_BLOOM_META);
    }

    private DataInput getBloomFilterMetadata(BlockType blockType) throws IOException {
        if (blockType != BlockType.GENERAL_BLOOM_META && blockType != BlockType.DELETE_FAMILY_BLOOM_META) {
            throw new RuntimeException("Block Type: " + blockType.toString() + " is not supported");
        }
        for (HFileBlock b : this.loadOnOpenBlocks) {
            if (b.getBlockType() != blockType) continue;
            return b.getByteStream();
        }
        return null;
    }

    @Override
    public boolean isFileInfoLoaded() {
        return true;
    }

    private void validateMinorVersion(Path path, int minorVersion) {
        if (minorVersion < 0 || minorVersion > 3) {
            String msg = "Minor version for path " + path + " is expected to be between " + 0 + " and " + 3 + " but is found to be " + minorVersion;
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public HFileContext getFileContext() {
        return this.hfileContext;
    }

    @VisibleForTesting
    boolean prefetchComplete() {
        return PrefetchExecutor.isCompleted(this.path);
    }

    protected static class EncodedScannerV2
    extends AbstractScannerV2 {
        private final HFileBlockDecodingContext decodingCtx;
        private final DataBlockEncoder.EncodedSeeker seeker;
        private final DataBlockEncoder dataBlockEncoder;
        protected final HFileContext meta;

        public EncodedScannerV2(HFileReaderV2 reader, boolean cacheBlocks, boolean pread, boolean isCompaction, HFileContext meta) {
            super(reader, cacheBlocks, pread, isCompaction);
            DataBlockEncoding encoding = reader.dataBlockEncoder.getDataBlockEncoding();
            this.dataBlockEncoder = encoding.getEncoder();
            this.decodingCtx = this.dataBlockEncoder.newDataBlockDecodingContext(meta);
            this.seeker = this.dataBlockEncoder.createSeeker(reader.getComparator(), this.decodingCtx);
            this.meta = meta;
        }

        @Override
        public boolean isSeeked() {
            return this.block != null;
        }

        private void updateCurrentBlock(HFileBlock newBlock) throws CorruptHFileException {
            this.block = newBlock;
            if (this.block.getBlockType() != BlockType.ENCODED_DATA) {
                throw new IllegalStateException("EncodedScanner works only on encoded data blocks");
            }
            short dataBlockEncoderId = this.block.getDataBlockEncodingId();
            if (!DataBlockEncoding.isCorrectEncoder((DataBlockEncoder)this.dataBlockEncoder, (short)dataBlockEncoderId)) {
                String encoderCls = this.dataBlockEncoder.getClass().getName();
                throw new CorruptHFileException("Encoder " + encoderCls + " doesn't support data block encoding " + DataBlockEncoding.getNameFromId((short)dataBlockEncoderId));
            }
            this.seeker.setCurrentBuffer(this.getEncodedBuffer(newBlock));
            ++this.blockFetches;
            this.nextIndexedKey = null;
        }

        private ByteBuffer getEncodedBuffer(HFileBlock newBlock) {
            ByteBuffer origBlock = newBlock.getBufferReadOnly();
            ByteBuffer encodedBlock = ByteBuffer.wrap(origBlock.array(), origBlock.arrayOffset() + newBlock.headerSize() + 2, newBlock.getUncompressedSizeWithoutHeader() - 2).slice();
            return encodedBlock;
        }

        @Override
        public boolean seekTo() throws IOException {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.getTrailer().getEntryCount() == 0L) {
                return false;
            }
            long firstDataBlockOffset = this.reader.getTrailer().getFirstDataBlockOffset();
            if (this.block != null && this.block.getOffset() == firstDataBlockOffset) {
                this.seeker.rewind();
                return true;
            }
            this.block = this.reader.readBlock(firstDataBlockOffset, -1L, this.cacheBlocks, this.pread, this.isCompaction, true, BlockType.DATA, this.getEffectiveDataBlockEncoding());
            if (this.block.getOffset() < 0L) {
                throw new IOException("Invalid block offset: " + this.block.getOffset());
            }
            this.updateCurrentBlock(this.block);
            return true;
        }

        @Override
        public boolean next() throws IOException {
            boolean isValid = this.seeker.next();
            if (!isValid) {
                this.block = this.readNextDataBlock();
                boolean bl = isValid = this.block != null;
                if (isValid) {
                    this.updateCurrentBlock(this.block);
                }
            }
            return isValid;
        }

        @Override
        public ByteBuffer getKey() {
            this.assertValidSeek();
            return this.seeker.getKeyDeepCopy();
        }

        @Override
        public int compareKey(KeyValue.KVComparator comparator, byte[] key, int offset, int length) {
            return this.seeker.compareKey(comparator, key, offset, length);
        }

        @Override
        public ByteBuffer getValue() {
            this.assertValidSeek();
            return this.seeker.getValueShallowCopy();
        }

        @Override
        public Cell getKeyValue() {
            if (this.block == null) {
                return null;
            }
            return this.seeker.getKeyValue();
        }

        @Override
        public String getKeyString() {
            ByteBuffer keyBuffer = this.getKey();
            return Bytes.toStringBinary((byte[])keyBuffer.array(), (int)keyBuffer.arrayOffset(), (int)keyBuffer.limit());
        }

        @Override
        public String getValueString() {
            ByteBuffer valueBuffer = this.getValue();
            return Bytes.toStringBinary((byte[])valueBuffer.array(), (int)valueBuffer.arrayOffset(), (int)valueBuffer.limit());
        }

        private void assertValidSeek() {
            if (this.block == null) {
                throw new AbstractHFileReader.NotSeekedException();
            }
        }

        @Override
        protected ByteBuffer getFirstKeyInBlock(HFileBlock curBlock) {
            return this.dataBlockEncoder.getFirstKeyInBlock(this.getEncodedBuffer(curBlock));
        }

        @Override
        protected int loadBlockAndSeekToKey(HFileBlock seekToBlock, Cell nextIndexedKey, boolean rewind, Cell key, boolean seekBefore) throws IOException {
            if (this.block == null || this.block.getOffset() != seekToBlock.getOffset()) {
                this.updateCurrentBlock(seekToBlock);
            } else if (rewind) {
                this.seeker.rewind();
            }
            this.nextIndexedKey = nextIndexedKey;
            return this.seeker.seekToKeyInBlock(key, seekBefore);
        }

        @Override
        public int compareKey(KeyValue.KVComparator comparator, Cell key) {
            return this.seeker.compareKey(comparator, key);
        }
    }

    protected static class ScannerV2
    extends AbstractScannerV2 {
        private HFileReaderV2 reader;

        public ScannerV2(HFileReaderV2 r, boolean cacheBlocks, boolean pread, boolean isCompaction) {
            super(r, cacheBlocks, pread, isCompaction);
            this.reader = r;
        }

        @Override
        public Cell getKeyValue() {
            if (!this.isSeeked()) {
                return null;
            }
            KeyValue ret = new KeyValue(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position(), this.getCellBufSize());
            if (this.reader.shouldIncludeMemstoreTS()) {
                ret.setSequenceId(this.currMemstoreTS);
            }
            return ret;
        }

        protected int getCellBufSize() {
            return 8 + this.currKeyLen + this.currValueLen;
        }

        @Override
        public ByteBuffer getKey() {
            this.assertSeeked();
            return ByteBuffer.wrap(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8, this.currKeyLen).slice();
        }

        @Override
        public int compareKey(KeyValue.KVComparator comparator, byte[] key, int offset, int length) {
            return comparator.compareFlatKey(key, offset, length, this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8, this.currKeyLen);
        }

        @Override
        public ByteBuffer getValue() {
            this.assertSeeked();
            return ByteBuffer.wrap(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8 + this.currKeyLen, this.currValueLen).slice();
        }

        protected void setNonSeekedState() {
            this.block = null;
            this.blockBuffer = null;
            this.currKeyLen = 0;
            this.currValueLen = 0;
            this.currMemstoreTS = 0L;
            this.currMemstoreTSLen = 0;
        }

        @Override
        public boolean next() throws IOException {
            this.assertSeeked();
            try {
                this.blockBuffer.position(this.getNextCellStartPosition());
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Current pos = " + this.blockBuffer.position() + "; currKeyLen = " + this.currKeyLen + "; currValLen = " + this.currValueLen + "; block limit = " + this.blockBuffer.limit() + "; HFile name = " + this.reader.getName() + "; currBlock currBlockOffset = " + this.block.getOffset()));
                throw e;
            }
            if (this.blockBuffer.remaining() <= 0) {
                long lastDataBlockOffset = this.reader.getTrailer().getLastDataBlockOffset();
                if (this.block.getOffset() >= lastDataBlockOffset) {
                    this.setNonSeekedState();
                    return false;
                }
                HFileBlock nextBlock = this.readNextDataBlock();
                if (nextBlock == null) {
                    this.setNonSeekedState();
                    return false;
                }
                this.updateCurrBlock(nextBlock);
                return true;
            }
            this.readKeyValueLen();
            return true;
        }

        protected int getNextCellStartPosition() {
            return this.blockBuffer.position() + 8 + this.currKeyLen + this.currValueLen + this.currMemstoreTSLen;
        }

        @Override
        public boolean seekTo() throws IOException {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.getTrailer().getEntryCount() == 0L) {
                return false;
            }
            long firstDataBlockOffset = this.reader.getTrailer().getFirstDataBlockOffset();
            if (this.block != null && this.block.getOffset() == firstDataBlockOffset) {
                this.blockBuffer.rewind();
                this.readKeyValueLen();
                return true;
            }
            this.block = this.reader.readBlock(firstDataBlockOffset, -1L, this.cacheBlocks, this.pread, this.isCompaction, true, BlockType.DATA, this.getEffectiveDataBlockEncoding());
            if (this.block.getOffset() < 0L) {
                throw new IOException("Invalid block offset: " + this.block.getOffset());
            }
            this.updateCurrBlock(this.block);
            return true;
        }

        @Override
        protected int loadBlockAndSeekToKey(HFileBlock seekToBlock, Cell nextIndexedKey, boolean rewind, Cell key, boolean seekBefore) throws IOException {
            if (this.block == null || this.block.getOffset() != seekToBlock.getOffset()) {
                this.updateCurrBlock(seekToBlock);
            } else if (rewind) {
                this.blockBuffer.rewind();
            }
            this.nextIndexedKey = nextIndexedKey;
            return this.blockSeek(key, seekBefore);
        }

        protected void updateCurrBlock(HFileBlock newBlock) {
            this.block = newBlock;
            if (this.block.getBlockType() != BlockType.DATA) {
                throw new IllegalStateException("ScannerV2 works only on data blocks, got " + this.block.getBlockType() + "; " + "fileName=" + this.reader.name + ", " + "dataBlockEncoder=" + this.reader.dataBlockEncoder + ", " + "isCompaction=" + this.isCompaction);
            }
            this.blockBuffer = this.block.getBufferWithoutHeader();
            this.readKeyValueLen();
            ++this.blockFetches;
            this.nextIndexedKey = null;
        }

        protected void readKeyValueLen() {
            this.blockBuffer.mark();
            this.currKeyLen = this.blockBuffer.getInt();
            this.currValueLen = this.blockBuffer.getInt();
            ByteBufferUtils.skip((ByteBuffer)this.blockBuffer, (int)(this.currKeyLen + this.currValueLen));
            this.readMvccVersion();
            if (this.currKeyLen < 0 || this.currValueLen < 0 || this.currKeyLen > this.blockBuffer.limit() || this.currValueLen > this.blockBuffer.limit()) {
                throw new IllegalStateException("Invalid currKeyLen " + this.currKeyLen + " or currValueLen " + this.currValueLen + ". Block offset: " + this.block.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header).");
            }
            this.blockBuffer.reset();
        }

        protected void readMvccVersion() {
            if (this.reader.shouldIncludeMemstoreTS()) {
                if (this.reader.decodeMemstoreTS) {
                    try {
                        this.currMemstoreTS = Bytes.readVLong((byte[])this.blockBuffer.array(), (int)(this.blockBuffer.arrayOffset() + this.blockBuffer.position()));
                        this.currMemstoreTSLen = WritableUtils.getVIntSize((long)this.currMemstoreTS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error reading memstore timestamp", e);
                    }
                } else {
                    this.currMemstoreTS = 0L;
                    this.currMemstoreTSLen = 1;
                }
            }
        }

        protected int blockSeek(Cell key, boolean seekBefore) {
            long memstoreTS = 0L;
            int memstoreTSLen = 0;
            int lastKeyValueSize = -1;
            KeyValue.KeyOnlyKeyValue keyOnlykv = new KeyValue.KeyOnlyKeyValue();
            do {
                this.blockBuffer.mark();
                int klen = this.blockBuffer.getInt();
                int vlen = this.blockBuffer.getInt();
                this.blockBuffer.reset();
                if (this.reader.shouldIncludeMemstoreTS()) {
                    if (this.reader.decodeMemstoreTS) {
                        try {
                            int memstoreTSOffset = this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8 + klen + vlen;
                            memstoreTS = Bytes.readVLong((byte[])this.blockBuffer.array(), (int)memstoreTSOffset);
                            memstoreTSLen = WritableUtils.getVIntSize((long)memstoreTS);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error reading memstore timestamp", e);
                        }
                    } else {
                        memstoreTS = 0L;
                        memstoreTSLen = 1;
                    }
                }
                int keyOffset = this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8;
                keyOnlykv.setKey(this.blockBuffer.array(), keyOffset, klen);
                int comp = this.reader.getComparator().compareOnlyKeyPortion(key, (Cell)keyOnlykv);
                if (comp == 0) {
                    if (seekBefore) {
                        if (lastKeyValueSize < 0) {
                            throw new IllegalStateException("blockSeek with seekBefore at the first key of the block: key=" + CellUtil.getCellKeyAsString((Cell)key) + ", blockOffset=" + this.block.getOffset() + ", onDiskSize=" + this.block.getOnDiskSizeWithHeader());
                        }
                        this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
                        this.readKeyValueLen();
                        return 1;
                    }
                    this.currKeyLen = klen;
                    this.currValueLen = vlen;
                    if (this.reader.shouldIncludeMemstoreTS()) {
                        this.currMemstoreTS = memstoreTS;
                        this.currMemstoreTSLen = memstoreTSLen;
                    }
                    return 0;
                }
                if (comp < 0) {
                    if (lastKeyValueSize > 0) {
                        this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
                    }
                    this.readKeyValueLen();
                    if (lastKeyValueSize == -1 && this.blockBuffer.position() == 0 && this.reader.trailer.getMinorVersion() >= 3) {
                        return -2;
                    }
                    return 1;
                }
                lastKeyValueSize = klen + vlen + memstoreTSLen + 8;
                this.blockBuffer.position(this.blockBuffer.position() + lastKeyValueSize);
            } while (this.blockBuffer.remaining() > 0);
            this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
            this.readKeyValueLen();
            return 1;
        }

        @Override
        protected ByteBuffer getFirstKeyInBlock(HFileBlock curBlock) {
            ByteBuffer buffer = curBlock.getBufferWithoutHeader();
            buffer.rewind();
            int klen = buffer.getInt();
            buffer.getInt();
            ByteBuffer keyBuff = buffer.slice();
            keyBuff.limit(klen);
            keyBuff.rewind();
            return keyBuff;
        }

        @Override
        public String getKeyString() {
            return Bytes.toStringBinary((byte[])this.blockBuffer.array(), (int)(this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8), (int)this.currKeyLen);
        }

        @Override
        public String getValueString() {
            return Bytes.toString((byte[])this.blockBuffer.array(), (int)(this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8 + this.currKeyLen), (int)this.currValueLen);
        }

        @Override
        public int compareKey(KeyValue.KVComparator comparator, Cell key) {
            return comparator.compareOnlyKeyPortion(key, (Cell)new KeyValue.KeyOnlyKeyValue(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + 8, this.currKeyLen));
        }
    }

    protected static abstract class AbstractScannerV2
    extends AbstractHFileReader.Scanner {
        protected HFileBlock block;
        protected Cell nextIndexedKey;

        @Override
        public Cell getNextIndexedKey() {
            return this.nextIndexedKey;
        }

        public AbstractScannerV2(HFileReaderV2 r, boolean cacheBlocks, boolean pread, boolean isCompaction) {
            super(r, cacheBlocks, pread, isCompaction);
        }

        protected abstract ByteBuffer getFirstKeyInBlock(HFileBlock var1);

        protected abstract int loadBlockAndSeekToKey(HFileBlock var1, Cell var2, boolean var3, Cell var4, boolean var5) throws IOException;

        @Override
        public int seekTo(byte[] key, int offset, int length) throws IOException {
            return this.seekTo((Cell)new KeyValue.KeyOnlyKeyValue(key, offset, length));
        }

        @Override
        public int reseekTo(byte[] key, int offset, int length) throws IOException {
            return this.reseekTo((Cell)new KeyValue.KeyOnlyKeyValue(key, offset, length));
        }

        @Override
        public int seekTo(Cell key) throws IOException {
            return this.seekTo(key, true);
        }

        @Override
        public int reseekTo(Cell key) throws IOException {
            if (this.isSeeked()) {
                int compared = this.compareKey(this.reader.getComparator(), key);
                if (compared < 1) {
                    return compared;
                }
                if (this.nextIndexedKey != null && (this.nextIndexedKey == HConstants.NO_NEXT_INDEXED_KEY || this.reader.getComparator().compareOnlyKeyPortion(key, this.nextIndexedKey) < 0)) {
                    return this.loadBlockAndSeekToKey(this.block, this.nextIndexedKey, false, key, false);
                }
            }
            return this.seekTo(key, false);
        }

        public int seekTo(Cell key, boolean rewind) throws IOException {
            HFileBlockIndex.BlockIndexReader indexReader = this.reader.getDataBlockIndexReader();
            BlockWithScanInfo blockWithScanInfo = indexReader.loadDataBlockWithScanInfo(key, this.block, this.cacheBlocks, this.pread, this.isCompaction, this.getEffectiveDataBlockEncoding());
            if (blockWithScanInfo == null || blockWithScanInfo.getHFileBlock() == null) {
                return -1;
            }
            return this.loadBlockAndSeekToKey(blockWithScanInfo.getHFileBlock(), blockWithScanInfo.getNextIndexedKey(), rewind, key, false);
        }

        @Override
        public boolean seekBefore(byte[] key, int offset, int length) throws IOException {
            return this.seekBefore((Cell)new KeyValue.KeyOnlyKeyValue(key, offset, length));
        }

        @Override
        public boolean seekBefore(Cell key) throws IOException {
            HFileBlock seekToBlock = this.reader.getDataBlockIndexReader().seekToDataBlock(key, this.block, this.cacheBlocks, this.pread, this.isCompaction, ((HFileReaderV2)this.reader).getEffectiveEncodingInCache(this.isCompaction));
            if (seekToBlock == null) {
                return false;
            }
            ByteBuffer firstKey = this.getFirstKeyInBlock(seekToBlock);
            if (this.reader.getComparator().compareOnlyKeyPortion((Cell)new KeyValue.KeyOnlyKeyValue(firstKey.array(), firstKey.arrayOffset(), firstKey.limit()), key) >= 0) {
                long previousBlockOffset = seekToBlock.getPrevBlockOffset();
                if (previousBlockOffset == -1L) {
                    return false;
                }
                seekToBlock = this.reader.readBlock(previousBlockOffset, seekToBlock.getOffset() - previousBlockOffset, this.cacheBlocks, this.pread, this.isCompaction, true, BlockType.DATA, this.getEffectiveDataBlockEncoding());
            }
            KeyValue.KeyOnlyKeyValue firstKeyInCurrentBlock = new KeyValue.KeyOnlyKeyValue(Bytes.getBytes((ByteBuffer)firstKey));
            this.loadBlockAndSeekToKey(seekToBlock, (Cell)firstKeyInCurrentBlock, true, key, true);
            return true;
        }

        protected HFileBlock readNextDataBlock() throws IOException {
            long lastDataBlockOffset = this.reader.getTrailer().getLastDataBlockOffset();
            if (this.block == null) {
                return null;
            }
            HFileBlock curBlock = this.block;
            do {
                if (curBlock.getOffset() >= lastDataBlockOffset) {
                    return null;
                }
                if (curBlock.getOffset() >= 0L) continue;
                throw new IOException("Invalid block file offset: " + this.block);
            } while (!(curBlock = this.reader.readBlock(curBlock.getOffset() + (long)curBlock.getOnDiskSizeWithHeader(), curBlock.getNextBlockOnDiskSizeWithHeader(), this.cacheBlocks, this.pread, this.isCompaction, true, null, this.getEffectiveDataBlockEncoding())).getBlockType().isData());
            return curBlock;
        }

        public DataBlockEncoding getEffectiveDataBlockEncoding() {
            return ((HFileReaderV2)this.reader).getEffectiveEncodingInCache(this.isCompaction);
        }

        public abstract int compareKey(KeyValue.KVComparator var1, byte[] var2, int var3, int var4);

        public abstract int compareKey(KeyValue.KVComparator var1, Cell var2);
    }
}

