/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.MultiHConnection;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionStateStore {
    private static final Log LOG = LogFactory.getLog(RegionStateStore.class);
    protected static final char META_REPLICA_ID_DELIMITER = '_';
    private volatile HRegion metaRegion;
    private MultiHConnection multiHConnection;
    private volatile boolean initialized;
    private final boolean noPersistence;
    private final Server server;

    static ServerName getRegionServer(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, RegionStateStore.getServerNameColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            HRegionLocation location;
            RegionLocations locations = MetaTableAccessor.getRegionLocations((Result)r);
            if (locations != null && (location = locations.getRegionLocation(replicaId)) != null) {
                return location.getServerName();
            }
            return null;
        }
        return ServerName.parseServerName((String)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    private static byte[] getServerNameColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVERNAME_QUALIFIER : Bytes.toBytes((String)("sn_" + String.format("%04X", replicaId)));
    }

    static RegionState.State getRegionState(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, RegionStateStore.getStateColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return RegionState.State.OPEN;
        }
        return RegionState.State.valueOf((String)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    private static byte[] getStateColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STATE_QUALIFIER : Bytes.toBytes((String)("state_" + String.format("%04X", replicaId)));
    }

    private boolean shouldPersistStateChange(HRegionInfo hri, RegionState state, RegionState oldState) {
        return !hri.isMetaRegion() && !RegionStates.isOneOfStates(state, RegionState.State.MERGING_NEW, RegionState.State.SPLITTING_NEW, RegionState.State.MERGED) && (!RegionStates.isOneOfStates(state, RegionState.State.OFFLINE) || !RegionStates.isOneOfStates(oldState, RegionState.State.MERGING_NEW, RegionState.State.SPLITTING_NEW, RegionState.State.MERGED));
    }

    RegionStateStore(Server server) {
        Configuration conf = server.getConfiguration();
        this.noPersistence = ConfigUtil.useZKForAssignment(conf) && !conf.getBoolean("hbase.assignment.usezk.migrating", false);
        this.server = server;
        this.initialized = false;
    }

    void start() throws IOException {
        if (!this.noPersistence) {
            if (this.server instanceof RegionServerServices) {
                this.metaRegion = ((RegionServerServices)this.server).getFromOnlineRegions(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
            }
            if (this.metaRegion == null) {
                Configuration conf = this.server.getConfiguration();
                this.multiHConnection = new MultiHConnection(conf, conf.getInt("hbase.regionstatestore.meta.connection", 1));
            }
        }
        this.initialized = true;
    }

    void stop() {
        this.initialized = false;
        if (this.multiHConnection != null) {
            this.multiHConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegionState(long openSeqNum, RegionState newState, RegionState oldState) {
        if (this.noPersistence) {
            return;
        }
        HRegionInfo hri = newState.getRegion();
        try {
            if (hri.isMetaRegion()) {
                try {
                    MetaTableLocator.setMetaLocation((ZooKeeperWatcher)this.server.getZooKeeper(), (ServerName)newState.getServerName(), (RegionState.State)newState.getState());
                    return;
                }
                catch (KeeperException e) {
                    throw new IOException("Failed to update meta ZNode", e);
                }
            }
            if (!this.initialized || !this.shouldPersistStateChange(hri, newState, oldState)) {
                return;
            }
            ServerName oldServer = oldState != null ? oldState.getServerName() : null;
            ServerName serverName = newState.getServerName();
            RegionState.State state = newState.getState();
            int replicaId = hri.getReplicaId();
            Put put = new Put(MetaTableAccessor.getMetaKeyForRegion((HRegionInfo)hri));
            StringBuilder info = new StringBuilder("Updating row ");
            info.append(hri.getRegionNameAsString()).append(" with state=").append(state);
            if (serverName != null && !serverName.equals((Object)oldServer)) {
                put.addImmutable(HConstants.CATALOG_FAMILY, RegionStateStore.getServerNameColumn(replicaId), Bytes.toBytes((String)serverName.getServerName()));
                info.append("&sn=").append(serverName);
            }
            if (openSeqNum >= 0L) {
                Preconditions.checkArgument((state == RegionState.State.OPEN && serverName != null ? 1 : 0) != 0, (Object)"Open region should be on a server");
                MetaTableAccessor.addLocation((Put)put, (ServerName)serverName, (long)openSeqNum, (int)replicaId);
                info.append("&openSeqNum=").append(openSeqNum);
                info.append("&server=").append(serverName);
            }
            put.addImmutable(HConstants.CATALOG_FAMILY, RegionStateStore.getStateColumn(replicaId), Bytes.toBytes((String)state.name()));
            LOG.info((Object)info);
            if (this.metaRegion != null) {
                try {
                    this.metaRegion.put(put);
                    return;
                }
                catch (Throwable t) {
                    RegionStateStore regionStateStore = this;
                    synchronized (regionStateStore) {
                        if (this.metaRegion != null) {
                            LOG.info((Object)"Meta region shortcut failed", t);
                            if (this.multiHConnection == null) {
                                this.multiHConnection = new MultiHConnection(this.server.getConfiguration(), 1);
                            }
                            this.metaRegion = null;
                        }
                    }
                }
            }
            this.multiHConnection.processBatchCallback(Arrays.asList(put), TableName.META_TABLE_NAME, null, null);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Failed to persist region state " + newState), (Throwable)ioe);
            this.server.abort("Failed to update region location", ioe);
        }
    }

    void splitRegion(HRegionInfo p, HRegionInfo a, HRegionInfo b, ServerName sn, int regionReplication) throws IOException {
        MetaTableAccessor.splitRegion((Connection)this.server.getConnection(), (HRegionInfo)p, (HRegionInfo)a, (HRegionInfo)b, (ServerName)sn, (int)regionReplication);
    }

    void mergeRegions(HRegionInfo p, HRegionInfo a, HRegionInfo b, ServerName sn, int regionReplication) throws IOException {
        MetaTableAccessor.mergeRegions((Connection)this.server.getConnection(), (HRegionInfo)p, (HRegionInfo)a, (HRegionInfo)b, (ServerName)sn, (int)regionReplication);
    }
}

