/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class DeleteTableHandler
extends TableEventHandler {
    private static final Log LOG = LogFactory.getLog(DeleteTableHandler.class);
    protected HTableDescriptor hTableDescriptor = null;

    public DeleteTableHandler(TableName tableName, Server server, MasterServices masterServices) {
        super(EventType.C_M_DELETE_TABLE, tableName, server, masterServices);
    }

    @Override
    protected void prepareWithTableLock() throws IOException {
        this.hTableDescriptor = this.getTableDescriptor();
    }

    protected void waitRegionInTransition(List<HRegionInfo> regions) throws IOException, CoordinatedStateException {
        AssignmentManager am = this.masterServices.getAssignmentManager();
        RegionStates states = am.getRegionStates();
        long waitTime = this.server.getConfiguration().getLong("hbase.master.wait.on.region", 300000L);
        for (HRegionInfo region : regions) {
            long done = System.currentTimeMillis() + waitTime;
            while (System.currentTimeMillis() < done) {
                if (states.isRegionInState(region, RegionState.State.FAILED_OPEN)) {
                    am.regionOffline(region);
                }
                if (!states.isRegionInTransition(region)) break;
                try {
                    Thread.sleep(this.waitingTimeForEvents);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while sleeping");
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                LOG.debug((Object)("Waiting on region to clear regions in transition; " + am.getRegionStates().getRegionTransitionState(region)));
            }
            if (!states.isRegionInTransition(region)) continue;
            throw new IOException("Waited hbase.master.wait.on.region (" + waitTime + "ms) for region to leave region " + region.getRegionNameAsString() + " in transitions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTableOperation(List<HRegionInfo> regions) throws IOException, CoordinatedStateException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preDeleteTableHandler(this.tableName);
        }
        this.waitRegionInTransition(regions);
        try {
            this.removeTableData(regions);
        }
        finally {
            LOG.debug((Object)("Removing '" + this.tableName + "' descriptor."));
            this.masterServices.getTableDescriptors().remove(this.tableName);
            AssignmentManager am = this.masterServices.getAssignmentManager();
            LOG.debug((Object)("Removing '" + this.tableName + "' from region states."));
            am.getRegionStates().tableDeleted(this.tableName);
            LOG.debug((Object)("Marking '" + this.tableName + "' as deleted."));
            am.getTableStateManager().setDeletedTable(this.tableName);
            this.cleanAnyRemainingRows();
        }
        if (cpHost != null) {
            cpHost.postDeleteTableHandler(this.tableName);
        }
    }

    private void cleanAnyRemainingRows() throws IOException {
        Scan tableScan = MetaTableAccessor.getScanForTableName((TableName)this.tableName);
        try (HTableInterface metaTable = this.masterServices.getConnection().getTable(TableName.META_TABLE_NAME);){
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            try (ResultScanner resScanner = metaTable.getScanner(tableScan);){
                for (Result result : resScanner) {
                    deletes.add(new Delete(result.getRow()));
                }
            }
            if (!deletes.isEmpty()) {
                LOG.warn((Object)("Deleting some vestigal " + deletes.size() + " rows of " + this.tableName + " from " + TableName.META_TABLE_NAME));
                if (LOG.isDebugEnabled()) {
                    for (Delete d : deletes) {
                        LOG.debug((Object)("Purging " + d));
                    }
                }
                metaTable.delete(deletes);
            }
        }
    }

    protected void removeTableData(List<HRegionInfo> regions) throws IOException, CoordinatedStateException {
        Path regionDir;
        LOG.debug((Object)"Deleting regions from META");
        MetaTableAccessor.deleteRegions((Connection)this.server.getConnection(), regions);
        MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
        Path tempTableDir = mfs.moveTableToTemp(this.tableName);
        FileSystem fs = mfs.getFileSystem();
        for (HRegionInfo hri : regions) {
            LOG.debug((Object)("Archiving region " + hri.getRegionNameAsString() + " from FS"));
            HFileArchiver.archiveRegion(fs, mfs.getRootDir(), tempTableDir, HRegion.getRegionDir(tempTableDir, hri.getEncodedName()));
        }
        HColumnDescriptor[] hcds = this.hTableDescriptor.getColumnFamilies();
        boolean hasMob = false;
        for (HColumnDescriptor hcd : hcds) {
            if (!hcd.isMobEnabled()) continue;
            hasMob = true;
            break;
        }
        Path mobTableDir = null;
        if (hasMob && fs.exists(regionDir = new Path(mobTableDir = FSUtils.getTableDir(new Path(mfs.getRootDir(), "mobdir"), this.tableName), MobUtils.getMobRegionInfo(this.tableName).getEncodedName()))) {
            HFileArchiver.archiveRegion(fs, mfs.getRootDir(), mobTableDir, regionDir);
        }
        if (!fs.delete(tempTableDir, true)) {
            LOG.error((Object)("Couldn't delete " + tempTableDir));
        }
        if (hasMob && mobTableDir != null && fs.exists(mobTableDir) && !fs.delete(mobTableDir, true)) {
            LOG.error((Object)("Couldn't delete " + mobTableDir));
        }
        LOG.debug((Object)("Table '" + this.tableName + "' archived!"));
    }

    @Override
    protected void releaseTableLock() {
        super.releaseTableLock();
        try {
            this.masterServices.getTableLockManager().tableDeleted(this.tableName);
        }
        catch (IOException ex) {
            LOG.warn((Object)"Received exception from TableLockManager.tableDeleted:", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }
}

