/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.tracker;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;

public class OSGIServiceTracker
extends ServiceTracker {
    private final Class clazzToTrack;
    private final List<ServiceReference> references = new ArrayList<ServiceReference>();
    private final BundleContext context;
    private final OSGIPluginTracker tracker;

    public OSGIServiceTracker(OSGIPluginTracker tracker, Class clazzToTrack) {
        this(tracker, clazzToTrack, false);
    }

    public OSGIServiceTracker(OSGIPluginTracker osgiPluginTracker, Class clazzToTrack, boolean asPluginInterface) {
        super(osgiPluginTracker.getBundleContext(), OSGIServiceTracker.createFilter(osgiPluginTracker.getBundleContext(), clazzToTrack, asPluginInterface), null);
        this.tracker = osgiPluginTracker;
        this.clazzToTrack = clazzToTrack;
        this.context = this.tracker.getBundleContext();
    }

    private static Filter createFilter(BundleContext context, Class<?> clazzToTrack, boolean asPluginInterface) {
        try {
            return context.createFilter(asPluginInterface ? "(&(objectClass=" + PluginInterface.class.getName() + ")(PluginType=" + clazzToTrack.getName() + "))" : "(objectClass=" + clazzToTrack.getName() + ")");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object addingService(ServiceReference reference) {
        this.references.add(reference);
        Object retVal = super.addingService(reference);
        this.tracker.serviceChanged(this.clazzToTrack, LifecycleEvent.START, reference);
        return retVal;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.references.remove(reference);
        super.removedService(reference, service);
        this.tracker.serviceChanged(this.clazzToTrack, LifecycleEvent.STOP, reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        super.modifiedService(reference, service);
        this.tracker.serviceChanged(this.clazzToTrack, LifecycleEvent.MODIFY, reference);
    }
}

