/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;

public class StoragePolicyAdmin
extends Configured
implements Tool {
    private static final int MAX_LINE_WIDTH = 80;
    private static final Command[] COMMANDS = new Command[]{new ListStoragePoliciesCommand(), new SetStoragePolicyCommand(), new GetStoragePolicyCommand(), new HelpCommand()};

    public static void main(String[] argsArray) throws Exception {
        StoragePolicyAdmin admin = new StoragePolicyAdmin(new Configuration());
        System.exit(admin.run(argsArray));
    }

    private static DistributedFileSystem getDFS(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system");
        }
        return (DistributedFileSystem)fs;
    }

    private static String prettifyException(Exception e) {
        return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage().split("\n")[0];
    }

    private static TableListing getOptionDescriptionListing() {
        return new TableListing.Builder().addField("").addField("", true).wrapWidth(80).hideHeaders().build();
    }

    public StoragePolicyAdmin(Configuration conf) {
        super(conf);
    }

    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            StoragePolicyAdmin.printUsage(false);
            return 1;
        }
        Command command = StoragePolicyAdmin.determineCommand(args[0]);
        if (command == null) {
            System.err.println("Can't understand command '" + args[0] + "'");
            if (!args[0].startsWith("-")) {
                System.err.println("Command names must start with dashes.");
            }
            StoragePolicyAdmin.printUsage(false);
            return 1;
        }
        LinkedList<String> argsList = new LinkedList<String>();
        argsList.addAll(Arrays.asList(args).subList(1, args.length));
        try {
            return command.run(this.getConf(), argsList);
        }
        catch (IllegalArgumentException e) {
            System.err.println(StoragePolicyAdmin.prettifyException(e));
            return -1;
        }
    }

    private static void printUsage(boolean longUsage) {
        System.err.println("Usage: bin/hdfs storagepolicies [COMMAND]");
        for (Command command : COMMANDS) {
            if (longUsage) {
                System.err.print(command.getLongUsage());
                continue;
            }
            System.err.print("          " + command.getShortUsage());
        }
        System.err.println();
    }

    private static Command determineCommand(String commandName) {
        for (Command COMMAND : COMMANDS) {
            if (!COMMAND.getName().equals(commandName)) continue;
            return COMMAND;
        }
        return null;
    }

    private static class HelpCommand
    implements Command {
        private HelpCommand() {
        }

        @Override
        public String getName() {
            return "-help";
        }

        @Override
        public String getShortUsage() {
            return "[-help <command-name>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = StoragePolicyAdmin.getOptionDescriptionListing();
            listing.addRow(new String[]{"<command-name>", "The command for which to get detailed help. If no command is specified, print detailed help for all commands"});
            return this.getShortUsage() + "\n" + "Get detailed help about a command.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (args.size() == 0) {
                for (Command command : COMMANDS) {
                    System.err.println(command.getLongUsage());
                }
                return 0;
            }
            if (args.size() != 1) {
                System.out.println("You must give exactly one argument to -help.");
                return 0;
            }
            String commandName = args.get(0);
            Command command = StoragePolicyAdmin.determineCommand("-" + commandName);
            if (command == null) {
                System.err.print("Unknown command '" + commandName + "'.\n");
                System.err.print("Valid help command names are:\n");
                String separator = "";
                for (Command c : COMMANDS) {
                    System.err.print(separator + c.getName().substring(1));
                    separator = ", ";
                }
                System.err.print("\n");
                return 1;
            }
            System.err.print(command.getLongUsage());
            return 0;
        }
    }

    private static class SetStoragePolicyCommand
    implements Command {
        private SetStoragePolicyCommand() {
        }

        @Override
        public String getName() {
            return "-setStoragePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path> -policy <policy>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = StoragePolicyAdmin.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the file/directory to set storage policy"});
            listing.addRow(new String[]{"<policy>", "The name of the block storage policy"});
            return this.getShortUsage() + "\n" + "Set the storage policy to a file/directory.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify the path for setting the storage policy.\nUsage: " + this.getLongUsage());
                return 1;
            }
            String policyName = StringUtils.popOptionWithArgument((String)"-policy", args);
            if (policyName == null) {
                System.err.println("Please specify the policy name.\nUsage: " + this.getLongUsage());
                return 1;
            }
            DistributedFileSystem dfs = StoragePolicyAdmin.getDFS(conf);
            try {
                dfs.setStoragePolicy(new Path(path), policyName);
                System.out.println("Set storage policy " + policyName + " on " + path);
            }
            catch (Exception e) {
                System.err.println(StoragePolicyAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class GetStoragePolicyCommand
    implements Command {
        private GetStoragePolicyCommand() {
        }

        @Override
        public String getName() {
            return "-getStoragePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = StoragePolicyAdmin.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the file/directory for getting the storage policy"});
            return this.getShortUsage() + "\n" + "Get the storage policy of a file/directory.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify the path with -path.\nUsage:" + this.getLongUsage());
                return 1;
            }
            DistributedFileSystem dfs = StoragePolicyAdmin.getDFS(conf);
            try {
                BlockStoragePolicy[] policies;
                HdfsFileStatus status = dfs.getClient().getFileInfo(path);
                if (status == null) {
                    System.err.println("File/Directory does not exist: " + path);
                    return 2;
                }
                byte storagePolicyId = status.getStoragePolicy();
                if (storagePolicyId == 0) {
                    System.out.println("The storage policy of " + path + " is unspecified");
                    return 0;
                }
                for (BlockStoragePolicy p : policies = dfs.getStoragePolicies()) {
                    if (p.getId() != storagePolicyId) continue;
                    System.out.println("The storage policy of " + path + ":\n" + p);
                    return 0;
                }
            }
            catch (Exception e) {
                System.err.println(StoragePolicyAdmin.prettifyException(e));
                return 2;
            }
            System.err.println("Cannot identify the storage policy for " + path);
            return 2;
        }
    }

    private static class ListStoragePoliciesCommand
    implements Command {
        private ListStoragePoliciesCommand() {
        }

        @Override
        public String getName() {
            return "-listPolicies";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + "]\n";
        }

        @Override
        public String getLongUsage() {
            return this.getShortUsage() + "\n" + "List all the existing block storage policies.\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            DistributedFileSystem dfs = StoragePolicyAdmin.getDFS(conf);
            try {
                BlockStoragePolicy[] policies = dfs.getStoragePolicies();
                System.out.println("Block Storage Policies:");
                for (BlockStoragePolicy policy : policies) {
                    if (policy == null) continue;
                    System.out.println("\t" + policy);
                }
            }
            catch (IOException e) {
                System.err.println(StoragePolicyAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    static interface Command {
        public String getName();

        public String getShortUsage();

        public String getLongUsage();

        public int run(Configuration var1, List<String> var2) throws IOException;
    }
}

