/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.QBMetaData;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;

public class QB {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.QB");
    private final int numJoins = 0;
    private final int numGbys = 0;
    private int numSels = 0;
    private int numSelDi = 0;
    private HashMap<String, String> aliasToTabs;
    private HashMap<String, QBExpr> aliasToSubq;
    private HashMap<String, Map<String, String>> aliasToProps;
    private List<String> aliases;
    private QBParseInfo qbp;
    private QBMetaData qbm;
    private QBJoinTree qbjoin;
    private String id;
    private boolean isQuery;
    private boolean isAnalyzeRewrite;
    private CreateTableDesc tblDesc = null;
    private CreateTableDesc localDirectoryDesc = null;
    private List<Path> encryptedTargetTablePaths;
    private HashMap<ASTNode, PTFInvocationSpec> ptfNodeToSpec;
    private HashMap<String, WindowingSpec> destToWindowingSpec;
    private QBSubQuery subQueryPredicateDef;
    private int numSubQueryPredicates;
    private QBSubQuery whereClauseSubQueryPredicate;
    private QBSubQuery havingClauseSubQueryPredicate;

    public void print(String msg) {
        LOG.info((Object)(msg + "alias=" + this.qbp.getAlias()));
        for (String alias : this.getSubqAliases()) {
            QBExpr qbexpr = this.getSubqForAlias(alias);
            LOG.info((Object)(msg + "start subquery " + alias));
            qbexpr.print(msg + " ");
            LOG.info((Object)(msg + "end subquery " + alias));
        }
    }

    public QB() {
    }

    public QB(String outer_id, String alias, boolean isSubQ) {
        this.aliasToTabs = new LinkedHashMap<String, String>();
        this.aliasToSubq = new LinkedHashMap<String, QBExpr>();
        this.aliasToProps = new LinkedHashMap<String, Map<String, String>>();
        this.aliases = new ArrayList<String>();
        if (alias != null) {
            alias = alias.toLowerCase();
        }
        this.qbp = new QBParseInfo(alias, isSubQ);
        this.qbm = new QBMetaData();
        this.ptfNodeToSpec = new LinkedHashMap<ASTNode, PTFInvocationSpec>();
        this.destToWindowingSpec = new LinkedHashMap<String, WindowingSpec>();
        this.id = QB.getAppendedAliasFromId(outer_id, alias);
    }

    public static String getAppendedAliasFromId(String outer_id, String alias) {
        return outer_id == null ? alias : outer_id + ":" + alias;
    }

    public String getAlias() {
        return this.qbp.getAlias();
    }

    public QBParseInfo getParseInfo() {
        return this.qbp;
    }

    public QBMetaData getMetaData() {
        return this.qbm;
    }

    public void setQBParseInfo(QBParseInfo qbp) {
        this.qbp = qbp;
    }

    public void countSelDi() {
        ++this.numSelDi;
    }

    public void countSel() {
        ++this.numSels;
    }

    public boolean exists(String alias) {
        return this.aliasToTabs.get(alias = alias.toLowerCase()) != null || this.aliasToSubq.get(alias) != null;
    }

    public void setTabAlias(String alias, String tabName) {
        this.aliasToTabs.put(alias.toLowerCase(), tabName);
    }

    public void setSubqAlias(String alias, QBExpr qbexpr) {
        this.aliasToSubq.put(alias.toLowerCase(), qbexpr);
    }

    public void setTabProps(String alias, Map<String, String> props) {
        this.aliasToProps.put(alias.toLowerCase(), props);
    }

    public void addAlias(String alias) {
        if (!this.aliases.contains(alias.toLowerCase())) {
            this.aliases.add(alias.toLowerCase());
        }
    }

    public String getId() {
        return this.id;
    }

    public int getNumGbys() {
        return 0;
    }

    public int getNumSelDi() {
        return this.numSelDi;
    }

    public int getNumSels() {
        return this.numSels;
    }

    public int getNumJoins() {
        return 0;
    }

    public Set<String> getSubqAliases() {
        return this.aliasToSubq.keySet();
    }

    public Set<String> getTabAliases() {
        return this.aliasToTabs.keySet();
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public QBExpr getSubqForAlias(String alias) {
        return this.aliasToSubq.get(alias.toLowerCase());
    }

    public String getTabNameForAlias(String alias) {
        return this.aliasToTabs.get(alias.toLowerCase());
    }

    public Map<String, String> getTabPropsForAlias(String alias) {
        return this.aliasToProps.get(alias.toLowerCase());
    }

    public void rewriteViewToSubq(String alias, String viewName, QBExpr qbexpr) {
        alias = alias.toLowerCase();
        String tableName = this.aliasToTabs.remove(alias);
        assert (viewName.equals(tableName));
        this.aliasToSubq.put(alias, qbexpr);
    }

    public void rewriteCTEToSubq(String alias, String cteName, QBExpr qbexpr) {
        this.rewriteViewToSubq(alias, cteName, qbexpr);
    }

    public QBJoinTree getQbJoinTree() {
        return this.qbjoin;
    }

    public void setQbJoinTree(QBJoinTree qbjoin) {
        this.qbjoin = qbjoin;
    }

    public void setIsQuery(boolean isQuery) {
        this.isQuery = isQuery;
    }

    public boolean getIsQuery() {
        return this.isQuery;
    }

    public boolean isTopLevelSelectStarQuery() {
        return !this.isCTAS() && this.qbp.isTopLevelSimpleSelectStarQuery();
    }

    public boolean isSimpleSelectQuery() {
        if (!this.qbp.isSimpleSelectQuery() || this.isCTAS() || this.qbp.isAnalyzeCommand()) {
            return false;
        }
        for (QBExpr qbexpr : this.aliasToSubq.values()) {
            if (qbexpr.isSimpleSelectQuery()) continue;
            return false;
        }
        return true;
    }

    public boolean hasTableSample(String alias) {
        return this.qbp.getTabSample(alias) != null;
    }

    public CreateTableDesc getTableDesc() {
        return this.tblDesc;
    }

    public void setTableDesc(CreateTableDesc desc) {
        this.tblDesc = desc;
    }

    public CreateTableDesc getLLocalDirectoryDesc() {
        return this.localDirectoryDesc;
    }

    public void setLocalDirectoryDesc(CreateTableDesc localDirectoryDesc) {
        this.localDirectoryDesc = localDirectoryDesc;
    }

    public boolean isCTAS() {
        return this.tblDesc != null;
    }

    public List<String> getSkewedColumnNames(String alias) {
        List<String> skewedColNames = null;
        if (null != this.qbm && null != this.qbm.getAliasToTable() && this.qbm.getAliasToTable().size() > 0) {
            Table tbl = this.getMetaData().getTableForAlias(alias);
            skewedColNames = tbl.getSkewedColNames();
        }
        return skewedColNames;
    }

    public boolean isAnalyzeRewrite() {
        return this.isAnalyzeRewrite;
    }

    public void setAnalyzeRewrite(boolean isAnalyzeRewrite) {
        this.isAnalyzeRewrite = isAnalyzeRewrite;
    }

    public PTFInvocationSpec getPTFInvocationSpec(ASTNode node) {
        return this.ptfNodeToSpec == null ? null : this.ptfNodeToSpec.get(node);
    }

    public void addPTFNodeToSpec(ASTNode node, PTFInvocationSpec spec) {
        this.ptfNodeToSpec = this.ptfNodeToSpec == null ? new LinkedHashMap() : this.ptfNodeToSpec;
        this.ptfNodeToSpec.put(node, spec);
    }

    public HashMap<ASTNode, PTFInvocationSpec> getPTFNodeToSpec() {
        return this.ptfNodeToSpec;
    }

    public WindowingSpec getWindowingSpec(String dest) {
        return this.destToWindowingSpec.get(dest);
    }

    public void addDestToWindowingSpec(String dest, WindowingSpec windowingSpec) {
        this.destToWindowingSpec.put(dest, windowingSpec);
    }

    public boolean hasWindowingSpec(String dest) {
        return this.destToWindowingSpec.get(dest) != null;
    }

    public HashMap<String, WindowingSpec> getAllWindowingSpecs() {
        return this.destToWindowingSpec;
    }

    protected void setSubQueryDef(QBSubQuery subQueryPredicateDef) {
        this.subQueryPredicateDef = subQueryPredicateDef;
    }

    protected QBSubQuery getSubQueryPredicateDef() {
        return this.subQueryPredicateDef;
    }

    protected int getNumSubQueryPredicates() {
        return this.numSubQueryPredicates;
    }

    protected int incrNumSubQueryPredicates() {
        return ++this.numSubQueryPredicates;
    }

    void setWhereClauseSubQueryPredicate(QBSubQuery sq) {
        this.whereClauseSubQueryPredicate = sq;
    }

    public QBSubQuery getWhereClauseSubQueryPredicate() {
        return this.whereClauseSubQueryPredicate;
    }

    void setHavingClauseSubQueryPredicate(QBSubQuery sq) {
        this.havingClauseSubQueryPredicate = sq;
    }

    public QBSubQuery getHavingClauseSubQueryPredicate() {
        return this.havingClauseSubQueryPredicate;
    }

    void addEncryptedTargetTablePath(Path p) {
        if (this.encryptedTargetTablePaths == null) {
            this.encryptedTargetTablePaths = new ArrayList<Path>();
        }
        this.encryptedTargetTablePaths.add(p);
    }

    List<Path> getEncryptedTargetTablePaths() {
        if (this.encryptedTargetTablePaths == null) {
            return Collections.emptyList();
        }
        return this.encryptedTargetTablePaths;
    }
}

