/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigProcessor;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.Pair;

public class POPartitionRearrangeTez
extends POLocalRearrangeTez {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POPartitionRearrangeTez.class);
    private static final TupleFactory tf = TupleFactory.getInstance();
    private static final BagFactory mBagFactory = BagFactory.getInstance();
    private Map<Object, Pair<Integer, Integer>> reducerMap = Maps.newHashMap();
    private Integer totalReducers = -1;
    private boolean inited = false;

    public POPartitionRearrangeTez(OperatorKey k) {
        this(k, -1);
    }

    public POPartitionRearrangeTez(OperatorKey k, int rp) {
        super(k, rp);
        this.index = (byte)-1;
        this.leafOps = Lists.newArrayList();
    }

    @Override
    public String name() {
        return this.getAliasString() + "Partition Rearrange" + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + "(" + this.mIsDistinct + ") - " + this.mKey.toString() + "\t->\t " + this.outputKey;
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (!this.inited) {
            this.init();
        }
        while (true) {
            this.inp = this.processInput();
            if (this.inp.returnStatus == 3 || this.inp.returnStatus == 2) break;
            if (this.inp.returnStatus == 1) continue;
            for (PhysicalPlan ep : this.plans) {
                ep.attachInput((Tuple)this.inp.result);
            }
            ArrayList<Result> resLst = new ArrayList<Result>();
            for (ExpressionOperator op : this.leafOps) {
                this.res = op.getNext(op.getResultType());
                if (this.res.returnStatus != 0) {
                    return this.res;
                }
                resLst.add(this.res);
            }
            this.res.result = this.constructPROutput(resLst, (Tuple)this.inp.result);
            if (this.writer == null) {
                return this.res;
            }
            for (Tuple result : (DataBag)this.res.result) {
                Byte index = (Byte)result.get(0);
                PigNullableWritable key = HDataType.getWritableComparableTypes(result.get(2), this.keyType);
                NullableTuple val = new NullableTuple((Tuple)result.get(3));
                NullablePartitionWritable wrappedKey = new NullablePartitionWritable(key);
                wrappedKey.setIndex(index);
                wrappedKey.setPartition((Integer)result.get(1));
                val.setIndex(index);
                try {
                    this.writer.write((Object)wrappedKey, (Object)val);
                }
                catch (IOException ioe) {
                    int errCode = 2135;
                    String msg = "Received error from POPartitionRearrage function." + ioe.getMessage();
                    throw new ExecException(msg, errCode, ioe);
                }
            }
            this.res = RESULT_EMPTY;
        }
        return this.inp;
    }

    protected DataBag constructPROutput(List<Result> resLst, Tuple value) throws ExecException {
        Tuple t = super.constructLROutput(resLst, null, value);
        Object key = t.get(1);
        DataBag opBag = mBagFactory.newDefaultBag();
        Pair<Integer, Integer> indexes = this.reducerMap.get(key);
        if (indexes == null) {
            indexes = new Pair<Integer, Integer>(-1, 0);
        }
        Integer reducerIdx = (Integer)indexes.first;
        Integer cnt = 0;
        while (cnt <= (Integer)indexes.second) {
            if (reducerIdx >= this.totalReducers) {
                reducerIdx = 0;
            }
            Tuple opTuple = mTupleFactory.newTuple(4);
            opTuple.set(0, t.get(0));
            opTuple.set(1, (int)reducerIdx);
            opTuple.set(2, key);
            opTuple.set(3, t.get(2));
            opBag.add(opTuple);
            Integer n = reducerIdx;
            Integer n2 = reducerIdx = Integer.valueOf(reducerIdx + 1);
            n = cnt;
            n2 = cnt = Integer.valueOf(cnt + 1);
        }
        return opBag;
    }

    private void init() throws RuntimeException {
        ObjectCache cache = ObjectCache.getInstance();
        String isCachedKey = "sample-" + PigProcessor.sampleVertex + ".cached";
        String totalReducersCacheKey = "sample-" + PigProcessor.sampleVertex + ".totalReducers";
        String reducerMapCacheKey = "sample-" + PigProcessor.sampleVertex + ".reducerMap";
        if (cache.retrieve(isCachedKey) == Boolean.TRUE) {
            this.totalReducers = (Integer)cache.retrieve(totalReducersCacheKey);
            this.reducerMap = (Map)cache.retrieve(reducerMapCacheKey);
            LOG.info((Object)("Found totalReducers and reducerMap in Tez cache. cachekey=" + totalReducersCacheKey + "," + reducerMapCacheKey));
            this.inited = true;
            return;
        }
        Map<String, Object> distMap = null;
        if (PigProcessor.sampleMap == null) {
            LOG.info((Object)"Key distribution map is empty");
            this.inited = true;
            return;
        }
        distMap = PigProcessor.sampleMap;
        long start = System.currentTimeMillis();
        try {
            DataBag partitionList = (DataBag)distMap.get("partition.list");
            this.totalReducers = Integer.valueOf("" + distMap.get("totalreducers"));
            for (Tuple idxTuple : partitionList) {
                Object keyT;
                Integer maxIndex = (Integer)idxTuple.get(idxTuple.size() - 1);
                Integer minIndex = (Integer)idxTuple.get(idxTuple.size() - 2);
                if (maxIndex < minIndex) {
                    maxIndex = this.totalReducers + maxIndex;
                }
                if (idxTuple.size() > 3) {
                    Tuple keyTuple = tf.newTuple();
                    for (int i = 0; i < idxTuple.size() - 2; ++i) {
                        keyTuple.append(idxTuple.get(i));
                    }
                    keyT = keyTuple;
                } else {
                    keyT = idxTuple.get(0);
                }
                Integer cnt = maxIndex - minIndex;
                this.reducerMap.put(keyT, new Pair<Integer, Integer>(minIndex, cnt));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info((Object)("Initialized POPartitionRearrangeTez. Time taken: " + (System.currentTimeMillis() - start)));
        cache.cache(isCachedKey, Boolean.TRUE);
        cache.cache(totalReducersCacheKey, this.totalReducers);
        cache.cache(reducerMapCacheKey, this.reducerMap);
        this.inited = true;
    }

    @Override
    public POPartitionRearrangeTez clone() throws CloneNotSupportedException {
        POPartitionRearrangeTez clone = new POPartitionRearrangeTez(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism);
        this.deepCopyTo(clone);
        clone.isSkewedJoin = this.isSkewedJoin;
        clone.connectedToPackage = this.connectedToPackage;
        clone.setOutputKey(this.outputKey);
        return clone;
    }
}

