/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputStepData;
import org.pentaho.di.trans.steps.jsoninput.JsonInput;
import org.pentaho.di.trans.steps.jsoninput.JsonInputData;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;

public class InputsReader
implements Iterable<InputStream> {
    private JsonInput step;
    private JsonInputMeta meta;
    private JsonInputData data;
    private ErrorHandler errorHandler;

    public InputsReader(JsonInput step, JsonInputMeta meta, JsonInputData data, ErrorHandler errorHandler) {
        this.step = step;
        this.meta = meta;
        this.data = data;
        this.errorHandler = errorHandler;
    }

    @Override
    public Iterator<InputStream> iterator() {
        if (!this.meta.isInFields() || this.meta.getIsAFile()) {
            Iterator<FileObject> files;
            if (this.meta.inputFiles.acceptingFilenames) {
                files = new FileNamesIterator((VariableSpace)this.step, this.errorHandler, this.getFieldIterator());
            } else {
                if (this.data.files == null) {
                    this.data.files = this.meta.getFileInputList((VariableSpace)this.step);
                }
                files = this.data.files.getFiles().listIterator(this.data.currentFileIndex);
            }
            return new FileContentIterator(files, this.data, this.errorHandler);
        }
        return new ChainedIterator<InputStream, String>((Iterator)this.getFieldIterator(), this.errorHandler){

            @Override
            protected InputStream tryNext() throws IOException {
                String next = (String)this.inner.next();
                return next == null ? null : IOUtils.toInputStream((String)next, (String)InputsReader.this.meta.getEncoding());
            }
        };
    }

    protected StringFieldIterator getFieldIterator() {
        return new StringFieldIterator(new RowIterator(this.step, this.data, this.errorHandler), this.data.indexSourceField);
    }

    protected class RowIterator
    implements Iterator<Object[]> {
        private StepInterface step;
        private ErrorHandler errorHandler;
        private boolean gotNext;

        public RowIterator(StepInterface step, JsonInputData data, ErrorHandler errorHandler) {
            this.step = step;
            this.errorHandler = errorHandler;
            this.gotNext = data.readrow != null;
        }

        protected void fetchNext() {
            try {
                ((InputsReader)InputsReader.this).data.readrow = this.step.getRow();
                this.gotNext = true;
            }
            catch (KettleException e) {
                this.errorHandler.error((Exception)((Object)e));
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.gotNext) {
                this.fetchNext();
            }
            return ((InputsReader)InputsReader.this).data.readrow != null;
        }

        @Override
        public Object[] next() {
            if (this.hasNext()) {
                this.gotNext = false;
                return ((InputsReader)InputsReader.this).data.readrow;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    protected class StringFieldIterator
    implements Iterator<String> {
        private RowIterator rowIter;
        private int idx;

        public StringFieldIterator(RowIterator rowIter, int idx) {
            this.rowIter = rowIter;
            this.idx = idx;
        }

        @Override
        public boolean hasNext() {
            return this.rowIter.hasNext();
        }

        @Override
        public String next() {
            Object[] row = this.rowIter.next();
            return row == null || row.length <= this.idx ? null : (String)row[this.idx];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    protected class FileNamesIterator
    extends ChainedIterator<FileObject, String> {
        private VariableSpace vars;

        public FileNamesIterator(VariableSpace varSpace, ErrorHandler handler, Iterator<String> fileNames) {
            super(fileNames, handler);
            this.vars = varSpace;
        }

        @Override
        public FileObject tryNext() throws KettleFileException {
            String fileName = InputsReader.this.step.environmentSubstitute((String)this.inner.next());
            return fileName == null ? null : KettleVFS.getFileObject((String)fileName, (VariableSpace)this.vars);
        }
    }

    protected class FileContentIterator
    extends ChainedIterator<InputStream, FileObject> {
        ErrorHandler handler;
        BaseFileInputStepData data;

        FileContentIterator(Iterator<FileObject> inner, BaseFileInputStepData data, ErrorHandler handler) {
            super(inner, handler);
            this.data = data;
        }

        @Override
        public InputStream tryNext() {
            if (this.hasNext()) {
                if (this.data.file != null) {
                    try {
                        this.data.file.close();
                    }
                    catch (FileSystemException e) {
                        this.handler.fileCloseError(this.data.file, e);
                    }
                }
                try {
                    this.data.file = (FileObject)this.inner.next();
                    ++this.data.currentFileIndex;
                    if (InputsReader.this.step.onNewFile(this.data.file)) {
                        return KettleVFS.getInputStream((FileObject)this.data.file);
                    }
                }
                catch (FileSystemException e) {
                    this.handler.fileOpenError(this.data.file, e);
                }
            }
            return null;
        }
    }

    protected abstract class ChainedIterator<T, C>
    implements Iterator<T> {
        protected Iterator<C> inner;
        protected ErrorHandler handler;

        ChainedIterator(Iterator<C> inner, ErrorHandler handler) {
            this.inner = inner;
            this.handler = handler;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public T next() {
            try {
                return this.tryNext();
            }
            catch (Exception e) {
                this.handler.error(e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        protected abstract T tryNext() throws Exception;
    }

    public static interface ErrorHandler {
        public void error(Exception var1);

        public void fileOpenError(FileObject var1, FileSystemException var2);

        public void fileCloseError(FileObject var1, FileSystemException var2);
    }
}

