/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avroinput;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.avroinput.AvroInputMeta;

public class AvroInputData
extends BaseStepData
implements StepDataInterface {
    protected LogChannelInterface m_log;
    protected RowMetaInterface m_outputRowMeta;
    protected DataFileStream m_containerReader;
    protected GenericDatumReader m_datumReader;
    protected Decoder m_decoder;
    protected InputStream m_inStream;
    protected Schema m_writerSchema;
    protected Schema m_schemaToUse;
    protected Schema m_defaultSchema;
    protected GenericDatumReader m_defaultDatumReader;
    protected Object m_defaultTopLevelObject;
    protected Map<String, Object[]> m_schemaCache = new HashMap<String, Object[]>();
    protected boolean m_jsonEncoded;
    protected GenericData.Record m_topLevelRecord;
    protected GenericData.Array m_topLevelArray;
    protected Map<Utf8, Object> m_topLevelMap;
    protected List<AvroInputMeta.AvroField> m_normalFields;
    protected AvroArrayExpansion m_expansionHandler;
    protected int m_newFieldOffset;
    protected boolean m_decodingFromField;
    protected int m_fieldToDecodeIndex = -1;
    protected boolean m_schemaInField;
    protected int m_schemaFieldIndex = -1;
    protected boolean m_schemaFieldIsPath;
    protected boolean m_cacheSchemas;
    protected boolean m_dontComplainAboutMissingFields;
    protected DecoderFactory m_factory;

    public static String cleansePath(String path) {
        String cleanKey;
        String key;
        int index = path.indexOf("${");
        int endIndex = 0;
        String tempStr = path;
        while (index >= 0 && (endIndex += tempStr.indexOf("}")) > 0 && endIndex > (index += 2) + 1 && endIndex + 1 < (path = path.replace(key = path.substring(index, endIndex), cleanKey = key.replace('.', '_'))).length()) {
            tempStr = path.substring(endIndex + 1, path.length());
            index = tempStr.indexOf("${");
            if (index <= 0) continue;
            index += endIndex;
        }
        return path;
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    protected static AvroInputMeta.AvroField createAvroField(String path, Schema s, String namePrefix) {
        AvroInputMeta.AvroField newField = new AvroInputMeta.AvroField();
        String fieldName = path;
        if (!Const.isEmpty((String)namePrefix)) {
            fieldName = namePrefix;
        }
        newField.m_fieldName = fieldName;
        newField.m_fieldPath = path;
        switch (s.getType()) {
            case BOOLEAN: {
                newField.m_kettleType = ValueMeta.getTypeDesc((int)4);
                break;
            }
            case ENUM: 
            case STRING: {
                newField.m_kettleType = ValueMeta.getTypeDesc((int)2);
                if (s.getType() != Schema.Type.ENUM) break;
                newField.m_indexedVals = s.getEnumSymbols();
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                newField.m_kettleType = ValueMeta.getTypeDesc((int)1);
                break;
            }
            case INT: 
            case LONG: {
                newField.m_kettleType = ValueMeta.getTypeDesc((int)5);
                break;
            }
            case BYTES: 
            case FIXED: {
                newField.m_kettleType = ValueMeta.getTypeDesc((int)8);
                break;
            }
            default: {
                newField = null;
            }
        }
        return newField;
    }

    protected static Schema checkUnion(Schema s) throws KettleException {
        boolean ok = false;
        List types = s.getTypes();
        Schema otherSchema = null;
        if (types.size() != 2) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnionError1", (String[])new String[0]));
        }
        for (Schema p : types) {
            if (p.getType() == Schema.Type.NULL) {
                ok = true;
                continue;
            }
            otherSchema = p;
        }
        if (!ok) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnionError2", (String[])new String[0]));
        }
        return otherSchema;
    }

    protected static List<Schema> checkUnionForLeafTypes(Schema s) {
        List types = s.getTypes();
        ArrayList<Schema> primitives = new ArrayList<Schema>();
        for (Schema toCheck : types) {
            switch (toCheck.getType()) {
                case BOOLEAN: 
                case ENUM: 
                case STRING: 
                case FLOAT: 
                case DOUBLE: 
                case INT: 
                case LONG: 
                case BYTES: 
                case FIXED: {
                    primitives.add(toCheck);
                }
            }
        }
        return primitives;
    }

    protected static List<AvroInputMeta.AvroField> getLeafFields(Schema s) throws KettleException {
        ArrayList<AvroInputMeta.AvroField> fields = new ArrayList<AvroInputMeta.AvroField>();
        String root = "$";
        if (s.getType() == Schema.Type.ARRAY || s.getType() == Schema.Type.MAP) {
            while (s.getType() == Schema.Type.ARRAY || s.getType() == Schema.Type.MAP) {
                if (s.getType() == Schema.Type.ARRAY) {
                    root = root + "[0]";
                    s = s.getElementType();
                    continue;
                }
                root = root + "[*key*]";
                s = s.getValueType();
            }
        }
        if (s.getType() == Schema.Type.RECORD) {
            AvroInputData.processRecord(root, s, fields, root);
        } else if (s.getType() == Schema.Type.UNION) {
            AvroInputData.processUnion(root, s, fields, root);
        } else {
            AvroInputMeta.AvroField newField = AvroInputData.createAvroField(root, s, null);
            if (newField != null) {
                fields.add(newField);
            }
        }
        return fields;
    }

    protected static void processUnion(String path, Schema s, List<AvroInputMeta.AvroField> fields, String namePrefix) throws KettleException {
        boolean topLevelUnion = path.equals("$");
        List<Schema> primitives = AvroInputData.checkUnionForLeafTypes(s);
        if (primitives.size() > 0) {
            AvroInputMeta.AvroField newField;
            if (primitives.size() == 1) {
                Schema single = primitives.get(0);
                newField = AvroInputData.createAvroField(path, single, namePrefix = topLevelUnion ? single.getName() : namePrefix);
                if (newField != null) {
                    fields.add(newField);
                }
            } else {
                Schema stringS = Schema.create((Schema.Type)Schema.Type.STRING);
                newField = AvroInputData.createAvroField(path, stringS, topLevelUnion ? path + "union:primitive/fixed" : namePrefix);
                if (newField != null) {
                    fields.add(newField);
                }
            }
        }
        for (Schema toCheck : s.getTypes()) {
            if (toCheck.getType() == Schema.Type.RECORD) {
                String recordName = "[u:" + toCheck.getName() + "]";
                AvroInputData.processRecord(path, toCheck, fields, namePrefix + recordName);
                continue;
            }
            if (toCheck.getType() == Schema.Type.MAP) {
                AvroInputData.processMap(path + "[*key*]", toCheck, fields, namePrefix + "[*key*]");
                continue;
            }
            if (toCheck.getType() != Schema.Type.ARRAY) continue;
            AvroInputData.processArray(path + "[0]", toCheck, fields, namePrefix + "[0]");
        }
    }

    protected static void processRecord(String path, Schema s, List<AvroInputMeta.AvroField> fields, String namePrefix) throws KettleException {
        List recordFields = s.getFields();
        for (Schema.Field rField : recordFields) {
            Schema rSchema = rField.schema();
            if (rSchema.getType() == Schema.Type.UNION) {
                AvroInputData.processUnion(path + "." + rField.name(), rSchema, fields, namePrefix + "." + rField.name());
                continue;
            }
            if (rSchema.getType() == Schema.Type.RECORD) {
                AvroInputData.processRecord(path + "." + rField.name(), rSchema, fields, namePrefix + "." + rField.name());
                continue;
            }
            if (rSchema.getType() == Schema.Type.ARRAY) {
                AvroInputData.processArray(path + "." + rField.name() + "[0]", rSchema, fields, namePrefix + "." + rField.name() + "[0]");
                continue;
            }
            if (rSchema.getType() == Schema.Type.MAP) {
                AvroInputData.processMap(path + "." + rField.name() + "[*key*]", rSchema, fields, namePrefix + "." + rField.name() + "[*key*]");
                continue;
            }
            AvroInputMeta.AvroField newField = AvroInputData.createAvroField(path + "." + rField.name(), rSchema, namePrefix + "." + rField.name());
            if (newField == null) continue;
            fields.add(newField);
        }
    }

    protected static void processMap(String path, Schema s, List<AvroInputMeta.AvroField> fields, String namePrefix) throws KettleException {
        if ((s = s.getValueType()).getType() == Schema.Type.UNION) {
            AvroInputData.processUnion(path, s, fields, namePrefix);
        } else if (s.getType() == Schema.Type.ARRAY) {
            AvroInputData.processArray(path + "[0]", s, fields, namePrefix + "[0]");
        } else if (s.getType() == Schema.Type.RECORD) {
            AvroInputData.processRecord(path, s, fields, namePrefix);
        } else if (s.getType() == Schema.Type.MAP) {
            AvroInputData.processMap(path + "[*key*]", s, fields, namePrefix + "[*key*]");
        } else {
            AvroInputMeta.AvroField newField = AvroInputData.createAvroField(path, s, namePrefix);
            if (newField != null) {
                fields.add(newField);
            }
        }
    }

    protected static void processArray(String path, Schema s, List<AvroInputMeta.AvroField> fields, String namePrefix) throws KettleException {
        if ((s = s.getElementType()).getType() == Schema.Type.UNION) {
            AvroInputData.processUnion(path, s, fields, namePrefix);
        } else if (s.getType() == Schema.Type.ARRAY) {
            AvroInputData.processArray(path + "[0]", s, fields, namePrefix);
        } else if (s.getType() == Schema.Type.RECORD) {
            AvroInputData.processRecord(path, s, fields, namePrefix);
        } else if (s.getType() == Schema.Type.MAP) {
            AvroInputData.processMap(path + "[*key*]", s, fields, namePrefix + "[*key*]");
        } else {
            AvroInputMeta.AvroField newField = AvroInputData.createAvroField(path, s, namePrefix);
            if (newField != null) {
                fields.add(newField);
            }
        }
    }

    protected static Schema loadSchema(String schemaFile) throws KettleException {
        Schema s = null;
        Schema.Parser p = new Schema.Parser();
        FileObject fileO = KettleVFS.getFileObject((String)schemaFile);
        try {
            InputStream in = KettleVFS.getInputStream((FileObject)fileO);
            s = p.parse(in);
            in.close();
        }
        catch (FileSystemException e) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.SchemaError", (String[])new String[0]), (Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.SchemaError", (String[])new String[0]), (Throwable)e);
        }
        return s;
    }

    protected static Schema loadSchemaFromContainer(String containerFilename) throws KettleException {
        Schema s = null;
        FileObject fileO = KettleVFS.getFileObject((String)containerFilename);
        InputStream in = null;
        try {
            in = KettleVFS.getInputStream((FileObject)fileO);
            GenericDatumReader dr = new GenericDatumReader();
            DataFileStream reader = new DataFileStream(in, (DatumReader)dr);
            s = reader.getSchema();
            reader.close();
        }
        catch (FileSystemException e) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), (Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), (Throwable)e);
        }
        return s;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public void initializeFromFieldDecoding(String fieldNameToDecode, String readerSchemaFile, List<AvroInputMeta.AvroField> fields, boolean jsonEncoded, int newFieldOffset, boolean schemaInField, String schemaFieldName, boolean schemaFieldIsPath, boolean cacheSchemas, boolean ignoreMissing, LogChannelInterface log) throws KettleException {
        this.m_log = log;
        this.m_decodingFromField = true;
        this.m_jsonEncoded = jsonEncoded;
        this.m_newFieldOffset = newFieldOffset;
        this.m_inStream = null;
        this.m_normalFields = new ArrayList<AvroInputMeta.AvroField>();
        this.m_cacheSchemas = cacheSchemas;
        this.m_schemaInField = schemaInField;
        this.m_dontComplainAboutMissingFields = ignoreMissing;
        for (AvroInputMeta.AvroField f : fields) {
            this.m_normalFields.add(f);
        }
        this.m_fieldToDecodeIndex = this.m_outputRowMeta.indexOfValue(fieldNameToDecode);
        if (schemaInField) {
            this.m_schemaFieldIndex = this.m_outputRowMeta.indexOfValue(schemaFieldName);
            if (this.m_schemaFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnableToFindIncommingSchemaField", (String[])new String[0]));
            }
            this.m_schemaFieldIsPath = schemaFieldIsPath;
        }
        if (Const.isEmpty((String)readerSchemaFile)) {
            if (!schemaInField) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.NoSchemaSupplied", (String[])new String[0]));
            }
            if (this.m_log.isBasic()) {
                this.m_log.logBasic(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.NoDefaultSchemaWarning", (String[])new String[0]));
            }
        }
        if (!Const.isEmpty((String)readerSchemaFile)) {
            this.m_defaultSchema = this.m_schemaToUse = AvroInputData.loadSchema(readerSchemaFile);
            this.m_defaultDatumReader = this.m_datumReader = new GenericDatumReader(this.m_schemaToUse);
        }
        this.m_factory = new DecoderFactory();
        this.init();
    }

    public void establishFileType(FileObject avroFile, String readerSchemaFile, List<AvroInputMeta.AvroField> fields, boolean jsonEncoded, int newFieldOffset, boolean ignoreMissing, LogChannelInterface log) throws KettleException {
        this.m_log = log;
        this.m_newFieldOffset = newFieldOffset;
        this.m_normalFields = new ArrayList<AvroInputMeta.AvroField>();
        for (AvroInputMeta.AvroField f : fields) {
            this.m_normalFields.add(f);
        }
        this.m_inStream = null;
        this.m_jsonEncoded = jsonEncoded;
        this.m_dontComplainAboutMissingFields = ignoreMissing;
        try {
            this.m_inStream = KettleVFS.getInputStream((FileObject)avroFile);
        }
        catch (FileSystemException e1) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnableToOpenAvroFile", (String[])new String[0]), (Throwable)e1);
        }
        if (!Const.isEmpty((String)readerSchemaFile)) {
            this.m_defaultSchema = this.m_schemaToUse = AvroInputData.loadSchema(readerSchemaFile);
        } else if (jsonEncoded) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.NoSchemaProvided", (String[])new String[0]));
        }
        this.m_datumReader = new GenericDatumReader();
        boolean nonContainer = false;
        if (!jsonEncoded) {
            try {
                this.m_containerReader = new DataFileStream(this.m_inStream, (DatumReader)this.m_datumReader);
                this.m_writerSchema = this.m_containerReader.getSchema();
                this.m_schemaToUse = !Const.isEmpty((String)readerSchemaFile) ? Schema.applyAliases((Schema)this.m_writerSchema, (Schema)this.m_schemaToUse) : this.m_writerSchema;
            }
            catch (IOException e) {
                nonContainer = true;
                try {
                    block19: {
                        try {
                            this.m_inStream.close();
                        }
                        catch (IOException e1) {
                            if (!log.isDebug()) break block19;
                            log.logError(Const.getStackTracker((Throwable)e1));
                        }
                    }
                    this.m_inStream = KettleVFS.getInputStream((FileObject)avroFile);
                }
                catch (FileSystemException e1) {
                    throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), (Throwable)e1);
                }
                this.m_containerReader = null;
            }
        }
        if (nonContainer || jsonEncoded) {
            if (Const.isEmpty((String)readerSchemaFile)) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.NoSchema", (String[])new String[0]));
            }
            this.m_factory = new DecoderFactory();
            if (jsonEncoded) {
                try {
                    this.m_decoder = this.m_factory.jsonDecoder(this.m_schemaToUse, this.m_inStream);
                }
                catch (IOException e) {
                    throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.JsonDecoderError", (String[])new String[0]));
                }
            } else {
                this.m_decoder = this.m_factory.binaryDecoder(this.m_inStream, null);
            }
            this.m_defaultDatumReader = this.m_datumReader = new GenericDatumReader(this.m_schemaToUse);
        }
        this.init();
    }

    protected void initTopLevelStructure(Schema schema, boolean setDefault) throws KettleException {
        if (schema.getType() == Schema.Type.RECORD) {
            this.m_topLevelRecord = new GenericData.Record(schema);
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelRecord;
            }
        } else if (schema.getType() == Schema.Type.UNION) {
            Schema firstUnion = null;
            for (Schema uS : schema.getTypes()) {
                if (uS.getType() != Schema.Type.RECORD) continue;
                firstUnion = uS;
                break;
            }
            this.m_topLevelRecord = new GenericData.Record(firstUnion);
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelRecord;
            }
        } else if (schema.getType() == Schema.Type.ARRAY) {
            this.m_topLevelArray = new GenericData.Array(1, schema);
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelArray;
            }
        } else if (schema.getType() == Schema.Type.MAP) {
            this.m_topLevelMap = new HashMap<Utf8, Object>();
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelMap;
            }
        } else {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnsupportedTopLevelStructure", (String[])new String[0]));
        }
    }

    protected void setTopLevelStructure(Object topLevel) {
        if (topLevel instanceof GenericData.Record) {
            this.m_topLevelRecord = (GenericData.Record)topLevel;
            this.m_topLevelArray = null;
            this.m_topLevelMap = null;
        } else if (topLevel instanceof GenericData.Array) {
            this.m_topLevelArray = (GenericData.Array)topLevel;
            this.m_topLevelRecord = null;
            this.m_topLevelMap = null;
        } else {
            this.m_topLevelMap = (HashMap)topLevel;
            this.m_topLevelRecord = null;
            this.m_topLevelArray = null;
        }
    }

    protected void setSchemaToUse(String schemaKey, boolean useCache, VariableSpace space) throws KettleException {
        if (Const.isEmpty((String)schemaKey)) {
            if (this.m_defaultDatumReader == null) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.IncommingSchemaIsMissingAndNoDefault", (String[])new String[0]));
            }
            if (this.m_log.isDetailed()) {
                this.m_log.logDetailed(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.IncommingSchemaIsMissing", (String[])new String[0]));
            }
            this.m_datumReader = this.m_defaultDatumReader;
            this.m_schemaToUse = this.m_datumReader.getSchema();
            this.setTopLevelStructure(this.m_defaultTopLevelObject);
            return;
        }
        schemaKey = schemaKey.trim();
        schemaKey = space.environmentSubstitute(schemaKey);
        Object[] cached = null;
        if (useCache) {
            cached = this.m_schemaCache.get(schemaKey);
            if (this.m_log.isDetailed() && cached != null) {
                this.m_log.logDetailed(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.UsingCachedSchema", (String[])new String[]{schemaKey}));
            }
        }
        if (!useCache || cached == null) {
            Schema toUse = null;
            if (this.m_schemaFieldIsPath) {
                if (this.m_log.isDetailed()) {
                    this.m_log.logDetailed(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.LoadingSchema", (String[])new String[]{schemaKey}));
                }
                try {
                    toUse = AvroInputData.loadSchema(schemaKey);
                }
                catch (KettleException ex) {
                    if (this.m_defaultDatumReader != null) {
                        if (this.m_log.isBasic()) {
                            this.m_log.logBasic(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.FailedToLoadSchmeaUsingDefault", (String[])new String[]{schemaKey}));
                        }
                        this.m_datumReader = this.m_defaultDatumReader;
                        this.m_schemaToUse = this.m_datumReader.getSchema();
                        this.setTopLevelStructure(this.m_defaultTopLevelObject);
                        return;
                    }
                    throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.CantLoadIncommingSchemaAndNoDefault", (String[])new String[]{schemaKey}));
                }
            } else {
                if (this.m_log.isDetailed()) {
                    this.m_log.logDetailed(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.ParsingSchema", (String[])new String[]{schemaKey}));
                }
                Schema.Parser p = new Schema.Parser();
                toUse = p.parse(schemaKey);
            }
            this.m_schemaToUse = toUse;
            this.m_datumReader = new GenericDatumReader(toUse);
            this.initTopLevelStructure(toUse, false);
            if (useCache) {
                Object[] schemaInfo = new Object[2];
                schemaInfo[0] = this.m_datumReader;
                Object object = this.m_topLevelArray != null ? this.m_topLevelArray : (schemaInfo[1] = this.m_topLevelRecord != null ? this.m_topLevelRecord : this.m_topLevelMap);
                if (this.m_log.isDetailed()) {
                    this.m_log.logDetailed(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.StoringSchemaInCache", (String[])new String[0]));
                }
                this.m_schemaCache.put(schemaKey, schemaInfo);
            }
        } else if (useCache) {
            this.m_datumReader = (GenericDatumReader)cached[0];
            this.m_schemaToUse = this.m_datumReader.getSchema();
            this.setTopLevelStructure(cached[1]);
        }
    }

    protected void init() throws KettleException {
        if (this.m_schemaToUse != null) {
            this.initTopLevelStructure(this.m_schemaToUse, true);
            if (this.m_normalFields == null || this.m_normalFields.size() == 0) {
                this.m_normalFields = AvroInputData.getLeafFields(this.m_schemaToUse);
            }
        }
        if (this.m_normalFields == null || this.m_normalFields.size() == 0) {
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.NoFieldPathsDefined", (String[])new String[0]));
        }
        this.m_expansionHandler = AvroInputData.checkFieldPaths(this.m_normalFields, this.m_outputRowMeta);
        for (AvroInputMeta.AvroField f : this.m_normalFields) {
            int outputIndex = this.m_outputRowMeta.indexOfValue(f.m_fieldName);
            f.init(outputIndex);
        }
        if (this.m_expansionHandler != null) {
            this.m_expansionHandler.init();
        }
    }

    protected static AvroArrayExpansion checkFieldPaths(List<AvroInputMeta.AvroField> normalFields, RowMetaInterface outputRowMeta) throws KettleException {
        String expansion = null;
        ArrayList<AvroInputMeta.AvroField> normalList = new ArrayList<AvroInputMeta.AvroField>();
        ArrayList<AvroInputMeta.AvroField> expansionList = new ArrayList<AvroInputMeta.AvroField>();
        for (AvroInputMeta.AvroField f : normalFields) {
            String path = f.m_fieldPath;
            if (path != null && path.lastIndexOf("[*]") >= 0) {
                if (path.indexOf("[*]") != path.lastIndexOf("[*]")) {
                    throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.PathContainsMultipleExpansions", (String[])new String[]{path}));
                }
                String pathPart = path.substring(0, path.lastIndexOf("[*]") + 3);
                if (expansion == null) {
                    expansion = pathPart;
                } else if (!expansion.equals(pathPart)) {
                    throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.MutipleDifferentExpansions", (String[])new String[0]));
                }
                expansionList.add(f);
                continue;
            }
            normalList.add(f);
        }
        normalFields.clear();
        for (AvroInputMeta.AvroField f : normalList) {
            normalFields.add(f);
        }
        if (expansionList.size() > 0) {
            ArrayList<AvroInputMeta.AvroField> subFields = new ArrayList<AvroInputMeta.AvroField>();
            for (AvroInputMeta.AvroField ef : expansionList) {
                AvroInputMeta.AvroField subField = new AvroInputMeta.AvroField();
                subField.m_fieldName = ef.m_fieldName;
                String path = ef.m_fieldPath;
                if (path.charAt(path.length() - 2) == '*') {
                    path = "dummy";
                } else {
                    path = path.substring(path.lastIndexOf("[*]") + 3, path.length());
                    path = "$" + path;
                }
                subField.m_fieldPath = path;
                subField.m_indexedVals = ef.m_indexedVals;
                subField.m_kettleType = ef.m_kettleType;
                subFields.add(subField);
            }
            AvroArrayExpansion exp = new AvroArrayExpansion(subFields);
            exp.m_expansionPath = expansion;
            exp.m_outputRowMeta = outputRowMeta;
            return exp;
        }
        return null;
    }

    private Object[][] setKettleFields(Object[] outputRowData, VariableSpace space) throws KettleException {
        Object[][] result = null;
        if (this.m_expansionHandler != null) {
            this.m_expansionHandler.reset(space);
            result = this.m_schemaToUse.getType() == Schema.Type.RECORD || this.m_schemaToUse.getType() == Schema.Type.UNION ? this.m_expansionHandler.convertToKettleValues(this.m_topLevelRecord, this.m_topLevelRecord.getSchema(), space, this.m_dontComplainAboutMissingFields) : (this.m_schemaToUse.getType() == Schema.Type.ARRAY ? this.m_expansionHandler.convertToKettleValues(this.m_topLevelArray, this.m_schemaToUse, space, this.m_dontComplainAboutMissingFields) : this.m_expansionHandler.convertToKettleValues(this.m_topLevelMap, this.m_schemaToUse, space, this.m_dontComplainAboutMissingFields));
        } else {
            result = new Object[1][];
        }
        outputRowData = outputRowData == null ? RowDataUtil.allocateRowData((int)this.m_outputRowMeta.size()) : RowDataUtil.resizeArray((Object[])outputRowData, (int)this.m_outputRowMeta.size());
        Object value = null;
        for (AvroInputMeta.AvroField f : this.m_normalFields) {
            f.reset(space);
            value = this.m_schemaToUse.getType() == Schema.Type.RECORD || this.m_schemaToUse.getType() == Schema.Type.UNION ? f.convertToKettleValue(this.m_topLevelRecord, this.m_topLevelRecord.getSchema(), this.m_dontComplainAboutMissingFields) : (this.m_schemaToUse.getType() == Schema.Type.ARRAY ? f.convertToKettleValue(this.m_topLevelArray, this.m_schemaToUse, this.m_dontComplainAboutMissingFields) : f.convertToKettleValue(this.m_topLevelMap, this.m_schemaToUse, this.m_dontComplainAboutMissingFields));
            outputRowData[f.m_outputIndex] = value;
        }
        if (this.m_expansionHandler == null) {
            result[0] = outputRowData;
        } else if (this.m_normalFields.size() > 0 || this.m_newFieldOffset > 0) {
            for (int i = 0; i < result.length; ++i) {
                Object[] row = result[i];
                for (int j = 0; j < this.m_newFieldOffset; ++j) {
                    row[j] = outputRowData[j];
                }
                for (AvroInputMeta.AvroField f : this.m_normalFields) {
                    row[f.m_outputIndex] = outputRowData[f.m_outputIndex];
                }
            }
        }
        return result;
    }

    public Object[][] avroObjectToKettle(Object[] incoming, VariableSpace space) throws KettleException {
        if (this.m_containerReader != null) {
            try {
                if (this.m_containerReader.hasNext()) {
                    if (this.m_topLevelRecord != null) {
                        this.m_topLevelRecord = (GenericData.Record)this.m_containerReader.next((Object)this.m_topLevelRecord);
                    } else if (this.m_topLevelArray != null) {
                        this.m_containerReader.next((Object)this.m_topLevelArray);
                    } else {
                        this.m_containerReader.next(this.m_topLevelMap);
                    }
                    return this.setKettleFields(incoming, space);
                }
                return null;
            }
            catch (IOException e) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.ObjectReadError", (String[])new String[0]));
            }
        }
        try {
            if (this.m_decodingFromField) {
                Object fieldValue;
                if (incoming == null || incoming.length == 0) {
                    return null;
                }
                ValueMetaInterface fieldMeta = this.m_outputRowMeta.getValueMeta(this.m_fieldToDecodeIndex);
                if (fieldMeta.isNull(incoming[this.m_fieldToDecodeIndex])) {
                    Object[][] result = new Object[][]{RowDataUtil.resizeArray((Object[])incoming, (int)this.m_outputRowMeta.size())};
                    return result;
                }
                if (this.m_schemaInField) {
                    ValueMetaInterface schemaMeta = this.m_outputRowMeta.getValueMeta(this.m_schemaFieldIndex);
                    String schemaToUse = schemaMeta.getString(incoming[this.m_schemaFieldIndex]);
                    this.setSchemaToUse(schemaToUse, this.m_cacheSchemas, space);
                }
                if (this.m_jsonEncoded) {
                    try {
                        fieldValue = fieldMeta.getString(incoming[this.m_fieldToDecodeIndex]);
                        this.m_decoder = this.m_factory.jsonDecoder(this.m_schemaToUse, (String)fieldValue);
                    }
                    catch (IOException e) {
                        throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.JsonDecoderError", (String[])new String[0]));
                    }
                } else {
                    fieldValue = fieldMeta.getBinary(incoming[this.m_fieldToDecodeIndex]);
                    this.m_decoder = this.m_factory.binaryDecoder(fieldValue, null);
                }
            }
            if (this.m_topLevelRecord != null) {
                this.m_topLevelRecord = (GenericData.Record)this.m_datumReader.read((Object)this.m_topLevelRecord, this.m_decoder);
            } else if (this.m_topLevelArray != null) {
                this.m_datumReader.read((Object)this.m_topLevelArray, this.m_decoder);
            } else {
                this.m_datumReader.read(this.m_topLevelMap, this.m_decoder);
            }
            return this.setKettleFields(incoming, space);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void close() throws IOException {
        if (this.m_containerReader != null) {
            this.m_containerReader.close();
        }
        if (this.m_inStream != null) {
            this.m_inStream.close();
        }
    }

    protected static class AvroArrayExpansion {
        public String m_expansionPath;
        protected List<AvroInputMeta.AvroField> m_subFields;
        private List<String> m_pathParts;
        private List<String> m_tempParts;
        protected RowMetaInterface m_outputRowMeta;

        public AvroArrayExpansion(List<AvroInputMeta.AvroField> subFields) {
            this.m_subFields = subFields;
        }

        public void init() throws KettleException {
            if (Const.isEmpty((String)this.m_expansionPath)) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.NoPathSet", (String[])new String[0]));
            }
            if (this.m_pathParts != null) {
                return;
            }
            String expansionPath = AvroInputData.cleansePath(this.m_expansionPath);
            String[] temp = expansionPath.split("\\.");
            this.m_pathParts = new ArrayList<String>();
            for (String part : temp) {
                this.m_pathParts.add(part);
            }
            if (this.m_pathParts.get(0).equals("$")) {
                this.m_pathParts.remove(0);
            } else if (this.m_pathParts.get(0).startsWith("$[")) {
                String r = this.m_pathParts.get(0).substring(1, this.m_pathParts.get(0).length());
                this.m_pathParts.set(0, r);
            }
            this.m_tempParts = new ArrayList<String>();
            if (this.m_subFields != null) {
                for (AvroInputMeta.AvroField f : this.m_subFields) {
                    int outputIndex = this.m_outputRowMeta.indexOfValue(f.m_fieldName);
                    f.init(outputIndex);
                }
            }
        }

        public void reset(VariableSpace space) {
            this.m_tempParts.clear();
            for (String part : this.m_pathParts) {
                this.m_tempParts.add(space.environmentSubstitute(part));
            }
            for (AvroInputMeta.AvroField f : this.m_subFields) {
                f.reset(space);
            }
        }

        public Object[][] convertToKettleValues(Map<Utf8, Object> map, Schema s, VariableSpace space, boolean ignoreMissing) throws KettleException {
            if (map == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.MalformedPathMap", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.MalformedPathMap2", (String[])new String[]{part}));
            }
            String key = part.substring(1, part.indexOf(93));
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if (key.equals("*")) {
                Schema valueType = s.getValueType();
                Object[][] result = new Object[map.keySet().size()][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                int i = 0;
                for (Utf8 mk : map.keySet()) {
                    Object value = map.get(mk);
                    for (int j = 0; j < this.m_subFields.size(); ++j) {
                        AvroInputMeta.AvroField sf = this.m_subFields.get(j);
                        sf.reset(space);
                        result[i][sf.m_outputIndex] = valueType.getType() == Schema.Type.RECORD ? sf.convertToKettleValue((GenericData.Record)value, valueType, ignoreMissing) : (valueType.getType() == Schema.Type.ARRAY ? sf.convertToKettleValue((GenericData.Array)value, valueType, ignoreMissing) : (valueType.getType() == Schema.Type.MAP ? sf.convertToKettleValue((Map)value, valueType, ignoreMissing) : sf.getPrimitive(value, valueType)));
                    }
                    ++i;
                }
                return result;
            }
            Object value = map.get(new Utf8(key));
            if (value == null) {
                Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                for (int i = 0; i < this.m_subFields.size(); ++i) {
                    AvroInputMeta.AvroField sf = this.m_subFields.get(i);
                    result[0][sf.m_outputIndex] = null;
                }
                return result;
            }
            Schema valueType = s.getValueType();
            if (valueType.getType() == Schema.Type.UNION) {
                if (value instanceof GenericContainer) {
                    valueType = ((GenericContainer)value).getSchema();
                } else if (value instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : valueType.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    valueType = mapSchema;
                } else {
                    if (!ignoreMissing) {
                        throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.EncounteredAPrimitivePriorToMapExpansion", (String[])new String[0]));
                    }
                    Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                    return result;
                }
            }
            if (valueType.getType() == Schema.Type.RECORD) {
                return this.convertToKettleValues((GenericData.Record)value, valueType, space, ignoreMissing);
            }
            if (valueType.getType() == Schema.Type.ARRAY) {
                return this.convertToKettleValues((GenericData.Array)value, valueType, space, ignoreMissing);
            }
            if (valueType.getType() == Schema.Type.MAP) {
                return this.convertToKettleValues((Map)value, valueType, space, ignoreMissing);
            }
            if (!ignoreMissing) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnexpectedMapValueTypeAtNonExpansionPoint", (String[])new String[0]));
            }
            Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            return result;
        }

        public Object[][] convertToKettleValues(GenericData.Array array, Schema s, VariableSpace space, boolean ignoreMissing) throws KettleException {
            if (array == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.MalformedPathArray", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.MalformedPathArray2", (String[])new String[]{part}));
            }
            String index = part.substring(1, part.indexOf(93));
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if (index.equals("*")) {
                Schema elementType = s.getElementType();
                Object[][] result = new Object[array.size()][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                for (int i = 0; i < array.size(); ++i) {
                    Object value = array.get(i);
                    for (int j = 0; j < this.m_subFields.size(); ++j) {
                        AvroInputMeta.AvroField sf = this.m_subFields.get(j);
                        sf.reset(space);
                        result[i][sf.m_outputIndex] = elementType.getType() == Schema.Type.RECORD ? sf.convertToKettleValue((GenericData.Record)value, elementType, ignoreMissing) : (elementType.getType() == Schema.Type.ARRAY ? sf.convertToKettleValue((GenericData.Array)value, elementType, ignoreMissing) : (elementType.getType() == Schema.Type.MAP ? sf.convertToKettleValue((Map)value, elementType, ignoreMissing) : sf.getPrimitive(value, elementType)));
                    }
                }
                return result;
            }
            int arrayI = 0;
            try {
                arrayI = Integer.parseInt(index.trim());
            }
            catch (NumberFormatException e) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnableToParseArrayIndex", (String[])new String[]{index}));
            }
            if (arrayI >= array.size() || arrayI < 0) {
                Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                for (int i = 0; i < this.m_subFields.size(); ++i) {
                    AvroInputMeta.AvroField sf = this.m_subFields.get(i);
                    result[0][sf.m_outputIndex] = null;
                }
                return result;
            }
            Object value = array.get(arrayI);
            Schema elementType = s.getElementType();
            if (elementType.getType() == Schema.Type.UNION) {
                if (value instanceof GenericContainer) {
                    elementType = ((GenericContainer)value).getSchema();
                } else if (value instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : elementType.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    elementType = mapSchema;
                } else {
                    if (!ignoreMissing) {
                        throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.EncounteredAPrimitivePriorToMapExpansion", (String[])new String[0]));
                    }
                    Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                    return result;
                }
            }
            if (elementType.getType() == Schema.Type.RECORD) {
                return this.convertToKettleValues((GenericData.Record)value, elementType, space, ignoreMissing);
            }
            if (elementType.getType() == Schema.Type.ARRAY) {
                return this.convertToKettleValues((GenericData.Array)value, elementType, space, ignoreMissing);
            }
            if (elementType.getType() == Schema.Type.MAP) {
                return this.convertToKettleValues((Map)value, elementType, space, ignoreMissing);
            }
            if (!ignoreMissing) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnexpectedArrayElementTypeAtNonExpansionPoint", (String[])new String[0]));
            }
            Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            return result;
        }

        public Object[][] convertToKettleValues(GenericData.Record record, Schema s, VariableSpace space, boolean ignoreMissing) throws KettleException {
            Schema.Field fieldS;
            if (record == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.MalformedPathRecord", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) == '[') {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.InvalidPath", (String[])new String[0]) + this.m_tempParts);
            }
            if (part.indexOf(91) > 0) {
                String arrayPart = part.substring(part.indexOf(91));
                part = part.substring(0, part.indexOf(91));
                this.m_tempParts.add(0, arrayPart);
            }
            if ((fieldS = s.getField(part)) == null && !ignoreMissing) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.NonExistentField", (String[])new String[]{part}));
            }
            Object field = record.get(part);
            if (field == null) {
                Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                return result;
            }
            Schema.Type fieldT = fieldS.schema().getType();
            Schema fieldSchema = fieldS.schema();
            if (fieldT == Schema.Type.UNION) {
                if (field instanceof GenericContainer) {
                    fieldSchema = ((GenericContainer)field).getSchema();
                    fieldT = fieldSchema.getType();
                } else if (field instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : fieldSchema.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    fieldSchema = mapSchema;
                    fieldT = Schema.Type.MAP;
                } else {
                    if (!ignoreMissing) {
                        throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.EncounteredAPrimitivePriorToMapExpansion", (String[])new String[0]));
                    }
                    Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                    return result;
                }
            }
            if (fieldT == Schema.Type.RECORD) {
                return this.convertToKettleValues((GenericData.Record)field, fieldSchema, space, ignoreMissing);
            }
            if (fieldT == Schema.Type.ARRAY) {
                return this.convertToKettleValues((GenericData.Array)field, fieldSchema, space, ignoreMissing);
            }
            if (fieldT == Schema.Type.MAP) {
                return this.convertToKettleValues((Map)field, fieldSchema, space, ignoreMissing);
            }
            throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.UnexpectedRecordFieldTypeAtNonExpansionPoint", (String[])new String[0]));
        }
    }
}

