/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.hbase.factory;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.pentaho.hadoop.hbase.factory.HBase9xPut;
import org.pentaho.hbase.factory.HBasePut;
import org.pentaho.hbase.factory.HBaseTable;

class HBase9xTable
implements HBaseTable {
    private final HTable tab;

    HBase9xTable(Configuration conf, String tableName) throws IOException {
        this.tab = new HTable(conf, tableName);
    }

    HBase9xTable(HTable tab) {
        this.tab = tab;
    }

    @Override
    public void setWriteBufferSize(long bufferSize) throws IOException {
        this.tab.setWriteBufferSize(bufferSize);
    }

    @Override
    public void setAutoFlush(boolean autoFlush) throws IOException {
        this.tab.setAutoFlush(autoFlush);
    }

    @Override
    public boolean isAutoFlush() throws IOException {
        return this.tab.isAutoFlush();
    }

    @Override
    public ResultScanner getScanner(Scan s) throws IOException {
        return this.tab.getScanner(s);
    }

    @Override
    public Result get(Get toGet) throws IOException {
        return this.tab.get(toGet);
    }

    @Override
    public void flushCommits() throws IOException {
        this.tab.flushCommits();
    }

    @Override
    public void delete(Delete toDel) throws IOException {
        this.tab.delete(toDel);
    }

    @Override
    public void close() throws IOException {
        this.tab.close();
    }

    @Override
    public void put(HBasePut put) throws IOException {
        if (put == null) {
            throw new NullPointerException("NULL Put passed");
        }
        if (!(put instanceof HBase9xPut)) {
            throw new IllegalArgumentException("Unexpected backed HBasePut type passed:" + put.getClass());
        }
        HBase9xPut p9x = (HBase9xPut)put;
        this.put(p9x.getPut());
    }

    void put(Put toPut) throws IOException {
        this.tab.put(toPut);
    }
}

