/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.Ordered;
import org.springframework.core.task.SyncTaskExecutor;

public class OrderedApplicationEventMulticaster
extends SimpleApplicationEventMulticaster {
    private final Comparator<ApplicationListener> comparator = new Comparator<ApplicationListener>(){

        @Override
        public int compare(ApplicationListener o1, ApplicationListener o2) {
            if (o1 instanceof Ordered && o2 instanceof Ordered) {
                return Integer.compare(((Ordered)o1).getOrder(), ((Ordered)o2).getOrder());
            }
            if (o1 instanceof Ordered) {
                return -1;
            }
            if (o2 instanceof Ordered) {
                return 1;
            }
            return 0;
        }
    };
    private Executor defaultExecutor = new SyncTaskExecutor();

    public OrderedApplicationEventMulticaster() {
        this.setTaskExecutor(this.defaultExecutor);
    }

    public OrderedApplicationEventMulticaster(BeanFactory beanFactory) {
        super(beanFactory);
        this.setTaskExecutor(this.defaultExecutor);
    }

    public void multicastEvent(final ApplicationEvent event) {
        Collection applicationListeners = this.getApplicationListeners();
        ApplicationListener[] listeners = applicationListeners.toArray(new ApplicationListener[applicationListeners.size()]);
        Arrays.sort(listeners, this.comparator);
        for (final ApplicationListener listener : listeners) {
            this.getTaskExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.onApplicationEvent(event);
                }
            });
        }
    }
}

