/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.dom4j.Node;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IComponent;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISelectionMapper;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.actionsequence.ActionParameter;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public abstract class ComponentBase
extends PentahoMessenger
implements IComponent,
IParameterResolver {
    private static final long serialVersionUID = -1344533990604702214L;
    protected static final String UNKNOWN_COMPONENT_ID = "unknown";
    public static final String MISSING_SESSION = "session missing";
    public static final String COMPONENT_EXECUTE_FAIL = "component failed";
    protected static final boolean debug = true;
    private IRuntimeContext runtimeContext;
    private IPentahoSession sessionContext;
    private String processId;
    private String actionName;
    private String instanceId;
    private String id;
    private boolean baseInitOk;
    private boolean componentInitOk;
    private String logId;
    private Node componentDefinition;
    private Map<String, String> componentDefinitionMap;
    private IActionDefinition actionDefinition;
    private final HashMap settings = new HashMap();

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setComponentDefinition(Node componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    public void setComponentDefinitionMap(Map<String, String> componentDefinitionMap) {
        this.componentDefinitionMap = componentDefinitionMap;
    }

    public Node getComponentDefinition() {
        return this.getComponentDefinition(false);
    }

    public Node getComponentDefinition(boolean process) {
        if (process) {
            List nodes = this.componentDefinition.selectNodes("//*");
            for (Node node : nodes) {
                String txt = node.getText();
                if (txt == null || node.isReadOnly()) continue;
                node.setText(this.applyInputsToFormat(txt));
            }
        }
        return this.componentDefinition;
    }

    public void setRuntimeContext(IRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public IRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void setSession(IPentahoSession session) {
        this.sessionContext = session;
    }

    public IPentahoSession getSession() {
        return this.sessionContext;
    }

    protected void saveSetting(String name, Object value) {
        this.settings.put(name, value);
    }

    protected Object getSetting(String name) {
        return this.settings.get(name);
    }

    protected String getStringSetting(String name) {
        Object value = this.settings.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    protected abstract boolean validateAction();

    protected abstract boolean validateSystemSettings();

    public abstract void done();

    protected abstract boolean executeAction() throws Throwable;

    public abstract boolean init();

    @Override
    public String getLogId() {
        return this.logId;
    }

    protected boolean isDefinedInput(String inputName) {
        if (this.runtimeContext.getInputNames().contains(inputName)) {
            return true;
        }
        return this.getComponentSetting(inputName) != null;
    }

    protected boolean isDefinedOutput(String outputName) {
        return this.runtimeContext.getOutputNames().contains(outputName);
    }

    protected boolean isDefinedResource(String resourceName) {
        return this.runtimeContext.getResourceNames().contains(resourceName);
    }

    public final int validate() {
        this.logId = Messages.getInstance().getString("Base.CODE_LOG_ID", this.instanceId, this.runtimeContext.getHandle(), this.actionName);
        this.debug(Messages.getInstance().getString("Base.DEBUG_VALIDATING_COMPONENT", this.actionName));
        this.id = Messages.getInstance().getString("Base.CODE_COMPONENT_ID", this.processId, this.actionName);
        this.baseInitOk = this.instanceId != null && this.sessionContext != null && this.processId != null && this.actionName != null;
        boolean systemSettingsValidate = this.validateSystemSettings();
        if (this.baseInitOk && systemSettingsValidate) {
            try {
                this.componentInitOk = this.validateAction();
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("Base.ERROR_0004_VALIDATION_FAILED"), e);
            }
        }
        if (this.getInitOk()) {
            return 1;
        }
        return 0;
    }

    public int resolveParameter(String template, String parameterName, Matcher parameterMatcher, int copyStart, StringBuffer result) {
        return -1;
    }

    public boolean getInitOk() {
        return this.baseInitOk && this.componentInitOk;
    }

    protected Set getOutputNames() {
        return this.runtimeContext.getOutputNames();
    }

    protected Set getInputNames() {
        return this.runtimeContext.getInputNames();
    }

    protected Set getResourceNames() {
        return this.runtimeContext.getResourceNames();
    }

    protected boolean feedbackAllowed() {
        return this.runtimeContext.feedbackAllowed();
    }

    protected IActionSequenceResource getResource(String resourceName) {
        return this.runtimeContext.getResourceDefintion(resourceName);
    }

    protected InputStream getResourceInputStream(IActionSequenceResource resource) throws FileNotFoundException {
        return resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
    }

    protected InputStream getInputStream(String inputName) {
        return this.runtimeContext.getInputStream(inputName);
    }

    protected int getOutputPreference() {
        return this.runtimeContext.getOutputPreference();
    }

    protected void audit(String messageType, String message, String value, int duration) {
        this.runtimeContext.audit(messageType, message, value, (long)duration);
    }

    protected boolean getInputBooleanValue(String inputName, boolean defaultValue) {
        String strValue = this.getInputStringValue(inputName);
        if (strValue == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(strValue)) {
            return true;
        }
        if ("false".equalsIgnoreCase(strValue)) {
            return false;
        }
        return defaultValue;
    }

    protected long getInputLongValue(String inputName, long defaultValue) {
        String strValue = this.getInputStringValue(inputName);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String getInputStringValue(String inputName) {
        return this.getInputStringValue(inputName, true);
    }

    protected String getInputStringValue(String inputName, boolean applyTemplates) {
        String value = null;
        value = this.runtimeContext.getInputNames().contains(inputName) ? this.runtimeContext.getInputParameterStringValue(inputName) : this.getComponentSetting(inputName);
        if (value != null && applyTemplates) {
            value = this.applyInputsToFormat(value);
        }
        return value;
    }

    protected Object getInputValue(String inputName) {
        if (this.runtimeContext.getInputNames().contains(inputName)) {
            return this.runtimeContext.getInputParameterValue(inputName);
        }
        Node node = this.componentDefinition.selectSingleNode(inputName);
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    private String getComponentSetting(String path) {
        if (this.runtimeContext.getInputNames().contains(path)) {
            return this.runtimeContext.getInputParameterStringValue(path);
        }
        if (this.componentDefinitionMap != null && this.componentDefinitionMap.containsKey(path)) {
            return this.componentDefinitionMap.get(path);
        }
        Node node = this.componentDefinition.selectSingleNode(path);
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    public void promptNeeded() {
        this.runtimeContext.promptNeeded();
    }

    public void promptNow() {
        this.runtimeContext.promptNow();
    }

    public String getResourceAsString(IActionSequenceResource resource) {
        try {
            return this.runtimeContext.getResourceAsString(resource);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getInitFailMessage() {
        return null;
    }

    public String createNewInstance(boolean persisted, Map parameters, boolean forceImmediateWrite) {
        return this.runtimeContext.createNewInstance(persisted, parameters, forceImmediateWrite);
    }

    public void inputMissingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0003_INPUT_PARAM_MISSING", paramName));
    }

    public void outputMissingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0004_OUTPUT_PARAM_MISSING", paramName));
    }

    public void resourceMissingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0005_RESOURCE_PARAM_MISSING", paramName));
    }

    public void resourceComponentSettingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0006_COMPONENT_SETTING_PARAM_MISSING", paramName));
    }

    public int execute() {
        String xsl = null;
        if (this.isDefinedInput("xsl")) {
            xsl = this.getComponentSetting("xsl");
        }
        if (xsl != null) {
            this.runtimeContext.setParameterXsl(xsl);
        } else {
            this.runtimeContext.setParameterXsl(PentahoSystem.getSystemSetting("default-parameter-xsl", "DefaultParameterForm.xsl"));
        }
        if (this.loggingLevel == 100) {
            this.warn(Messages.getInstance().getString("Base.WARNING_LOGGING_LEVEL_UNKNOWN"));
            this.loggingLevel = 2;
        }
        int result = 7;
        if (this.sessionContext == null) {
            this.error(Messages.getInstance().getErrorString("Base.ERROR_0001_INVALID_SESSION"));
            return result;
        }
        this.debug(Messages.getInstance().getString("Base.DEBUG_VALIDATION_RESULT") + this.getInitOk());
        if (!this.getInitOk()) {
            return result;
        }
        try {
            int n = result = this.executeAction() ? 6 : 7;
            if (result == 6 && this.runtimeContext.isPromptPending() && this.isDefinedInput("handle-all-prompts")) {
                this.runtimeContext.promptNow();
            }
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(Messages.getInstance().getErrorString("Base.ERROR_0002_EXECUTION_FAILED"), e);
        }
        return result;
    }

    @Override
    public String getObjectName() {
        return this.getClass().getName();
    }

    public String getId() {
        return this.id;
    }

    public String getActionTitle() {
        return this.runtimeContext.getActionTitle();
    }

    @Deprecated
    protected IContentItem getOutputContentItem(String mimeType) {
        return this.runtimeContext.getOutputContentItem(mimeType);
    }

    protected IContentItem getOutputContentItem(String outputName, String mimeType) {
        return this.runtimeContext.getOutputContentItem(outputName, mimeType);
    }

    protected IContentItem getContentOutputItem(String outputName, String mimeType) {
        return this.runtimeContext.getOutputContentItem(outputName, mimeType);
    }

    protected IContentItem getOutputItem(String outputName, String mimeType, String extension) {
        return this.runtimeContext.getOutputItem(outputName, mimeType, extension);
    }

    protected void setOutputValue(String outputName, Object value) {
        this.runtimeContext.setOutputValue(outputName, value);
    }

    protected void addTempParameter(String name, IActionParameter param) {
        this.runtimeContext.addTempParameter(name, param);
    }

    protected void addTempParameterObject(String name, Object paramObject) {
        String pType = "object";
        ActionParameter actionParameter = new ActionParameter(name, pType, paramObject, null, null);
        this.addTempParameter(name, actionParameter);
    }

    @Deprecated
    protected OutputStream getDefaultOutputStream(String mimeType) {
        IContentItem contentItem = this.runtimeContext.getOutputContentItem(mimeType);
        if (contentItem != null) {
            try {
                return contentItem.getOutputStream(this.getActionName());
            }
            catch (Exception e) {
                this.getLogger().error((Object)e);
            }
        }
        return null;
    }

    protected String applyInputsToFormat(String format) {
        return this.runtimeContext.applyInputsToFormat(format, (IParameterResolver)this);
    }

    protected IActionParameter getOutputItem(String outputName) {
        return this.runtimeContext.getOutputParameter(outputName);
    }

    protected String getSolutionName() {
        return "";
    }

    protected String getSolutionPath() {
        return this.runtimeContext.getSolutionPath();
    }

    protected IActionParameter getInputParameter(String parameterName) {
        return this.runtimeContext.getInputParameter(parameterName);
    }

    protected boolean isPromptPending() {
        return this.runtimeContext.isPromptPending();
    }

    protected void setFeedbackMimeType(String mimeType) {
        IContentItem feedbackContentItem = this.runtimeContext.getFeedbackContentItem();
        feedbackContentItem.setMimeType(mimeType);
    }

    @Deprecated
    protected void setOutputMimeType(String mimeType) {
        IContentItem outputContentItem = this.runtimeContext.getOutputContentItem(mimeType);
        outputContentItem.setMimeType(mimeType);
    }

    protected void setOutputMimeType(String outputName, String mimeType) {
        IContentItem outputContentItem = this.runtimeContext.getOutputContentItem(outputName);
        outputContentItem.setMimeType(mimeType);
    }

    protected OutputStream getFeedbackOutputStream() {
        IContentItem feedbackContentItem = this.runtimeContext.getFeedbackContentItem();
        if (feedbackContentItem != null) {
            try {
                return feedbackContentItem.getOutputStream(this.getActionName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    protected void createFeedbackParameter(IActionParameter actionParam) {
        this.runtimeContext.createFeedbackParameter(actionParam);
        this.runtimeContext.promptNeeded();
    }

    protected void createFeedbackParameter(ISelectionMapper selMap, String fieldName, Object defaultValues) {
        this.runtimeContext.createFeedbackParameter(selMap, fieldName, defaultValues);
        this.runtimeContext.promptNeeded();
    }

    protected void createFeedbackParameter(ISelectionMapper selMap, String fieldName, Object defaultValues, boolean optional) {
        this.runtimeContext.createFeedbackParameter(selMap, fieldName, defaultValues, optional);
        if (!optional) {
            this.runtimeContext.promptNeeded();
        }
    }

    protected void createFeedbackParameter(String fieldName, String displayName, String hint, String defaultValue, boolean visible) {
        this.runtimeContext.createFeedbackParameter(fieldName, displayName, hint, (Object)defaultValue, visible);
        this.runtimeContext.promptNeeded();
    }

    protected void createFeedbackParameter(String fieldName, String displayName, String hint, String defaultValue, boolean visible, boolean optional) {
        this.runtimeContext.createFeedbackParameter(fieldName, displayName, hint, (Object)defaultValue, visible, optional);
        if (!optional) {
            this.runtimeContext.promptNeeded();
        }
    }

    public void createFeedbackParameter(String fieldName, String displayName, String hint, Object defaultValues, List values, Map dispNames, String displayStyle) {
        this.runtimeContext.createFeedbackParameter(fieldName, displayName, hint, defaultValues, values, dispNames, displayStyle);
        this.runtimeContext.promptNeeded();
    }

    public void createFeedbackParameter(String fieldName, String displayName, String hint, Object defaultValues, List values, Map dispNames, String displayStyle, boolean optional) {
        this.runtimeContext.createFeedbackParameter(fieldName, displayName, hint, defaultValues, values, dispNames, displayStyle, optional);
        if (!optional) {
            this.runtimeContext.promptNeeded();
        }
    }

    protected IPentahoStreamSource getResourceDataSource(IActionSequenceResource resource) throws FileNotFoundException {
        return this.runtimeContext.getResourceDataSource(resource);
    }

    public void setActionDefinition(IActionDefinition actionDefinition) {
        this.actionDefinition = actionDefinition;
    }

    public IActionDefinition getActionDefinition() {
        return this.actionDefinition;
    }
}

