/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmloutput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.xmloutput.XMLOutput;
import org.pentaho.di.trans.steps.xmloutput.XMLOutputMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.step.BaseStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class XMLOutputExternalResourceConsumer
extends BaseStepExternalResourceConsumer<XMLOutput, XMLOutputMeta> {
    public boolean isDataDriven(XMLOutputMeta meta) {
        return false;
    }

    public Collection<IExternalResourceInfo> getResourcesFromMeta(XMLOutputMeta meta, IAnalysisContext context) {
        String[] paths;
        TransMeta parentTransMeta;
        StepMeta parentStepMeta;
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (!this.isDataDriven(meta) && (parentStepMeta = meta.getParentStepMeta()) != null && (parentTransMeta = parentStepMeta.getParentTransMeta()) != null && (paths = meta.getFiles((VariableSpace)parentTransMeta)) != null) {
            resources = new ArrayList<IExternalResourceInfo>(paths.length);
            for (String path : paths) {
                if (Const.isEmpty((String)path)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createFileResource((FileObject)KettleVFS.getFileObject((String)path), (boolean)false);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public Class<XMLOutputMeta> getMetaClass() {
        return XMLOutputMeta.class;
    }
}

