/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xsdvalidator;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xsdvalidator.XsdValidator;
import org.pentaho.di.trans.steps.xsdvalidator.XsdValidatorData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="XSDValidator", image="XOU.svg", i18nPackageName="org.pentaho.di.trans.steps.xsdvalidator", name="XSDValidator.name", description="XSDValidator.description", categoryDescription="XSDValidator.category", documentationUrl="http://wiki.pentaho.com/display/EAI/XSD+Validator")
public class XsdValidatorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = XsdValidatorMeta.class;
    private String xsdFilename;
    private String xmlStream;
    private String resultFieldname;
    private boolean addValidationMessage;
    private String validationMessageField;
    private boolean outputStringField;
    private String ifXmlValid;
    private String ifXmlInvalid;
    private boolean xmlSourceFile;
    private String xsdDefinedField;
    private String xsdSource;
    public String SPECIFY_FILENAME = "filename";
    public String SPECIFY_FIELDNAME = "fieldname";
    public String NO_NEED = "noneed";

    public void setXSDSource(String xsdsourcein) {
        this.xsdSource = xsdsourcein;
    }

    public String getXSDSource() {
        return this.xsdSource;
    }

    public void setXSDDefinedField(String xsddefinedfieldin) {
        this.xsdDefinedField = xsddefinedfieldin;
    }

    public String getXSDDefinedField() {
        return this.xsdDefinedField;
    }

    public boolean getXMLSourceFile() {
        return this.xmlSourceFile;
    }

    public void setXMLSourceFile(boolean xmlsourcefilein) {
        this.xmlSourceFile = xmlsourcefilein;
    }

    public String getIfXmlValid() {
        return this.ifXmlValid;
    }

    public String getIfXmlInvalid() {
        return this.ifXmlInvalid;
    }

    public void setIfXMLValid(String ifXmlValid) {
        this.ifXmlValid = ifXmlValid;
    }

    public void setIfXmlInvalid(String ifXmlInvalid) {
        this.ifXmlInvalid = ifXmlInvalid;
    }

    public boolean getOutputStringField() {
        return this.outputStringField;
    }

    public void setOutputStringField(boolean outputStringField) {
        this.outputStringField = outputStringField;
    }

    public String getValidationMessageField() {
        return this.validationMessageField;
    }

    public void setValidationMessageField(String validationMessageField) {
        this.validationMessageField = validationMessageField;
    }

    public boolean useAddValidationMessage() {
        return this.addValidationMessage;
    }

    public void setAddValidationMessage(boolean addValidationMessage) {
        this.addValidationMessage = addValidationMessage;
    }

    public String getXSDFilename() {
        return this.xsdFilename;
    }

    public String getResultfieldname() {
        return this.resultFieldname;
    }

    public String getXMLStream() {
        return this.xmlStream;
    }

    public void setXSDfilename(String xdsFilename) {
        this.xsdFilename = xdsFilename;
    }

    public void setResultfieldname(String resultFieldname) {
        this.resultFieldname = resultFieldname;
    }

    public void setXMLStream(String xmlStream) {
        this.xmlStream = xmlStream;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        XsdValidatorMeta retval = (XsdValidatorMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.xsdFilename = XMLHandler.getTagValue((Node)stepnode, (String)"xdsfilename");
            this.xmlStream = XMLHandler.getTagValue((Node)stepnode, (String)"xmlstream");
            this.resultFieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.xsdDefinedField = XMLHandler.getTagValue((Node)stepnode, (String)"xsddefinedfield");
            this.xsdSource = XMLHandler.getTagValue((Node)stepnode, (String)"xsdsource");
            this.addValidationMessage = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addvalidationmsg"));
            this.validationMessageField = XMLHandler.getTagValue((Node)stepnode, (String)"validationmsgfield");
            this.ifXmlValid = XMLHandler.getTagValue((Node)stepnode, (String)"ifxmlvalid");
            this.ifXmlInvalid = XMLHandler.getTagValue((Node)stepnode, (String)"ifxmlunvalid");
            this.outputStringField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"outputstringfield"));
            this.xmlSourceFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"xmlsourcefile"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"XsdValidatorMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.xsdFilename = "";
        this.xmlStream = "";
        this.resultFieldname = "result";
        this.addValidationMessage = false;
        this.validationMessageField = "ValidationMsgField";
        this.ifXmlValid = "";
        this.ifXmlInvalid = "";
        this.outputStringField = false;
        this.xmlSourceFile = false;
        this.xsdDefinedField = "";
        this.xsdSource = this.SPECIFY_FILENAME;
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v;
        if (!Const.isEmpty((String)this.resultFieldname)) {
            if (this.outputStringField) {
                v = new ValueMeta(space.environmentSubstitute(this.getResultfieldname()), 2);
                inputRowMeta.addValueMeta((ValueMetaInterface)v);
            } else {
                v = new ValueMeta(space.environmentSubstitute(this.getResultfieldname()), 4);
                inputRowMeta.addValueMeta((ValueMetaInterface)v);
            }
        }
        if (this.addValidationMessage && !Const.isEmpty((String)this.validationMessageField)) {
            v = new ValueMeta(space.environmentSubstitute(this.validationMessageField), 2);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"xdsfilename", (String)this.xsdFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlstream", (String)this.xmlStream));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultFieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"addvalidationmsg", (boolean)this.addValidationMessage));
        retval.append("    " + XMLHandler.addTagValue((String)"validationmsgfield", (String)this.validationMessageField));
        retval.append("    " + XMLHandler.addTagValue((String)"ifxmlunvalid", (String)this.ifXmlInvalid));
        retval.append("    " + XMLHandler.addTagValue((String)"ifxmlvalid", (String)this.ifXmlValid));
        retval.append("    " + XMLHandler.addTagValue((String)"outputstringfield", (boolean)this.outputStringField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlsourcefile", (boolean)this.xmlSourceFile));
        retval.append("    " + XMLHandler.addTagValue((String)"xsddefinedfield", (String)this.xsdDefinedField));
        retval.append("    " + XMLHandler.addTagValue((String)"xsdsource", (String)this.xsdSource));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.xsdFilename = rep.getStepAttributeString(id_step, "xdsfilename");
            this.xmlStream = rep.getStepAttributeString(id_step, "xmlstream");
            this.resultFieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.xmlSourceFile = rep.getStepAttributeBoolean(id_step, "xmlsourcefile");
            this.addValidationMessage = rep.getStepAttributeBoolean(id_step, "addvalidationmsg");
            this.validationMessageField = rep.getStepAttributeString(id_step, "validationmsgfield");
            this.ifXmlValid = rep.getStepAttributeString(id_step, "ifxmlvalid");
            this.ifXmlInvalid = rep.getStepAttributeString(id_step, "ifxmlunvalid");
            this.outputStringField = rep.getStepAttributeBoolean(id_step, "outputstringfield");
            this.xsdDefinedField = rep.getStepAttributeString(id_step, "xsddefinedfield");
            this.xsdSource = rep.getStepAttributeString(id_step, "xsdsource");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XsdValidatorMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "xdsfilename", this.xsdFilename);
            rep.saveStepAttribute(id_transformation, id_step, "xmlstream", this.xmlStream);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultFieldname);
            rep.saveStepAttribute(id_transformation, id_step, "xmlsourcefile", this.xmlSourceFile);
            rep.saveStepAttribute(id_transformation, id_step, "addvalidationmsg", this.addValidationMessage);
            rep.saveStepAttribute(id_transformation, id_step, "validationmsgfield", this.validationMessageField);
            rep.saveStepAttribute(id_transformation, id_step, "ifxmlvalid", this.ifXmlValid);
            rep.saveStepAttribute(id_transformation, id_step, "ifxmlunvalid", this.ifXmlInvalid);
            rep.saveStepAttribute(id_transformation, id_step, "outputstringfield", this.outputStringField);
            rep.saveStepAttribute(id_transformation, id_step, "xsddefinedfield", this.xsdDefinedField);
            rep.saveStepAttribute(id_transformation, id_step, "xsdsource", this.xsdSource);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XsdValidatorMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (Const.isEmpty((String)this.xmlStream)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.XMLStreamFieldEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.XMLStreamFieldOK", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.resultFieldname)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ResultFieldEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ResultFieldOK", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.xsdSource.equals(this.SPECIFY_FILENAME) && Const.isEmpty((String)this.xsdFilename)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.XSDFieldEmpty", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ConnectedStepOK", (String[])new String[]{String.valueOf(prev.size())}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new XsdValidator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new XsdValidatorData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!Const.isEmpty((String)this.xsdFilename)) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.xsdFilename), (VariableSpace)space);
                this.xsdFilename = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.xsdFilename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

