/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.usersettings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.usersettings.IAnyUserSettingService;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository.usersettings.pojo.UserSetting;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSettingService
implements IAnyUserSettingService,
IUserSettingService {
    public static final String SETTING_PREFIX = "_USERSETTING";
    IPentahoSession session = null;
    private static final byte[] lock = new byte[0];
    protected IUnifiedRepository repository;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public UserSettingService(IUnifiedRepository repository) {
        this.repository = repository;
    }

    public void init(IPentahoSession session) {
        this.session = session;
    }

    public void deleteUserSettings() {
        String homePath = ClientRepositoryPaths.getUserHomeFolderPath(PentahoSessionHolder.getSession().getName());
        Serializable id = this.repository.getFile(homePath).getId();
        Map fileMetadata = this.repository.getFileMetadata(id);
        HashMap finalMetadata = new HashMap(fileMetadata.size());
        for (Map.Entry entry : fileMetadata.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(SETTING_PREFIX)) continue;
            finalMetadata.put(key, entry.getValue());
        }
        this.repository.setFileMetadata(id, finalMetadata);
    }

    private static UserSetting createSetting(String name, Serializable value) {
        return UserSettingService.createSetting(name, value.toString());
    }

    private static UserSetting createSetting(String name, String value) {
        UserSetting setting = new UserSetting();
        setting.setSettingName(name);
        setting.setSettingValue(value);
        return setting;
    }

    public List<IUserSetting> getUserSettings() {
        ArrayList<IUserSetting> userSettings = new ArrayList<IUserSetting>();
        String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
        Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
        Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
        for (Map.Entry entry : tenantMetadata.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(SETTING_PREFIX)) continue;
            UserSetting setting = UserSettingService.createSetting(key.substring(SETTING_PREFIX.length()), (Serializable)entry.getValue());
            userSettings.add(setting);
        }
        String homePath = ClientRepositoryPaths.getUserHomeFolderPath(PentahoSessionHolder.getSession().getName());
        Serializable userHomeId = this.repository.getFile(homePath).getId();
        Map userMetadata = this.repository.getFileMetadata(userHomeId);
        for (Map.Entry entry : userMetadata.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(SETTING_PREFIX)) continue;
            UserSetting setting = UserSettingService.createSetting(key.substring(SETTING_PREFIX.length()), (Serializable)entry.getValue());
            if (userSettings.contains(setting)) {
                userSettings.remove(setting);
            }
            userSettings.add(setting);
        }
        return userSettings;
    }

    public IUserSetting getUserSetting(String settingName, String defaultValue) {
        boolean hasAuth;
        boolean bl = hasAuth = PentahoSessionHolder.getSession().getAttribute("SPRING_SECURITY_CONTEXT") != null;
        if (hasAuth) {
            try {
                String homePath = ClientRepositoryPaths.getUserHomeFolderPath(PentahoSessionHolder.getSession().getName());
                Serializable userHomeId = this.repository.getFile(homePath).getId();
                Map userMetadata = this.repository.getFileMetadata(userHomeId);
                for (Map.Entry entry : userMetadata.entrySet()) {
                    String settingFromKey;
                    String key = (String)entry.getKey();
                    if (!key.startsWith(SETTING_PREFIX) || !(settingFromKey = key.substring(SETTING_PREFIX.length())).equals(settingName)) continue;
                    return UserSettingService.createSetting(settingFromKey, (Serializable)entry.getValue());
                }
                String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
                Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
                Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
                for (Map.Entry entry : tenantMetadata.entrySet()) {
                    String settingFromKey;
                    String key = (String)entry.getKey();
                    if (!key.startsWith(SETTING_PREFIX) || !(settingFromKey = key.substring(SETTING_PREFIX.length())).equals(settingName)) continue;
                    return UserSettingService.createSetting(settingFromKey, (Serializable)entry.getValue());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return UserSettingService.createSetting(settingName, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserSetting(String settingName, String settingValue) {
        String name = PentahoSessionHolder.getSession().getName();
        String homePath = ClientRepositoryPaths.getUserHomeFolderPath(name);
        byte[] byArray = lock;
        synchronized (lock) {
            final Serializable id = this.repository.getFile(homePath).getId();
            final Map fileMetadata = this.repository.getFileMetadata(id);
            fileMetadata.put(SETTING_PREFIX + settingName, settingValue);
            try {
                SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        UserSettingService.this.repository.setFileMetadata(id, fileMetadata);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Error storing user setting for user: " + name + ", setting: " + settingName + ", value: " + settingValue, (Throwable)e);
                }
                this.log.error("Error storing user setting", (Throwable)e);
            }
            return;
        }
    }

    public void deleteUserSettings(String username) throws SecurityException {
        HashMap finalMetadata;
        Serializable id;
        if (this.canAdminister()) {
            String homePath = ClientRepositoryPaths.getUserHomeFolderPath(username);
            id = this.repository.getFile(homePath).getId();
            Map fileMetadata = this.repository.getFileMetadata(id);
            finalMetadata = new HashMap(fileMetadata.size());
            for (Map.Entry entry : fileMetadata.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(SETTING_PREFIX)) continue;
                finalMetadata.put(key, entry.getValue());
            }
        } else {
            throw new SecurityException("Unauthorized User");
        }
        this.repository.setFileMetadata(id, finalMetadata);
    }

    public List<IUserSetting> getUserSettings(String username) throws SecurityException {
        ArrayList<IUserSetting> userSettings = new ArrayList<IUserSetting>();
        if (this.canAdminister()) {
            try {
                String homePath = ClientRepositoryPaths.getUserHomeFolderPath(username);
                Serializable userHomeId = this.repository.getFile(homePath).getId();
                Map userMetadata = this.repository.getFileMetadata(userHomeId);
                for (Map.Entry entry : userMetadata.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith(SETTING_PREFIX)) continue;
                    String settingFromKey = key.substring(SETTING_PREFIX.length());
                    userSettings.add(UserSettingService.createSetting(settingFromKey, (Serializable)entry.getValue()));
                }
            }
            catch (Throwable throwable) {}
        } else {
            throw new SecurityException("Unauthorized User");
        }
        return userSettings;
    }

    public IUserSetting getUserSetting(String username, String settingName, String defaultValue) throws SecurityException {
        if (this.canAdminister()) {
            try {
                String homePath = ClientRepositoryPaths.getUserHomeFolderPath(PentahoSessionHolder.getSession().getName());
                Serializable userHomeId = this.repository.getFile(homePath).getId();
                Map userMetadata = this.repository.getFileMetadata(userHomeId);
                for (Map.Entry entry : userMetadata.entrySet()) {
                    String settingFromKey;
                    String key = (String)entry.getKey();
                    if (!key.startsWith(SETTING_PREFIX) || !(settingFromKey = key.substring(SETTING_PREFIX.length())).equals(settingName)) continue;
                    return UserSettingService.createSetting(settingFromKey, (Serializable)entry.getValue());
                }
            }
            catch (Throwable throwable) {}
        } else {
            throw new SecurityException("Unauthorized User");
        }
        return UserSettingService.createSetting(settingName, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserSetting(String username, String settingName, String settingValue) throws SecurityException {
        if (this.canAdminister()) {
            String homePath = ClientRepositoryPaths.getUserHomeFolderPath(username);
            byte[] byArray = lock;
            synchronized (lock) {
                final Serializable id = this.repository.getFile(homePath).getId();
                final Map fileMetadata = this.repository.getFileMetadata(id);
                fileMetadata.put(SETTING_PREFIX + settingName, settingValue);
                try {
                    SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            UserSettingService.this.repository.setFileMetadata(id, fileMetadata);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Error storing user setting for user: " + username + ", setting: " + settingName + ", value: " + settingValue, (Throwable)e);
                    }
                    this.log.error("Error storing user setting", (Throwable)e);
                }
            }
        }
        throw new SecurityException("Unauthorized User");
    }

    public IUserSetting getGlobalUserSetting(String settingName, String defaultValue) {
        String key;
        String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
        Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
        Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
        Serializable value = (Serializable)tenantMetadata.get(key = SETTING_PREFIX + settingName);
        if (value != null) {
            return UserSettingService.createSetting(settingName, value.toString());
        }
        return UserSettingService.createSetting(settingName, defaultValue);
    }

    public List<IUserSetting> getGlobalUserSettings() {
        String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
        Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
        Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
        ArrayList<IUserSetting> userSettings = new ArrayList<IUserSetting>(tenantMetadata.size());
        for (Map.Entry entry : tenantMetadata.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(SETTING_PREFIX)) continue;
            userSettings.add(UserSettingService.createSetting(key.substring(SETTING_PREFIX.length()), (Serializable)entry.getValue()));
        }
        return userSettings;
    }

    public void setGlobalUserSetting(String settingName, String settingValue) {
        if (SecurityHelper.getInstance().isPentahoAdministrator(this.session)) {
            String tentantHomePath = ClientRepositoryPaths.getEtcFolderPath();
            Serializable tenantHomeId = this.repository.getFile(tentantHomePath).getId();
            Map tenantMetadata = this.repository.getFileMetadata(tenantHomeId);
            tenantMetadata.put(SETTING_PREFIX + settingName, settingValue);
            this.repository.setFileMetadata(tenantHomeId, tenantMetadata);
        }
    }

    private boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }
}

