/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import com.google.common.base.Throwables;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.dataservice.jdbc.ThinConnection;
import org.pentaho.di.trans.dataservice.jdbc.ThinDriver;
import org.pentaho.di.trans.dataservice.jdbc.ThinParameterMetaData;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultFactory;
import org.pentaho.di.trans.dataservice.jdbc.ThinStatement;
import org.pentaho.di.trans.dataservice.jdbc.annotation.NotSupported;

public class ThinPreparedStatement
extends ThinStatement
implements PreparedStatement {
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("'['yyyy/MM/dd HH:mm:ss.SSS']'");
    private final String sql;
    protected List<Integer> placeholderIndexes;
    protected ValueMetaInterface[] paramMeta;
    protected Object[] paramData;

    public ThinPreparedStatement(ThinConnection connection, String sql) throws SQLException {
        this(connection, sql, new ThinResultFactory());
    }

    public ThinPreparedStatement(ThinConnection connection, String sql, ThinResultFactory resultFactory) throws SQLException {
        super(connection, resultFactory);
        this.sql = sql;
        this.analyzeSql();
    }

    public void analyzeSql() throws SQLException {
        try {
            this.placeholderIndexes = new ArrayList<Integer>();
            for (int index = 0; index < this.sql.length(); ++index) {
                if ((index = ThinUtil.skipChars((String)this.sql, (int)index, (char[])new char[]{'\'', '\"'})) >= this.sql.length() || this.sql.charAt(index) != '?') continue;
                this.placeholderIndexes.add(index);
            }
            this.paramData = new Object[this.placeholderIndexes.size()];
            this.paramMeta = new ValueMetaInterface[this.placeholderIndexes.size()];
            for (int i = 0; i < this.placeholderIndexes.size(); ++i) {
                this.paramMeta[i] = new ValueMetaString("param-" + (i + 1));
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SQLException.class);
            throw new SQLException(e);
        }
    }

    public String replaceSql() throws SQLException {
        try {
            StringBuilder newSql = new StringBuilder(this.sql);
            for (int i = this.placeholderIndexes.size() - 1; i >= 0; --i) {
                int index = this.placeholderIndexes.get(i);
                ValueMetaInterface valueMeta = this.paramMeta[i];
                if (valueMeta == null) {
                    throw new SQLException("Parameter " + (i + 1) + " was not specified");
                }
                String replacement = null;
                if (valueMeta.isNull(this.paramData[i])) {
                    replacement = "NULL";
                } else {
                    switch (valueMeta.getType()) {
                        case 2: {
                            replacement = "'" + valueMeta.getString(this.paramData[i]) + "'";
                            break;
                        }
                        case 1: {
                            double d = valueMeta.getNumber(this.paramData[i]);
                            replacement = Double.toString(d);
                            break;
                        }
                        case 5: {
                            long l = valueMeta.getInteger(this.paramData[i]);
                            replacement = Long.toString(l);
                            break;
                        }
                        case 3: {
                            java.util.Date date = valueMeta.getDate(this.paramData[i]);
                            replacement = FORMAT.format(date);
                            break;
                        }
                        case 6: {
                            BigDecimal bd = valueMeta.getBigNumber(this.paramData[i]);
                            replacement = bd.toString();
                            break;
                        }
                        case 4: {
                            boolean b = valueMeta.getBoolean(this.paramData[i]);
                            replacement = b ? "TRUE" : "FALSE";
                            break;
                        }
                    }
                }
                if (replacement == null) {
                    throw new KettleSQLException("Unhandled data type: " + valueMeta.getTypeDesc() + " replacing parameter " + (i + 1));
                }
                newSql.replace(index, index + 1, replacement);
            }
            return newSql.toString();
        }
        catch (Exception e) {
            throw new SQLException("Unexpected enhancing SQL to include specified parameters", e);
        }
    }

    @Override
    @NotSupported
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch operations are not supported");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.analyzeSql();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.replaceSql());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.replaceSql());
    }

    @Override
    @NotSupported
    public int executeUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException("Update operations are not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        return resultSet == null ? null : resultSet.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new ThinParameterMetaData(this);
    }

    @Override
    @NotSupported
    public void setArray(int nr, Array value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    @NotSupported
    public void setAsciiStream(int nr, InputStream value) throws SQLException {
        throw new SQLFeatureNotSupportedException("ASCII Streams are not supported");
    }

    @Override
    @NotSupported
    public void setAsciiStream(int nr, InputStream value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("ASCII Streams are not supported");
    }

    @Override
    @NotSupported
    public void setAsciiStream(int nr, InputStream value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("ASCII Streams are not supported");
    }

    @Override
    public void setBigDecimal(int nr, BigDecimal value) throws SQLException {
        this.setValue(nr, value, (ValueMetaInterface)new ValueMetaBigNumber("param-" + nr));
    }

    @Override
    @NotSupported
    public void setBinaryStream(int nr, InputStream value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Binary Streams are not supported");
    }

    @Override
    @NotSupported
    public void setBinaryStream(int nr, InputStream value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Binary Streams are not supported");
    }

    @Override
    @NotSupported
    public void setBinaryStream(int nr, InputStream value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Binary Streams are not supported");
    }

    @Override
    @NotSupported
    public void setBlob(int nr, Blob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("BLOB parameters are not supported");
    }

    @Override
    @NotSupported
    public void setBlob(int nr, InputStream value) throws SQLException {
        throw new SQLFeatureNotSupportedException("BLOB parameters are not supported");
    }

    @Override
    @NotSupported
    public void setBlob(int nr, InputStream value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("BLOB parameters are not supported");
    }

    @Override
    public void setBoolean(int nr, boolean value) throws SQLException {
        this.setValue(nr, value, (ValueMetaInterface)new ValueMetaBoolean("param-" + nr));
    }

    @Override
    public void setByte(int nr, byte value) throws SQLException {
        this.setValue(nr, value, (ValueMetaInterface)new ValueMetaInteger("param-" + nr));
    }

    @Override
    @NotSupported
    public void setBytes(int nr, byte[] value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Binary parameters are not supported");
    }

    @Override
    @NotSupported
    public void setCharacterStream(int nr, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Character stream parameters are not supported");
    }

    @Override
    @NotSupported
    public void setCharacterStream(int nr, Reader value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Character stream parameters are not supported");
    }

    @Override
    @NotSupported
    public void setCharacterStream(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Character stream parameters are not supported");
    }

    @Override
    @NotSupported
    public void setClob(int nr, Clob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("CLOB parameters are not supported");
    }

    @Override
    @NotSupported
    public void setClob(int nr, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("CLOB parameters are not supported");
    }

    @Override
    @NotSupported
    public void setClob(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("CLOB parameters are not supported");
    }

    @Override
    public void setDate(int nr, Date value) throws SQLException {
        this.setDate(nr, value, Calendar.getInstance());
    }

    @Override
    public void setDate(int nr, Date value, Calendar calendar) throws SQLException {
        this.setTimeValue(nr, value, calendar);
    }

    @Override
    public void setDouble(int nr, double value) throws SQLException {
        this.setValue(nr, value, (ValueMetaInterface)new ValueMetaNumber("param-" + nr));
    }

    @Override
    public void setFloat(int nr, float value) throws SQLException {
        this.setDouble(nr, value);
    }

    @Override
    public void setInt(int nr, int value) throws SQLException {
        this.setValue(nr, value, (ValueMetaInterface)new ValueMetaInteger("param-" + nr));
    }

    @Override
    public void setLong(int nr, long value) throws SQLException {
        this.setValue(nr, value, (ValueMetaInterface)new ValueMetaInteger("param-" + nr));
    }

    @Override
    @NotSupported
    public void setNCharacterStream(int nr, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCharacter stream parameters are not supported");
    }

    @Override
    @NotSupported
    public void setNCharacterStream(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCharacter stream parameters are not supported");
    }

    @Override
    @NotSupported
    public void setNClob(int nr, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCLOB parameters are not supported");
    }

    @Override
    @NotSupported
    public void setNClob(int nr, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCLOB parameters are not supported");
    }

    @Override
    @NotSupported
    public void setNClob(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCLOB parameters are not supported");
    }

    @Override
    @NotSupported
    public void setNString(int nr, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NString parameters are not supported");
    }

    @Override
    public void setNull(int nr, int sqlType) throws SQLException {
        this.setValue(nr, null, ThinUtil.getValueMeta((String)("param-" + nr), (int)sqlType));
    }

    @Override
    public void setNull(int nr, int value, String typeName) throws SQLException {
        this.setNull(nr, value);
    }

    @Override
    public void setObject(int nr, Object value) throws SQLException {
        if (value == null) {
            this.setNull(nr, 1111);
        } else if (value instanceof String) {
            this.setString(nr, (String)value);
        } else if (value instanceof Long) {
            this.setLong(nr, (Long)value);
        } else if (value instanceof Integer) {
            this.setInt(nr, (Integer)value);
        } else if (value instanceof Byte) {
            this.setByte(nr, (Byte)value);
        } else if (value instanceof java.util.Date) {
            this.setTimeValue(nr, (java.util.Date)value, Calendar.getInstance());
        } else if (value instanceof Boolean) {
            this.setBoolean(nr, (Boolean)value);
        } else if (value instanceof Double) {
            this.setDouble(nr, (Double)value);
        } else if (value instanceof Float) {
            this.setFloat(nr, ((Float)value).floatValue());
        } else if (value instanceof BigDecimal) {
            this.setBigDecimal(nr, (BigDecimal)value);
        } else {
            throw new SQLException("value of class " + value.getClass().getName());
        }
    }

    @Override
    public void setObject(int nr, Object value, int targetSqlType) throws SQLException {
        ThinDriver.logger.warning(String.format("Ignoring targetSqlType (%s).  Deducing sql type from object (%s)", targetSqlType, value == null ? "NULL" : value.getClass().getName()));
        this.setObject(nr, value);
    }

    @Override
    public void setObject(int nr, Object value, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(nr, value, targetSqlType);
    }

    @Override
    @NotSupported
    public void setRef(int nr, Ref value) throws SQLException {
        throw new SQLFeatureNotSupportedException("REF parameters are not supported");
    }

    @Override
    @NotSupported
    public void setRowId(int nr, RowId value) throws SQLException {
        throw new SQLFeatureNotSupportedException("ROWID parameters are not supported");
    }

    @Override
    @NotSupported
    public void setSQLXML(int nr, SQLXML value) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXML parameters are not supported");
    }

    @Override
    public void setShort(int nr, short value) throws SQLException {
        this.setLong(nr, value);
    }

    @Override
    public void setString(int nr, String value) throws SQLException {
        this.setValue(nr, value, (ValueMetaInterface)new ValueMetaString("param-" + nr));
    }

    @Override
    public void setTime(int nr, Time value) throws SQLException {
        this.setTime(nr, value, Calendar.getInstance());
    }

    @Override
    public void setTime(int nr, Time value, Calendar calendar) throws SQLException {
        this.setTimeValue(nr, value, calendar);
    }

    @Override
    public void setTimestamp(int nr, Timestamp value) throws SQLException {
        this.setTimestamp(nr, value, Calendar.getInstance());
    }

    @Override
    public void setTimestamp(int nr, Timestamp value, Calendar calendar) throws SQLException {
        this.setTimeValue(nr, value, calendar);
    }

    @Override
    @NotSupported
    public void setURL(int nr, URL value) throws SQLException {
        throw new SQLFeatureNotSupportedException("URL parameters are not supported");
    }

    @Override
    @NotSupported
    @Deprecated
    public void setUnicodeStream(int nr, InputStream value, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unicode stream parameters are not supported");
    }

    public ValueMetaInterface[] getParamMeta() {
        return this.paramMeta;
    }

    public Object[] getParamData() {
        return this.paramData;
    }

    protected void setValue(int nr, Object value, ValueMetaInterface valueMeta) throws SQLException {
        if (nr < 1 || nr > this.paramData.length) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the SQL statement");
        }
        this.paramData[nr - 1] = value;
        this.paramMeta[nr - 1] = valueMeta;
    }

    protected void setTimeValue(int nr, java.util.Date value, Calendar calendar) throws SQLException {
        calendar.setTime(value);
        this.setValue(nr, calendar.getTime(), (ValueMetaInterface)new ValueMetaDate("param-" + nr));
    }
}

