/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.sqoop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.bigdata.api.sqoop.SqoopService;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.SqoopShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopServiceImpl
implements SqoopService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqoopServiceImpl.class);
    private final HadoopShim hadoopShim;
    private final SqoopShim sqoopShim;
    private final NamedCluster namedCluster;

    public SqoopServiceImpl(HadoopShim hadoopShim, SqoopShim sqoopShim, NamedCluster namedCluster) {
        this.hadoopShim = hadoopShim;
        this.sqoopShim = sqoopShim;
        this.namedCluster = namedCluster;
    }

    public int runTool(List<String> args, Properties properties) {
        Configuration configuration = this.hadoopShim.createConfiguration();
        for (Map.Entry entry : Maps.fromProperties((Properties)properties).entrySet()) {
            configuration.set((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            System.setProperty("sqoop.throwOnError", "true");
            this.configureShim(configuration);
            return this.sqoopShim.runTool(args.toArray(new String[args.size()]), configuration);
        }
        catch (Exception e) {
            LOGGER.error("Error executing sqoop", (Throwable)e);
            return 1;
        }
    }

    public void configureShim(Configuration conf) throws Exception {
        ArrayList messages = Lists.newArrayList();
        if (this.namedCluster.isMapr()) {
            this.hadoopShim.configureConnectionInformation("", "", "", "", conf, (List)messages);
        } else {
            this.hadoopShim.configureConnectionInformation(this.namedCluster.environmentSubstitute(this.namedCluster.getHdfsHost()), this.namedCluster.environmentSubstitute(this.namedCluster.getHdfsPort()), this.namedCluster.environmentSubstitute(this.namedCluster.getJobTrackerHost()), this.namedCluster.environmentSubstitute(this.namedCluster.getJobTrackerPort()), conf, (List)messages);
        }
        for (String m : messages) {
            LOGGER.info(m);
        }
    }
}

