/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POUnion
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    BitSet done;
    boolean nextReturnEOP = false;
    private static Result eopResult = new Result(3, null);
    int lastInd = 0;

    public POUnion(OperatorKey k) {
        this(k, -1, null);
    }

    public POUnion(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POUnion(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POUnion(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void setInputs(List<PhysicalOperator> inputs) {
        super.setInputs(inputs);
        this.done = inputs != null ? new BitSet(inputs.size()) : new BitSet(0);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitUnion(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Union" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public void clearDone() {
        this.done.clear();
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (this.nextReturnEOP) {
            this.nextReturnEOP = false;
            return eopResult;
        }
        if (!this.isInputAttached()) {
            if (this.inputs == null || this.inputs.size() == 0) {
                return eopResult;
            }
            while (true) {
                Result res;
                if (this.done.nextClearBit(0) >= this.inputs.size()) {
                    this.clearDone();
                    return eopResult;
                }
                if (this.lastInd >= this.inputs.size() || this.done.nextClearBit(this.lastInd) >= this.inputs.size()) {
                    this.lastInd = 0;
                }
                int ind = this.done.nextClearBit(this.lastInd);
                do {
                    if (POUnion.getReporter() != null) {
                        POUnion.getReporter().progress();
                    }
                    res = ((PhysicalOperator)this.inputs.get(ind)).getNextTuple();
                    this.lastInd = ind + 1;
                    if (res.returnStatus != 0 && res.returnStatus != 1 && res.returnStatus != 2) continue;
                    this.illustratorMarkup(res.result, res.result, ind);
                    return res;
                } while (res.returnStatus != 3);
                this.done.set(ind);
            }
        }
        this.res.result = this.input;
        this.res.returnStatus = 0;
        this.detachInput();
        this.nextReturnEOP = true;
        this.illustratorMarkup(this.res.result, this.res.result, 0);
        return this.res;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            if (this.illustrator.getEquivalenceClasses() == null) {
                int size = this.inputs == null ? 1 : this.inputs.size();
                LinkedList<IdentityHashSet<Tuple>> equivalenceClasses = new LinkedList<IdentityHashSet<Tuple>>();
                for (int i = 0; i < size; ++i) {
                    IdentityHashSet equivalenceClass = new IdentityHashSet();
                    equivalenceClasses.add(equivalenceClass);
                }
                this.illustrator.setEquivalenceClasses(equivalenceClasses, this);
            }
            ExampleTuple tIn = (ExampleTuple)in;
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tIn);
            this.illustrator.addData((Tuple)out);
        }
        return null;
    }
}

