/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.RerunTransitionXCommand;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class BundleRerunXCommand
extends RerunTransitionXCommand<Void> {
    private final String coordScope;
    private final String dateScope;
    private final boolean refresh;
    private final boolean noCleanup;
    private BundleJobBean bundleJob;
    private List<BundleActionBean> bundleActions;
    protected boolean prevPending;

    public BundleRerunXCommand(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) {
        super("bundle_rerun", "bundle_rerun", 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.coordScope = coordScope;
        this.dateScope = dateScope;
        this.refresh = refresh;
        this.noCleanup = noCleanup;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, this.jobId);
            this.bundleActions = BundleActionQueryExecutor.getInstance().getList(BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, this.jobId);
            LogUtils.setLogInfo(this.bundleJob, this.logInfo);
            super.setJob((Job)this.bundleJob);
            this.prevPending = this.bundleJob.isPending();
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public void rerunChildren() throws CommandException {
        boolean isUpdateActionDone = false;
        HashMap<String, BundleActionBean> coordNameToBAMapping = new HashMap<String, BundleActionBean>();
        if (this.bundleActions != null) {
            for (BundleActionBean action : this.bundleActions) {
                if (action.getCoordName() == null) continue;
                coordNameToBAMapping.put(action.getCoordName(), action);
            }
        }
        if (this.coordScope != null && !this.coordScope.isEmpty()) {
            String[] list;
            for (String coordName : list = this.coordScope.split(",")) {
                coordName = coordName.trim();
                if (coordNameToBAMapping.keySet().contains(coordName)) {
                    String rerunDateScope;
                    String coordId = ((BundleActionBean)coordNameToBAMapping.get(coordName)).getCoordId();
                    if (coordId == null) {
                        this.LOG.info("No coord id found. Therefore, nothing to queue for coord rerun for coordname: " + coordName);
                        continue;
                    }
                    CoordinatorJobBean coordJob = this.getCoordJob(coordId);
                    if (this.dateScope != null && !this.dateScope.isEmpty()) {
                        rerunDateScope = this.dateScope;
                    } else {
                        String coordStart = DateUtils.formatDateOozieTZ(coordJob.getStartTime());
                        String coordEnd = DateUtils.formatDateOozieTZ(coordJob.getEndTime());
                        rerunDateScope = coordStart + "::" + coordEnd;
                    }
                    this.LOG.debug("Queuing rerun range [" + rerunDateScope + "] for coord id " + coordId + " of bundle " + this.bundleJob.getId());
                    this.queue(new CoordRerunXCommand(coordId, "date", rerunDateScope, this.refresh, this.noCleanup));
                    this.updateBundleAction((BundleActionBean)coordNameToBAMapping.get(coordName));
                    isUpdateActionDone = true;
                    continue;
                }
                this.LOG.info("Rerun for coord " + coordName + " NOT performed because it is not in bundle ", this.bundleJob.getId());
            }
        } else if (this.dateScope != null && !this.dateScope.isEmpty() && this.bundleActions != null) {
            for (BundleActionBean action : this.bundleActions) {
                if (action.getCoordId() == null) {
                    this.LOG.info("No coord id found. Therefore nothing to queue for coord rerun with coord name " + action.getCoordName());
                    continue;
                }
                this.LOG.debug("Queuing rerun range [" + this.dateScope + "] for coord id " + action.getCoordId() + " of bundle " + this.bundleJob.getId());
                this.queue(new CoordRerunXCommand(action.getCoordId(), "date", this.dateScope, this.refresh, this.noCleanup));
                this.updateBundleAction(action);
                isUpdateActionDone = true;
            }
        }
        if (!isUpdateActionDone) {
            this.transitToPrevious();
        }
        this.LOG.info("Rerun coord jobs for the bundle=[{0}]", this.jobId);
    }

    private final void transitToPrevious() throws CommandException {
        this.bundleJob.setStatus(this.getPrevStatus());
        if (!this.prevPending) {
            this.bundleJob.resetPending();
        } else {
            this.bundleJob.setPending();
        }
        this.updateJob();
    }

    private void updateBundleAction(BundleActionBean action) {
        action.incrementAndGetPending();
        action.setLastModifiedTime(new Date());
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<BundleActionQueryExecutor.BundleActionQuery>(BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_PENDING_MODTIME, action));
    }

    @Override
    public void updateJob() {
        Job.Status bundleJobStatus;
        if (this.getPrevStatus() != null && ((bundleJobStatus = this.getPrevStatus()).equals((Object)Job.Status.PAUSED) || bundleJobStatus.equals((Object)Job.Status.PAUSEDWITHERROR))) {
            this.bundleJob.setStatus(bundleJobStatus);
            if (this.prevPending) {
                this.bundleJob.setPending();
            } else {
                this.bundleJob.resetPending();
            }
        }
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<BundleJobQueryExecutor.BundleJobQuery>(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, this.bundleJob));
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public Job getJob() {
        return this.bundleJob;
    }

    @Override
    public void notifyParent() throws CommandException {
    }

    @Override
    public XLog getLog() {
        return this.LOG;
    }

    private final CoordinatorJobBean getCoordJob(String coordId) throws CommandException {
        try {
            CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, coordId);
            return job;
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
    }
}

