/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.xml.sax.SAXException;

public class SchemaService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.SchemaService.";
    public static final String WF_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.wf.ext.schemas";
    public static final String COORD_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.coord.ext.schemas";
    public static final String BUNDLE_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.bundle.ext.schemas";
    public static final String SLA_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.sla.ext.schemas";
    @Deprecated
    public static final String SLA_NAME_SPACE_URI = "uri:oozie:sla:0.1";
    public static final String SLA_NAMESPACE_URI_2 = "uri:oozie:sla:0.2";
    public static final String COORDINATOR_NAMESPACE_URI_1 = "uri:oozie:coordinator:0.1";
    private Schema wfSchema;
    private Schema coordSchema;
    private Schema bundleSchema;
    private Schema slaSchema;
    private static final String[] OOZIE_WORKFLOW_XSD = new String[]{"oozie-workflow-0.1.xsd", "oozie-workflow-0.2.xsd", "oozie-workflow-0.2.5.xsd", "oozie-workflow-0.3.xsd", "oozie-workflow-0.4.xsd", "oozie-workflow-0.4.5.xsd", "oozie-workflow-0.5.xsd"};
    private static final String[] OOZIE_COORDINATOR_XSD = new String[]{"oozie-coordinator-0.1.xsd", "oozie-coordinator-0.2.xsd", "oozie-coordinator-0.3.xsd", "oozie-coordinator-0.4.xsd"};
    private static final String[] OOZIE_BUNDLE_XSD = new String[]{"oozie-bundle-0.1.xsd", "oozie-bundle-0.2.xsd"};
    private static final String[] OOZIE_SLA_SEMANTIC_XSD = new String[]{"gms-oozie-sla-0.1.xsd", "oozie-sla-0.2.xsd"};

    private Schema loadSchema(Configuration conf, String[] baseSchemas, String extSchema) throws SAXException, IOException {
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        for (String baseSchema : baseSchemas) {
            sources.add(new StreamSource(IOUtils.getResourceAsStream(baseSchema, -1)));
        }
        String[] schemas = conf.getStrings(extSchema);
        if (schemas != null) {
            for (String schema : schemas) {
                if ((schema = schema.trim()).isEmpty()) continue;
                sources.add(new StreamSource(IOUtils.getResourceAsStream(schema, -1)));
            }
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(sources.toArray(new StreamSource[sources.size()]));
    }

    @Override
    public void init(Services services) throws ServiceException {
        try {
            this.wfSchema = this.loadSchema(services.getConf(), OOZIE_WORKFLOW_XSD, WF_CONF_EXT_SCHEMAS);
            this.coordSchema = this.loadSchema(services.getConf(), OOZIE_COORDINATOR_XSD, COORD_CONF_EXT_SCHEMAS);
            this.bundleSchema = this.loadSchema(services.getConf(), OOZIE_BUNDLE_XSD, BUNDLE_CONF_EXT_SCHEMAS);
            this.slaSchema = this.loadSchema(services.getConf(), OOZIE_SLA_SEMANTIC_XSD, SLA_CONF_EXT_SCHEMAS);
            this.bundleSchema = this.loadSchema(services.getConf(), OOZIE_BUNDLE_XSD, BUNDLE_CONF_EXT_SCHEMAS);
        }
        catch (SAXException ex) {
            throw new ServiceException(ErrorCode.E0130, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0131, ex.getMessage(), ex);
        }
    }

    @Override
    public Class<? extends Service> getInterface() {
        return SchemaService.class;
    }

    @Override
    public void destroy() {
        this.wfSchema = null;
        this.bundleSchema = null;
        this.slaSchema = null;
        this.coordSchema = null;
    }

    public Schema getSchema(SchemaName schemaName) {
        Schema returnSchema = null;
        if (schemaName == SchemaName.WORKFLOW) {
            returnSchema = this.wfSchema;
        } else if (schemaName == SchemaName.COORDINATOR) {
            returnSchema = this.coordSchema;
        } else if (schemaName == SchemaName.BUNDLE) {
            returnSchema = this.bundleSchema;
        } else if (schemaName == SchemaName.SLA_ORIGINAL) {
            returnSchema = this.slaSchema;
        } else {
            throw new RuntimeException("No schema found with name " + (Object)((Object)schemaName));
        }
        return returnSchema;
    }

    public static enum SchemaName {
        WORKFLOW(1),
        COORDINATOR(2),
        SLA_ORIGINAL(3),
        BUNDLE(4);

        private final int id;

        private SchemaName(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

