/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.mongo.AuthContext;
import org.pentaho.mongo.KerberosHelper;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.MongoProp;
import org.pentaho.mongo.MongoProperties;
import org.pentaho.mongo.MongoUtilLogger;
import org.pentaho.mongo.wrapper.KerberosInvocationHandler;
import org.pentaho.mongo.wrapper.UsernamePasswordMongoClientWrapper;
import org.pentaho.mongo.wrapper.collection.KerberosMongoCollectionWrapper;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;

class KerberosMongoClientWrapper
extends UsernamePasswordMongoClientWrapper {
    private final AuthContext authContext;

    public KerberosMongoClientWrapper(MongoProperties props, MongoUtilLogger log) throws MongoDbException {
        super(props, log);
        this.authContext = new AuthContext(KerberosHelper.login(this.getUser(), props));
    }

    KerberosMongoClientWrapper(MongoClient client, MongoUtilLogger log, String username, AuthContext authContext) {
        super(client, log, username);
        this.authContext = authContext;
    }

    @Override
    public List<MongoCredential> getCredentialList() {
        ArrayList<MongoCredential> credList = new ArrayList<MongoCredential>();
        credList.add(MongoCredential.createGSSAPICredential((String)this.props.get(MongoProp.USERNAME)));
        return credList;
    }

    @Override
    protected MongoCollectionWrapper wrap(DBCollection collection) {
        return KerberosInvocationHandler.wrap(MongoCollectionWrapper.class, this.authContext, new KerberosMongoCollectionWrapper(collection, this.authContext));
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }
}

