/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.verticabulkload;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.ProvidesModelerMeta;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.verticabulkload.VerticaBulkLoader;
import org.pentaho.di.verticabulkload.VerticaBulkLoaderData;
import org.w3c.dom.Node;

@Step(id="VerticaBulkLoader", image="vertica.svg", i18nPackageName="plugin.com.vertica.kettle.bulkloader", name="VerticaBulkLoaderMeta.TypeLongDesc", description="VerticaBulkLoaderMeta.TypeTooltipDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Bulk", documentationUrl="http://wiki.pentaho.com/display/EAI/Vertica+Bulk+Loader")
public class VerticaBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesModelerMeta {
    private static Class<?> PKG = VerticaBulkLoaderMeta.class;
    private DatabaseMeta databaseMeta;
    private String schemaName;
    private String tablename;
    private boolean direct = true;
    private boolean abortOnError = true;
    private String exceptionsFileName;
    private String rejectedDataFileName;
    private String streamName;
    private boolean specifyFields;
    private String[] fieldStream = new String[0];
    private String[] fieldDatabase = new String[0];

    public void allocate(int nrRows) {
        this.fieldStream = new String[nrRows];
        this.fieldDatabase = new String[nrRows];
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public Object clone() {
        int i;
        VerticaBulkLoaderMeta retval = (VerticaBulkLoaderMeta)((Object)super.clone());
        int nrStream = this.fieldStream.length;
        int nrDatabase = this.fieldDatabase.length;
        retval.fieldStream = new String[nrStream];
        retval.fieldDatabase = new String[nrDatabase];
        for (i = 0; i < nrStream; ++i) {
            retval.fieldStream[i] = this.fieldStream[i];
        }
        for (i = 0; i < nrDatabase; ++i) {
            retval.fieldDatabase[i] = this.fieldDatabase[i];
        }
        return retval;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTablename() {
        return this.getTableName();
    }

    public String getTableName() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void setSpecifyFields(boolean specifyFields) {
        this.specifyFields = specifyFields;
    }

    public boolean specifyFields() {
        return this.specifyFields;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    public String getExceptionsFileName() {
        return this.exceptionsFileName;
    }

    public void setExceptionsFileName(String exceptionsFileName) {
        this.exceptionsFileName = exceptionsFileName;
    }

    public String getRejectedDataFileName() {
        return this.rejectedDataFileName;
    }

    public void setRejectedDataFileName(String rejectedDataFileName) {
        this.rejectedDataFileName = rejectedDataFileName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public boolean isSpecifyFields() {
        return this.specifyFields;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tablename = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.specifyFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"specify_fields"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrRows);
            for (int i = 0; i < nrRows; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldDatabase[i] = XMLHandler.getTagValue((Node)knode, (String)"column_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
            }
            this.exceptionsFileName = XMLHandler.getTagValue((Node)stepnode, (String)"exceptions_filename");
            this.rejectedDataFileName = XMLHandler.getTagValue((Node)stepnode, (String)"rejected_data_filename");
            this.abortOnError = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"abort_on_error"));
            this.direct = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"direct"));
            this.streamName = XMLHandler.getTagValue((Node)stepnode, (String)"stream_name");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.tablename = "";
        this.specifyFields = false;
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    " + XMLHandler.addTagValue((String)"table", (String)this.tablename));
        retval.append("    " + XMLHandler.addTagValue((String)"specify_fields", (boolean)this.specifyFields));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldDatabase.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"column_name", (String)this.fieldDatabase[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldStream[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"exceptions_filename", (String)this.exceptionsFileName));
        retval.append("    " + XMLHandler.addTagValue((String)"rejected_data_filename", (String)this.rejectedDataFileName));
        retval.append("    " + XMLHandler.addTagValue((String)"abort_on_error", (boolean)this.abortOnError));
        retval.append("    " + XMLHandler.addTagValue((String)"direct", (boolean)this.direct));
        retval.append("    " + XMLHandler.addTagValue((String)"stream_name", (String)this.streamName));
        return retval.toString();
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tablename = rep.getStepAttributeString(id_step, "table");
            this.specifyFields = rep.getStepAttributeBoolean(id_step, "specify_fields");
            int nrCols = rep.countNrStepAttributes(id_step, "field_column_name");
            int nrStreams = rep.countNrStepAttributes(id_step, "field_stream_name");
            int nrRows = nrCols < nrStreams ? nrStreams : nrCols;
            this.allocate(nrRows);
            for (int idx = 0; idx < nrRows; ++idx) {
                this.fieldDatabase[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "field_column_name"), (String)"");
                this.fieldStream[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "field_stream_name"), (String)"");
            }
            this.exceptionsFileName = rep.getStepAttributeString(id_step, "exceptions_filename");
            this.rejectedDataFileName = rep.getStepAttributeString(id_step, "rejected_data_filename");
            this.abortOnError = rep.getStepAttributeBoolean(id_step, "abort_on_error");
            this.direct = rep.getStepAttributeBoolean(id_step, "direct");
            this.streamName = rep.getStepAttributeString(id_step, "stream_name");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "specify_fields", this.specifyFields);
            int nrRows = this.fieldDatabase.length < this.fieldStream.length ? this.fieldStream.length : this.fieldDatabase.length;
            for (int idx = 0; idx < nrRows; ++idx) {
                String columnName = idx < this.fieldDatabase.length ? this.fieldDatabase[idx] : "";
                String streamName = idx < this.fieldStream.length ? this.fieldStream[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "field_column_name", columnName);
                rep.saveStepAttribute(id_transformation, id_step, idx, "field_stream_name", streamName);
            }
            rep.saveStepAttribute(id_transformation, id_step, "exceptions_filename", this.exceptionsFileName);
            rep.saveStepAttribute(id_transformation, id_step, "rejected_data_filename", this.rejectedDataFileName);
            rep.saveStepAttribute(id_transformation, id_step, "abort_on_error", this.abortOnError);
            rep.saveStepAttribute(id_transformation, id_step, "direct", this.direct);
            rep.saveStepAttribute(id_transformation, id_step, "stream_name", this.streamName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ConnectionExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            Database db = new Database((LoggingObjectInterface)transMeta, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ConnectionOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (!Const.isEmpty((String)transMeta.environmentSubstitute(this.tablename))) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tablename));
                    if (db.checkTableExists(schemaTable)) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        RowMetaInterface r = db.getTableFields(schemaTable);
                        if (r != null) {
                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            String error_message = "";
                            boolean error_found = false;
                            if (prev != null && prev.size() > 0) {
                                int idx;
                                int i;
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                                if (!this.specifyFields()) {
                                    for (i = 0; i < prev.size(); ++i) {
                                        ValueMetaInterface pv = prev.getValueMeta(i);
                                        idx = r.indexOfValue(pv.getName());
                                        if (idx >= 0) continue;
                                        error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                        error_found = true;
                                    }
                                    if (error_found) {
                                        error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsNotFoundInOutput", (String[])new String[]{error_message});
                                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    } else {
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    }
                                } else {
                                    for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                        int idx2 = r.indexOfValue(this.getFieldDatabase()[i]);
                                        if (idx2 >= 0) continue;
                                        error_message = error_message + "\t\t" + this.getFieldDatabase()[i] + Const.CR;
                                        error_found = true;
                                    }
                                    if (error_found) {
                                        error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsSpecifiedNotInTable", (String[])new String[]{error_message});
                                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    } else {
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    }
                                }
                                error_message = "";
                                if (!this.specifyFields()) {
                                    for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                        ValueMetaInterface rv = r.getValueMeta(i);
                                        idx = prev.indexOfValue(rv.getName());
                                        if (idx >= 0) continue;
                                        error_message = error_message + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                        error_found = true;
                                    }
                                    if (error_found) {
                                        error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                                        cr = new CheckResult(3, error_message, (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    }
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                }
                                for (i = 0; i < this.getFieldStream().length; ++i) {
                                    int idx3 = prev.indexOfValue(this.getFieldStream()[i]);
                                    if (idx3 >= 0) continue;
                                    error_message = error_message + "\t\t" + this.getFieldStream()[i] + Const.CR;
                                    error_found = true;
                                }
                                if (error_found) {
                                    error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsSpecifiedNotFound", (String[])new String[]{error_message});
                                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                }
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            }
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.NoTableName", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.NoConnection", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new VerticaBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new VerticaBulkLoaderData();
    }

    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (prev != null) {
            for (int i = 0; i < prev.size(); ++i) {
                ValueMetaInterface v = prev.getValueMeta(i);
                DatabaseImpact ii = new DatabaseImpact(2, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tablename), v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Const.isEmpty((String)transMeta.environmentSubstitute(this.tablename))) {
                    Database db = new Database((LoggingObjectInterface)transMeta, this.databaseMeta);
                    db.shareVariablesWith((VariableSpace)transMeta);
                    try {
                        db.connect();
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tablename));
                        String cr_table = db.getDDL(schemaTable, prev);
                        if (cr_table == null || cr_table.length() == 0) {
                            cr_table = null;
                        }
                        retval.setSQL(cr_table);
                    }
                    catch (KettleDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tablename);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public String[] getFieldDatabase() {
        return this.fieldDatabase;
    }

    public void setFieldDatabase(String[] fieldDatabase) {
        this.fieldDatabase = fieldDatabase;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowMetaInterface getTableRowMetaInterface() throws KettleException {
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        DBCache.getInstance().clear(this.databaseMeta.getName());
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)this.tablename)) throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tablename);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public RowMeta getRowMeta(StepDataInterface stepData) {
        return (RowMeta)((VerticaBulkLoaderData)stepData).getInsertRowMeta();
    }

    public List<String> getDatabaseFields() {
        if (this.specifyFields()) {
            return Arrays.asList(this.getFieldDatabase());
        }
        return Collections.emptyList();
    }

    public List<String> getStreamFields() {
        if (this.specifyFields()) {
            return Arrays.asList(this.getFieldStream());
        }
        return Collections.emptyList();
    }
}

