/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.clients.DataServiceClient;
import org.pentaho.di.trans.dataservice.optimization.AutoOptimizationService;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.UIFactory;

public class DataServiceContext {
    private final DataServiceMetaStoreUtil metaStoreUtil;
    private final List<AutoOptimizationService> autoOptimizationServices;
    private final PentahoCacheManager cacheManager;
    private final List<PushDownFactory> pushDownFactories;
    private final LogChannelInterface logChannel;
    private final UIFactory uiFactory;
    private final ConcurrentMap<String, DataServiceExecutor> executors = new ConcurrentHashMap<String, DataServiceExecutor>();

    public DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = DataServiceMetaStoreUtil.create(this);
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    @VisibleForTesting
    protected DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, DataServiceMetaStoreUtil metaStoreUtil, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = metaStoreUtil;
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    public PentahoCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public DataServiceMetaStoreUtil getMetaStoreUtil() {
        return this.metaStoreUtil;
    }

    public List<AutoOptimizationService> getAutoOptimizationServices() {
        return this.autoOptimizationServices;
    }

    public List<PushDownFactory> getPushDownFactories() {
        return this.pushDownFactories;
    }

    public LogChannelInterface getLogChannel() {
        return this.logChannel;
    }

    public UIFactory getUIFactory() {
        return this.uiFactory;
    }

    public DataServiceDelegate getDataServiceDelegate() {
        return DataServiceDelegate.withDefaultSpoonInstance(this);
    }

    public DataServiceClient createClient(final Supplier<Repository> supplier) {
        return new DataServiceClient(new DataServiceFactory(this){

            @Override
            public Repository getRepository() {
                return (Repository)supplier.get();
            }
        });
    }

    public DataServiceClient createLocalClient() {
        return new DataServiceClient(this.getDataServiceDelegate());
    }

    public void addExecutor(DataServiceExecutor executor) {
        this.executors.putIfAbsent(executor.getId(), executor);
    }

    public DataServiceExecutor getExecutor(String id) {
        return (DataServiceExecutor)this.executors.get(id);
    }

    public void removeExecutor(String id) {
        this.executors.remove(id);
    }
}

