/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.ui.repository.RepositoryExtension;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;

@ExtensionPoint(id="DeleteRepositoryObjectExtensionPointPlugin", extensionPointId="AfterDeleteRepositoryObject", description="Remove a data service associated with a deleted repository object")
public class DeleteRepositoryObjectExtensionPointPlugin
implements ExtensionPointInterface {
    private final DataServiceMetaStoreUtil metaStoreUtil;

    public DeleteRepositoryObjectExtensionPointPlugin(DataServiceContext context) {
        this.metaStoreUtil = context.getMetaStoreUtil();
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        RepositoryExtension repositoryExtension = (RepositoryExtension)object;
        UIRepositoryObject repositoryObject = repositoryExtension.getRepositoryObject();
        if (repositoryObject.getRepositoryElementType().equals((Object)RepositoryObjectType.TRANSFORMATION)) {
            Repository repository = repositoryObject.getRepository();
            this.metaStoreUtil.clearReferences(repository.loadTransformation(repositoryObject.getObjectId(), null));
        }
    }
}

