/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.clients;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.client.DataServiceClientService;
import org.pentaho.di.trans.dataservice.clients.CommandQueryService;
import org.pentaho.di.trans.dataservice.clients.DualQueryService;
import org.pentaho.di.trans.dataservice.clients.ExecutorQueryService;
import org.pentaho.di.trans.dataservice.clients.Query;
import org.pentaho.di.trans.dataservice.jdbc.ThinServiceInformation;
import org.pentaho.di.trans.dataservice.serialization.DataServiceFactory;
import org.pentaho.metastore.api.IMetaStore;

public class DataServiceClient
implements DataServiceClientService,
Query.Service {
    private final DataServiceFactory factory;
    private final ImmutableList<Query.Service> queryServices;

    public DataServiceClient(DataServiceFactory dataServiceFactory) {
        this.factory = dataServiceFactory;
        this.queryServices = ImmutableList.of((Object)new CommandQueryService(dataServiceFactory.getContext()), (Object)new DualQueryService(), (Object)new ExecutorQueryService(this.factory));
    }

    public DataServiceFactory getFactory() {
        return this.factory;
    }

    public DataInputStream query(String sqlQuery, int maxRows) throws SQLException {
        DataInputStream dataInputStream;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.prepareQuery(sqlQuery, maxRows).writeTo(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            dataInputStream = new DataInputStream(byteArrayInputStream);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SQLException.class);
            throw new SQLException(e);
        }
        return dataInputStream;
    }

    public Query prepareQuery(String sql, int maxRows) throws KettleException {
        return this.prepareQuery(sql, maxRows, (Map<String, String>)ImmutableMap.of());
    }

    @Override
    public Query prepareQuery(String sql, int maxRows, Map<String, String> parameters) throws KettleException {
        for (Query.Service queryService : this.queryServices) {
            Query query = queryService.prepareQuery(sql, maxRows, parameters);
            if (query == null) continue;
            return query;
        }
        throw new KettleException("Unable to resolve query: " + sql);
    }

    public List<ThinServiceInformation> getServiceInformation() throws SQLException {
        ArrayList services = Lists.newArrayList();
        for (DataServiceMeta service : this.factory.getDataServices(this.logErrors())) {
            TransMeta transMeta = service.getServiceTrans();
            try {
                transMeta.activateParameters();
                RowMetaInterface serviceFields = transMeta.getStepFields(service.getStepname());
                ThinServiceInformation serviceInformation = new ThinServiceInformation(service.getName(), serviceFields);
                services.add(serviceInformation);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Unable to get fields for service {0}, transformation: {1}", service.getName(), transMeta.getName());
                this.factory.getLogChannel().logError(message, (Throwable)e);
            }
        }
        return services;
    }

    private Function<Exception, Void> logErrors() {
        return this.factory.logErrors("Unable to retrieve data service");
    }

    @Deprecated
    public void setRepository(Repository repository) {
    }

    @Deprecated
    public void setMetaStore(IMetaStore metaStore) {
    }
}

