/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization;

import com.google.common.util.concurrent.ListenableFuture;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.UUID;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.di.trans.dataservice.optimization.PushDownType;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.pentaho.ui.xul.XulEventSource;

@MetaStoreElementType(name="Push Down Optimization", description="Define opportunities to improve Data Service performance by modifying user transformation execution")
public class PushDownOptimizationMeta
implements XulEventSource {
    private static final Class<?> PKG = PushDownOptimizationMeta.class;
    public static final String PUSH_DOWN_STEP_NAME = "step_name";
    @MetaStoreAttribute
    private String name = UUID.randomUUID().toString();
    @MetaStoreAttribute(key="step_name")
    private String stepName = "";
    @MetaStoreAttribute
    private PushDownType type;
    @MetaStoreAttribute
    private boolean enabled = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public PushDownType getType() {
        return this.type;
    }

    public void setType(PushDownType type) {
        this.type = type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ListenableFuture<Boolean> activate(DataServiceExecutor executor) {
        return this.getType().activate(executor, this);
    }

    public OptimizationImpactInfo preview(DataServiceExecutor executor) {
        final OptimizationImpactInfo preview = this.getType().preview(executor, this);
        if (this.enabled) {
            return preview;
        }
        return new OptimizationImpactInfo(this.getStepName()){
            {
                super(x0);
                this.setModified(false);
                this.setErrorMsg(preview.getErrorMsg());
                this.setQueryBeforeOptimization(preview.getQueryBeforeOptimization());
            }

            @Override
            public String getDescription() {
                return "#Optimization is disabled\n" + super.getDescription();
            }
        };
    }

    public String toString() {
        return MessageFormat.format("PushDownOptimizationMeta'{'name=''{0}'', stepName=''{1}'', type={2}'}'", this.name, this.stepName, this.type != null ? this.type.getClass().getName() : null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

