/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceAlreadyExistsException;
import org.pentaho.di.trans.dataservice.serialization.TransOpenedExtensionPointPlugin;
import org.pentaho.di.trans.dataservice.serialization.UndefinedDataServiceException;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaChangeListenerInterface;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class SynchronizationService
implements ContentChangedListener,
StepMetaChangeListenerInterface {
    static Class<TransOpenedExtensionPointPlugin> PKG = TransOpenedExtensionPointPlugin.class;
    final DataServiceDelegate delegate;

    public SynchronizationService(DataServiceDelegate delegate) {
        this.delegate = delegate;
    }

    public void contentChanged(Object parentObject) {
    }

    public void contentSafe(Object parentObject) {
        this.delegate.sync((TransMeta)parentObject, this.syncErrors());
    }

    public void onStepChange(TransMeta transMeta, StepMeta oldMeta, StepMeta newMeta) {
        if (Objects.equal((Object)oldMeta.getName(), (Object)newMeta.getName())) {
            return;
        }
        try {
            DataServiceMeta dataService = this.delegate.getDataServiceByStepName(transMeta, oldMeta.getName());
            if (dataService != null) {
                dataService.setStepname(newMeta.getName());
                this.delegate.save(dataService);
            }
        }
        catch (MetaStoreException e) {
            this.delegate.getLogChannel().logError(e.getMessage(), (Throwable)e);
        }
    }

    Function<Exception, Void> syncErrors() {
        return new Function<Exception, Void>(){

            public Void apply(Exception e) {
                DataServiceMeta dataService;
                String message = e.getMessage();
                if (e instanceof DataServiceAlreadyExistsException) {
                    dataService = ((DataServiceAlreadyExistsException)((Object)e)).getDataServiceMeta();
                    SynchronizationService.this.delegate.syncExec(SynchronizationService.this.suggestEdit(dataService, message));
                }
                if (e instanceof UndefinedDataServiceException) {
                    dataService = ((UndefinedDataServiceException)((Object)e)).getDataServiceMeta();
                    SynchronizationService.this.delegate.syncExec(SynchronizationService.this.suggestRemove(dataService, message));
                }
                SynchronizationService.this.delegate.getLogChannel().logError(message, (Throwable)e);
                return null;
            }
        };
    }

    public Runnable suggestEdit(final DataServiceMeta dataService, final String message) {
        return new Runnable(){

            @Override
            public void run() {
                SynchronizationService.this.delegate.suggestEdit(dataService, BaseMessages.getString(PKG, (String)"Messages.SaveError.Title", (String[])new String[0]), message + "\n" + BaseMessages.getString(PKG, (String)"Messages.SaveError.Edit", (String[])new String[0]));
            }
        };
    }

    private Runnable suggestRemove(final DataServiceMeta dataService, final String message) {
        return new Runnable(){

            @Override
            public void run() {
                boolean remove = SynchronizationService.this.delegate.showPrompt(BaseMessages.getString(PKG, (String)"Messages.SaveError.Title", (String[])new String[0]), message + "\n" + BaseMessages.getString(PKG, (String)"Messages.SaveError.Remove", (String[])new String[0]));
                if (remove) {
                    SynchronizationService.this.delegate.removeDataService(dataService);
                }
            }
        };
    }

    public void install(TransMeta transMeta) {
        List listeners = transMeta.getContentChangedListeners();
        if (FluentIterable.from((Iterable)listeners).filter(SynchronizationService.class).isEmpty()) {
            transMeta.addContentChangedListener((ContentChangedListener)this);
            transMeta.addStepChangeListener((StepMetaChangeListenerInterface)this);
        }
    }
}

