/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.net.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslog;
import org.productivity.java.syslog4j.impl.AbstractSyslogWriter;
import org.productivity.java.syslog4j.impl.net.tcp.TCPNetSyslog;
import org.productivity.java.syslog4j.impl.net.tcp.TCPNetSyslogConfigIF;

public class TCPNetSyslogWriter
extends AbstractSyslogWriter {
    private static final long serialVersionUID = -6388813866108482855L;
    protected TCPNetSyslog tcpNetSyslog = null;
    protected Socket socket = null;
    protected TCPNetSyslogConfigIF tcpNetSyslogConfig = null;

    public void initialize(AbstractSyslog abstractSyslog) {
        super.initialize(abstractSyslog);
        this.tcpNetSyslog = (TCPNetSyslog)abstractSyslog;
        this.tcpNetSyslogConfig = (TCPNetSyslogConfigIF)this.tcpNetSyslog.getConfig();
    }

    protected SocketFactory obtainSocketFactory() {
        return SocketFactory.getDefault();
    }

    protected Socket createSocket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        SocketFactory socketFactory = this.obtainSocketFactory();
        Socket socket = socketFactory.createSocket(inetAddress, n);
        if (this.tcpNetSyslogConfig.isSoLinger()) {
            socket.setSoLinger(true, this.tcpNetSyslogConfig.getSoLingerSeconds());
        }
        if (this.tcpNetSyslogConfig.isKeepAlive()) {
            socket.setKeepAlive(bl);
        }
        if (this.tcpNetSyslogConfig.isReuseAddress()) {
            socket.setReuseAddress(true);
        }
        return socket;
    }

    protected Socket getSocket() throws SyslogRuntimeException {
        if (this.socket != null && this.socket.isConnected()) {
            return this.socket;
        }
        try {
            InetAddress inetAddress = this.tcpNetSyslog.getHostAddress();
            this.socket = this.createSocket(inetAddress, this.syslog.getConfig().getPort(), this.tcpNetSyslogConfig.isPersistentConnection());
        }
        catch (IOException iOException) {
            throw new SyslogRuntimeException(iOException);
        }
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                if (!"Socket is closed".equalsIgnoreCase(iOException.getMessage())) {
                    throw new SyslogRuntimeException(iOException);
                }
                Object var4_3 = null;
                if (socket == this.socket) {
                    this.socket = null;
                }
            }
            Object var4_2 = null;
            if (socket == this.socket) {
                this.socket = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (socket == this.socket) {
                this.socket = null;
            }
            throw throwable;
        }
    }

    public void write(byte[] byArray) throws SyslogRuntimeException {
        Socket socket = null;
        int n = 0;
        while (n != -1 && n < this.tcpNetSyslogConfig.getWriteRetries() + 1) {
            try {
                socket = this.getSocket();
                if (socket == null) {
                    throw new SyslogRuntimeException("No socket available");
                }
                OutputStream outputStream = socket.getOutputStream();
                if (this.tcpNetSyslogConfig.isSetBufferSize()) {
                    socket.setSendBufferSize(byArray.length);
                }
                outputStream.write(byArray);
                byte[] byArray2 = this.tcpNetSyslogConfig.getDelimiterSequence();
                if (byArray2 != null && byArray2.length > 0) {
                    outputStream.write(byArray2);
                }
                this.syslog.setBackLogStatus(false);
                n = -1;
                if (this.tcpNetSyslogConfig.isPersistentConnection()) continue;
                this.closeSocket(socket);
            }
            catch (IOException iOException) {
                if (iOException.getMessage().toLowerCase().indexOf("software caused connection abort") > -1) {
                    n = this.tcpNetSyslogConfig.getWriteRetries();
                    this.closeSocket(socket);
                }
                this.closeSocket(socket);
                if (++n < this.tcpNetSyslogConfig.getWriteRetries() + 1) continue;
                throw new SyslogRuntimeException(iOException);
            }
        }
    }

    public synchronized void flush() throws SyslogRuntimeException {
        if (this.socket == null) {
            return;
        }
        if (this.syslogConfig.isThreaded()) {
            this.shutdown();
            this.syslog.createWriterThread(this);
        } else {
            this.closeSocket(this.socket);
        }
    }

    public synchronized void shutdown() throws SyslogRuntimeException {
        if (this.socket == null) {
            return;
        }
        if (this.syslogConfig.isThreaded()) {
            this.shutdown = true;
            long l = System.currentTimeMillis();
            boolean bl = false;
            while (!bl) {
                if (this.socket == null || this.socket.isClosed()) {
                    bl = true;
                    continue;
                }
                long l2 = System.currentTimeMillis();
                if (l2 > l + (long)this.tcpNetSyslogConfig.getMaxShutdownWait()) {
                    this.closeSocket(this.socket);
                    this.thread.interrupt();
                    bl = true;
                }
                if (bl) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            if (this.socket == null || this.socket.isClosed()) {
                return;
            }
            this.closeSocket(this.socket);
        }
    }

    protected void runCompleted() {
        this.closeSocket(this.socket);
    }
}

