/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.meta;

import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;

public class HBaseValueMetaInterfaceImpl
extends HBaseValueMeta
implements HBaseValueMetaInterface {
    private final HBaseBytesUtilShim hBaseBytesUtilShim;

    public HBaseValueMetaInterfaceImpl(String name, int type, int length, int precision, HBaseBytesUtilShim hBaseBytesUtilShim) throws IllegalArgumentException {
        super(name, type, length, precision);
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
    }

    public Object decodeColumnValue(byte[] rawColValue) throws KettleException {
        return HBaseValueMeta.decodeColumnValue((byte[])rawColValue, (HBaseValueMeta)this, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
    }

    public byte[] encodeColumnValue(Object o, ValueMetaInterface valueMetaInterface) throws KettleException {
        return HBaseValueMeta.encodeColumnValue((Object)o, (ValueMetaInterface)valueMetaInterface, (HBaseValueMeta)this, (HBaseBytesUtilShim)this.hBaseBytesUtilShim);
    }

    public void getXml(StringBuilder retval) {
        retval.append("\n        ").append(XMLHandler.openTag((String)"field"));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"table_name", (String)this.getTableName()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"mapping_name", (String)this.getMappingName()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"alias", (String)this.getAlias()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"family", (String)this.getColumnFamily()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"column", (String)this.getColumnName()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"key", (boolean)this.isKey()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.getType())));
        String format = this.getConversionMask();
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"format", (String)format));
        if (this.getStorageType() == 2) {
            retval.append("\n            ").append(XMLHandler.addTagValue((String)"index_values", (String)this.getIndexValues()));
        }
        retval.append("\n        ").append(XMLHandler.closeTag((String)"field"));
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step, int i) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, i, "table_name", this.getTableName());
        rep.saveStepAttribute(id_transformation, id_step, i, "mapping_name", this.getMappingName());
        rep.saveStepAttribute(id_transformation, id_step, i, "alias", this.getAlias());
        rep.saveStepAttribute(id_transformation, id_step, i, "family", this.getColumnFamily());
        rep.saveStepAttribute(id_transformation, id_step, i, "column", this.getColumnName());
        rep.saveStepAttribute(id_transformation, id_step, i, "key", this.isKey());
        rep.saveStepAttribute(id_transformation, id_step, i, "type", ValueMeta.getTypeDesc((int)this.getType()));
        String format = this.getConversionMask();
        rep.saveStepAttribute(id_transformation, id_step, i, "format", format);
        if (this.getStorageType() == 2) {
            rep.saveStepAttribute(id_transformation, id_step, i, "index_values", this.getIndexValues());
        }
    }

    private String getIndexValues() {
        Object[] labels = this.getIndex();
        StringBuffer vals = new StringBuffer();
        vals.append("{");
        for (int i = 0; i < labels.length; ++i) {
            if (i != labels.length - 1) {
                vals.append(labels[i].toString().trim()).append(",");
                continue;
            }
            vals.append(labels[i].toString().trim()).append("}");
        }
        return vals.toString();
    }
}

