/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public interface CircuitBreaker {
    public void circuitBreak(String var1, long var2);

    public double addEstimateBytesAndMaybeBreak(long var1, String var3) throws CircuitBreakingException;

    public long addWithoutBreaking(long var1);

    public long getUsed();

    public long getLimit();

    public double getOverhead();

    public long getTrippedCount();

    public Name getName();

    public static enum Type {
        MEMORY,
        PARENT,
        NOOP;


        public static Type parseValue(String value) {
            switch (value.toLowerCase(Locale.ROOT)) {
                case "noop": {
                    return NOOP;
                }
                case "parent": {
                    return PARENT;
                }
                case "memory": {
                    return MEMORY;
                }
            }
            throw new ElasticsearchIllegalArgumentException("No CircuitBreaker with type: " + value);
        }
    }

    public static enum Name {
        PARENT(0),
        FIELDDATA(1),
        REQUEST(2);

        private int ordinal;

        private Name(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getSerializableValue() {
            return this.ordinal;
        }

        public static Name readFrom(StreamInput in) throws IOException {
            int value = in.readVInt();
            switch (value) {
                case 0: {
                    return PARENT;
                }
                case 1: {
                    return FIELDDATA;
                }
                case 2: {
                    return REQUEST;
                }
            }
            throw new ElasticsearchIllegalArgumentException("No CircuitBreaker with ordinal: " + value);
        }

        public static void writeTo(Name name, StreamOutput out) throws IOException {
            out.writeVInt(name.getSerializableValue());
        }
    }
}

