/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.docset.OrDocIdSet;

public class OrFilter
extends Filter {
    private final List<? extends Filter> filters;

    public OrFilter(List<? extends Filter> filters) {
        this.filters = filters;
    }

    public List<? extends Filter> filters() {
        return this.filters;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getDocIdSet(context, acceptDocs);
        }
        ArrayList<DocIdSet> sets = new ArrayList<DocIdSet>(this.filters.size());
        for (int i = 0; i < this.filters.size(); ++i) {
            DocIdSet set = this.filters.get(i).getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(set)) continue;
            sets.add(set);
        }
        if (sets.size() == 0) {
            return null;
        }
        if (sets.size() == 1) {
            return (DocIdSet)sets.get(0);
        }
        return new OrDocIdSet(sets.toArray(new DocIdSet[sets.size()]));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.filters ? 0 : this.filters.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OrFilter other = (OrFilter)((Object)obj);
        return this.equalFilters(this.filters, other.filters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Filter filter : this.filters) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(filter);
        }
        return builder.toString();
    }

    private boolean equalFilters(List<? extends Filter> filters1, List<? extends Filter> filters2) {
        return filters1 == filters2 || filters1 != null && filters1.equals(filters2);
    }
}

