/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.time.DateTimeField;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.DurationField;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.unit.TimeValue;

public abstract class TimeZoneRounding
extends Rounding {
    public static Builder builder(DateTimeUnit unit) {
        return new Builder(unit);
    }

    public static Builder builder(TimeValue interval) {
        return new Builder(interval);
    }

    static class DayIntervalTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 6;
        private long interval;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        DayIntervalTimeZoneRounding() {
        }

        DayIntervalTimeZoneRounding(long interval, DateTimeZone preTz, DateTimeZone postTz) {
            if (interval < 1L) {
                throw new ElasticsearchIllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 6;
        }

        @Override
        public long roundKey(long utcMillis) {
            long time = this.preTz.convertUTCToLocal(utcMillis);
            return Rounding.Interval.roundKey(time, this.interval);
        }

        @Override
        public long valueForKey(long key) {
            long time = Rounding.Interval.roundValue(key, this.interval);
            time = this.postTz.convertUTCToLocal(time);
            return time;
        }

        @Override
        public long nextRoundingValue(long value) {
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    static class TimeIntervalTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 5;
        private long interval;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        TimeIntervalTimeZoneRounding() {
        }

        TimeIntervalTimeZoneRounding(long interval, DateTimeZone preTz, DateTimeZone postTz) {
            if (interval < 1L) {
                throw new ElasticsearchIllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 5;
        }

        @Override
        public long roundKey(long utcMillis) {
            long time = this.preTz.convertUTCToLocal(utcMillis);
            return Rounding.Interval.roundKey(time, this.interval);
        }

        @Override
        public long valueForKey(long key) {
            long time = Rounding.Interval.roundValue(key, this.interval);
            time = this.preTz.convertLocalToUTC(time, false);
            time = this.postTz.convertUTCToLocal(time);
            return time;
        }

        @Override
        public long nextRoundingValue(long value) {
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    static class UTCIntervalTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 4;
        private long interval;

        UTCIntervalTimeZoneRounding() {
        }

        UTCIntervalTimeZoneRounding(long interval) {
            if (interval < 1L) {
                throw new ElasticsearchIllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval;
        }

        @Override
        public byte id() {
            return 4;
        }

        @Override
        public long roundKey(long utcMillis) {
            return Rounding.Interval.roundKey(utcMillis, this.interval);
        }

        @Override
        public long valueForKey(long key) {
            return Rounding.Interval.roundValue(key, this.interval);
        }

        @Override
        public long nextRoundingValue(long value) {
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
        }
    }

    static class DayTimeZoneRoundingFloor
    extends TimeZoneRounding {
        static final byte ID = 3;
        private DateTimeUnit unit;
        private DateTimeField field;
        private DurationField durationField;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        DayTimeZoneRoundingFloor() {
        }

        DayTimeZoneRoundingFloor(DateTimeUnit unit, DateTimeZone preTz, DateTimeZone postTz) {
            this.unit = unit;
            this.field = unit.field();
            this.durationField = this.field.getDurationField();
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 3;
        }

        @Override
        public long roundKey(long utcMillis) {
            long local = this.preTz.convertUTCToLocal(utcMillis);
            return this.field.roundFloor(local);
        }

        @Override
        public long valueForKey(long time) {
            return this.postTz.convertUTCToLocal(time);
        }

        @Override
        public long nextRoundingValue(long currentWithPostZone) {
            long currentWithoutPostZone = this.postTz.convertLocalToUTC(currentWithPostZone, false);
            long nextWithoutPostZone = this.durationField.add(currentWithoutPostZone, 1);
            return this.postTz.convertUTCToLocal(nextWithoutPostZone);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.unit = DateTimeUnit.resolve(in.readByte());
            this.field = this.unit.field();
            this.durationField = this.field.getDurationField();
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.id());
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    static class UTCTimeZoneRoundingFloor
    extends TimeZoneRounding {
        static final byte ID = 2;
        private DateTimeUnit unit;
        private DateTimeField field;
        private DurationField durationField;

        UTCTimeZoneRoundingFloor() {
        }

        UTCTimeZoneRoundingFloor(DateTimeUnit unit) {
            this.unit = unit;
            this.field = unit.field();
            this.durationField = this.field.getDurationField();
        }

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public long roundKey(long utcMillis) {
            return this.field.roundFloor(utcMillis);
        }

        @Override
        public long valueForKey(long key) {
            return key;
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.durationField.add(value, 1);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.unit = DateTimeUnit.resolve(in.readByte());
            this.field = this.unit.field();
            this.durationField = this.field.getDurationField();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.id());
        }
    }

    static class TimeTimeZoneRoundingFloor
    extends TimeZoneRounding {
        static final byte ID = 1;
        private DateTimeUnit unit;
        private DateTimeField field;
        private DurationField durationField;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        TimeTimeZoneRoundingFloor() {
        }

        TimeTimeZoneRoundingFloor(DateTimeUnit unit, DateTimeZone preTz, DateTimeZone postTz) {
            this.unit = unit;
            this.field = unit.field();
            this.durationField = this.field.getDurationField();
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public long roundKey(long utcMillis) {
            long local = this.preTz.convertUTCToLocal(utcMillis);
            return this.preTz.convertLocalToUTC(this.field.roundFloor(local), false, utcMillis);
        }

        @Override
        public long valueForKey(long time) {
            return this.postTz.convertUTCToLocal(time);
        }

        @Override
        public long nextRoundingValue(long time) {
            long currentWithoutPostZone = this.postTz.convertLocalToUTC(time, false);
            long local = this.preTz.convertUTCToLocal(currentWithoutPostZone);
            long nextLocal = this.durationField.add(local, 1);
            return this.postTz.convertUTCToLocal(this.preTz.convertLocalToUTC(nextLocal, false));
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.unit = DateTimeUnit.resolve(in.readByte());
            this.field = this.unit.field();
            this.durationField = this.field.getDurationField();
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.id());
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    public static class Builder {
        private DateTimeUnit unit;
        private long interval = -1L;
        private DateTimeZone preTz = DateTimeZone.UTC;
        private DateTimeZone postTz = DateTimeZone.UTC;
        private float factor = 1.0f;
        private long preOffset;
        private long postOffset;
        private boolean preZoneAdjustLargeInterval = false;

        public Builder(DateTimeUnit unit) {
            this.unit = unit;
            this.interval = -1L;
        }

        public Builder(TimeValue interval) {
            this.unit = null;
            if (interval.millis() < 1L) {
                throw new ElasticsearchIllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval.millis();
        }

        public Builder preZone(DateTimeZone preTz) {
            this.preTz = preTz;
            return this;
        }

        public Builder preZoneAdjustLargeInterval(boolean preZoneAdjustLargeInterval) {
            this.preZoneAdjustLargeInterval = preZoneAdjustLargeInterval;
            return this;
        }

        public Builder postZone(DateTimeZone postTz) {
            this.postTz = postTz;
            return this;
        }

        public Builder preOffset(long preOffset) {
            this.preOffset = preOffset;
            return this;
        }

        public Builder postOffset(long postOffset) {
            this.postOffset = postOffset;
            return this;
        }

        public Builder factor(float factor) {
            this.factor = factor;
            return this;
        }

        public Rounding build() {
            Rounding timeZoneRounding = this.unit != null ? (this.preTz.equals(DateTimeZone.UTC) && this.postTz.equals(DateTimeZone.UTC) ? new UTCTimeZoneRoundingFloor(this.unit) : (this.preZoneAdjustLargeInterval || this.unit.field().getDurationField().getUnitMillis() < 43200000L ? new TimeTimeZoneRoundingFloor(this.unit, this.preTz, this.postTz) : new DayTimeZoneRoundingFloor(this.unit, this.preTz, this.postTz))) : (this.preTz.equals(DateTimeZone.UTC) && this.postTz.equals(DateTimeZone.UTC) ? new UTCIntervalTimeZoneRounding(this.interval) : (this.preZoneAdjustLargeInterval || this.interval < 43200000L ? new TimeIntervalTimeZoneRounding(this.interval, this.preTz, this.postTz) : new DayIntervalTimeZoneRounding(this.interval, this.preTz, this.postTz)));
            if (this.preOffset != 0L || this.postOffset != 0L) {
                timeZoneRounding = new Rounding.PrePostRounding(timeZoneRounding, this.preOffset, this.postOffset);
            }
            if (this.factor != 1.0f) {
                timeZoneRounding = new Rounding.FactorRounding(timeZoneRounding, this.factor);
            }
            return timeZoneRounding;
        }
    }
}

