/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.util.HashMap;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaData;
import org.pentaho.agilebi.modeler.nodes.FieldMetaData;
import org.pentaho.agilebi.modeler.propforms.GenericPropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;

public class CategoryMetaDataCollection
extends AbstractMetaDataModelNode<CategoryMetaData> {
    private static final long serialVersionUID = 7083527229930283278L;
    private String name = "Categories";
    private static final String CLASSNAME = "pentaho-smallcategorybutton";

    public CategoryMetaDataCollection() {
        super(CLASSNAME);
        this.valid = false;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        this.name = name;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Override
    protected void fireCollectionChanged() {
        this.changeSupport.firePropertyChange("children", null, this);
    }

    @Override
    public void onAdd(CategoryMetaData child) {
        child.setParent(this);
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateNode();
    }

    @Override
    public void onRemove(CategoryMetaData child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    @Override
    @Bindable
    public String getValidImage() {
        return "images/sm_folder_icon.png";
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if (this.size() == 0) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.categorycollecion.REQUIRES_AT_LEAST_ONE_CATEGORY", new String[0]));
            this.valid = false;
        }
        HashMap<String, CategoryMetaData> usedNames = new HashMap<String, CategoryMetaData>();
        for (CategoryMetaData cat : this.children) {
            this.valid &= cat.isValid();
            this.validationMessages.addAll(cat.getValidationMessages());
            if (usedNames.containsKey(cat.getName())) {
                CategoryMetaData c;
                this.valid = false;
                String msg = ModelerMessagesHolder.getMessages().getString("validation.categorycollecion.DUPLICATE_CATEGORY_NAMES", cat.getName());
                this.validationMessages.add(msg);
                cat.invalidate();
                if (!cat.getValidationMessages().contains(msg)) {
                    cat.getValidationMessages().add(msg);
                }
                if (!(c = (CategoryMetaData)usedNames.get(cat.getName())).isValid()) continue;
                c.invalidate();
                if (c.getValidationMessages().contains(msg)) continue;
                c.getValidationMessages().add(msg);
                continue;
            }
            usedNames.put(cat.getName(), cat);
        }
        if (!this.suppressEvents) {
            this.firePropertyChange("valid", null, this.valid);
        }
    }

    @Bindable
    public boolean isEditingDisabled() {
        return true;
    }

    @Override
    public Class<GenericPropertiesForm> getPropertiesForm() {
        return GenericPropertiesForm.class;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(CategoryMetaDataCollection obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryMetaDataCollection other = obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return obj instanceof AvailableField || obj instanceof FieldMetaData || obj instanceof AvailableTable || obj instanceof CategoryMetaData;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            if (data instanceof AvailableTable) {
                AvailableTable table = (AvailableTable)data;
                CategoryMetaData cat = new CategoryMetaData(table.getName());
                for (AvailableField field : table.getAvailableFields()) {
                    cat.add(this.getWorkspace().createFieldForParentWithNode(cat, field));
                }
                return cat;
            }
            if (data instanceof AvailableField) {
                AvailableField field = (AvailableField)data;
                CategoryMetaData cat = new CategoryMetaData(field.getName());
                cat.add(this.getWorkspace().createFieldForParentWithNode(cat, field));
                return cat;
            }
            if (data instanceof CategoryMetaData) {
                return data;
            }
            throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }
}

