/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerImpl;
import org.ops4j.pax.web.service.jetty.internal.NIOSocketConnectorWrapper;
import org.ops4j.pax.web.service.jetty.internal.SocketConnectorWrapper;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.Bundle;

class JettyFactoryImpl
implements JettyFactory {
    private final ServerModel serverModel;
    private Bundle bundle;

    JettyFactoryImpl(ServerModel serverModel, Bundle bundle) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.serverModel = serverModel;
        this.bundle = bundle;
    }

    @Override
    public JettyServer createServer() {
        return new JettyServerImpl(this.serverModel, this.bundle);
    }

    @Override
    public Connector createConnector(String name, int port, String host, boolean useNIO, Boolean checkForwardedHeaders) {
        if (useNIO) {
            NIOSocketConnectorWrapper nioConnector = new NIOSocketConnectorWrapper();
            nioConnector.setName(name);
            nioConnector.setHost(host);
            nioConnector.setPort(port);
            nioConnector.setUseDirectBuffers(true);
            if (checkForwardedHeaders != null) {
                nioConnector.setForwarded(checkForwardedHeaders);
            }
            return nioConnector;
        }
        SocketConnectorWrapper connector = new SocketConnectorWrapper();
        connector.setName(name);
        connector.setPort(port);
        connector.setHost(host);
        if (checkForwardedHeaders != null) {
            connector.setForwarded(checkForwardedHeaders);
        }
        return connector;
    }

    @Override
    public Connector createSecureConnector(String name, int port, String sslKeystore, String sslPassword, String sslKeyPassword, String host, String sslKeystoreType, boolean isClientAuthNeeded, boolean isClientAuthWanted, boolean useNIO) {
        SslContextFactory sslContextFactory = new SslContextFactory(sslKeystore);
        sslContextFactory.setKeyStorePassword(sslKeyPassword);
        sslContextFactory.setKeyManagerPassword(sslPassword);
        sslContextFactory.setNeedClientAuth(isClientAuthNeeded);
        sslContextFactory.setWantClientAuth(isClientAuthWanted);
        if (sslKeystoreType != null) {
            sslContextFactory.setKeyStoreType(sslKeystoreType);
        }
        if (useNIO) {
            SslSelectChannelConnector connector = new SslSelectChannelConnector(sslContextFactory);
            connector.setName(name);
            connector.setPort(port);
            connector.setHost(host);
            connector.setConfidentialPort(port);
            return connector;
        }
        SslSocketConnector connector = new SslSocketConnector(sslContextFactory);
        connector.setName(name);
        connector.setPort(port);
        connector.setHost(host);
        connector.setConfidentialPort(port);
        return connector;
    }
}

