/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.client.BasicService;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.CollectionSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.DynamicSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.LiteralSimpleSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPNamespaceConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.soap.SOAPWSDLConstants;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class SerializerRegistryGenerator
extends GeneratorBase {
    private static final String SERIALIZER_FACTORY = "serializerFactory";
    private static final String DESERIALIZER_FACTORY = "deserializerFactory";
    private static final String MAPPING = "mapping";
    private static final String LITERAL_MAPPING = "mapping2";
    private SOAPVersion soapVer = SOAPVersion.SOAP_11;
    private SOAPEncodingConstants soapEncodingConstants = null;
    private SOAPNamespaceConstants soapNamespaceConstants = null;
    private SOAPWSDLConstants soapWSDLConstants = null;
    private boolean haveCustom = false;
    private Model model;
    private Set visitedTypes;

    public SerializerRegistryGenerator() {
        this(SOAPVersion.SOAP_11);
    }

    public SerializerRegistryGenerator(SOAPVersion ver) {
        this.init(ver);
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
        this.soapNamespaceConstants = SOAPConstantsFactory.getSOAPNamespaceConstants(ver);
        this.soapWSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(ver);
        this.soapVer = ver;
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new SerializerRegistryGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new SerializerRegistryGenerator(model, config, properties);
    }

    private SerializerRegistryGenerator(Model model, Configuration config, Properties properties) {
        this(model, config, properties, SOAPVersion.SOAP_11);
    }

    private SerializerRegistryGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        super(model, config, properties);
        this.init(ver);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.model = model;
    }

    protected void preVisitService(Service service) throws Exception {
        super.preVisitService(service);
        this.visitedTypes = new HashSet();
        Iterator types = this.model.getExtraTypes();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (type.isSOAPType()) {
                ((SOAPType)type).accept(this);
                continue;
            }
            ((LiteralType)type).accept(this);
        }
    }

    protected void postVisitService(Service service) throws Exception {
        try {
            this.generateSerializerRegistry(service);
        }
        catch (IOException e) {
            SerializerRegistryGenerator.fail("generator.cant.write", service.getName().getLocalPart());
        }
        this.visitedTypes = null;
        this.servicePackage = null;
    }

    protected void visitParameter(Parameter param) throws Exception {
        AbstractType type = param.getType();
        if (type.isSOAPType()) {
            ((SOAPType)type).accept(this);
        } else {
            ((LiteralType)type).accept(this);
        }
    }

    protected void preVisitResponse(Response response) throws Exception {
        Iterator iter = response.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    protected void preVisitRequest(Request request) throws Exception {
        Iterator iter = request.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    public void visit(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        } else if (fault.getBlock().getType().isLiteralType()) {
            ((LiteralType)fault.getBlock().getType()).accept(this);
        }
    }

    public void visit(SOAPCustomType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        this.haveCustom = true;
    }

    public void visit(SOAPSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(SOAPAnyType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        this.haveCustom = true;
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(LiteralSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(LiteralFragmentType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitLiteralArrayWrapperType(LiteralArrayWrapperType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(LiteralEnumerationType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(LiteralListType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(SOAPListType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    private boolean haveVisited(AbstractType type) {
        return this.visitedTypes.contains(type);
    }

    private void typeVisited(AbstractType type) {
        this.visitedTypes.add(type);
    }

    private void generateSerializerRegistry(Service service) throws IOException {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().serializerRegistryClassName(intf);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            this.log("creating serializer registry: " + className);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("SerializerRegistry");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writePackage(out, className);
            this.writeImports(out);
            out.pln();
            this.writeClassDecl(out, className);
            this.writeConstructor(out, className);
            out.pln();
            this.writeGetRegistry(out);
            out.pln();
            this.writeStatics(out);
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.client.BasicService;");
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.*;");
        p.pln("import com.sun.xml.rpc.encoding.literal.*;");
        p.pln("import com.sun.xml.rpc.soap.SOAPVersion;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.rpc.*;");
        p.pln("import javax.xml.rpc.encoding.*;");
        p.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        p.plnI("public class " + Names.stripQualifier(className) + " implements SerializerConstants {");
    }

    private void writeStatics(IndentingWriter p) throws IOException, Exception {
        p.plnI("private static void registerSerializer(TypeMapping mapping, java.lang.Class javaType, javax.xml.namespace.QName xmlType,");
        p.pln("Serializer ser) {");
        p.plnI("mapping.register(javaType, xmlType, new SingletonSerializerFactory(ser),");
        p.pln("new SingletonDeserializerFactory((Deserializer)ser));");
        p.pO();
        p.pOln("}");
        p.pln();
    }

    private boolean mappingExistsForType(TypeMapping mapping, AbstractType type) {
        try {
            SerializerFactory factory;
            Class<Comparable<Boolean>> cls = null;
            String javaName = type.getJavaType().getName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                if (javaName.equals(Boolean.TYPE.toString())) {
                    cls = Boolean.TYPE;
                } else if (javaName.equals("byte")) {
                    cls = Byte.TYPE;
                } else if (javaName.equals("double")) {
                    cls = Double.TYPE;
                } else if (javaName.equals("int")) {
                    cls = Integer.TYPE;
                } else if (javaName.equals("float")) {
                    cls = Float.TYPE;
                } else if (javaName.equals("long")) {
                    cls = Long.TYPE;
                } else if (javaName.equals("short")) {
                    cls = Short.TYPE;
                }
            }
            if (cls == null) {
                if (javaName.equals("byte[]")) {
                    cls = byte[].class;
                }
                cls = javaName.equals("java.lang.String[]") ? String[].class : Class.forName(javaName);
            }
            if ((factory = mapping.getSerializer(cls, type.getName())) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void writeConstructor(IndentingWriter p, String className) throws IOException {
        p.plnI("public " + Names.stripQualifier(className) + "() {");
        p.pOln("}");
    }

    private void writeGetRegistry(IndentingWriter p) throws IOException, ClassNotFoundException {
        p.plnI("public TypeMappingRegistry getRegistry() {");
        HashSet<String> processedTypes = new HashSet<String>();
        p.pln();
        p.pln("TypeMappingRegistry registry = BasicService.createStandardTypeMappingRegistry();");
        p.pln("TypeMapping mapping12 = registry.getTypeMapping(SOAP12Constants.NS_SOAP_ENCODING);");
        p.pln("TypeMapping mapping = registry.getTypeMapping(SOAPConstants.NS_SOAP_ENCODING);");
        p.pln("TypeMapping mapping2 = registry.getTypeMapping(\"\");");
        TypeMappingRegistry registry = BasicService.createStandardTypeMappingRegistry();
        TypeMapping mapping = registry.getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
        TypeMapping literalMapping = registry.getTypeMapping("");
        TypeMapping mapping12 = registry.getTypeMapping("http://www.w3.org/2002/06/soap-encoding");
        for (AbstractType type : this.visitedTypes) {
            String key;
            if (type.getJavaType().getName().equals("void") || processedTypes.contains(key = SerializerRegistryGenerator.genKey(type))) continue;
            processedTypes.add(key);
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, type);
            if ((writer instanceof SimpleTypeSerializerWriter || writer instanceof CollectionSerializerWriter || writer instanceof LiteralSimpleSerializerWriter || writer instanceof DynamicSerializerWriter) && (this.mappingExistsForType(literalMapping, type) && type.isLiteralType() || (this.mappingExistsForType(mapping, type) || this.mappingExistsForType(mapping12, type)) && type.isSOAPType())) continue;
            p.plnI("{");
            if (type.isSOAPType()) {
                if (type.getVersion().equals(SOAPVersion.SOAP_12.toString())) {
                    writer.registerSerializer(p, this.encodeTypes, this.multiRefEncoding, "mapping12");
                } else {
                    writer.registerSerializer(p, this.encodeTypes, this.multiRefEncoding, MAPPING);
                }
            } else if (type.isLiteralType()) {
                writer.registerSerializer(p, this.encodeTypes, this.multiRefEncoding, LITERAL_MAPPING);
            }
            p.pOln("}");
        }
        p.pln("return registry;");
        p.pOln("}");
    }

    protected static String genKey(AbstractType type) {
        String schemaType = type.getName().toString();
        String javaType = type.getJavaType().getName();
        String typeType = type instanceof LiteralListType || type instanceof SOAPListType ? type.toString() : type.getClass().getName();
        return schemaType + ";" + javaType + ";" + typeType;
    }
}

