/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.pentaho.di.core.SwingUniversalImage;
import org.pentaho.di.core.SwingUniversalImageSvg;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.svg.SvgImage;

public class SwtUniversalImageSvg
extends SwtUniversalImage {
    private final GraphicsNode svgGraphicsNode;
    private final Dimension2D svgGraphicsSize;

    public SwtUniversalImageSvg(SvgImage svg) {
        UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
        DocumentLoader documentLoader = new DocumentLoader((UserAgent)userAgentAdapter);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgentAdapter, documentLoader);
        GVTBuilder builder = new GVTBuilder();
        this.svgGraphicsNode = builder.build(ctx, svg.getDocument());
        this.svgGraphicsSize = ctx.getDocumentSize();
    }

    @Override
    protected Image renderSimple(Device device) {
        return this.renderSimple(device, (int)Math.round(this.svgGraphicsSize.getWidth()), (int)Math.round(this.svgGraphicsSize.getHeight()));
    }

    @Override
    protected Image renderSimple(Device device, int width, int height) {
        BufferedImage area = SwingUniversalImage.createBitmap((int)width, (int)height);
        Graphics2D gc = SwingUniversalImage.createGraphics((BufferedImage)area);
        SwingUniversalImageSvg.render((Graphics2D)gc, (GraphicsNode)this.svgGraphicsNode, (Dimension2D)this.svgGraphicsSize, (int)(width / 2), (int)(height / 2), (int)width, (int)height, (double)0.0);
        gc.dispose();
        return this.swing2swt(device, area);
    }

    @Override
    protected Image renderRotated(Device device, int width, int height, double angleRadians) {
        BufferedImage doubleArea = SwingUniversalImage.createDoubleBitmap((int)width, (int)height);
        Graphics2D gc = SwingUniversalImage.createGraphics((BufferedImage)doubleArea);
        SwingUniversalImageSvg.render((Graphics2D)gc, (GraphicsNode)this.svgGraphicsNode, (Dimension2D)this.svgGraphicsSize, (int)(doubleArea.getWidth() / 2), (int)(doubleArea.getHeight() / 2), (int)width, (int)height, (double)angleRadians);
        gc.dispose();
        return this.swing2swt(device, doubleArea);
    }
}

