/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.syslog;

import java.net.InetAddress;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.syslog.JobEntrySyslog;
import org.pentaho.di.job.entries.syslog.SyslogDefs;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.LabelText;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.snmp4j.UserTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;

public class JobEntrySyslogDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntrySyslog.class;
    private LabelText wName;
    private FormData fdName;
    private LabelTextVar wServerName;
    private FormData fdServerName;
    private Label wlFacility;
    private FormData fdlFacility;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntrySyslog jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Group wServerSettings;
    private FormData fdServerSettings;
    private Group wLogSettings;
    private FormData fdLogSettings;
    private CTabFolder wTabFolder;
    private Composite wGeneralComp;
    private CTabItem wGeneralTab;
    private FormData fdGeneralComp;
    private FormData fdTabFolder;
    private FormData fdPort;
    private LabelTextVar wPort;
    private FormData fdFacility;
    private CCombo wFacility;
    private Label wlPriority;
    private FormData fdlPriority;
    private FormData fdPriority;
    private CCombo wPriority;
    private Label wlDatePattern;
    private FormData fdlDatePattern;
    private FormData fdDatePattern;
    private ComboVar wDatePattern;
    private Button wTest;
    private FormData fdTest;
    private Listener lsTest;
    private Group wMessageGroup;
    private FormData fdMessageGroup;
    private Label wlMessage;
    private StyledTextComp wMessage;
    private FormData fdlMessage;
    private FormData fdMessage;
    private Label wlAddTimestamp;
    private FormData fdlAddTimestamp;
    private Button wAddTimestamp;
    private FormData fdAddTimestamp;
    private Label wlAddHostName;
    private FormData fdlAddHostName;
    private Button wAddHostName;
    private FormData fdAddHostName;

    public JobEntrySyslogDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntrySyslog)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntrySyslogDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wName = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"JobEntrySyslog.Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntrySyslog.Name.Tooltip", (String[])new String[0]));
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.top = new FormAttachment(0, 0);
        this.fdName.left = new FormAttachment(0, 0);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData(this.fdName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Tab.General.Label", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)generalLayout);
        this.wServerSettings = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wServerSettings);
        this.wServerSettings.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout ServerSettingsgroupLayout = new FormLayout();
        ServerSettingsgroupLayout.marginWidth = 10;
        ServerSettingsgroupLayout.marginHeight = 10;
        this.wServerSettings.setLayout((Layout)ServerSettingsgroupLayout);
        this.wServerName = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobEntrySyslog.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntrySyslog.Server.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        this.fdServerName = new FormData();
        this.fdServerName.left = new FormAttachment(0, 0);
        this.fdServerName.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData(this.fdServerName);
        this.wPort = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobEntrySyslog.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntrySyslog.Port.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        this.fdPort = new FormData();
        this.fdPort.left = new FormAttachment(0, 0);
        this.fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData(this.fdPort);
        this.wTest = new Button((Composite)this.wServerSettings, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTest);
        this.fdTest = new FormData();
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.TestConnection.Tooltip", (String[])new String[0]));
        this.fdTest.top = new FormAttachment((Control)this.wPort, 2 * margin);
        this.fdTest.right = new FormAttachment(100, 0);
        this.wTest.setLayoutData((Object)this.fdTest);
        this.fdServerSettings = new FormData();
        this.fdServerSettings.left = new FormAttachment(0, margin);
        this.fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerSettings.right = new FormAttachment(100, -margin);
        this.wServerSettings.setLayoutData((Object)this.fdServerSettings);
        this.wLogSettings = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wLogSettings);
        this.wLogSettings.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.LogSettings.Group.Label", (String[])new String[0]));
        FormLayout LogSettingsgroupLayout = new FormLayout();
        LogSettingsgroupLayout.marginWidth = 10;
        LogSettingsgroupLayout.marginHeight = 10;
        this.wLogSettings.setLayout((Layout)LogSettingsgroupLayout);
        this.wlFacility = new Label((Composite)this.wLogSettings, 131072);
        this.wlFacility.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Facility.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFacility);
        this.fdlFacility = new FormData();
        this.fdlFacility.left = new FormAttachment(0, margin);
        this.fdlFacility.right = new FormAttachment(middle, -margin);
        this.fdlFacility.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.wlFacility.setLayoutData((Object)this.fdlFacility);
        this.wFacility = new CCombo((Composite)this.wLogSettings, 2060);
        this.wFacility.setItems(SyslogDefs.FACILITYS);
        this.props.setLook((Control)this.wFacility);
        this.fdFacility = new FormData();
        this.fdFacility.left = new FormAttachment(middle, margin);
        this.fdFacility.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdFacility.right = new FormAttachment(100, 0);
        this.wFacility.setLayoutData((Object)this.fdFacility);
        this.wFacility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.wlPriority = new Label((Composite)this.wLogSettings, 131072);
        this.wlPriority.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Priority.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPriority);
        this.fdlPriority = new FormData();
        this.fdlPriority.left = new FormAttachment(0, margin);
        this.fdlPriority.right = new FormAttachment(middle, -margin);
        this.fdlPriority.top = new FormAttachment((Control)this.wFacility, margin);
        this.wlPriority.setLayoutData((Object)this.fdlPriority);
        this.wPriority = new CCombo((Composite)this.wLogSettings, 2060);
        this.wPriority.setItems(SyslogDefs.PRIORITYS);
        this.props.setLook((Control)this.wPriority);
        this.fdPriority = new FormData();
        this.fdPriority.left = new FormAttachment(middle, margin);
        this.fdPriority.top = new FormAttachment((Control)this.wFacility, margin);
        this.fdPriority.right = new FormAttachment(100, 0);
        this.wPriority.setLayoutData((Object)this.fdPriority);
        this.wPriority.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.fdLogSettings = new FormData();
        this.fdLogSettings.left = new FormAttachment(0, margin);
        this.fdLogSettings.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdLogSettings.right = new FormAttachment(100, -margin);
        this.wLogSettings.setLayoutData((Object)this.fdLogSettings);
        this.wMessageGroup = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wMessageGroup);
        this.wMessageGroup.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.MessageGroup.Group.Label", (String[])new String[0]));
        FormLayout MessageGroupgroupLayout = new FormLayout();
        MessageGroupgroupLayout.marginWidth = 10;
        MessageGroupgroupLayout.marginHeight = 10;
        this.wMessageGroup.setLayout((Layout)MessageGroupgroupLayout);
        this.wlAddHostName = new Label((Composite)this.wMessageGroup, 131072);
        this.wlAddHostName.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.AddHostName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddHostName);
        this.fdlAddHostName = new FormData();
        this.fdlAddHostName.left = new FormAttachment(0, 0);
        this.fdlAddHostName.top = new FormAttachment((Control)this.wLogSettings, margin);
        this.fdlAddHostName.right = new FormAttachment(middle, -margin);
        this.wlAddHostName.setLayoutData((Object)this.fdlAddHostName);
        this.wAddHostName = new Button((Composite)this.wMessageGroup, 32);
        this.props.setLook((Control)this.wAddHostName);
        this.wAddHostName.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.AddHostName.Tooltip", (String[])new String[0]));
        this.fdAddHostName = new FormData();
        this.fdAddHostName.left = new FormAttachment(middle, margin);
        this.fdAddHostName.top = new FormAttachment((Control)this.wLogSettings, margin);
        this.fdAddHostName.right = new FormAttachment(100, 0);
        this.wAddHostName.setLayoutData((Object)this.fdAddHostName);
        this.wAddHostName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySyslogDialog.this.jobEntry.setChanged();
            }
        });
        this.wlAddTimestamp = new Label((Composite)this.wMessageGroup, 131072);
        this.wlAddTimestamp.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.AddTimestamp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTimestamp);
        this.fdlAddTimestamp = new FormData();
        this.fdlAddTimestamp.left = new FormAttachment(0, 0);
        this.fdlAddTimestamp.top = new FormAttachment((Control)this.wAddHostName, margin);
        this.fdlAddTimestamp.right = new FormAttachment(middle, -margin);
        this.wlAddTimestamp.setLayoutData((Object)this.fdlAddTimestamp);
        this.wAddTimestamp = new Button((Composite)this.wMessageGroup, 32);
        this.props.setLook((Control)this.wAddTimestamp);
        this.wAddTimestamp.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.AddTimestamp.Tooltip", (String[])new String[0]));
        this.fdAddTimestamp = new FormData();
        this.fdAddTimestamp.left = new FormAttachment(middle, margin);
        this.fdAddTimestamp.top = new FormAttachment((Control)this.wAddHostName, margin);
        this.fdAddTimestamp.right = new FormAttachment(100, 0);
        this.wAddTimestamp.setLayoutData((Object)this.fdAddTimestamp);
        this.wAddTimestamp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySyslogDialog.this.activeAddTimestamp();
                JobEntrySyslogDialog.this.jobEntry.setChanged();
            }
        });
        this.wlDatePattern = new Label((Composite)this.wMessageGroup, 131072);
        this.wlDatePattern.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.DatePattern.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDatePattern);
        this.fdlDatePattern = new FormData();
        this.fdlDatePattern.left = new FormAttachment(0, margin);
        this.fdlDatePattern.right = new FormAttachment(middle, -margin);
        this.fdlDatePattern.top = new FormAttachment((Control)this.wAddTimestamp, margin);
        this.wlDatePattern.setLayoutData((Object)this.fdlDatePattern);
        this.wDatePattern = new ComboVar((VariableSpace)this.jobMeta, (Composite)this.wMessageGroup, 2060);
        this.wDatePattern.setItems(Const.getDateFormats());
        this.props.setLook((Control)this.wDatePattern);
        this.fdDatePattern = new FormData();
        this.fdDatePattern.left = new FormAttachment(middle, margin);
        this.fdDatePattern.top = new FormAttachment((Control)this.wAddTimestamp, margin);
        this.fdDatePattern.right = new FormAttachment(100, 0);
        this.wDatePattern.setLayoutData(this.fdDatePattern);
        this.wDatePattern.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.wlMessage = new Label((Composite)this.wMessageGroup, 131072);
        this.wlMessage.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Message.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMessage);
        this.fdlMessage = new FormData();
        this.fdlMessage.left = new FormAttachment(0, margin);
        this.fdlMessage.top = new FormAttachment((Control)this.wLogSettings, margin);
        this.fdlMessage.right = new FormAttachment(middle, -margin);
        this.wlMessage.setLayoutData((Object)this.fdlMessage);
        this.wMessage = new StyledTextComp((VariableSpace)this.jobEntry, (Composite)this.wMessageGroup, 19202, "");
        this.props.setLook((Control)this.wMessage);
        this.wMessage.addModifyListener(lsMod);
        this.fdMessage = new FormData();
        this.fdMessage.left = new FormAttachment(middle, margin);
        this.fdMessage.top = new FormAttachment((Control)this.wDatePattern, margin);
        this.fdMessage.right = new FormAttachment(100, -2 * margin);
        this.fdMessage.bottom = new FormAttachment(100, -margin);
        this.wMessage.setLayoutData(this.fdMessage);
        this.fdMessageGroup = new FormData();
        this.fdMessageGroup.left = new FormAttachment(0, margin);
        this.fdMessageGroup.top = new FormAttachment((Control)this.wLogSettings, margin);
        this.fdMessageGroup.right = new FormAttachment(100, -margin);
        this.fdMessageGroup.bottom = new FormAttachment(100, -margin);
        this.wMessageGroup.setLayoutData((Object)this.fdMessageGroup);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.props.setLook((Control)this.wGeneralComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySyslogDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySyslogDialog.this.ok();
            }
        };
        this.lsTest = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySyslogDialog.this.test();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wTest.addListener(13, this.lsTest);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntrySyslogDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wServerName.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntrySyslogDialog.this.cancel();
            }
        });
        this.getData();
        this.activeAddTimestamp();
        this.wTabFolder.setSelection(0);
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobEntrySyslogDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void activeAddTimestamp() {
        this.wlDatePattern.setEnabled(this.wAddTimestamp.getSelection());
        this.wDatePattern.setEnabled(this.wAddTimestamp.getSelection());
    }

    private void test() {
        MessageBox mb;
        boolean testOK = false;
        String errMsg = null;
        String hostname = this.jobMeta.environmentSubstitute(this.wServerName.getText());
        int nrPort = Const.toInt((String)this.jobMeta.environmentSubstitute("" + this.wPort.getText()), (int)514);
        try {
            UdpAddress udpAddress = new UdpAddress(InetAddress.getByName(hostname), nrPort);
            UserTarget usertarget = new UserTarget();
            usertarget.setAddress((Address)udpAddress);
            testOK = usertarget.getAddress().isValid();
            if (!testOK) {
                errMsg = BaseMessages.getString(PKG, (String)"JobEntrySyslog.CanNotGetAddress", (String[])new String[]{hostname});
            }
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (testOK) {
            mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Connected.OK", (String[])new String[]{hostname}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Connected.NOK.ConnectionBad", (String[])new String[]{hostname}) + Const.CR + errMsg + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.Connected.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        this.wServerName.setText(Const.NVL((String)this.jobEntry.getServerName(), (String)""));
        this.wPort.setText(Const.NVL((String)this.jobEntry.getPort(), (String)String.valueOf(514)));
        if (this.jobEntry.getFacility() != null) {
            this.wFacility.setText(this.jobEntry.getFacility());
        }
        if (this.jobEntry.getPriority() != null) {
            this.wPriority.setText(this.jobEntry.getPriority());
        }
        if (this.jobEntry.getMessage() != null) {
            this.wMessage.setText(this.jobEntry.getMessage());
        }
        if (this.jobEntry.getDatePattern() != null) {
            this.wDatePattern.setText(this.jobEntry.getDatePattern());
        }
        this.wAddTimestamp.setSelection(this.jobEntry.isAddTimestamp());
        this.wAddHostName.setSelection(this.jobEntry.isAddHostName());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobEntrySyslog.PleaseGiveJobEntryAName.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"JobEntrySyslog.PleaseGiveJobEntryAName.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setPort(this.wPort.getText());
        this.jobEntry.setServerName(this.wServerName.getText());
        this.jobEntry.setFacility(this.wFacility.getText());
        this.jobEntry.setPriority(this.wPriority.getText());
        this.jobEntry.setMessage(this.wMessage.getText());
        this.jobEntry.addTimestamp(this.wAddTimestamp.getSelection());
        this.jobEntry.setDatePattern(this.wDatePattern.getText());
        this.jobEntry.addHostName(this.wAddHostName.getSelection());
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

