/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.missing;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.missing.MissingTrans;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class MissingTransDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MissingTransDialog.class;
    private Shell shell;
    private Shell shellParent;
    private List<MissingTrans> missingTrans;
    private int mode;
    private PropsUI props;
    private String stepResult;
    public static final int MISSING_TRANS_STEPS = 1;
    public static final int MISSING_TRANS_STEP_ID = 2;

    public MissingTransDialog(Shell parent, List<MissingTrans> missingTrans, StepMetaInterface baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, baseStepMeta, transMeta, stepname);
        this.shellParent = parent;
        this.missingTrans = missingTrans;
        this.mode = 1;
    }

    public MissingTransDialog(Shell parent, Object in, TransMeta transMeta, String stepname) {
        super(parent, (BaseStepMeta)in, transMeta, stepname);
        this.shellParent = parent;
        this.mode = 2;
    }

    private String getErrorMessage(List<MissingTrans> missingTrans, int mode) {
        String message = "";
        if (mode == 1) {
            StringBuffer entries = new StringBuffer();
            for (MissingTrans entry : missingTrans) {
                if (missingTrans.indexOf(entry) == missingTrans.size() - 1) {
                    entries.append("- " + entry.getStepName() + " - " + entry.getMissingPluginId() + "\n\n");
                    continue;
                }
                entries.append("- " + entry.getStepName() + " - " + entry.getMissingPluginId() + "\n");
            }
            message = BaseMessages.getString(PKG, (String)"MissingTransDialog.MissingTransSteps", (String[])new String[]{entries.toString()});
        }
        if (mode == 2) {
            message = BaseMessages.getString(PKG, (String)"MissingTransDialog.MissingTransStepId", (String[])new String[]{this.stepname + " - " + ((MissingTrans)this.baseStepMeta).getMissingPluginId()});
        }
        return message.toString();
    }

    public String open() {
        this.props = PropsUI.getInstance();
        Display display = this.shellParent.getDisplay();
        int margin = 4;
        this.shell = new Shell(this.shellParent, 67681);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginLeft = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"MissingTransDialog.MissingPlugins", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        Label image = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)image);
        Image icon = display.getSystemImage(4);
        image.setImage(icon);
        FormData imageData = new FormData();
        imageData.left = new FormAttachment(0, 5);
        imageData.right = new FormAttachment(11, 0);
        imageData.top = new FormAttachment(0, 10);
        image.setLayoutData((Object)imageData);
        Label error = new Label((Composite)this.shell, 64);
        this.props.setLook((Control)error);
        error.setText(this.getErrorMessage(this.missingTrans, this.mode));
        FormData errorData = new FormData();
        errorData.left = new FormAttachment((Control)image, 5);
        errorData.right = new FormAttachment(100, -5);
        errorData.top = new FormAttachment(0, 10);
        error.setLayoutData((Object)errorData);
        Label separator = new Label((Composite)this.shell, 64);
        this.props.setLook((Control)separator);
        FormData separatorData = new FormData();
        separatorData.top = new FormAttachment((Control)error, 10);
        separator.setLayoutData((Object)separatorData);
        Button closeButton = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)closeButton);
        FormData fdClose = new FormData();
        fdClose.right = new FormAttachment(98);
        fdClose.top = new FormAttachment((Control)separator);
        closeButton.setLayoutData((Object)fdClose);
        closeButton.setText(BaseMessages.getString(PKG, (String)"MissingTransDialog.Close", (String[])new String[0]));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MissingTransDialog.this.shell.dispose();
                MissingTransDialog.this.stepResult = null;
            }
        });
        FormData fdSearch = new FormData();
        if (this.mode == 1) {
            Button openButton = new Button((Composite)this.shell, 8);
            this.props.setLook((Control)openButton);
            FormData fdOpen = new FormData();
            fdOpen.right = new FormAttachment((Control)closeButton, -5);
            fdOpen.bottom = new FormAttachment((Control)closeButton, 0, 1024);
            openButton.setLayoutData((Object)fdOpen);
            openButton.setText(BaseMessages.getString(PKG, (String)"MissingTransDialog.OpenFile", (String[])new String[0]));
            openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MissingTransDialog.this.shell.dispose();
                    MissingTransDialog.this.stepResult = MissingTransDialog.this.stepname;
                }
            });
            fdSearch.right = new FormAttachment((Control)openButton, -5);
            fdSearch.bottom = new FormAttachment((Control)openButton, 0, 1024);
        } else {
            fdSearch.right = new FormAttachment((Control)closeButton, -5);
            fdSearch.bottom = new FormAttachment((Control)closeButton, 0, 1024);
        }
        Button searchButton = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)searchButton);
        searchButton.setText(BaseMessages.getString(PKG, (String)"MissingTransDialog.SearchMarketplace", (String[])new String[0]));
        searchButton.setLayoutData((Object)fdSearch);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MissingTransDialog.this.shell.dispose();
                    Spoon.getInstance().openMarketplace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepResult;
    }
}

