/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.sapinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.SAPR3DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sapinput.SapInputMeta;
import org.pentaho.di.trans.steps.sapinput.SapOutputField;
import org.pentaho.di.trans.steps.sapinput.SapParameter;
import org.pentaho.di.trans.steps.sapinput.SapType;
import org.pentaho.di.trans.steps.sapinput.sap.SAPConnection;
import org.pentaho.di.trans.steps.sapinput.sap.SAPConnectionFactory;
import org.pentaho.di.trans.steps.sapinput.sap.SAPField;
import org.pentaho.di.trans.steps.sapinput.sap.SAPFunction;
import org.pentaho.di.trans.steps.sapinput.sap.SAPFunctionSignature;
import org.pentaho.di.trans.steps.sapinput.sap.SAPLibraryTester;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.di.ui.trans.steps.sapinput.SapFunctionBrowser;
import org.pentaho.di.ui.trans.steps.sapinput.SapInputAboutDialog;

public class SapInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SapInputMeta.class;
    private CCombo wConnection;
    private Label wlFunction;
    private Text wFunction;
    private Button wbFunction;
    private Label wlInput;
    private TableView wInput;
    private Label wlOutput;
    private TableView wOutput;
    private Button wGet;
    private Listener lsGet;
    private SAPFunction function;
    private SapInputMeta input;
    private Button wAbout;
    private Link wAscLink;
    private List<ColumnInfo> inputFieldColumns = new ArrayList<ColumnInfo>();
    private List<ColumnInfo> outputFieldColumns = new ArrayList<ColumnInfo>();
    private RowMetaInterface prevFields = null;

    public SapInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (SapInputMeta)in;
    }

    public String open() {
        MessageBox messageBox;
        int style;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        if (!SAPLibraryTester.isJCoLibAvailable()) {
            style = 1;
            messageBox = new MessageBox(this.shell, style);
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"SapInputDialog.JCoLibNotFound", (String[])new String[0]));
            messageBox.open();
        }
        if (!SAPLibraryTester.isJCoImplAvailable()) {
            style = 1;
            messageBox = new MessageBox(this.shell, style);
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"SapInputDialog.JCoImplNotFound", (String[])new String[0]));
            messageBox.open();
        }
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SapInputDialog.this.input.setChanged();
            }
        };
        ModifyListener lsConnectionMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SapInputDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Object lastControl = this.wStepname;
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)lastControl, middle, margin);
        ArrayList<String> items = new ArrayList<String>();
        for (DatabaseMeta dbMeta : this.transMeta.getDatabases()) {
            if (!(dbMeta.getDatabaseInterface() instanceof SAPR3DatabaseMeta)) continue;
            items.add(dbMeta.getName());
        }
        this.wConnection.setItems(items.toArray(new String[items.size()]));
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsConnectionMod);
        lastControl = this.wConnection;
        this.wlFunction = new Label((Composite)this.shell, 131072);
        this.wlFunction.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.Function.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFunction);
        FormData fdlFunction = new FormData();
        fdlFunction.left = new FormAttachment(0, 0);
        fdlFunction.right = new FormAttachment(middle, -margin);
        fdlFunction.top = new FormAttachment((Control)lastControl, margin);
        this.wlFunction.setLayoutData((Object)fdlFunction);
        this.wbFunction = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbFunction);
        this.wbFunction.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.FindFunctionButton.Label", (String[])new String[0]));
        FormData fdbFunction = new FormData();
        fdbFunction.right = new FormAttachment(100, 0);
        fdbFunction.top = new FormAttachment((Control)lastControl, margin);
        this.wbFunction.setLayoutData((Object)fdbFunction);
        this.wbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SapInputDialog.this.getFunction();
            }
        });
        this.wFunction = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFunction);
        this.wFunction.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SapInputDialog.this.function = new SAPFunction(((Text)e.widget).getText());
                SapInputDialog.this.input.setChanged();
            }
        });
        FormData fdFunction = new FormData();
        fdFunction.left = new FormAttachment(middle, 0);
        fdFunction.right = new FormAttachment((Control)this.wbFunction, -margin);
        fdFunction.top = new FormAttachment((Control)lastControl, margin);
        this.wFunction.setLayoutData((Object)fdFunction);
        lastControl = this.wFunction;
        this.wlInput = new Label((Composite)this.shell, 0);
        this.wlInput.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.Input.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInput);
        FormData fdlInput = new FormData();
        fdlInput.left = new FormAttachment(0, 0);
        fdlInput.top = new FormAttachment((Control)lastControl, margin);
        this.wlInput.setLayoutData((Object)fdlInput);
        ColumnInfo[] ciKey = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.SAPType", (String[])new String[0]), 2, SapType.getDescriptions()), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.TableOrStruct", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.SAPParameterName", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.TargetType", (String[])new String[0]), 2, ValueMeta.getTypes())};
        this.inputFieldColumns.add(ciKey[0]);
        this.wInput = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciKey, this.input.getParameters().size(), lsMod, this.props);
        FormData fdInput = new FormData();
        fdInput.left = new FormAttachment(0, 0);
        fdInput.top = new FormAttachment((Control)this.wlInput, margin);
        fdInput.right = new FormAttachment(100, 0);
        fdInput.bottom = new FormAttachment(40, 0);
        this.wInput.setLayoutData(fdInput);
        lastControl = this.wInput;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.GetFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wAbout = new Button((Composite)this.shell, 8);
        this.wAbout.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.About.Button", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wAbout, this.wGet, this.wCancel}, margin, null);
        this.wlOutput = new Label((Composite)this.shell, 0);
        this.wlOutput.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.Output.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutput);
        FormData fdlOutput = new FormData();
        fdlOutput.left = new FormAttachment(0, 0);
        fdlOutput.top = new FormAttachment((Control)this.wInput, margin);
        this.wlOutput.setLayoutData((Object)fdlOutput);
        ColumnInfo[] ciReturn = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.SAPField", (String[])new String[0]), 2, new String[0], false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.SAPType", (String[])new String[0]), 2, SapType.getDescriptions(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.TableOrStruct", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.NewName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SapInputDialog.ColumnInfo.TargetType", (String[])new String[0]), 2, ValueMeta.getTypes())};
        this.outputFieldColumns.add(ciReturn[0]);
        this.wOutput = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciReturn, this.input.getOutputFields().size(), lsMod, this.props);
        FormData fdOutput = new FormData();
        fdOutput.left = new FormAttachment(0, 0);
        fdOutput.top = new FormAttachment((Control)this.wlOutput, margin);
        fdOutput.right = new FormAttachment(100, 0);
        fdOutput.bottom = new FormAttachment((Control)this.wOK, -8 * margin);
        this.wOutput.setLayoutData(fdOutput);
        lastControl = this.wOutput;
        this.wAscLink = new Link((Composite)this.shell, 0);
        FormData fdAscLink = new FormData();
        fdAscLink.left = new FormAttachment(0, 0);
        fdAscLink.top = new FormAttachment((Control)this.wOutput, margin);
        this.wAscLink.setLayoutData((Object)fdAscLink);
        this.wAscLink.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.Provided.Info", (String[])new String[0]));
        lastControl = this.wAscLink;
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SapInputDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                SapInputDialog.this.preview();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                SapInputDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SapInputDialog.this.cancel();
            }
        };
        Listener lsAbout = new Listener(){

            public void handleEvent(Event e) {
                SapInputDialog.this.about();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.wAbout.addListener(13, lsAbout);
        this.wAscLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)event.text);
            }
        });
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SapInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wFunction.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SapInputDialog.this.cancel();
            }
        });
        this.getData();
        this.setSize();
        this.input.setChanged(this.backupChanged);
        this.setComboValues();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void getFunction() {
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta == null) {
            this.showDatabaseWarning(false);
            return;
        }
        SapFunctionBrowser browser = new SapFunctionBrowser(this.shell, (VariableSpace)this.transMeta, 0, databaseMeta, this.wFunction.getText());
        this.function = browser.open();
        if (this.function != null) {
            this.get();
        }
    }

    private void setComboValues() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                try {
                    SapInputDialog.this.prevFields = SapInputDialog.this.transMeta.getPrevStepFields(SapInputDialog.this.stepname);
                }
                catch (KettleException e) {
                    SapInputDialog.this.prevFields = (RowMetaInterface)new RowMeta();
                    String msg = BaseMessages.getString((Class)PKG, (String)"SapInputDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                    SapInputDialog.this.logError(msg);
                }
                Object[] prevStepFieldNames = SapInputDialog.this.prevFields.getFieldNames();
                Arrays.sort(prevStepFieldNames);
                for (int i = 0; i < SapInputDialog.this.inputFieldColumns.size(); ++i) {
                    ColumnInfo colInfo = (ColumnInfo)SapInputDialog.this.outputFieldColumns.get(i);
                    colInfo.setComboValues((String[])prevStepFieldNames);
                }
            }
        };
        new Thread(fieldLoader).start();
    }

    public void getData() {
        int colnr;
        TableItem item;
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"SapInputDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        this.function = this.input.getFunction();
        if (this.input.getFunction() != null) {
            this.wFunction.setText(Const.NVL((String)this.input.getFunction().getName(), (String)""));
        }
        for (i = 0; i < this.input.getParameters().size(); ++i) {
            SapParameter parameter = (SapParameter)this.input.getParameters().get(i);
            item = this.wInput.table.getItem(i);
            colnr = 1;
            item.setText(colnr++, Const.NVL((String)parameter.getFieldName(), (String)""));
            item.setText(colnr++, parameter.getSapType().getDescription());
            item.setText(colnr++, Const.NVL((String)parameter.getTableName(), (String)""));
            item.setText(colnr++, Const.NVL((String)parameter.getParameterName(), (String)""));
            item.setText(colnr++, ValueMeta.getTypeDesc((int)parameter.getTargetType()));
        }
        this.wInput.setRowNums();
        this.wInput.optWidth(true);
        for (i = 0; i < this.input.getOutputFields().size(); ++i) {
            SapOutputField outputField = (SapOutputField)this.input.getOutputFields().get(i);
            item = this.wOutput.table.getItem(i);
            colnr = 1;
            item.setText(colnr++, Const.NVL((String)outputField.getSapFieldName(), (String)""));
            item.setText(colnr++, outputField.getSapType().getDescription());
            item.setText(colnr++, Const.NVL((String)outputField.getTableName(), (String)""));
            item.setText(colnr++, Const.NVL((String)outputField.getNewName(), (String)""));
            item.setText(colnr++, ValueMeta.getTypeDesc((int)outputField.getTargetType()));
        }
        this.wOutput.setRowNums();
        this.wOutput.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        int answer;
        int answer2;
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        if (this.transMeta.findDatabase(this.wConnection.getText()) == null && (answer2 = this.showDatabaseWarning(true)) == 256) {
            return;
        }
        HashSet<String> tables = new HashSet<String>();
        int nrParameters = this.wOutput.nrNonEmpty();
        for (int i = 0; i < nrParameters; ++i) {
            TableItem item = this.wOutput.getNonEmpty(i);
            String tableName = item.getText(3);
            tables.add(tableName);
        }
        if (tables.size() > 1 && (answer = this.showMultipleOutputTablesWarning(true)) == 256) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void preview() {
        SapInputMeta oneMeta = new SapInputMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        this.transMeta.getVariable("Internal.Transformation.Filename.Directory");
        previewMeta.getVariable("Internal.Transformation.Filename.Directory");
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CsvInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    private void about() {
        new SapInputAboutDialog(this.shell).open();
    }

    private int showDatabaseWarning(boolean includeCancel) {
        MessageBox mb = new MessageBox(this.shell, 0x20 | (includeCancel ? 256 : 0) | 1);
        mb.setMessage(BaseMessages.getString(PKG, (String)"SapInputDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
        return mb.open();
    }

    private int showMultipleOutputTablesWarning(boolean includeCancel) {
        MessageBox mb = new MessageBox(this.shell, 0x20 | (includeCancel ? 256 : 0) | 1);
        mb.setMessage(BaseMessages.getString(PKG, (String)"SapInputDialog.MultipleOutputTables.DialogMessage", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.MultipleOutputTables.DialogTitle", (String[])new String[0]));
        return mb.open();
    }

    private void getInfo(SapInputMeta meta) {
        meta.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        meta.setFunction(this.function);
        meta.getParameters().clear();
        int nrParameters = this.wInput.nrNonEmpty();
        for (int i = 0; i < nrParameters; ++i) {
            TableItem item = this.wInput.getNonEmpty(i);
            int colnr = 1;
            String fieldName = item.getText(colnr++);
            SapType sapType = SapType.findTypeForDescription((String)item.getText(colnr++));
            String tableName = item.getText(colnr++);
            String parameterName = item.getText(colnr++);
            int targetType = ValueMeta.getType((String)item.getText(colnr++));
            meta.getParameters().add(new SapParameter(fieldName, sapType, tableName, parameterName, targetType));
        }
        meta.getOutputFields().clear();
        int nrFields = this.wOutput.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wOutput.getNonEmpty(i);
            int colnr = 1;
            String sapFieldName = item.getText(colnr++);
            SapType sapType = SapType.findTypeForDescription((String)item.getText(colnr++));
            String tableName = item.getText(colnr++);
            String newName = item.getText(colnr++);
            int targetType = ValueMeta.getType((String)item.getText(colnr++));
            meta.getOutputFields().add(new SapOutputField(sapFieldName, sapType, tableName, newName, targetType));
        }
    }

    private void get() {
        block13: {
            try {
                DatabaseMeta databaseMeta;
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null && !r.isEmpty()) {
                    TableItemInsertListener listener = new TableItemInsertListener(){

                        @Override
                        public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                            tableItem.setText(2, "=");
                            return true;
                        }
                    };
                    BaseStepDialog.getFieldsFromPrevious(r, this.wInput, 1, new int[]{1, 3}, new int[0], -1, -1, listener);
                }
                if ((databaseMeta = this.transMeta.findDatabase(this.wConnection.getText())) == null) {
                    this.showDatabaseWarning(false);
                    return;
                }
                if (this.function == null) break block13;
                this.wFunction.setText(this.function.getName());
                if (this.wInput.nrNonEmpty() != 0 || this.wOutput.nrNonEmpty() != 0) {
                    MessageBox mb = new MessageBox(this.shell, 196);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SapInputDialog.ClearInputOutput.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"SapInputDialog.ClearInputOutput.DialogTitle", (String[])new String[0]));
                    int answer = mb.open();
                    if (answer == 128) {
                        return;
                    }
                }
                this.wInput.clearAll(false);
                this.wOutput.clearAll(false);
                Cursor hourGlass = new Cursor((Device)this.shell.getDisplay(), 1);
                SAPConnection sc = SAPConnectionFactory.create();
                try {
                    int colnr;
                    SapType type;
                    TableItem item;
                    this.shell.setCursor(hourGlass);
                    sc.open(databaseMeta);
                    SAPFunctionSignature signature = sc.getFunctionSignature(this.function);
                    int rownr = 0;
                    for (SAPField field : signature.getInput()) {
                        item = rownr == 0 ? this.wInput.table.getItem(0) : new TableItem(this.wInput.table, 0);
                        ++rownr;
                        type = this.getSapType(field);
                        colnr = 1;
                        item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
                        item.setText(colnr++, type == null ? "" : type.getDescription());
                        item.setText(colnr++, Const.NVL((String)field.getTable(), (String)""));
                        item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
                        item.setText(colnr++, field.getTypePentaho());
                    }
                    this.wInput.setRowNums();
                    this.wInput.optWidth(true);
                    rownr = 0;
                    for (SAPField field : signature.getOutput()) {
                        item = rownr == 0 ? this.wOutput.table.getItem(0) : new TableItem(this.wOutput.table, 0);
                        ++rownr;
                        type = this.getSapType(field);
                        colnr = 1;
                        item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
                        item.setText(colnr++, type == null ? "" : type.getDescription());
                        item.setText(colnr++, Const.NVL((String)field.getTable(), (String)""));
                        item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
                        item.setText(colnr++, field.getTypePentaho());
                    }
                    this.wOutput.setRowNums();
                    this.wOutput.optWidth(true);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
                finally {
                    sc.close();
                    this.shell.setCursor(null);
                    hourGlass.dispose();
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SapInputDialog.GetFieldsFailed.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SapInputDialog.GetFieldsFailed.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    private SapType getSapType(SAPField field) {
        String type = field.getType();
        if (type != null && type.startsWith("input_")) {
            type = type.substring("input_".length());
        } else if (type != null && type.startsWith("output_")) {
            type = type.substring("output_".length());
        }
        return SapType.findTypeForCode((String)type);
    }

    @Override
    public String toString() {
        return this.stepname;
    }
}

