/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.annotations.RepositoryPlugin;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.IdNotFoundException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.AbstractRepository;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.ClusterDelegate;
import org.pentaho.di.repository.pur.DatabaseDelegate;
import org.pentaho.di.repository.pur.IRepositoryConnector;
import org.pentaho.di.repository.pur.ISharedObjectsTransformer;
import org.pentaho.di.repository.pur.ITransformer;
import org.pentaho.di.repository.pur.JobDelegate;
import org.pentaho.di.repository.pur.LazyUnifiedRepositoryDirectory;
import org.pentaho.di.repository.pur.PartitionDelegate;
import org.pentaho.di.repository.pur.PurObjectRevision;
import org.pentaho.di.repository.pur.PurRepositoryConnector;
import org.pentaho.di.repository.pur.PurRepositoryExporter;
import org.pentaho.di.repository.pur.PurRepositoryImporter;
import org.pentaho.di.repository.pur.PurRepositoryLocation;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.RepositoryConnectResult;
import org.pentaho.di.repository.pur.RepositoryObjectAccessException;
import org.pentaho.di.repository.pur.RepositoryServiceRegistry;
import org.pentaho.di.repository.pur.RootRef;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.repository.pur.SharedObjectAssembler;
import org.pentaho.di.repository.pur.SlaveDelegate;
import org.pentaho.di.repository.pur.TransDelegate;
import org.pentaho.di.repository.pur.UnifiedRepositoryConnectionAclService;
import org.pentaho.di.repository.pur.UnifiedRepositoryInvocationHandler;
import org.pentaho.di.repository.pur.UnifiedRepositoryLockService;
import org.pentaho.di.repository.pur.UnifiedRepositoryRevisionService;
import org.pentaho.di.repository.pur.metastore.PurRepositoryMetaStore;
import org.pentaho.di.repository.pur.model.EEJobMeta;
import org.pentaho.di.repository.pur.model.EERepositoryObject;
import org.pentaho.di.repository.pur.model.EETransMeta;
import org.pentaho.di.repository.pur.model.EEUserInfo;
import org.pentaho.di.repository.pur.model.RepositoryLock;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.di.ui.repository.pur.services.IAclService;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.repository.pur.services.IRevisionService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.ClientRepositoryPaths;

@RepositoryPlugin(id="PentahoEnterpriseRepository", name="RepositoryType.Name.EnterpriseRepository", description="RepositoryType.Description.EnterpriseRepository", metaClass="org.pentaho.di.repository.pur.PurRepositoryMeta", i18nPackageName="org.pentaho.di.repository.pur")
public class PurRepository
extends AbstractRepository
implements Repository,
RepositoryExtended,
Serializable {
    private static final long serialVersionUID = 7460109109707189479L;
    public static final String LAZY_REPOSITORY = "KETTLE_LAZY_REPOSITORY";
    private static Class<?> PKG = PurRepository.class;
    private static final String REPOSITORY_VERSION = "1.0";
    private static final boolean VERSION_SHARED_OBJECTS = true;
    private static final String FOLDER_PDI = "pdi";
    private static final String FOLDER_PARTITION_SCHEMAS = "partitionSchemas";
    private static final String FOLDER_CLUSTER_SCHEMAS = "clusterSchemas";
    private static final String FOLDER_SLAVE_SERVERS = "slaveServers";
    private static final String FOLDER_DATABASES = "databases";
    private boolean test = false;
    private IUnifiedRepository pur;
    private IUser user;
    private PurRepositoryMeta repositoryMeta;
    private DatabaseDelegate databaseMetaTransformer = new DatabaseDelegate(this);
    private PartitionDelegate partitionSchemaTransformer = new PartitionDelegate(this);
    private SlaveDelegate slaveTransformer = new SlaveDelegate(this);
    private ClusterDelegate clusterTransformer = new ClusterDelegate(this);
    private ISharedObjectsTransformer transDelegate;
    private ISharedObjectsTransformer jobDelegate;
    private Map<RepositoryObjectType, SharedObjectAssembler<?>> sharedObjectAssemblerMap;
    private RepositorySecurityManager securityManager;
    private RepositorySecurityProvider securityProvider;
    protected LogChannelInterface log;
    protected Serializable cachedSlaveServerParentFolderId;
    protected Serializable cachedPartitionSchemaParentFolderId;
    protected Serializable cachedClusterSchemaParentFolderId;
    protected Serializable cachedDatabaseMetaParentFolderId;
    private final RootRef rootRef = new RootRef();
    private UnifiedRepositoryLockService unifiedRepositoryLockService;
    private Map<RepositoryObjectType, List<? extends SharedObjectInterface>> sharedObjectsByType = null;
    private boolean connected = false;
    private String connectMessage = null;
    protected PurRepositoryMetaStore metaStore;
    private IRepositoryConnector purRepositoryConnector;
    private RepositoryServiceRegistry purRepositoryServiceRegistry = new RepositoryServiceRegistry();

    public PurRepository() {
        this.initSharedObjectAssemblerMap();
    }

    protected RepositoryDirectoryInterface getRootDir() throws KettleException {
        RepositoryDirectoryInterface ref = this.rootRef.getRef();
        return ref == null ? this.loadRepositoryDirectoryTree() : ref;
    }

    public void setTest(IUnifiedRepository pur) {
        this.pur = pur;
        this.repositoryMeta.setRepositoryLocation(new PurRepositoryLocation("doesnotmatch"));
        this.test = true;
    }

    private boolean isTest() {
        return this.test;
    }

    public void init(RepositoryMeta repositoryMeta) {
        this.log = new LogChannel((Object)this.getClass().getSimpleName());
        this.repositoryMeta = (PurRepositoryMeta)repositoryMeta;
        this.purRepositoryConnector = new PurRepositoryConnector(this, this.repositoryMeta, this.rootRef);
    }

    public void setPurRepositoryConnector(IRepositoryConnector purRepositoryConnector) {
        this.purRepositoryConnector = purRepositoryConnector;
    }

    public RootRef getRootRef() {
        return this.rootRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String username, String password) throws KettleException {
        block22: {
            if (this.isTest()) {
                this.connected = true;
                this.purRepositoryServiceRegistry.registerService(IRevisionService.class, new UnifiedRepositoryRevisionService(this.pur, this.getRootRef()));
                this.purRepositoryServiceRegistry.registerService(ILockService.class, new UnifiedRepositoryLockService(this.pur));
                this.purRepositoryServiceRegistry.registerService(IAclService.class, new UnifiedRepositoryConnectionAclService(this.pur));
                this.metaStore = new PurRepositoryMetaStore(this);
                try {
                    this.metaStore.createNamespace("pentaho");
                }
                catch (MetaStoreException e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryMetastore.NamespaceCreateException.Message", (String[])new String[]{"pentaho"}), (Throwable)e);
                }
                this.user = new EEUserInfo(username, password, username, "test user", true);
                this.jobDelegate = new JobDelegate(this, this.pur);
                this.transDelegate = new TransDelegate(this, this.pur);
                this.unifiedRepositoryLockService = new UnifiedRepositoryLockService(this.pur);
                return;
            }
            try {
                if (this.log != null && this.purRepositoryConnector != null && this.purRepositoryConnector.getLog() != null) {
                    this.purRepositoryConnector.getLog().setLogLevel(this.log.getLogLevel());
                }
                RepositoryConnectResult result = this.purRepositoryConnector.connect(username, password);
                this.user = result.getUser();
                this.connected = result.isSuccess();
                this.securityProvider = result.getSecurityProvider();
                this.securityManager = result.getSecurityManager();
                IUnifiedRepository r = result.getUnifiedRepository();
                try {
                    this.pur = (IUnifiedRepository)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{IUnifiedRepository.class}, new UnifiedRepositoryInvocationHandler<IUnifiedRepository>(r));
                }
                catch (Throwable th) {
                    if (this.log.isError()) {
                        this.log.logError("Failed to setup repository connection", th);
                    }
                    this.connected = false;
                }
                this.unifiedRepositoryLockService = new UnifiedRepositoryLockService(this.pur);
                this.connectMessage = result.getConnectMessage();
                this.purRepositoryServiceRegistry = result.repositoryServiceRegistry();
                this.transDelegate = new TransDelegate(this, this.pur);
                this.jobDelegate = new JobDelegate(this, this.pur);
                if (!this.connected) break block22;
            }
            catch (Throwable throwable) {
                if (this.connected) {
                    if (this.log.isBasic()) {
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepositoryMetastore.Create.Message", (String[])new String[0]));
                    }
                    this.metaStore = new PurRepositoryMetaStore(this);
                    try {
                        this.metaStore.createNamespace("pentaho");
                        if (this.log.isBasic()) {
                            this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepositoryMetastore.NamespaceCreateSuccess.Message", (String[])new String[]{"pentaho"}));
                        }
                    }
                    catch (MetaStoreNamespaceExistsException metaStoreNamespaceExistsException) {
                    }
                    catch (MetaStoreException e) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryMetastore.NamespaceCreateException.Message", (String[])new String[]{"pentaho"}), (Throwable)e);
                    }
                    if (this.log.isBasic()) {
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepository.ConnectSuccess.Message", (String[])new String[0]));
                    }
                }
                throw throwable;
            }
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepositoryMetastore.Create.Message", (String[])new String[0]));
            }
            this.metaStore = new PurRepositoryMetaStore(this);
            try {
                this.metaStore.createNamespace("pentaho");
                if (this.log.isBasic()) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepositoryMetastore.NamespaceCreateSuccess.Message", (String[])new String[]{"pentaho"}));
                }
            }
            catch (MetaStoreNamespaceExistsException result) {
            }
            catch (MetaStoreException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryMetastore.NamespaceCreateException.Message", (String[])new String[]{"pentaho"}), (Throwable)e);
            }
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepository.ConnectSuccess.Message", (String[])new String[0]));
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        this.connected = false;
        this.metaStore = null;
        this.purRepositoryConnector.disconnect();
    }

    public int countNrJobEntryAttributes(ObjectId idJobentry, String code) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public int countNrStepAttributes(ObjectId idStep, String code) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public RepositoryDirectoryInterface createRepositoryDirectory(RepositoryDirectoryInterface parentDirectory, String directoryPath) throws KettleException {
        try {
            RepositoryDirectoryInterface refreshedParentDir = this.findDirectory(parentDirectory.getPath());
            parentDirectory.setChildren(refreshedParentDir.getChildren());
            String[] path = Const.splitPath((String)directoryPath, (String)"/");
            RepositoryDirectoryInterface follow = parentDirectory;
            for (int level = 0; level < path.length; ++level) {
                RepositoryDirectoryInterface child = follow.findChild(path[level]);
                if (child == null) {
                    child = new RepositoryDirectory(follow, path[level]);
                    this.saveRepositoryDirectory(child);
                    follow.addSubdirectory(child);
                }
                follow = child;
            }
            return follow;
        }
        catch (Exception e) {
            throw new KettleException("Unable to create directory with path [" + directoryPath + "]", (Throwable)e);
        }
    }

    public void saveRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
        try {
            if ("/".equals(dir.getParent().getName())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"PurRepository.FailedDirectoryCreation.Message", (String[])new String[0]));
            }
            RepositoryFile newFolder = this.pur.createFolder((Serializable)((Object)(dir.getParent().getObjectId() != null ? dir.getParent().getObjectId().getId() : null)), new RepositoryFile.Builder(dir.getName()).folder(true).build(), null);
            dir.setObjectId((ObjectId)new StringObjectId(newFolder.getId().toString()));
        }
        catch (Exception e) {
            throw new KettleException("Unable to save repository directory with path [" + this.getPath(null, dir, null) + "]", (Throwable)e);
        }
    }

    protected boolean isSameOrAncestorFolder(RepositoryFile folder, RepositoryFile baseFolder) {
        return folder != null && baseFolder != null && (baseFolder.getId().equals(folder.getId()) || baseFolder.getPath().lastIndexOf("/") != folder.getPath().lastIndexOf("/") && baseFolder.getPath().startsWith(folder.getPath()));
    }

    protected boolean isUserHomeDirectory(RepositoryFile folder) {
        RepositoryFile homeRootFolder;
        if (folder != null && (homeRootFolder = this.pur.getFile(ClientRepositoryPaths.getHomeFolderPath())) != null) {
            String folderPath;
            String temp = homeRootFolder.getPath();
            String homeRootPath = temp.endsWith("/") && temp.length() > "/".length() ? temp.substring(0, temp.length() - "/".length()) : temp;
            temp = folder.getPath();
            String string = folderPath = temp.endsWith("/") && temp.length() > "/".length() ? temp.substring(0, temp.length() - "/".length()) : temp;
            if (folderPath.startsWith(homeRootPath)) {
                if (folderPath.equals(homeRootPath)) {
                    return false;
                }
                int folderPathDirCount = 0;
                int homeRootPathDirCount = 0;
                int x = 0;
                while (x >= 0) {
                    x = folderPath.indexOf("/", x + 1);
                    ++folderPathDirCount;
                }
                x = 0;
                while (x >= 0) {
                    x = homeRootPath.indexOf("/", x + 1);
                    ++homeRootPathDirCount;
                }
                if (folderPathDirCount == homeRootPathDirCount + 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public void deleteRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
        this.deleteRepositoryDirectory(dir, false);
    }

    public void deleteRepositoryDirectory(RepositoryDirectoryInterface dir, boolean deleteHomeDirectories) throws KettleException {
        try {
            RepositoryFile folder = this.pur.getFileById((Serializable)((Object)dir.getObjectId().getId()));
            RepositoryFile homeFolder = this.pur.getFile(ClientRepositoryPaths.getUserHomeFolderPath((String)this.user.getLogin()));
            if (this.isSameOrAncestorFolder(folder, homeFolder)) {
                throw new KettleException("You are not allowed to delete your home folder.");
            }
            if (!deleteHomeDirectories && this.isUserHomeDirectory(folder)) {
                throw new RepositoryObjectAccessException("Cannot delete another users home directory", RepositoryObjectAccessException.AccessExceptionType.USER_HOME_DIR);
            }
            this.pur.deleteFile((Serializable)((Object)dir.getObjectId().getId()), null);
            this.rootRef.clearRef();
        }
        catch (Exception e) {
            throw new KettleException("Unable to delete directory with path [" + this.getPath(null, dir, null) + "]", (Throwable)e);
        }
    }

    public ObjectId renameRepositoryDirectory(ObjectId dirId, RepositoryDirectoryInterface newParent, String newName) throws KettleException {
        return this.renameRepositoryDirectory(dirId, newParent, newName, false);
    }

    public ObjectId renameRepositoryDirectory(ObjectId dirId, RepositoryDirectoryInterface newParent, String newName, boolean renameHomeDirectories) throws KettleException {
        String finalName = null;
        String finalParentPath = null;
        String interimFolderPath = null;
        try {
            RepositoryFile homeFolder = this.pur.getFile(ClientRepositoryPaths.getUserHomeFolderPath((String)this.user.getLogin()));
            RepositoryFile folder = this.pur.getFileById((Serializable)((Object)dirId.getId()));
            finalName = newName != null ? newName : folder.getName();
            interimFolderPath = this.getParentPath(folder.getPath());
            String string = finalParentPath = newParent != null ? this.getPath(null, newParent, null) : interimFolderPath;
            if (this.isSameOrAncestorFolder(folder, homeFolder)) {
                throw new KettleException("You are not allowed to move/rename your home folder.");
            }
            if (!renameHomeDirectories && this.isUserHomeDirectory(folder)) {
                throw new RepositoryObjectAccessException("Cannot move another users home directory", RepositoryObjectAccessException.AccessExceptionType.USER_HOME_DIR);
            }
            this.pur.moveFile((Serializable)((Object)dirId.getId()), finalParentPath + "/" + finalName, null);
            this.rootRef.clearRef();
            return dirId;
        }
        catch (Exception e) {
            throw new KettleException("Unable to move/rename directory with id [" + dirId + "] to new parent [" + finalParentPath + "] and new name [" + finalName + "]", (Throwable)e);
        }
    }

    protected RepositoryFileTree loadRepositoryFileTree(String path) {
        return this.pur.getTree(path, -1, null, true);
    }

    public RepositoryDirectoryInterface loadRepositoryDirectoryTree(boolean eager) throws KettleException {
        Object rootDir;
        if (eager) {
            RepositoryFileTree rootFileTree = this.loadRepositoryFileTree(ClientRepositoryPaths.getRootFolderPath());
            rootDir = this.initRepositoryDirectoryTree(rootFileTree);
        } else {
            RepositoryFile root = this.pur.getFile("/");
            rootDir = new LazyUnifiedRepositoryDirectory(root, null, this.pur, this.purRepositoryServiceRegistry);
        }
        this.rootRef.setRef((RepositoryDirectoryInterface)rootDir);
        return rootDir;
    }

    public RepositoryDirectoryInterface loadRepositoryDirectoryTree() throws KettleException {
        return this.loadRepositoryDirectoryTree(this.isLoadingEager());
    }

    private boolean isLoadingEager() {
        return "false".equals(System.getProperty(LAZY_REPOSITORY));
    }

    private RepositoryDirectoryInterface initRepositoryDirectoryTree(RepositoryFileTree repoTree) throws KettleException {
        RepositoryFile rootFolder = repoTree.getFile();
        RepositoryDirectory rootDir = new RepositoryDirectory();
        rootDir.setObjectId((ObjectId)new StringObjectId(rootFolder.getId().toString()));
        this.loadRepositoryDirectory((RepositoryDirectoryInterface)rootDir, rootFolder, repoTree);
        RepositoryDirectory etcDir = rootDir.findDirectory(ClientRepositoryPaths.getEtcFolderPath());
        RepositoryDirectory newRoot = new RepositoryDirectory();
        newRoot.setObjectId(rootDir.getObjectId());
        newRoot.setVisible(false);
        for (int i = 0; i < rootDir.getNrSubdirectories(); ++i) {
            RepositoryDirectory childDir = rootDir.getSubdirectory(i);
            boolean isEtcChild = childDir.equals(etcDir);
            if (isEtcChild) continue;
            newRoot.addSubdirectory((RepositoryDirectoryInterface)childDir);
        }
        return newRoot;
    }

    private void loadRepositoryDirectory(RepositoryDirectoryInterface parentDir, RepositoryFile folder, RepositoryFileTree treeNode) throws KettleException {
        try {
            ArrayList<EERepositoryObject> fileChildren = new ArrayList<EERepositoryObject>();
            List children = treeNode.getChildren();
            if (children != null) {
                for (RepositoryFileTree child : children) {
                    if (child.getFile().isFolder()) {
                        RepositoryDirectory dir = new RepositoryDirectory(parentDir, child.getFile().getName());
                        dir.setObjectId((ObjectId)new StringObjectId(child.getFile().getId().toString()));
                        parentDir.addSubdirectory((RepositoryDirectoryInterface)dir);
                        this.loadRepositoryDirectory((RepositoryDirectoryInterface)dir, child.getFile(), child);
                        continue;
                    }
                    RepositoryLock lock = this.unifiedRepositoryLockService.getLock(child.getFile());
                    RepositoryObjectType objectType = PurRepository.getObjectType(child.getFile().getName());
                    fileChildren.add(new EERepositoryObject(child, parentDir, null, objectType, null, lock, false));
                }
                parentDir.setRepositoryObjects(fileChildren);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to load directory structure from repository", (Throwable)e);
        }
    }

    public String[] getDirectoryNames(ObjectId idDirectory) throws KettleException {
        try {
            List children = this.pur.getChildren((Serializable)((Object)idDirectory.getId()));
            ArrayList<String> childNames = new ArrayList<String>();
            for (RepositoryFile child : children) {
                if (!child.isFolder()) continue;
                childNames.add(child.getName());
            }
            return childNames.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get list of object names from directory [" + idDirectory + "]", (Throwable)e);
        }
    }

    public void deleteClusterSchema(ObjectId idCluster) throws KettleException {
        this.permanentlyDeleteSharedObject(idCluster);
        this.removeFromSharedObjectCache(RepositoryObjectType.CLUSTER_SCHEMA, idCluster);
    }

    public void deleteJob(ObjectId idJob) throws KettleException {
        this.deleteFileById(idJob);
    }

    protected void permanentlyDeleteSharedObject(ObjectId id) throws KettleException {
        try {
            this.pur.deleteFile((Serializable)((Object)id.getId()), true, null);
        }
        catch (Exception e) {
            throw new KettleException("Unable to delete object with id [" + id + "]", (Throwable)e);
        }
    }

    public void deleteFileById(ObjectId id) throws KettleException {
        try {
            this.pur.deleteFile((Serializable)((Object)id.getId()), null);
            this.rootRef.clearRef();
        }
        catch (Exception e) {
            throw new KettleException("Unable to delete object with id [" + id + "]", (Throwable)e);
        }
    }

    public void deletePartitionSchema(ObjectId idPartitionSchema) throws KettleException {
        this.permanentlyDeleteSharedObject(idPartitionSchema);
        this.removeFromSharedObjectCache(RepositoryObjectType.PARTITION_SCHEMA, idPartitionSchema);
    }

    public void deleteSlave(ObjectId idSlave) throws KettleException {
        this.permanentlyDeleteSharedObject(idSlave);
        this.removeFromSharedObjectCache(RepositoryObjectType.SLAVE_SERVER, idSlave);
    }

    public void deleteTransformation(ObjectId idTransformation) throws KettleException {
        this.deleteFileById(idTransformation);
        this.rootRef.clearRef();
    }

    public boolean exists(String name, RepositoryDirectoryInterface repositoryDirectory, RepositoryObjectType objectType) throws KettleException {
        try {
            String absPath = this.getPath(name, repositoryDirectory, objectType);
            return this.pur.getFile(absPath) != null;
        }
        catch (Exception e) {
            throw new KettleException("Unable to verify if the repository element [" + name + "] exists in ", (Throwable)e);
        }
    }

    private String getPath(String name, RepositoryDirectoryInterface repositoryDirectory, RepositoryObjectType objectType) {
        String path = null;
        if (repositoryDirectory != null && repositoryDirectory.getObjectId() != null) {
            path = repositoryDirectory.getPath();
        }
        if (objectType == null) {
            return path;
        }
        String sanitizedName = PurRepository.checkAndSanitize(name);
        switch (objectType) {
            case DATABASE: {
                return this.getDatabaseMetaParentFolderPath() + "/" + sanitizedName + RepositoryObjectType.DATABASE.getExtension();
            }
            case TRANSFORMATION: {
                if (path == null) {
                    return null;
                }
                return path + (path.endsWith("/") ? "" : "/") + sanitizedName + RepositoryObjectType.TRANSFORMATION.getExtension();
            }
            case PARTITION_SCHEMA: {
                return this.getPartitionSchemaParentFolderPath() + "/" + sanitizedName + RepositoryObjectType.PARTITION_SCHEMA.getExtension();
            }
            case SLAVE_SERVER: {
                return this.getSlaveServerParentFolderPath() + "/" + sanitizedName + RepositoryObjectType.SLAVE_SERVER.getExtension();
            }
            case CLUSTER_SCHEMA: {
                return this.getClusterSchemaParentFolderPath() + "/" + sanitizedName + RepositoryObjectType.CLUSTER_SCHEMA.getExtension();
            }
            case JOB: {
                if (path == null) {
                    return null;
                }
                return path + (path.endsWith("/") ? "" : "/") + sanitizedName + RepositoryObjectType.JOB.getExtension();
            }
        }
        throw new UnsupportedOperationException("not implemented");
    }

    public ObjectId getClusterID(String name) throws KettleException {
        try {
            return this.getObjectId(name, null, RepositoryObjectType.CLUSTER_SCHEMA, false);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get ID for cluster schema [" + name + "]", (Throwable)e);
        }
    }

    public ObjectId[] getClusterIDs(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.CLUSTER_SCHEMA, includeDeleted);
            ArrayList<StringObjectId> ids = new ArrayList<StringObjectId>();
            for (RepositoryFile file : children) {
                ids.add(new StringObjectId(file.getId().toString()));
            }
            return ids.toArray(new ObjectId[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all cluster schema IDs", (Throwable)e);
        }
    }

    public String[] getClusterNames(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.CLUSTER_SCHEMA, includeDeleted);
            ArrayList<String> names = new ArrayList<String>();
            for (RepositoryFile file : children) {
                names.add(file.getTitle());
            }
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all cluster schema names", (Throwable)e);
        }
    }

    public ObjectId getDatabaseID(String name) throws KettleException {
        try {
            ObjectId objectId = this.getObjectId(name, null, RepositoryObjectType.DATABASE, false);
            if (objectId == null) {
                List<RepositoryFile> allDatabases = this.getAllFilesOfType(null, RepositoryObjectType.DATABASE, false);
                String[] existingNames = new String[allDatabases.size()];
                for (int i = 0; i < allDatabases.size(); ++i) {
                    RepositoryFile file = allDatabases.get(i);
                    existingNames[i] = file.getTitle();
                }
                int index = DatabaseMeta.indexOfName((String[])existingNames, (String)name);
                if (index != -1) {
                    return new StringObjectId(allDatabases.get(index).getId().toString());
                }
            }
            return objectId;
        }
        catch (Exception e) {
            throw new KettleException("Unable to get ID for database [" + name + "]", (Throwable)e);
        }
    }

    private ObjectId getObjectId(String name, RepositoryDirectoryInterface dir, RepositoryObjectType objectType, boolean includedDeleteFiles) {
        String absPath = this.getPath(name, dir, objectType);
        RepositoryFile file = this.pur.getFile(absPath);
        if (file != null) {
            return new StringObjectId(file.getId().toString());
        }
        if (includedDeleteFiles) {
            switch (objectType) {
                case DATABASE: {
                    List deletedChildren = this.pur.getDeletedFiles(this.getDatabaseMetaParentFolderPath(), name + RepositoryObjectType.DATABASE.getExtension());
                    if (!deletedChildren.isEmpty()) {
                        return new StringObjectId(((RepositoryFile)deletedChildren.get(0)).getId().toString());
                    }
                    return null;
                }
                case TRANSFORMATION: {
                    List deletedChildren = this.pur.getDeletedFiles(dir.getObjectId().getId(), name + RepositoryObjectType.TRANSFORMATION.getExtension());
                    if (!deletedChildren.isEmpty()) {
                        return new StringObjectId(((RepositoryFile)deletedChildren.get(0)).getId().toString());
                    }
                    return null;
                }
                case PARTITION_SCHEMA: {
                    List deletedChildren = this.pur.getDeletedFiles(this.getPartitionSchemaParentFolderPath(), name + RepositoryObjectType.PARTITION_SCHEMA.getExtension());
                    if (!deletedChildren.isEmpty()) {
                        return new StringObjectId(((RepositoryFile)deletedChildren.get(0)).getId().toString());
                    }
                    return null;
                }
                case SLAVE_SERVER: {
                    List deletedChildren = this.pur.getDeletedFiles(this.getSlaveServerParentFolderPath(), name + RepositoryObjectType.SLAVE_SERVER.getExtension());
                    if (!deletedChildren.isEmpty()) {
                        return new StringObjectId(((RepositoryFile)deletedChildren.get(0)).getId().toString());
                    }
                    return null;
                }
                case CLUSTER_SCHEMA: {
                    List deletedChildren = this.pur.getDeletedFiles(this.getClusterSchemaParentFolderPath(), name + RepositoryObjectType.CLUSTER_SCHEMA.getExtension());
                    if (!deletedChildren.isEmpty()) {
                        return new StringObjectId(((RepositoryFile)deletedChildren.get(0)).getId().toString());
                    }
                    return null;
                }
                case JOB: {
                    List deletedChildren = this.pur.getDeletedFiles(dir.getObjectId().getId(), name + RepositoryObjectType.JOB.getExtension());
                    if (!deletedChildren.isEmpty()) {
                        return new StringObjectId(((RepositoryFile)deletedChildren.get(0)).getId().toString());
                    }
                    return null;
                }
            }
            throw new UnsupportedOperationException("not implemented");
        }
        return null;
    }

    public ObjectId[] getDatabaseIDs(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.DATABASE, includeDeleted);
            ArrayList<StringObjectId> ids = new ArrayList<StringObjectId>(children.size());
            for (RepositoryFile file : children) {
                ids.add(new StringObjectId(file.getId().toString()));
            }
            return ids.toArray(new ObjectId[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all database IDs", (Throwable)e);
        }
    }

    protected List<RepositoryFile> getAllFilesOfType(ObjectId dirId, RepositoryObjectType objectType, boolean includeDeleted) throws KettleException {
        return this.getAllFilesOfType(dirId, Collections.singletonList(objectType), includeDeleted);
    }

    protected List<RepositoryFile> getAllFilesOfType(ObjectId dirId, List<RepositoryObjectType> objectTypes, boolean includeDeleted) throws KettleException {
        ArrayList<RepositoryFile> allChildren = new ArrayList<RepositoryFile>();
        List<RepositoryFile> children = this.getAllFilesOfType(dirId, objectTypes);
        allChildren.addAll(children);
        if (includeDeleted) {
            String dirPath = null;
            if (dirId != null) {
                dirPath = this.pur.getFileById((Serializable)((Object)dirId.getId())).getPath();
            }
            List<RepositoryFile> deletedChildren = this.getAllDeletedFilesOfType(dirPath, objectTypes);
            allChildren.addAll(deletedChildren);
            Collections.sort(allChildren);
        }
        return allChildren;
    }

    protected List<RepositoryFile> getAllFilesOfType(ObjectId dirId, List<RepositoryObjectType> objectTypes) throws KettleException {
        HashSet<Object> parentFolderIds = new HashSet<Object>();
        ArrayList<String> filters = new ArrayList<String>();
        block9: for (RepositoryObjectType objectType : objectTypes) {
            switch (objectType) {
                case DATABASE: {
                    parentFolderIds.add(this.getDatabaseMetaParentFolderId());
                    filters.add("*" + RepositoryObjectType.DATABASE.getExtension());
                    continue block9;
                }
                case TRANSFORMATION: {
                    parentFolderIds.add(dirId.getId());
                    filters.add("*" + RepositoryObjectType.TRANSFORMATION.getExtension());
                    continue block9;
                }
                case PARTITION_SCHEMA: {
                    parentFolderIds.add(this.getPartitionSchemaParentFolderId());
                    filters.add("*" + RepositoryObjectType.PARTITION_SCHEMA.getExtension());
                    continue block9;
                }
                case SLAVE_SERVER: {
                    parentFolderIds.add(this.getSlaveServerParentFolderId());
                    filters.add("*" + RepositoryObjectType.SLAVE_SERVER.getExtension());
                    continue block9;
                }
                case CLUSTER_SCHEMA: {
                    parentFolderIds.add(this.getClusterSchemaParentFolderId());
                    filters.add("*" + RepositoryObjectType.CLUSTER_SCHEMA.getExtension());
                    continue block9;
                }
                case JOB: {
                    parentFolderIds.add(dirId.getId());
                    filters.add("*" + RepositoryObjectType.JOB.getExtension());
                    continue block9;
                }
                case TRANS_DATA_SERVICE: {
                    parentFolderIds.add(dirId.getId());
                    filters.add("*" + RepositoryObjectType.TRANS_DATA_SERVICE.getExtension());
                    continue block9;
                }
            }
            throw new UnsupportedOperationException("not implemented");
        }
        StringBuilder mergedFilterBuf = new StringBuilder();
        int i = 0;
        for (String filter : filters) {
            if (i++ > 0) {
                mergedFilterBuf.append(" | ");
            }
            mergedFilterBuf.append(filter);
        }
        ArrayList<RepositoryFile> allFiles = new ArrayList<RepositoryFile>();
        for (Serializable serializable : parentFolderIds) {
            allFiles.addAll(this.pur.getChildren(serializable, mergedFilterBuf.toString()));
        }
        Collections.sort(allFiles);
        return allFiles;
    }

    protected List<RepositoryFile> getAllDeletedFilesOfType(String dirPath, List<RepositoryObjectType> objectTypes) throws KettleException {
        HashSet<String> parentFolderPaths = new HashSet<String>();
        ArrayList<String> filters = new ArrayList<String>();
        block8: for (RepositoryObjectType objectType : objectTypes) {
            switch (objectType) {
                case DATABASE: {
                    parentFolderPaths.add(this.getDatabaseMetaParentFolderPath());
                    filters.add("*" + RepositoryObjectType.DATABASE.getExtension());
                    continue block8;
                }
                case TRANSFORMATION: {
                    parentFolderPaths.add(dirPath);
                    filters.add("*" + RepositoryObjectType.TRANSFORMATION.getExtension());
                    continue block8;
                }
                case PARTITION_SCHEMA: {
                    parentFolderPaths.add(this.getPartitionSchemaParentFolderPath());
                    filters.add("*" + RepositoryObjectType.PARTITION_SCHEMA.getExtension());
                    continue block8;
                }
                case SLAVE_SERVER: {
                    parentFolderPaths.add(this.getSlaveServerParentFolderPath());
                    filters.add("*" + RepositoryObjectType.SLAVE_SERVER.getExtension());
                    continue block8;
                }
                case CLUSTER_SCHEMA: {
                    parentFolderPaths.add(this.getClusterSchemaParentFolderPath());
                    filters.add("*" + RepositoryObjectType.CLUSTER_SCHEMA.getExtension());
                    continue block8;
                }
                case JOB: {
                    parentFolderPaths.add(dirPath);
                    filters.add("*" + RepositoryObjectType.JOB.getExtension());
                    continue block8;
                }
            }
            throw new UnsupportedOperationException();
        }
        StringBuilder mergedFilterBuf = new StringBuilder();
        int i = 0;
        for (String filter : filters) {
            if (i++ > 0) {
                mergedFilterBuf.append(" | ");
            }
            mergedFilterBuf.append(filter);
        }
        ArrayList<RepositoryFile> allFiles = new ArrayList<RepositoryFile>();
        for (String parentFolderPath : parentFolderPaths) {
            allFiles.addAll(this.pur.getDeletedFiles(parentFolderPath, mergedFilterBuf.toString()));
        }
        Collections.sort(allFiles);
        return allFiles;
    }

    public String[] getDatabaseNames(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.DATABASE, includeDeleted);
            ArrayList<String> names = new ArrayList<String>(children.size());
            for (RepositoryFile file : children) {
                names.add(file.getTitle());
            }
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all database names", (Throwable)e);
        }
    }

    private void initSharedObjectAssemblerMap() {
        this.sharedObjectAssemblerMap = new EnumMap(RepositoryObjectType.class);
        this.sharedObjectAssemblerMap.put(RepositoryObjectType.DATABASE, this.databaseMetaTransformer);
        this.sharedObjectAssemblerMap.put(RepositoryObjectType.CLUSTER_SCHEMA, this.clusterTransformer);
        this.sharedObjectAssemblerMap.put(RepositoryObjectType.PARTITION_SCHEMA, this.partitionSchemaTransformer);
        this.sharedObjectAssemblerMap.put(RepositoryObjectType.SLAVE_SERVER, this.slaveTransformer);
    }

    public DatabaseDelegate getDatabaseMetaTransformer() {
        return this.databaseMetaTransformer;
    }

    public ClusterDelegate getClusterTransformer() {
        return this.clusterTransformer;
    }

    public PartitionDelegate getPartitionSchemaTransformer() {
        return this.partitionSchemaTransformer;
    }

    public void clearSharedObjectCache() {
        this.sharedObjectsByType = null;
    }

    protected void readSharedObjects(Map<RepositoryObjectType, List<? extends SharedObjectInterface>> sharedObjectsByType, RepositoryObjectType ... types) throws KettleException {
        ArrayList<RepositoryFile> allFiles = new ArrayList<RepositoryFile>();
        LinkedHashMap<RepositoryObjectType, List<RepositoryFile>> filesByType = this.getFilesByType(allFiles, types);
        try {
            List data = this.pur.getDataForReadInBatch(allFiles, NodeRepositoryFileData.class);
            List versions = this.pur.getVersionSummaryInBatch(allFiles);
            Iterator dataIter = data.iterator();
            Iterator versionsIter = versions.iterator();
            for (Map.Entry<RepositoryObjectType, List<RepositoryFile>> entry : filesByType.entrySet()) {
                SharedObjectAssembler<?> assembler = this.sharedObjectAssemblerMap.get(entry.getKey());
                if (assembler == null) {
                    throw new UnsupportedOperationException(String.format("Cannot assemble shared object of type [%s]", entry.getKey()));
                }
                Iterator<RepositoryFile> filesIter = entry.getValue().iterator();
                ArrayList sharedObjects = new ArrayList(entry.getValue().size());
                while (filesIter.hasNext()) {
                    RepositoryFile file = filesIter.next();
                    NodeRepositoryFileData repoData = (NodeRepositoryFileData)dataIter.next();
                    VersionSummary version = (VersionSummary)versionsIter.next();
                    try {
                        sharedObjects.add(assembler.assemble(file, repoData, version));
                    }
                    catch (Exception ex) {
                        this.getLog().logError("Unable to load shared objects", (Throwable)ex);
                    }
                }
                sharedObjectsByType.put(entry.getKey(), sharedObjects);
            }
        }
        catch (Exception ex) {
            throw new KettleException("Unable to load shared objects", (Throwable)ex);
        }
    }

    private LinkedHashMap<RepositoryObjectType, List<RepositoryFile>> getFilesByType(List<RepositoryFile> allFiles, RepositoryObjectType ... types) throws KettleException {
        LinkedHashMap<RepositoryObjectType, List<RepositoryFile>> filesByType = new LinkedHashMap<RepositoryObjectType, List<RepositoryFile>>();
        for (RepositoryObjectType type : types) {
            try {
                List<RepositoryFile> files = this.getAllFilesOfType(null, type, false);
                filesByType.put(type, files);
                allFiles.addAll(files);
            }
            catch (Exception ex) {
                throw new KettleException(String.format("Unable to get all files of type [%s]", type), (Throwable)ex);
            }
        }
        return filesByType;
    }

    public List<DatabaseMeta> readDatabases() throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.DATABASE, false);
            ArrayList<DatabaseMeta> dbMetas = new ArrayList<DatabaseMeta>();
            for (RepositoryFile file : children) {
                DataNode node = ((NodeRepositoryFileData)this.pur.getDataForRead(file.getId(), NodeRepositoryFileData.class)).getNode();
                DatabaseMeta databaseMeta = (DatabaseMeta)this.databaseMetaTransformer.dataNodeToElement(node);
                databaseMeta.setName(file.getTitle());
                dbMetas.add(databaseMeta);
            }
            return dbMetas;
        }
        catch (Exception e) {
            throw new KettleException("Unable to read all databases", (Throwable)e);
        }
    }

    public void deleteDatabaseMeta(String databaseName) throws KettleException {
        RepositoryFile fileToDelete = null;
        try {
            fileToDelete = this.pur.getFile(this.getPath(databaseName, null, RepositoryObjectType.DATABASE));
        }
        catch (Exception e) {
            throw new KettleException("Unable to delete database with name [" + databaseName + "]", (Throwable)e);
        }
        StringObjectId idDatabase = new StringObjectId(fileToDelete.getId().toString());
        this.permanentlyDeleteSharedObject((ObjectId)idDatabase);
        this.removeFromSharedObjectCache(RepositoryObjectType.DATABASE, (ObjectId)idDatabase);
    }

    public long getJobEntryAttributeInteger(ObjectId idJobentry, int nr, String code) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public String getJobEntryAttributeString(ObjectId idJobentry, int nr, String code) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public boolean getJobEntryAttributeBoolean(ObjectId arg0, int arg1, String arg2, boolean arg3) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public ObjectId getJobId(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        try {
            return this.getObjectId(name, repositoryDirectory, RepositoryObjectType.JOB, false);
        }
        catch (Exception e) {
            String path = repositoryDirectory != null ? repositoryDirectory.toString() : "null";
            throw new IdNotFoundException("Unable to get ID for job [" + name + "]", (Throwable)e, name, path, RepositoryObjectType.JOB);
        }
    }

    public String[] getJobNames(ObjectId idDirectory, boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(idDirectory, RepositoryObjectType.JOB, includeDeleted);
            ArrayList<String> names = new ArrayList<String>();
            for (RepositoryFile file : children) {
                names.add(file.getTitle());
            }
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all job names", (Throwable)e);
        }
    }

    public List<RepositoryElementMetaInterface> getJobObjects(ObjectId idDirectory, boolean includeDeleted) throws KettleException {
        return this.getPdiObjects(idDirectory, Arrays.asList(RepositoryObjectType.JOB), includeDeleted);
    }

    public LogChannelInterface getLog() {
        return this.log;
    }

    public String getName() {
        return this.repositoryMeta.getName();
    }

    public ObjectId getPartitionSchemaID(String name) throws KettleException {
        try {
            return this.getObjectId(name, null, RepositoryObjectType.PARTITION_SCHEMA, false);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get ID for partition schema [" + name + "]", (Throwable)e);
        }
    }

    public ObjectId[] getPartitionSchemaIDs(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.PARTITION_SCHEMA, includeDeleted);
            ArrayList<StringObjectId> ids = new ArrayList<StringObjectId>();
            for (RepositoryFile file : children) {
                ids.add(new StringObjectId(file.getId().toString()));
            }
            return ids.toArray(new ObjectId[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all partition schema IDs", (Throwable)e);
        }
    }

    public String[] getPartitionSchemaNames(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.PARTITION_SCHEMA, includeDeleted);
            ArrayList<String> names = new ArrayList<String>();
            for (RepositoryFile file : children) {
                names.add(file.getTitle());
            }
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all partition schema names", (Throwable)e);
        }
    }

    public RepositoryMeta getRepositoryMeta() {
        return this.repositoryMeta;
    }

    public RepositorySecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public RepositorySecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public ObjectId getSlaveID(String name) throws KettleException {
        try {
            return this.getObjectId(name, null, RepositoryObjectType.SLAVE_SERVER, false);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get ID for slave server with name [" + name + "]", (Throwable)e);
        }
    }

    public ObjectId[] getSlaveIDs(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.SLAVE_SERVER, includeDeleted);
            ArrayList<StringObjectId> ids = new ArrayList<StringObjectId>();
            for (RepositoryFile file : children) {
                ids.add(new StringObjectId(file.getId().toString()));
            }
            return ids.toArray(new ObjectId[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all slave server IDs", (Throwable)e);
        }
    }

    public String[] getSlaveNames(boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(null, RepositoryObjectType.SLAVE_SERVER, includeDeleted);
            ArrayList<String> names = new ArrayList<String>();
            for (RepositoryFile file : children) {
                names.add(file.getTitle());
            }
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all slave server names", (Throwable)e);
        }
    }

    public List<SlaveServer> getSlaveServers() throws KettleException {
        return this.loadAndCacheSharedObjects(true).get(RepositoryObjectType.SLAVE_SERVER);
    }

    public SlaveDelegate getSlaveTransformer() {
        return this.slaveTransformer;
    }

    public boolean getStepAttributeBoolean(ObjectId idStep, int nr, String code, boolean def) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public long getStepAttributeInteger(ObjectId idStep, int nr, String code) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public String getStepAttributeString(ObjectId idStep, int nr, String code) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public ObjectId getTransformationID(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        try {
            return this.getObjectId(name, repositoryDirectory, RepositoryObjectType.TRANSFORMATION, false);
        }
        catch (Exception e) {
            String path = repositoryDirectory != null ? repositoryDirectory.toString() : "null";
            throw new IdNotFoundException("Unable to get ID for job [" + name + "]", (Throwable)e, name, path, RepositoryObjectType.TRANSFORMATION);
        }
    }

    public String[] getTransformationNames(ObjectId idDirectory, boolean includeDeleted) throws KettleException {
        try {
            List<RepositoryFile> children = this.getAllFilesOfType(idDirectory, RepositoryObjectType.TRANSFORMATION, includeDeleted);
            ArrayList<String> names = new ArrayList<String>();
            for (RepositoryFile file : children) {
                names.add(file.getTitle());
            }
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get all transformation names", (Throwable)e);
        }
    }

    public List<RepositoryElementMetaInterface> getTransformationObjects(ObjectId idDirectory, boolean includeDeleted) throws KettleException {
        return this.getPdiObjects(idDirectory, Arrays.asList(RepositoryObjectType.TRANSFORMATION), includeDeleted);
    }

    protected List<RepositoryElementMetaInterface> getPdiObjects(ObjectId dirId, List<RepositoryObjectType> objectTypes, boolean includeDeleted) throws KettleException {
        try {
            RepositoryDirectoryInterface repDir = this.getRootDir().findDirectory(dirId);
            ArrayList<RepositoryElementMetaInterface> list = new ArrayList<RepositoryElementMetaInterface>();
            List<RepositoryFile> nonDeletedChildren = this.getAllFilesOfType(dirId, objectTypes);
            for (RepositoryFile file : nonDeletedChildren) {
                RepositoryLock lock = this.unifiedRepositoryLockService.getLock(file);
                RepositoryObjectType objectType = PurRepository.getObjectType(file.getName());
                list.add(new EERepositoryObject(file, repDir, null, objectType, null, lock, false));
            }
            if (includeDeleted) {
                String dirPath = null;
                if (dirId != null) {
                    dirPath = this.pur.getFileById((Serializable)((Object)dirId.getId())).getPath();
                }
                List<RepositoryFile> deletedChildren = this.getAllDeletedFilesOfType(dirPath, objectTypes);
                for (RepositoryFile file : deletedChildren) {
                    RepositoryLock lock = this.unifiedRepositoryLockService.getLock(file);
                    RepositoryObjectType objectType = PurRepository.getObjectType(file.getName());
                    list.add(new EERepositoryObject(file, repDir, null, objectType, null, lock, true));
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new KettleException("Unable to get list of objects from directory [" + dirId + "]", (Throwable)e);
        }
    }

    public static RepositoryObjectType getObjectType(String filename) throws KettleException {
        if (filename.endsWith(RepositoryObjectType.TRANSFORMATION.getExtension())) {
            return RepositoryObjectType.TRANSFORMATION;
        }
        if (filename.endsWith(RepositoryObjectType.JOB.getExtension())) {
            return RepositoryObjectType.JOB;
        }
        if (filename.endsWith(RepositoryObjectType.DATABASE.getExtension())) {
            return RepositoryObjectType.DATABASE;
        }
        if (filename.endsWith(RepositoryObjectType.SLAVE_SERVER.getExtension())) {
            return RepositoryObjectType.SLAVE_SERVER;
        }
        if (filename.endsWith(RepositoryObjectType.CLUSTER_SCHEMA.getExtension())) {
            return RepositoryObjectType.CLUSTER_SCHEMA;
        }
        if (filename.endsWith(RepositoryObjectType.PARTITION_SCHEMA.getExtension())) {
            return RepositoryObjectType.PARTITION_SCHEMA;
        }
        return RepositoryObjectType.UNKNOWN;
    }

    public IUser getUserInfo() {
        return this.user;
    }

    public String getVersion() {
        return REPOSITORY_VERSION;
    }

    public void insertJobEntryDatabase(ObjectId idJob, ObjectId idJobentry, ObjectId idDatabase) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public ObjectId insertLogEntry(String description) throws KettleException {
        return null;
    }

    public void insertStepDatabase(ObjectId idTransformation, ObjectId idStep, ObjectId idDatabase) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public ClusterSchema loadClusterSchema(ObjectId idClusterSchema, List<SlaveServer> slaveServers, String versionId) throws KettleException {
        try {
            NodeRepositoryFileData data = (NodeRepositoryFileData)this.pur.getDataAtVersionForRead((Serializable)((Object)idClusterSchema.getId()), (Serializable)((Object)versionId), NodeRepositoryFileData.class);
            RepositoryFile file = null;
            file = versionId != null ? this.pur.getFileAtVersion((Serializable)((Object)idClusterSchema.getId()), (Serializable)((Object)versionId)) : this.pur.getFileById((Serializable)((Object)idClusterSchema.getId()));
            return this.clusterTransformer.assemble(file, data, this.pur.getVersionSummary((Serializable)((Object)idClusterSchema.getId()), (Serializable)((Object)versionId)));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load cluster schema with id [" + idClusterSchema + "]", (Throwable)e);
        }
    }

    public Condition loadConditionFromStepAttribute(ObjectId idStep, String code) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public DatabaseMeta loadDatabaseMetaFromJobEntryAttribute(ObjectId idJobentry, String nameCode, int nr, String idCode, List<DatabaseMeta> databases) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public DatabaseMeta loadDatabaseMetaFromStepAttribute(ObjectId idStep, String code, List<DatabaseMeta> databases) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public PartitionSchema loadPartitionSchema(ObjectId partitionSchemaId, String versionId) throws KettleException {
        try {
            NodeRepositoryFileData data = (NodeRepositoryFileData)this.pur.getDataAtVersionForRead((Serializable)((Object)partitionSchemaId.getId()), (Serializable)((Object)versionId), NodeRepositoryFileData.class);
            RepositoryFile file = null;
            file = versionId != null ? this.pur.getFileAtVersion((Serializable)((Object)partitionSchemaId.getId()), (Serializable)((Object)versionId)) : this.pur.getFileById((Serializable)((Object)partitionSchemaId.getId()));
            return this.partitionSchemaTransformer.assemble(file, data, this.pur.getVersionSummary((Serializable)((Object)partitionSchemaId.getId()), (Serializable)((Object)versionId)));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load partition schema with id [" + partitionSchemaId + "]", (Throwable)e);
        }
    }

    public SlaveServer loadSlaveServer(ObjectId idSlaveServer, String versionId) throws KettleException {
        try {
            NodeRepositoryFileData data = (NodeRepositoryFileData)this.pur.getDataAtVersionForRead((Serializable)((Object)idSlaveServer.getId()), (Serializable)((Object)versionId), NodeRepositoryFileData.class);
            RepositoryFile file = null;
            file = versionId != null ? this.pur.getFileAtVersion((Serializable)((Object)idSlaveServer.getId()), (Serializable)((Object)versionId)) : this.pur.getFileById((Serializable)((Object)idSlaveServer.getId()));
            return this.slaveTransformer.assemble(file, data, this.pur.getVersionSummary((Serializable)((Object)idSlaveServer.getId()), (Serializable)((Object)versionId)));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load slave server with id [" + idSlaveServer + "]", (Throwable)e);
        }
    }

    protected Map<RepositoryObjectType, List<? extends SharedObjectInterface>> loadAndCacheSharedObjects(boolean deepCopy) throws KettleException {
        if (this.sharedObjectsByType == null) {
            try {
                this.sharedObjectsByType = new EnumMap<RepositoryObjectType, List<? extends SharedObjectInterface>>(RepositoryObjectType.class);
                this.readSharedObjects(this.sharedObjectsByType, RepositoryObjectType.DATABASE, RepositoryObjectType.PARTITION_SCHEMA, RepositoryObjectType.SLAVE_SERVER, RepositoryObjectType.CLUSTER_SCHEMA);
            }
            catch (Exception e) {
                this.sharedObjectsByType = null;
                throw new KettleException("Unable to read shared objects from repository", (Throwable)e);
            }
        }
        return deepCopy ? this.deepCopy(this.sharedObjectsByType) : this.sharedObjectsByType;
    }

    protected Map<RepositoryObjectType, List<? extends SharedObjectInterface>> loadAndCacheSharedObjects() throws KettleException {
        return this.loadAndCacheSharedObjects(true);
    }

    private Map<RepositoryObjectType, List<? extends SharedObjectInterface>> deepCopy(Map<RepositoryObjectType, List<? extends SharedObjectInterface>> orig) throws KettleException {
        EnumMap<RepositoryObjectType, List<? extends SharedObjectInterface>> copy = new EnumMap<RepositoryObjectType, List<? extends SharedObjectInterface>>(RepositoryObjectType.class);
        for (Map.Entry<RepositoryObjectType, List<? extends SharedObjectInterface>> entry : orig.entrySet()) {
            RepositoryObjectType type = entry.getKey();
            List<? extends SharedObjectInterface> value = entry.getValue();
            ArrayList<DatabaseMeta> newValue = new ArrayList<DatabaseMeta>(value.size());
            for (SharedObjectInterface sharedObjectInterface : value) {
                DatabaseMeta newValueItem;
                if (sharedObjectInterface instanceof DatabaseMeta) {
                    DatabaseMeta databaseMeta = (DatabaseMeta)((DatabaseMeta)sharedObjectInterface).clone();
                    databaseMeta.setObjectId(((DatabaseMeta)sharedObjectInterface).getObjectId());
                    databaseMeta.clearChanged();
                    newValueItem = databaseMeta;
                } else if (sharedObjectInterface instanceof SlaveServer) {
                    SlaveServer slaveServer = (SlaveServer)((SlaveServer)sharedObjectInterface).clone();
                    slaveServer.setObjectId(((SlaveServer)sharedObjectInterface).getObjectId());
                    slaveServer.clearChanged();
                    newValueItem = slaveServer;
                } else if (sharedObjectInterface instanceof PartitionSchema) {
                    PartitionSchema partitionSchema = (PartitionSchema)((PartitionSchema)sharedObjectInterface).clone();
                    partitionSchema.setObjectId(((PartitionSchema)sharedObjectInterface).getObjectId());
                    partitionSchema.clearChanged();
                    newValueItem = partitionSchema;
                } else if (sharedObjectInterface instanceof ClusterSchema) {
                    ClusterSchema clusterSchema = ((ClusterSchema)sharedObjectInterface).clone();
                    clusterSchema.setObjectId(((ClusterSchema)sharedObjectInterface).getObjectId());
                    clusterSchema.clearChanged();
                    newValueItem = clusterSchema;
                } else {
                    throw new KettleException("unknown shared object class");
                }
                newValue.add(newValueItem);
            }
            copy.put(type, newValue);
        }
        return copy;
    }

    public SharedObjects readJobMetaSharedObjects(JobMeta jobMeta) throws KettleException {
        return this.jobDelegate.loadSharedObjects((RepositoryElementInterface)jobMeta, this.loadAndCacheSharedObjects(true));
    }

    public SharedObjects readTransSharedObjects(TransMeta transMeta) throws KettleException {
        return this.transDelegate.loadSharedObjects((RepositoryElementInterface)transMeta, this.loadAndCacheSharedObjects(true));
    }

    public ObjectId renameJob(ObjectId idJob, RepositoryDirectoryInterface newDirectory, String newName) throws KettleException {
        return this.renameJob(idJob, null, newDirectory, newName);
    }

    public ObjectId renameJob(ObjectId idJobForRename, String versionComment, RepositoryDirectoryInterface newDirectory, String newJobName) throws KettleException {
        return this.renameTransOrJob(idJobForRename, versionComment, newDirectory, newJobName, RepositoryObjectType.JOB, "PurRepository.ERROR_0006_UNABLE_TO_RENAME_JOB");
    }

    public ObjectId renameTransformation(ObjectId idTransformation, RepositoryDirectoryInterface newDirectory, String newName) throws KettleException {
        return this.renameTransformation(idTransformation, null, newDirectory, newName);
    }

    public ObjectId renameTransformation(ObjectId idTransForRename, String versionComment, RepositoryDirectoryInterface newDirectory, String newTransName) throws KettleException {
        return this.renameTransOrJob(idTransForRename, versionComment, newDirectory, newTransName, RepositoryObjectType.TRANSFORMATION, "PurRepository.ERROR_0006_UNABLE_TO_RENAME_TRANS");
    }

    private ObjectId renameTransOrJob(ObjectId idObject, String versionComment, RepositoryDirectoryInterface newDirectory, String newTitle, RepositoryObjectType objectType, String errorMsgKey) throws KettleException {
        String fullName;
        RepositoryFile file = this.pur.getFileById((Serializable)((Object)idObject.getId()));
        RepositoryFile.Builder builder = new RepositoryFile.Builder(file);
        if (newTitle == null) {
            fullName = file.getName();
        } else {
            builder.title("default", newTitle).createdDate(null);
            fullName = PurRepository.checkAndSanitize(newTitle) + objectType.getExtension();
        }
        String absPath = this.calcDestAbsPath(file, newDirectory, fullName);
        RepositoryFile fileFromDestination = this.pur.getFile(absPath);
        if (fileFromDestination == null) {
            file = builder.build();
            NodeRepositoryFileData data = (NodeRepositoryFileData)this.pur.getDataAtVersionForRead(file.getId(), null, NodeRepositoryFileData.class);
            if (newTitle != null) {
                this.pur.updateFile(file, (IRepositoryFileData)data, versionComment);
            }
            this.pur.moveFile((Serializable)((Object)idObject.getId()), absPath, null);
            this.rootRef.clearRef();
            return idObject;
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)errorMsgKey, (String[])new String[]{file.getName(), newTitle}));
    }

    protected String getParentPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if ("/".equals(path)) {
            return null;
        }
        int lastSlashIndex = path.lastIndexOf("/");
        if (lastSlashIndex == 0) {
            return "/";
        }
        if (lastSlashIndex > 0) {
            return path.substring(0, lastSlashIndex);
        }
        throw new IllegalArgumentException();
    }

    protected String calcDestAbsPath(RepositoryFile existingFile, RepositoryDirectoryInterface newDirectory, String newName) {
        String newDirectoryPath = this.getPath(null, newDirectory, null);
        StringBuilder buf = new StringBuilder(existingFile.getPath().length());
        if (newDirectory != null) {
            buf.append(newDirectoryPath);
        } else {
            buf.append(this.getParentPath(existingFile.getPath()));
        }
        return buf.append("/").append(newName).toString();
    }

    public void save(RepositoryElementInterface element, String versionComment, ProgressMonitorListener monitor, boolean overwriteAssociated) throws KettleException {
        this.save(element, versionComment, Calendar.getInstance(), monitor, overwriteAssociated);
    }

    public void save(RepositoryElementInterface element, String versionComment, Calendar versionDate, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
        try {
            switch (element.getRepositoryElementType()) {
                case TRANSFORMATION: {
                    this.saveTrans(element, versionComment, versionDate);
                    break;
                }
                case JOB: {
                    this.saveJob(element, versionComment, versionDate);
                    break;
                }
                case DATABASE: {
                    this.saveDatabaseMeta(element, versionComment, versionDate);
                    break;
                }
                case SLAVE_SERVER: {
                    this.saveSlaveServer(element, versionComment, versionDate);
                    break;
                }
                case CLUSTER_SCHEMA: {
                    this.saveClusterSchema(element, versionComment, versionDate);
                    break;
                }
                case PARTITION_SCHEMA: {
                    this.savePartitionSchema(element, versionComment, versionDate);
                    break;
                }
                default: {
                    throw new KettleException("It's not possible to save Class [" + element.getClass().getName() + "] to the repository");
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save repository element [" + element + "]", (Throwable)e);
        }
    }

    private boolean isRenamed(RepositoryElementInterface element, RepositoryFile file) throws KettleException {
        if (element.getObjectId() == null) {
            return false;
        }
        String filename = element.getName();
        switch (element.getRepositoryElementType()) {
            case TRANSFORMATION: {
                filename = filename + RepositoryObjectType.TRANSFORMATION.getExtension();
                break;
            }
            case JOB: {
                filename = filename + RepositoryObjectType.JOB.getExtension();
                break;
            }
            case DATABASE: {
                filename = filename + RepositoryObjectType.DATABASE.getExtension();
                break;
            }
            case SLAVE_SERVER: {
                filename = filename + RepositoryObjectType.SLAVE_SERVER.getExtension();
                break;
            }
            case CLUSTER_SCHEMA: {
                filename = filename + RepositoryObjectType.CLUSTER_SCHEMA.getExtension();
                break;
            }
            case PARTITION_SCHEMA: {
                filename = filename + RepositoryObjectType.PARTITION_SCHEMA.getExtension();
                break;
            }
            default: {
                throw new KettleException("unknown element type [" + element.getClass().getName() + "]");
            }
        }
        return !file.getName().equals(PurRepository.checkAndSanitize(filename));
    }

    private void renameIfNecessary(RepositoryElementInterface element, RepositoryFile file) throws KettleException {
        if (!this.isRenamed(element, file)) {
            return;
        }
        StringBuilder buf = new StringBuilder(file.getPath().length());
        buf.append(this.getParentPath(file.getPath()));
        buf.append("/");
        buf.append(PurRepository.checkAndSanitize(element.getName()));
        switch (element.getRepositoryElementType()) {
            case DATABASE: {
                buf.append(RepositoryObjectType.DATABASE.getExtension());
                break;
            }
            case SLAVE_SERVER: {
                buf.append(RepositoryObjectType.SLAVE_SERVER.getExtension());
                break;
            }
            case CLUSTER_SCHEMA: {
                buf.append(RepositoryObjectType.CLUSTER_SCHEMA.getExtension());
                break;
            }
            case PARTITION_SCHEMA: {
                buf.append(RepositoryObjectType.PARTITION_SCHEMA.getExtension());
                break;
            }
            default: {
                throw new KettleException("It's not possible to rename Class [" + element.getClass().getName() + "] to the repository");
            }
        }
        this.pur.moveFile(file.getId(), buf.toString(), null);
    }

    @Deprecated
    protected void saveJob0(RepositoryElementInterface element, String versionComment, boolean saveSharedObjects, boolean checkLock, boolean checkRename, boolean loadRevision, boolean checkDeleted) throws KettleException {
        this.saveTransOrJob(this.jobDelegate, element, versionComment, null, saveSharedObjects, checkLock, checkRename, loadRevision, checkDeleted);
    }

    protected void saveJob(RepositoryElementInterface element, String versionComment, Calendar versionDate) throws KettleException {
        this.saveKettleEntity(element, versionComment, versionDate, true, true, true, true, true);
    }

    @Deprecated
    protected void saveTrans0(RepositoryElementInterface element, String versionComment, Calendar versionDate, boolean saveSharedObjects, boolean checkLock, boolean checkRename, boolean loadRevision, boolean checkDeleted) throws KettleException {
        this.saveTransOrJob(this.transDelegate, element, versionComment, versionDate, saveSharedObjects, checkLock, checkRename, loadRevision, checkDeleted);
    }

    protected boolean isDeleted(RepositoryFile file) {
        return this.isInTrash(file);
    }

    protected boolean isInTrash(RepositoryFile file) {
        return file.getPath().contains("/.trash/");
    }

    protected void saveTrans(RepositoryElementInterface element, String versionComment, Calendar versionDate) throws KettleException {
        this.saveKettleEntity(element, versionComment, versionDate, true, true, true, true, true);
    }

    protected void saveDatabaseMeta(RepositoryElementInterface element, String versionComment, Calendar versionDate) throws KettleException {
        block6: {
            try {
                if (element.getObjectId() == null) {
                    element.setObjectId(this.getDatabaseID(element.getName()));
                }
                boolean isUpdate = element.getObjectId() != null;
                RepositoryFile file = null;
                if (isUpdate) {
                    file = this.pur.getFileById((Serializable)((Object)element.getObjectId().getId()));
                    String title = ((DatabaseMeta)element).getDisplayName();
                    file = new RepositoryFile.Builder(file).title("default", title).build();
                    this.renameIfNecessary(element, file);
                    file = this.pur.updateFile(file, (IRepositoryFileData)new NodeRepositoryFileData(this.databaseMetaTransformer.elementToDataNode(element)), versionComment);
                } else {
                    file = new RepositoryFile.Builder(PurRepository.checkAndSanitize(RepositoryFilenameUtils.escape((String)element.getName(), (List)this.pur.getReservedChars()) + RepositoryObjectType.DATABASE.getExtension())).title("default", element.getName()).versioned(true).build();
                    file = this.pur.createFile(this.getDatabaseMetaParentFolderId(), file, (IRepositoryFileData)new NodeRepositoryFileData(this.databaseMetaTransformer.elementToDataNode(element)), versionComment);
                }
                StringObjectId objectId = new StringObjectId(file.getId().toString());
                element.setObjectId((ObjectId)objectId);
                element.setObjectRevision(this.getObjectRevision((ObjectId)objectId, null));
                if (element instanceof ChangedFlagInterface) {
                    ((ChangedFlagInterface)element).clearChanged();
                }
                this.updateSharedObjectCache(element);
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("access denied") < 0) break block6;
                throw new KettleException(BaseMessages.getString(PKG, (String)"PurRepository.ERROR_0004_DATABASE_UPDATE_ACCESS_DENIED", (String[])new String[]{element.getName()}), (Throwable)e);
            }
        }
    }

    public DatabaseMeta loadDatabaseMeta(ObjectId databaseId, String versionId) throws KettleException {
        try {
            NodeRepositoryFileData data = (NodeRepositoryFileData)this.pur.getDataAtVersionForRead((Serializable)((Object)databaseId.getId()), (Serializable)((Object)versionId), NodeRepositoryFileData.class);
            RepositoryFile file = null;
            file = versionId != null ? this.pur.getFileAtVersion((Serializable)((Object)databaseId.getId()), (Serializable)((Object)versionId)) : this.pur.getFileById((Serializable)((Object)databaseId.getId()));
            return this.databaseMetaTransformer.assemble(file, data, this.pur.getVersionSummary((Serializable)((Object)databaseId.getId()), (Serializable)((Object)versionId)));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load database with id [" + databaseId + "]", (Throwable)e);
        }
    }

    public TransMeta loadTransformation(String transName, RepositoryDirectoryInterface parentDir, ProgressMonitorListener monitor, boolean setInternalVariables, String versionId) throws KettleException {
        String absPath = null;
        try {
            absPath = this.getPath(transName, parentDir, RepositoryObjectType.TRANSFORMATION);
            if (absPath == null) {
                throw new KettleFileException(BaseMessages.getString(PKG, (String)"PurRepository.ERROR_0002_TRANSFORMATION_NOT_FOUND", (String[])new String[]{transName}));
            }
            RepositoryFile file = this.pur.getFile(absPath);
            if (versionId != null) {
                file = this.pur.getFileAtVersion(file.getId(), (Serializable)((Object)versionId));
            }
            NodeRepositoryFileData data = null;
            ObjectRevision revision = null;
            data = (NodeRepositoryFileData)this.pur.getDataAtVersionForRead(file.getId(), (Serializable)((Object)versionId), NodeRepositoryFileData.class);
            revision = this.getObjectRevision((ObjectId)new StringObjectId(file.getId().toString()), versionId);
            TransMeta transMeta = this.buildTransMeta(file, parentDir, data, revision);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationMetaLoaded.id, (Object)transMeta);
            return transMeta;
        }
        catch (Exception e) {
            throw new KettleException("Unable to load transformation from path [" + absPath + "]", (Throwable)e);
        }
    }

    private TransMeta buildTransMeta(RepositoryFile file, RepositoryDirectoryInterface parentDir, NodeRepositoryFileData data, ObjectRevision revision) throws KettleException {
        TransMeta transMeta = new TransMeta();
        transMeta.setName(file.getTitle());
        transMeta.setDescription(file.getDescription());
        transMeta.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
        transMeta.setObjectRevision(revision);
        transMeta.setRepository((Repository)this);
        transMeta.setRepositoryDirectory(parentDir);
        transMeta.setMetaStore(this.getMetaStore());
        this.readTransSharedObjects(transMeta);
        this.transDelegate.dataNodeToElement(data.getNode(), (RepositoryElementInterface)transMeta);
        transMeta.clearChanged();
        return transMeta;
    }

    protected List<TransMeta> loadTransformations(ProgressMonitorListener monitor, LogChannelInterface log, List<RepositoryFile> files, boolean setInternalVariables) throws KettleException {
        ArrayList<TransMeta> transformations = new ArrayList<TransMeta>(files.size());
        List filesData = this.pur.getDataForReadInBatch(files, NodeRepositoryFileData.class);
        List versions = this.pur.getVersionSummaryInBatch(files);
        Iterator<RepositoryFile> filesIter = files.iterator();
        Iterator filesDataIter = filesData.iterator();
        Iterator versionsIter = versions.iterator();
        while ((monitor == null || !monitor.isCanceled()) && filesIter.hasNext()) {
            RepositoryFile file = filesIter.next();
            NodeRepositoryFileData fileData = (NodeRepositoryFileData)filesDataIter.next();
            VersionSummary version = (VersionSummary)versionsIter.next();
            String dirPath = file.getPath().substring(0, file.getPath().lastIndexOf("/"));
            try {
                log.logDetailed("Loading/Exporting transformation [{0} : {1}]  ({2})", new Object[]{dirPath, file.getTitle(), file.getPath()});
                if (monitor != null) {
                    monitor.subTask("Exporting transformation [" + file.getPath() + "]");
                }
                TransMeta transMeta = this.buildTransMeta(file, this.findDirectory(dirPath), fileData, this.createObjectRevision(version));
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)log, (String)KettleExtensionPoint.TransformationMetaLoaded.id, (Object)transMeta);
                transformations.add(transMeta);
            }
            catch (Exception ex) {
                log.logDetailed("Unable to load transformation [" + file.getPath() + "]", new Object[]{ex});
                log.logError("An error occurred reading transformation [" + file.getTitle() + "] from directory [" + dirPath + "] : " + ex.getMessage());
                log.logError("Transformation [" + file.getTitle() + "] from directory [" + dirPath + "] was not exported because of a loading error!");
            }
        }
        return transformations;
    }

    public JobMeta loadJob(String jobname, RepositoryDirectoryInterface parentDir, ProgressMonitorListener monitor, String versionId) throws KettleException {
        String absPath = null;
        try {
            absPath = this.getPath(jobname, parentDir, RepositoryObjectType.JOB);
            if (absPath == null) {
                throw new KettleFileException(BaseMessages.getString(PKG, (String)"PurRepository.ERROR_0003_JOB_NOT_FOUND", (String[])new String[]{jobname}));
            }
            RepositoryFile file = this.pur.getFile(absPath);
            if (versionId != null) {
                file = this.pur.getFileAtVersion(file.getId(), (Serializable)((Object)versionId));
            }
            NodeRepositoryFileData data = null;
            ObjectRevision revision = null;
            data = (NodeRepositoryFileData)this.pur.getDataAtVersionForRead(file.getId(), (Serializable)((Object)versionId), NodeRepositoryFileData.class);
            revision = this.getObjectRevision((ObjectId)new StringObjectId(file.getId().toString()), versionId);
            JobMeta jobMeta = this.buildJobMeta(file, parentDir, data, revision);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobMetaLoaded.id, (Object)jobMeta);
            return jobMeta;
        }
        catch (Exception e) {
            throw new KettleException("Unable to load transformation from path [" + absPath + "]", (Throwable)e);
        }
    }

    private JobMeta buildJobMeta(RepositoryFile file, RepositoryDirectoryInterface parentDir, NodeRepositoryFileData data, ObjectRevision revision) throws KettleException {
        JobMeta jobMeta = new JobMeta();
        jobMeta.setName(file.getTitle());
        jobMeta.setDescription(file.getDescription());
        jobMeta.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
        jobMeta.setObjectRevision(revision);
        jobMeta.setRepository((Repository)this);
        jobMeta.setRepositoryDirectory(parentDir);
        jobMeta.setMetaStore(this.getMetaStore());
        this.readJobMetaSharedObjects(jobMeta);
        this.jobDelegate.dataNodeToElement(data.getNode(), (RepositoryElementInterface)jobMeta);
        jobMeta.clearChanged();
        return jobMeta;
    }

    protected List<JobMeta> loadJobs(ProgressMonitorListener monitor, LogChannelInterface log, List<RepositoryFile> files, boolean setInternalVariables) throws KettleException {
        ArrayList<JobMeta> jobs = new ArrayList<JobMeta>(files.size());
        List filesData = this.pur.getDataForReadInBatch(files, NodeRepositoryFileData.class);
        List versions = this.pur.getVersionSummaryInBatch(files);
        Iterator<RepositoryFile> filesIter = files.iterator();
        Iterator filesDataIter = filesData.iterator();
        Iterator versionsIter = versions.iterator();
        while ((monitor == null || !monitor.isCanceled()) && filesIter.hasNext()) {
            RepositoryFile file = filesIter.next();
            NodeRepositoryFileData fileData = (NodeRepositoryFileData)filesDataIter.next();
            VersionSummary version = (VersionSummary)versionsIter.next();
            try {
                String dirPath = file.getPath().substring(0, file.getPath().lastIndexOf("/"));
                log.logDetailed("Loading/Exporting job [{0} : {1}]  ({2})", new Object[]{dirPath, file.getTitle(), file.getPath()});
                if (monitor != null) {
                    monitor.subTask("Exporting job [" + file.getPath() + "]");
                }
                JobMeta jobMeta = this.buildJobMeta(file, this.findDirectory(dirPath), fileData, this.createObjectRevision(version));
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)log, (String)KettleExtensionPoint.JobMetaLoaded.id, (Object)jobMeta);
                jobs.add(jobMeta);
            }
            catch (Exception ex) {
                log.logError("Unable to load job [" + file.getPath() + "]", (Throwable)ex);
            }
        }
        return jobs;
    }

    protected static String checkAndSanitize(String in) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        String extension = null;
        if (in.endsWith(RepositoryObjectType.CLUSTER_SCHEMA.getExtension())) {
            extension = RepositoryObjectType.CLUSTER_SCHEMA.getExtension();
        } else if (in.endsWith(RepositoryObjectType.DATABASE.getExtension())) {
            extension = RepositoryObjectType.DATABASE.getExtension();
        } else if (in.endsWith(RepositoryObjectType.JOB.getExtension())) {
            extension = RepositoryObjectType.JOB.getExtension();
        } else if (in.endsWith(RepositoryObjectType.PARTITION_SCHEMA.getExtension())) {
            extension = RepositoryObjectType.PARTITION_SCHEMA.getExtension();
        } else if (in.endsWith(RepositoryObjectType.SLAVE_SERVER.getExtension())) {
            extension = RepositoryObjectType.SLAVE_SERVER.getExtension();
        } else if (in.endsWith(RepositoryObjectType.TRANSFORMATION.getExtension())) {
            extension = RepositoryObjectType.TRANSFORMATION.getExtension();
        }
        String out = in;
        if (extension != null) {
            out = out.substring(0, out.length() - extension.length());
        }
        if (out.contains("/") || out.equals("..") || out.equals(".") || StringUtils.isBlank((String)out)) {
            throw new IllegalArgumentException();
        }
        if (System.getProperty("KETTLE_COMPATIBILITY_PUR_OLD_NAMING_MODE", "N").equals("Y")) {
            out = out.replaceAll("[/:\\[\\]\\*'\"\\|\\s\\.]", "_");
        }
        if (extension != null) {
            return out + extension;
        }
        return out;
    }

    protected void saveRepositoryElement(RepositoryElementInterface element, String versionComment, ITransformer transformer, Serializable elementsFolderId) throws KettleException {
        RepositoryFile file;
        boolean isUpdate;
        boolean bl = isUpdate = element.getObjectId() != null;
        if (isUpdate) {
            file = this.pur.getFileById((Serializable)((Object)element.getObjectId().getId()));
            file = new RepositoryFile.Builder(file).title("default", element.getName()).description("default", Const.NVL((String)element.getDescription(), (String)"")).build();
            this.renameIfNecessary(element, file);
            file = this.pur.updateFile(file, (IRepositoryFileData)new NodeRepositoryFileData(transformer.elementToDataNode(element)), versionComment);
        } else {
            file = new RepositoryFile.Builder(PurRepository.checkAndSanitize(element.getName() + element.getRepositoryElementType().getExtension())).title("default", element.getName()).description("default", Const.NVL((String)element.getDescription(), (String)"")).versioned(true).build();
            file = this.pur.createFile(elementsFolderId, file, (IRepositoryFileData)new NodeRepositoryFileData(transformer.elementToDataNode(element)), versionComment);
        }
        StringObjectId objectId = new StringObjectId(file.getId().toString());
        element.setObjectId((ObjectId)objectId);
        element.setObjectRevision(this.getObjectRevision((ObjectId)objectId, null));
        if (element instanceof ChangedFlagInterface) {
            ((ChangedFlagInterface)element).clearChanged();
        }
        this.updateSharedObjectCache(element);
    }

    protected void savePartitionSchema(RepositoryElementInterface element, String versionComment, Calendar versionDate) {
        try {
            if (element.getObjectId() == null) {
                element.setObjectId(this.getPartitionSchemaID(element.getName()));
            }
            this.saveRepositoryElement(element, versionComment, this.partitionSchemaTransformer, this.getPartitionSchemaParentFolderId());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
        }
    }

    protected void saveSlaveServer(RepositoryElementInterface element, String versionComment, Calendar versionDate) throws KettleException {
        try {
            if (element.getObjectId() == null) {
                element.setObjectId(this.getSlaveID(element.getName()));
            }
            this.saveRepositoryElement(element, versionComment, this.slaveTransformer, this.getSlaveServerParentFolderId());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
        }
    }

    protected void saveClusterSchema(RepositoryElementInterface element, String versionComment, Calendar versionDate) {
        try {
            if (element.getObjectId() == null) {
                element.setObjectId(this.getClusterID(element.getName()));
            }
            this.saveRepositoryElement(element, versionComment, this.clusterTransformer, this.getClusterSchemaParentFolderId());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
        }
    }

    private void updateSharedObjectCache(RepositoryElementInterface element) throws KettleException {
        this.updateSharedObjectCache(element, null, null);
    }

    private void removeFromSharedObjectCache(RepositoryObjectType type, ObjectId id) throws KettleException {
        this.updateSharedObjectCache(null, type, id);
    }

    private void updateSharedObjectCache(RepositoryElementInterface element, RepositoryObjectType type, ObjectId id) throws KettleException {
        if (element != null && (element.getObjectId() == null || element.getObjectId().getId() == null)) {
            throw new IllegalArgumentException(element.getName() + " has a null id");
        }
        this.loadAndCacheSharedObjects(false);
        boolean remove = element == null;
        ObjectId idToFind = element != null ? element.getObjectId() : id;
        RepositoryObjectType typeToUpdate = element != null ? element.getRepositoryElementType() : type;
        ClusterSchema elementToUpdate = null;
        List<? extends SharedObjectInterface> origSharedObjects = null;
        switch (typeToUpdate) {
            case DATABASE: {
                origSharedObjects = this.sharedObjectsByType.get(RepositoryObjectType.DATABASE);
                if (remove) break;
                elementToUpdate = (RepositoryElementInterface)((DatabaseMeta)element).clone();
                break;
            }
            case SLAVE_SERVER: {
                origSharedObjects = this.sharedObjectsByType.get(RepositoryObjectType.SLAVE_SERVER);
                if (remove) break;
                elementToUpdate = (RepositoryElementInterface)((SlaveServer)element).clone();
                break;
            }
            case CLUSTER_SCHEMA: {
                origSharedObjects = this.sharedObjectsByType.get(RepositoryObjectType.CLUSTER_SCHEMA);
                if (remove) break;
                elementToUpdate = ((ClusterSchema)element).clone();
                break;
            }
            case PARTITION_SCHEMA: {
                origSharedObjects = this.sharedObjectsByType.get(RepositoryObjectType.PARTITION_SCHEMA);
                if (remove) break;
                elementToUpdate = (RepositoryElementInterface)((PartitionSchema)element).clone();
                break;
            }
            default: {
                throw new KettleException("unknown type [" + typeToUpdate + "]");
            }
        }
        ArrayList<? extends SharedObjectInterface> newSharedObjects = new ArrayList<SharedObjectInterface>(origSharedObjects);
        boolean found = false;
        for (int i = 0; i < origSharedObjects.size(); ++i) {
            ObjectId objectId;
            RepositoryElementInterface repositoryElementInterface = (RepositoryElementInterface)origSharedObjects.get(i);
            if (repositoryElementInterface == null || (objectId = repositoryElementInterface.getObjectId()) == null || !objectId.equals(idToFind)) continue;
            if (remove) {
                newSharedObjects.remove(i);
            } else {
                elementToUpdate.setObjectId(idToFind);
                newSharedObjects.set(i, (SharedObjectInterface)((SharedObjectInterface)elementToUpdate));
            }
            found = true;
        }
        if (!remove && !found) {
            elementToUpdate.setObjectId(idToFind);
            newSharedObjects.add((SharedObjectInterface)((SharedObjectInterface)elementToUpdate));
        }
        this.sharedObjectsByType.put(typeToUpdate, newSharedObjects);
    }

    private ObjectRevision getObjectRevision(ObjectId elementId, String versionId) {
        return this.createObjectRevision(this.pur.getVersionSummary((Serializable)((Object)elementId.getId()), (Serializable)((Object)versionId)));
    }

    protected ObjectRevision createObjectRevision(VersionSummary versionSummary) {
        return new PurObjectRevision(versionSummary.getId(), versionSummary.getAuthor(), versionSummary.getDate(), versionSummary.getMessage());
    }

    private String getDatabaseMetaParentFolderPath() {
        return ClientRepositoryPaths.getEtcFolderPath() + "/" + FOLDER_PDI + "/" + FOLDER_DATABASES;
    }

    Serializable getDatabaseMetaParentFolderId() {
        if (this.cachedDatabaseMetaParentFolderId == null) {
            RepositoryFile f = this.pur.getFile(this.getDatabaseMetaParentFolderPath());
            this.cachedDatabaseMetaParentFolderId = f.getId();
        }
        return this.cachedDatabaseMetaParentFolderId;
    }

    private String getPartitionSchemaParentFolderPath() {
        return ClientRepositoryPaths.getEtcFolderPath() + "/" + FOLDER_PDI + "/" + FOLDER_PARTITION_SCHEMAS;
    }

    private Serializable getPartitionSchemaParentFolderId() {
        if (this.cachedPartitionSchemaParentFolderId == null) {
            RepositoryFile f = this.pur.getFile(this.getPartitionSchemaParentFolderPath());
            this.cachedPartitionSchemaParentFolderId = f.getId();
        }
        return this.cachedPartitionSchemaParentFolderId;
    }

    private String getSlaveServerParentFolderPath() {
        return ClientRepositoryPaths.getEtcFolderPath() + "/" + FOLDER_PDI + "/" + FOLDER_SLAVE_SERVERS;
    }

    private Serializable getSlaveServerParentFolderId() {
        if (this.cachedSlaveServerParentFolderId == null) {
            RepositoryFile f = this.pur.getFile(this.getSlaveServerParentFolderPath());
            this.cachedSlaveServerParentFolderId = f.getId();
        }
        return this.cachedSlaveServerParentFolderId;
    }

    private String getClusterSchemaParentFolderPath() {
        return ClientRepositoryPaths.getEtcFolderPath() + "/" + FOLDER_PDI + "/" + FOLDER_CLUSTER_SCHEMAS;
    }

    private Serializable getClusterSchemaParentFolderId() {
        if (this.cachedClusterSchemaParentFolderId == null) {
            RepositoryFile f = this.pur.getFile(this.getClusterSchemaParentFolderPath());
            this.cachedClusterSchemaParentFolderId = f.getId();
        }
        return this.cachedClusterSchemaParentFolderId;
    }

    public void saveConditionStepAttribute(ObjectId idTransformation, ObjectId idStep, String code, Condition condition) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveDatabaseMetaJobEntryAttribute(ObjectId idJob, ObjectId idJobentry, int nr, String nameCode, String idCode, DatabaseMeta database) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveDatabaseMetaStepAttribute(ObjectId idTransformation, ObjectId idStep, String code, DatabaseMeta database) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveJobEntryAttribute(ObjectId idJob, ObjectId idJobentry, int nr, String code, String value) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveJobEntryAttribute(ObjectId idJob, ObjectId idJobentry, int nr, String code, boolean value) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveJobEntryAttribute(ObjectId idJob, ObjectId idJobentry, int nr, String code, long value) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveStepAttribute(ObjectId idTransformation, ObjectId idStep, int nr, String code, String value) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveStepAttribute(ObjectId idTransformation, ObjectId idStep, int nr, String code, boolean value) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveStepAttribute(ObjectId idTransformation, ObjectId idStep, int nr, String code, long value) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void saveStepAttribute(ObjectId idTransformation, ObjectId idStep, int nr, String code, double value) throws KettleException {
        throw new UnsupportedOperationException();
    }

    public void undeleteObject(RepositoryElementMetaInterface element) throws KettleException {
        this.pur.undeleteFile((Serializable)((Object)element.getObjectId().getId()), null);
        this.rootRef.clearRef();
    }

    public List<RepositoryElementMetaInterface> getJobAndTransformationObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return this.getPdiObjects(id_directory, Arrays.asList(RepositoryObjectType.JOB, RepositoryObjectType.TRANSFORMATION), includeDeleted);
    }

    public IRepositoryService getService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return this.purRepositoryServiceRegistry.getService(clazz);
    }

    public List<Class<? extends IRepositoryService>> getServiceInterfaces() throws KettleException {
        return this.purRepositoryServiceRegistry.getRegisteredInterfaces();
    }

    public boolean hasService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return this.purRepositoryServiceRegistry.getService(clazz) != null;
    }

    public RepositoryDirectoryInterface getDefaultSaveDirectory(RepositoryElementInterface repositoryElement) throws KettleException {
        return this.getUserHomeDirectory();
    }

    public RepositoryDirectoryInterface getUserHomeDirectory() throws KettleException {
        return this.findDirectory(ClientRepositoryPaths.getUserHomeFolderPath((String)this.user.getLogin()));
    }

    public RepositoryObject getObjectInformation(ObjectId objectId, RepositoryObjectType objectType) throws KettleException {
        try {
            RepositoryFile repositoryFile;
            try {
                repositoryFile = this.pur.getFileById((Serializable)((Object)objectId.getId()));
            }
            catch (Exception e) {
                this.log.logError("Error when trying to obtain a file by id: " + objectId.getId(), (Throwable)e);
                return null;
            }
            if (repositoryFile == null) {
                return null;
            }
            RepositoryFileAcl repositoryFileAcl = this.pur.getAcl(repositoryFile.getId());
            String parentPath = this.getParentPath(repositoryFile.getPath());
            String name = repositoryFile.getTitle();
            String description = repositoryFile.getDescription();
            Date modifiedDate = repositoryFile.getLastModifiedDate();
            String ownerName = repositoryFileAcl != null ? repositoryFileAcl.getOwner().getName() : "";
            boolean deleted = this.isDeleted(repositoryFile);
            RepositoryDirectoryInterface directory = this.findDirectory(parentPath);
            return new RepositoryObject(objectId, name, directory, ownerName, modifiedDate, objectType, description, deleted);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get object information for object with id=" + objectId, (Throwable)e);
        }
    }

    public RepositoryDirectoryInterface findDirectory(String directory) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = null;
        boolean usingRootDirCache = this.rootRef.getRef() != null;
        repositoryDirectoryInterface = this.getRootDir().findDirectory(directory);
        if (repositoryDirectoryInterface == null && usingRootDirCache) {
            repositoryDirectoryInterface = this.loadRepositoryDirectoryTree().findDirectory(directory);
        }
        return repositoryDirectoryInterface;
    }

    public RepositoryDirectoryInterface findDirectory(ObjectId directory) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = null;
        boolean usingRootDirCache = this.rootRef.getRef() != null;
        repositoryDirectoryInterface = this.getRootDir().findDirectory(directory);
        if (repositoryDirectoryInterface == null && usingRootDirCache) {
            repositoryDirectoryInterface = this.loadRepositoryDirectoryTree().findDirectory(directory);
        }
        return repositoryDirectoryInterface;
    }

    public JobMeta loadJob(ObjectId idJob, String versionLabel) throws KettleException {
        try {
            RepositoryFile file = null;
            file = versionLabel != null ? this.pur.getFileAtVersion((Serializable)((Object)idJob.getId()), (Serializable)((Object)versionLabel)) : this.pur.getFileById((Serializable)((Object)idJob.getId()));
            EEJobMeta jobMeta = new EEJobMeta();
            jobMeta.setName(file.getTitle());
            jobMeta.setDescription(file.getDescription());
            jobMeta.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
            jobMeta.setObjectRevision(this.getObjectRevision((ObjectId)new StringObjectId(file.getId().toString()), versionLabel));
            jobMeta.setRepository(this);
            jobMeta.setRepositoryDirectory(this.findDirectory(this.getParentPath(file.getPath())));
            this.readJobMetaSharedObjects(jobMeta);
            jobMeta.setRepositoryLock(this.unifiedRepositoryLockService.getLock(file));
            this.jobDelegate.dataNodeToElement(((NodeRepositoryFileData)this.pur.getDataAtVersionForRead((Serializable)((Object)idJob.getId()), (Serializable)((Object)versionLabel), NodeRepositoryFileData.class)).getNode(), (RepositoryElementInterface)jobMeta);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobMetaLoaded.id, (Object)jobMeta);
            jobMeta.clearChanged();
            return jobMeta;
        }
        catch (Exception e) {
            throw new KettleException("Unable to load job with id [" + idJob + "]", (Throwable)e);
        }
    }

    public TransMeta loadTransformation(ObjectId idTransformation, String versionLabel) throws KettleException {
        try {
            RepositoryFile file = null;
            file = versionLabel != null ? this.pur.getFileAtVersion((Serializable)((Object)idTransformation.getId()), (Serializable)((Object)versionLabel)) : this.pur.getFileById((Serializable)((Object)idTransformation.getId()));
            EETransMeta transMeta = new EETransMeta();
            transMeta.setName(file.getTitle());
            transMeta.setDescription(file.getDescription());
            transMeta.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
            transMeta.setObjectRevision(this.getObjectRevision((ObjectId)new StringObjectId(file.getId().toString()), versionLabel));
            transMeta.setRepository(this);
            transMeta.setRepositoryDirectory(this.findDirectory(this.getParentPath(file.getPath())));
            transMeta.setRepositoryLock(this.unifiedRepositoryLockService.getLock(file));
            transMeta.setMetaStore(this.getMetaStore());
            this.readTransSharedObjects(transMeta);
            this.transDelegate.dataNodeToElement(((NodeRepositoryFileData)this.pur.getDataAtVersionForRead((Serializable)((Object)idTransformation.getId()), (Serializable)((Object)versionLabel), NodeRepositoryFileData.class)).getNode(), (RepositoryElementInterface)transMeta);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationMetaLoaded.id, (Object)transMeta);
            transMeta.clearChanged();
            return transMeta;
        }
        catch (Exception e) {
            throw new KettleException("Unable to load transformation with id [" + idTransformation + "]", (Throwable)e);
        }
    }

    public String getConnectMessage() {
        return this.connectMessage;
    }

    public String[] getJobsUsingDatabase(ObjectId id_database) throws KettleException {
        ArrayList<String> result = new ArrayList<String>();
        for (RepositoryFile file : this.getReferrers(id_database, Collections.singletonList(RepositoryObjectType.JOB))) {
            result.add(file.getPath());
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getTransformationsUsingDatabase(ObjectId id_database) throws KettleException {
        ArrayList<String> result = new ArrayList<String>();
        for (RepositoryFile file : this.getReferrers(id_database, Collections.singletonList(RepositoryObjectType.TRANSFORMATION))) {
            result.add(file.getPath());
        }
        return result.toArray(new String[result.size()]);
    }

    protected List<RepositoryFile> getReferrers(ObjectId fileId, List<RepositoryObjectType> referrerTypes) throws KettleException {
        ArrayList<RepositoryFile> result = new ArrayList<RepositoryFile>();
        List files = this.pur.getReferrers((Serializable)((Object)fileId.getId()));
        if (referrerTypes != null && referrerTypes.size() > 0) {
            for (RepositoryFile file : files) {
                if (!referrerTypes.contains(PurRepository.getObjectType(file.getName()))) continue;
                result.add(file);
            }
        }
        return result;
    }

    public IRepositoryExporter getExporter() throws KettleException {
        List<String> exportPerms = Arrays.asList("org.pentaho.repository.create", "org.pentaho.repository.execute");
        IAbsSecurityProvider securityProvider = this.purRepositoryServiceRegistry.getService(IAbsSecurityProvider.class);
        StringBuilder errorMessage = new StringBuilder("[");
        for (String perm : exportPerms) {
            if (securityProvider == null && PurRepositoryConnector.inProcess()) {
                return new PurRepositoryExporter(this);
            }
            if (securityProvider != null && securityProvider.isAllowed(perm)) {
                return new PurRepositoryExporter(this);
            }
            errorMessage.append(perm);
            errorMessage.append(", ");
        }
        errorMessage.setLength(errorMessage.length() - 2);
        errorMessage.append("]");
        throw new KettleSecurityException(BaseMessages.getString(PKG, (String)"PurRepository.ERROR_0005_INCORRECT_PERMISSION", (String[])new String[]{errorMessage.toString()}));
    }

    public IRepositoryImporter getImporter() {
        return new PurRepositoryImporter(this);
    }

    public IUnifiedRepository getPur() {
        return this.pur;
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public ServiceManager getServiceManager() {
        return this.purRepositoryConnector == null ? null : this.purRepositoryConnector.getServiceManager();
    }

    protected void saveKettleEntity(RepositoryElementInterface element, String versionComment, Calendar versionDate, boolean saveSharedObjects, boolean checkLock, boolean checkRename, boolean loadRevision, boolean checkDeleted) throws KettleException {
        ISharedObjectsTransformer objectTransformer;
        switch (element.getRepositoryElementType()) {
            case TRANSFORMATION: {
                objectTransformer = this.transDelegate;
                break;
            }
            case JOB: {
                objectTransformer = this.jobDelegate;
                break;
            }
            default: {
                throw new KettleException("Unknown RepositoryObjectType. Should be TRANSFORMATION or JOB ");
            }
        }
        this.saveTransOrJob(objectTransformer, element, versionComment, versionDate, saveSharedObjects, checkLock, checkRename, loadRevision, checkDeleted);
    }

    private void saveTransOrJob(ISharedObjectsTransformer objectTransformer, RepositoryElementInterface element, String versionComment, Calendar versionDate, boolean saveSharedObjects, boolean checkLock, boolean checkRename, boolean loadRevision, boolean checkDeleted) throws KettleException {
        RepositoryFile file;
        boolean isUpdate;
        if (saveSharedObjects) {
            objectTransformer.saveSharedObjects(element, versionComment);
        }
        boolean bl = isUpdate = element.getObjectId() != null;
        if (isUpdate) {
            ObjectId id = element.getObjectId();
            file = this.pur.getFileById((Serializable)((Object)id.getId()));
            if (checkLock && file.isLocked() && !this.unifiedRepositoryLockService.canUnlockFileById(id)) {
                throw new KettleException("File is currently locked by another user for editing");
            }
            if (checkDeleted && this.isInTrash(file)) {
                throw new KettleException("File is in the Trash. Use Save As.");
            }
            file = new RepositoryFile.Builder(file).title("default", element.getName()).createdDate(versionDate != null ? versionDate.getTime() : new Date()).description("default", Const.NVL((String)element.getDescription(), (String)"")).build();
            file = this.pur.updateFile(file, (IRepositoryFileData)new NodeRepositoryFileData(objectTransformer.elementToDataNode(element)), versionComment);
            if (checkRename && this.isRenamed(element, file)) {
                this.renameKettleEntity(element, null, element.getName());
            }
        } else {
            file = new RepositoryFile.Builder(PurRepository.checkAndSanitize(element.getName() + element.getRepositoryElementType().getExtension())).versioned(true).title("default", element.getName()).createdDate(versionDate != null ? versionDate.getTime() : new Date()).description("default", Const.NVL((String)element.getDescription(), (String)"")).build();
            file = this.pur.createFile((Serializable)((Object)element.getRepositoryDirectory().getObjectId().getId()), file, (IRepositoryFileData)new NodeRepositoryFileData(objectTransformer.elementToDataNode(element)), versionComment);
        }
        StringObjectId objectId = new StringObjectId(file.getId().toString());
        element.setObjectId((ObjectId)objectId);
        if (loadRevision) {
            element.setObjectRevision(this.getObjectRevision((ObjectId)objectId, null));
        }
        if (element instanceof ChangedFlagInterface) {
            ((ChangedFlagInterface)element).clearChanged();
        }
    }

    protected ObjectId renameKettleEntity(RepositoryElementInterface transOrJob, RepositoryDirectoryInterface newDirectory, String newName) throws KettleException {
        switch (transOrJob.getRepositoryElementType()) {
            case TRANSFORMATION: {
                return this.renameTransformation(transOrJob.getObjectId(), null, newDirectory, newName);
            }
            case JOB: {
                return this.renameJob(transOrJob.getObjectId(), null, newDirectory, newName);
            }
        }
        throw new KettleException("Unknown RepositoryObjectType. Should be TRANSFORMATION or JOB ");
    }

    protected static enum RepositoryServers {
        DIS,
        POBS;

    }
}

