/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.preparser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.preparser.DatumPath;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XML {
    public static boolean parseMessage(Properties props, String message, Collection msgMask) throws HL7Exception {
        boolean ret = false;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            InputSource inSrc = new InputSource(new StringReader(message));
            HL7MessageHandler handler = new HL7MessageHandler();
            Properties properties = handler.m_props = props != null ? props : new Properties();
            if (msgMask != null) {
                handler.m_msgMask = msgMask;
            } else {
                handler.m_msgMask = new Vector();
                handler.m_msgMask.add(new DatumPath());
            }
            parser.parse(inSrc, (DefaultHandler)handler);
            ret = true;
        }
        catch (ParserConfigurationException e) {
            throw new HL7Exception(e);
        }
        catch (IOException e) {
            throw new HL7Exception(e);
        }
        catch (StopParsingException e) {
            throw new HL7Exception(e);
        }
        catch (SAXException e) {
            throw new HL7Exception(e);
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            Properties props = new Properties();
            Vector<DatumPath> msgMask = new Vector<DatumPath>();
            msgMask.add(new DatumPath().add("MSH").add(0).add(9));
            try {
                boolean parseret = XML.parseMessage(props, args[0], msgMask);
                System.err.println("parseMessage returned " + parseret);
            }
            catch (HL7Exception e) {
                e.printStackTrace();
            }
            props.list(System.err);
        }
    }

    protected static class HL7MessageHandler
    extends DefaultHandler {
        public Properties m_props = null;
        public Collection m_msgMask = null;
        protected boolean m_startedDocument = false;
        StringBuffer m_msgID = new StringBuffer();
        DatumPath m_curPath = new DatumPath();
        DatumPath m_lastDumpedPath = new DatumPath();
        TreeMap m_segmentId2nextRepIdx = new TreeMap();
        int m_depthWithinUsefulElement = -1;
        int m_depthWithinUselessElement = -1;
        StringBuffer m_chars = new StringBuffer(10);

        public HL7MessageHandler() {
            this.clear();
        }

        void clear() {
            this.m_startedDocument = false;
            this.m_msgID.delete(0, this.m_msgID.length());
            this.m_curPath.clear();
            this.m_lastDumpedPath.clear().add(new String()).add(-42).add(-42).add(-42).add(-42).add(-42);
            this.m_segmentId2nextRepIdx.clear();
            this.m_depthWithinUsefulElement = -1;
            this.m_depthWithinUselessElement = -1;
            this.m_chars.delete(0, this.m_chars.length());
        }

        public void startDocument() throws SAXException {
            boolean ok = false;
            if (!this.m_startedDocument && this.m_props != null) {
                this.m_startedDocument = true;
                ok = true;
            }
            if (!ok) {
                this.clear();
                throw new StopParsingException();
            }
        }

        public void endDocument() throws SAXException {
            boolean ok = false;
            if (this.m_startedDocument) {
                this.clear();
                ok = true;
            }
            if (!ok) {
                this.clear();
                throw new StopParsingException();
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            boolean ok = false;
            if (this.m_startedDocument) {
                this.m_chars.delete(0, this.m_chars.length());
                if (this.m_depthWithinUselessElement >= 0) {
                    ++this.m_depthWithinUselessElement;
                } else {
                    int oldCurPathSize = this.m_curPath.size();
                    if (HL7MessageHandler.tryToGrowDocLocationFromElementName(this.m_msgID, this.m_curPath, this.m_segmentId2nextRepIdx, this.m_lastDumpedPath, qName)) {
                        if (this.m_curPath.size() > oldCurPathSize && this.m_depthWithinUsefulElement == -1) {
                            boolean curPathStartsWithAMaskElem = false;
                            Iterator maskIt = this.m_msgMask.iterator();
                            while (!curPathStartsWithAMaskElem && maskIt.hasNext()) {
                                curPathStartsWithAMaskElem = this.m_curPath.startsWith((DatumPath)maskIt.next());
                            }
                            if (curPathStartsWithAMaskElem) {
                                this.m_depthWithinUsefulElement = 0;
                            } else {
                                boolean aMaskElemStartsWithCurPath = false;
                                Iterator maskIt2 = this.m_msgMask.iterator();
                                while (!aMaskElemStartsWithCurPath && maskIt2.hasNext()) {
                                    aMaskElemStartsWithCurPath = ((DatumPath)maskIt2.next()).startsWith(this.m_curPath);
                                }
                                if (!aMaskElemStartsWithCurPath) {
                                    this.m_depthWithinUselessElement = 0;
                                    this.m_curPath.setSize(oldCurPathSize);
                                }
                            }
                        }
                    } else {
                        this.m_depthWithinUselessElement = 0;
                    }
                }
                ok = true;
            }
            if (!ok) {
                this.clear();
                throw new StopParsingException();
            }
        }

        protected static boolean tryToGrowDocLocationFromElementName(StringBuffer msgID, DatumPath curPath, Map segmentId2nextRepIdx, DatumPath lastDumpedPath, String elementName) {
            boolean ok = false;
            if (msgID.length() == 0 && curPath.size() == 0) {
                msgID.replace(0, msgID.length(), elementName);
                segmentId2nextRepIdx.clear();
                ok = true;
            } else if (msgID.length() > 0 && curPath.size() == 0) {
                if (!elementName.startsWith("" + msgID + '.')) {
                    curPath.add(elementName);
                    if (segmentId2nextRepIdx.containsKey(elementName)) {
                        curPath.add(segmentId2nextRepIdx.get(elementName));
                    } else {
                        curPath.add(new Integer(0));
                    }
                    segmentId2nextRepIdx.put(elementName, new Integer((Integer)curPath.get(curPath.size() - 1) + 1));
                }
                ok = true;
            } else if (msgID.length() > 0 && curPath.size() > 0) {
                if (curPath.size() == 2) {
                    if (elementName.startsWith("" + curPath.get(0) + '.')) {
                        try {
                            int fieldIdxFromElementName = Integer.parseInt(elementName.substring(elementName.indexOf(46) + 1));
                            curPath.add(new Integer(fieldIdxFromElementName));
                            if (lastDumpedPath.size() >= 4 && (Integer)lastDumpedPath.get(2) == fieldIdxFromElementName) {
                                curPath.add(new Integer((Integer)lastDumpedPath.get(3) + 1));
                            } else {
                                curPath.add(new Integer(0));
                            }
                            ok = true;
                        }
                        catch (NumberFormatException fieldIdxFromElementName) {}
                    }
                } else if (curPath.size() == 4 || curPath.size() == 5) {
                    try {
                        int idxFromElementName = Integer.parseInt(elementName.substring(elementName.indexOf(46) + 1));
                        curPath.add(new Integer(idxFromElementName));
                        ok = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return ok;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            boolean ok = false;
            if (this.m_startedDocument) {
                if (this.m_depthWithinUselessElement >= 0) {
                    --this.m_depthWithinUselessElement;
                    ok = true;
                } else {
                    if (this.m_msgID.length() > 0 && this.m_curPath.size() == 0) {
                        if (qName.compareTo("" + this.m_msgID) == 0) {
                            this.m_msgID.delete(0, this.m_msgID.length());
                        }
                        ok = true;
                    } else if (this.m_msgID.length() > 0 && this.m_curPath.size() > 0) {
                        this.tryToDumpDataToProps();
                        if (this.m_curPath.size() == 2) {
                            this.m_curPath.setSize(0);
                            ok = true;
                        } else if (this.m_curPath.size() == 4) {
                            this.m_curPath.setSize(2);
                            ok = true;
                        } else if (this.m_curPath.size() == 5 || this.m_curPath.size() == 6) {
                            this.m_curPath.setSize(this.m_curPath.size() - 1);
                            ok = true;
                        }
                    }
                    if (this.m_depthWithinUsefulElement >= 0) {
                        --this.m_depthWithinUsefulElement;
                    }
                }
            }
            if (!ok) {
                this.clear();
                throw new StopParsingException();
            }
        }

        protected void tryToDumpDataToProps() {
            if (this.m_curPath.size() >= 2 && this.m_depthWithinUselessElement == -1 && (!this.m_lastDumpedPath.get(0).equals(this.m_curPath.get(0)) || this.m_lastDumpedPath.numbersLessThan(this.m_curPath)) && this.m_depthWithinUsefulElement >= 0) {
                if (this.m_props.containsKey("" + this.m_curPath)) {
                    System.err.println("ALAAAARM: CLOBBERING PROPERTY in " + this.getClass());
                }
                this.m_props.setProperty("" + this.m_curPath, "" + this.m_chars);
                this.m_lastDumpedPath.copy(this.m_curPath);
                this.m_chars.delete(0, this.m_chars.length());
            }
        }

        public void characters(char[] chars, int start, int length) {
            if (this.m_msgID.length() > 0 && this.m_curPath.size() >= 4) {
                this.m_chars.append(chars, start, length);
            }
        }

        public void ignoreableWhitespace(char[] chars, int start, int length) {
            this.characters(chars, start, length);
        }

        public void error(SAXParseException e) {
            System.err.println("Error in " + this.getClass() + ": " + e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    protected static class StopParsingException
    extends SAXException {
        public StopParsingException() {
            super("ca.uhn.hl7.....StopParsingException");
        }
    }
}

