/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.AbstractDelegate;
import org.pentaho.di.repository.pur.AttributesMapUtil;
import org.pentaho.di.repository.pur.ISharedObjectsTransformer;
import org.pentaho.di.repository.pur.ITransformer;
import org.pentaho.di.repository.pur.PurRepositoryAttribute;
import org.pentaho.di.repository.pur.RepositoryProxy;
import org.pentaho.di.repository.pur.UnifiedRepositoryConnectionAclService;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowDistributionInterface;
import org.pentaho.di.trans.step.RowDistributionPluginType;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.missing.MissingTrans;
import org.pentaho.di.ui.repository.pur.services.IConnectionAclService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.w3c.dom.Node;

public class TransDelegate
extends AbstractDelegate
implements ITransformer,
ISharedObjectsTransformer,
Serializable {
    private static final long serialVersionUID = 3766852226384368923L;
    private static final String PROP_STEP_ERROR_HANDLING_MIN_PCT_ROWS = "step_error_handling_min_pct_rows";
    private static final String PROP_STEP_ERROR_HANDLING_MAX_PCT_ERRORS = "step_error_handling_max_pct_errors";
    private static final String PROP_STEP_ERROR_HANDLING_MAX_ERRORS = "step_error_handling_max_errors";
    private static final String PROP_STEP_ERROR_HANDLING_CODES_VALUENAME = "step_error_handling_codes_valuename";
    private static final String PROP_STEP_ERROR_HANDLING_FIELDS_VALUENAME = "step_error_handling_fields_valuename";
    static final String PROP_STEP_ERROR_HANDLING_DESCRIPTIONS_VALUENAME = "step_error_handling_descriptions_valuename";
    private static final String PROP_STEP_ERROR_HANDLING_NR_VALUENAME = "step_error_handling_nr_valuename";
    private static final String PROP_STEP_ERROR_HANDLING_IS_ENABLED = "step_error_handling_is_enabled";
    private static final String PROP_STEP_ERROR_HANDLING_TARGET_STEP = "step_error_handling_target_step";
    private static final String PROP_LOG_SIZE_LIMIT = "LOG_SIZE_LIMIT";
    private static final String PROP_LOG_INTERVAL = "LOG_INTERVAL";
    private static final String PROP_TRANSFORMATION_TYPE = "TRANSFORMATION_TYPE";
    public static final String PROP_TRANS_DATA_SERVICE_NAME = "DATA_SERVICE_NAME";
    private static final String PROP_STEP_PERFORMANCE_LOG_TABLE = "STEP_PERFORMANCE_LOG_TABLE";
    private static final String PROP_STEP_PERFORMANCE_CAPTURING_DELAY = "STEP_PERFORMANCE_CAPTURING_DELAY";
    private static final String PROP_STEP_PERFORMANCE_CAPTURING_SIZE_LIMIT = "STEP_PERFORMANCE_CAPTURING_SIZE_LIMIT";
    private static final String PROP_CAPTURE_STEP_PERFORMANCE = "CAPTURE_STEP_PERFORMANCE";
    private static final String PROP_SHARED_FILE = "SHARED_FILE";
    private static final String PROP_USING_THREAD_PRIORITIES = "USING_THREAD_PRIORITIES";
    static final String PROP_FEEDBACK_SIZE = "FEEDBACK_SIZE";
    private static final String PROP_FEEDBACK_SHOWN = "FEEDBACK_SHOWN";
    static final String PROP_UNIQUE_CONNECTIONS = "UNIQUE_CONNECTIONS";
    private static final String PROP_ID_DIRECTORY = "ID_DIRECTORY";
    static final String PROP_SIZE_ROWSET = "SIZE_ROWSET";
    private static final String PROP_MODIFIED_DATE = "MODIFIED_DATE";
    private static final String PROP_MODIFIED_USER = "MODIFIED_USER";
    private static final String PROP_CREATED_DATE = "CREATED_DATE";
    private static final String PROP_CREATED_USER = "CREATED_USER";
    static final String PROP_DIFF_MAXDATE = "DIFF_MAXDATE";
    static final String PROP_OFFSET_MAXDATE = "OFFSET_MAXDATE";
    private static final String PROP_FIELD_NAME_MAXDATE = "FIELD_NAME_MAXDATE";
    private static final String PROP_TABLE_NAME_MAXDATE = "TABLE_NAME_MAXDATE";
    private static final String PROP_ID_DATABASE_MAXDATE = "ID_DATABASE_MAXDATE";
    static final String PROP_USE_LOGFIELD = "USE_LOGFIELD";
    static final String PROP_USE_BATCHID = "USE_BATCHID";
    private static final String PROP_TABLE_NAME_LOG = "TABLE_NAME_LOG";
    private static final String PROP_DATABASE_LOG = "DATABASE_LOG";
    private static final String PROP_STEP_REJECTED = "STEP_REJECTED";
    private static final String PROP_STEP_UPDATE = "STEP_UPDATE";
    private static final String PROP_STEP_OUTPUT = "STEP_OUTPUT";
    private static final String PROP_STEP_INPUT = "STEP_INPUT";
    private static final String PROP_STEP_WRITE = "STEP_WRITE";
    private static final String PROP_STEP_READ = "STEP_READ";
    static final String PROP_TRANS_STATUS = "TRANS_STATUS";
    private static final String PROP_TRANS_VERSION = "TRANS_VERSION";
    private static final String PROP_EXTENDED_DESCRIPTION = "EXTENDED_DESCRIPTION";
    static final String PROP_NR_PARAMETERS = "NR_PARAMETERS";
    static final String NODE_PARAMETERS = "parameters";
    static final String PROP_NR_HOPS = "NR_HOPS";
    static final String PROP_NR_NOTES = "NR_NOTES";
    static final String NODE_NOTES = "notes";
    static final String NODE_HOPS = "hops";
    private static final String PROP_STEP_ERROR_HANDLING_SOURCE_STEP = "step_error_handling_source_step";
    private static final String NODE_PARTITIONER_CUSTOM = "partitionerCustom";
    private static final String PROP_PARTITIONING_SCHEMA = "PARTITIONING_SCHEMA";
    private static final String PROP_PARTITIONING_METHOD = "PARTITIONING_METHOD";
    private static final String PROP_CLUSTER_SCHEMA = "cluster_schema";
    private static final String NODE_STEP_CUSTOM = "custom";
    private static Class<?> PKG = TransDelegate.class;
    static final String PROP_STEP_DISTRIBUTE = "STEP_DISTRIBUTE";
    static final String PROP_STEP_ROW_DISTRIBUTION = "STEP_ROW_DISTRIBUTION";
    static final String PROP_STEP_GUI_DRAW = "STEP_GUI_DRAW";
    static final String PROP_STEP_GUI_LOCATION_Y = "STEP_GUI_LOCATION_Y";
    static final String PROP_STEP_GUI_LOCATION_X = "STEP_GUI_LOCATION_X";
    static final String PROP_STEP_COPIES = "STEP_COPIES";
    static final String PROP_STEP_COPIES_STRING = "STEP_COPIES_STRING";
    static final String PROP_STEP_TYPE = "STEP_TYPE";
    static final String NODE_TRANS = "transformation";
    static final String NODE_TRANS_PRIVATE_DATABASES = "transPrivateDatabases";
    private static final String EXT_STEP = ".kst";
    static final String NODE_STEPS = "steps";
    private static final String PROP_XML = "XML";
    private static final String NOTE_PREFIX = "__NOTE__#";
    private static final String TRANS_HOP_FROM = "TRANS_HOP_FROM";
    private static final String TRANS_HOP_TO = "TRANS_HOP_TO";
    private static final String TRANS_HOP_ENABLED = "TRANS_HOP_ENABLED";
    private static final String TRANS_HOP_PREFIX = "__TRANS_HOP__#";
    private static final String TRANS_PARAM_PREFIX = "__TRANS_PARAM__#";
    private static final String PARAM_KEY = "PARAM_KEY";
    private static final String PARAM_DESC = "PARAM_DESC";
    private static final String PARAM_DEFAULT = "PARAM_DEFAULT";
    private final Repository repo;
    private final IConnectionAclService unifiedRepositoryConnectionAclService;

    public TransDelegate(Repository repo, IUnifiedRepository pur) {
        this.repo = repo;
        this.unifiedRepositoryConnectionAclService = new UnifiedRepositoryConnectionAclService(pur);
    }

    @Override
    public RepositoryElementInterface dataNodeToElement(DataNode rootNode) throws KettleException {
        TransMeta transMeta = new TransMeta();
        this.dataNodeToElement(rootNode, (RepositoryElementInterface)transMeta);
        return transMeta;
    }

    @Override
    public void dataNodeToElement(DataNode rootNode, RepositoryElementInterface element) throws KettleException {
        TransMeta transMeta = (TransMeta)element;
        HashSet<String> privateTransformationDatabases = null;
        DataNode privateDatabases = rootNode.getNode(NODE_TRANS_PRIVATE_DATABASES);
        if (privateDatabases != null) {
            privateTransformationDatabases = new HashSet<String>();
            for (DataNode privateDatabase : privateDatabases.getNodes()) {
                privateTransformationDatabases.add(privateDatabase.getName());
            }
        }
        transMeta.setPrivateDatabases(privateTransformationDatabases);
        DataNode stepsNode = rootNode.getNode(NODE_STEPS);
        for (DataNode stepNode : stepsNode.getNodes()) {
            String copiesString;
            StepMeta stepMeta = new StepMeta((ObjectId)new StringObjectId(stepNode.getId().toString()));
            stepMeta.setParentTransMeta(transMeta);
            stepMeta.setName(this.getString(stepNode, "NAME"));
            if (stepNode.hasProperty("DESCRIPTION")) {
                stepMeta.setDescription(this.getString(stepNode, "DESCRIPTION"));
            }
            stepMeta.setDistributes(stepNode.getProperty(PROP_STEP_DISTRIBUTE).getBoolean());
            DataProperty rowDistributionProperty = stepNode.getProperty(PROP_STEP_ROW_DISTRIBUTION);
            String rowDistributionCode = rowDistributionProperty == null ? null : rowDistributionProperty.getString();
            RowDistributionInterface rowDistribution = (RowDistributionInterface)PluginRegistry.getInstance().loadClass(RowDistributionPluginType.class, rowDistributionCode, RowDistributionInterface.class);
            stepMeta.setRowDistribution(rowDistribution);
            stepMeta.setDraw(stepNode.getProperty(PROP_STEP_GUI_DRAW).getBoolean());
            int copies = (int)stepNode.getProperty(PROP_STEP_COPIES).getLong();
            String string = copiesString = stepNode.getProperty(PROP_STEP_COPIES_STRING) != null ? stepNode.getProperty(PROP_STEP_COPIES_STRING).getString() : "";
            if (!Const.isEmpty((String)copiesString)) {
                stepMeta.setCopiesString(copiesString);
            } else {
                stepMeta.setCopies(copies);
            }
            int x = (int)stepNode.getProperty(PROP_STEP_GUI_LOCATION_X).getLong();
            int y = (int)stepNode.getProperty(PROP_STEP_GUI_LOCATION_Y).getLong();
            stepMeta.setLocation(x, y);
            AttributesMapUtil.loadAttributesMap(stepNode, (AttributesInterface)stepMeta);
            String stepType = this.getString(stepNode, PROP_STEP_TYPE);
            PluginRegistry registry = PluginRegistry.getInstance();
            PluginInterface stepPlugin = registry.findPluginWithId(StepPluginType.class, stepType);
            StepMetaInterface stepMetaInterface = null;
            if (stepPlugin != null) {
                stepMetaInterface = (StepMetaInterface)registry.loadClass(stepPlugin);
                stepType = stepPlugin.getIds()[0];
            } else {
                stepMeta.setStepMetaInterface((StepMetaInterface)new MissingTrans(stepMeta.getName(), stepType));
                transMeta.addMissingTrans((MissingTrans)stepMeta.getStepMetaInterface());
            }
            stepMeta.setStepID(stepType);
            RepositoryProxy proxy = new RepositoryProxy(stepNode.getNode(NODE_STEP_CUSTOM));
            if (!stepMeta.isMissing()) {
                this.readRepCompatibleStepMeta(stepMetaInterface, (Repository)proxy, null, transMeta.getDatabases());
                stepMetaInterface.readRep((Repository)proxy, transMeta.getMetaStore(), null, transMeta.getDatabases());
                stepMeta.setStepMetaInterface(stepMetaInterface);
            }
            StepPartitioningMeta stepPartitioningMeta = new StepPartitioningMeta();
            if (stepNode.hasProperty(PROP_PARTITIONING_SCHEMA)) {
                String partSchemaId = stepNode.getProperty(PROP_PARTITIONING_SCHEMA).getRef().getId().toString();
                String schemaName = this.repo.loadPartitionSchema((ObjectId)new StringObjectId(partSchemaId), null).getName();
                stepPartitioningMeta.setPartitionSchemaName(schemaName);
                String methodCode = this.getString(stepNode, PROP_PARTITIONING_METHOD);
                stepPartitioningMeta.setMethod(StepPartitioningMeta.getMethod((String)methodCode));
                if (stepPartitioningMeta.getPartitioner() != null) {
                    proxy = new RepositoryProxy(stepNode.getNode(NODE_PARTITIONER_CUSTOM));
                    stepPartitioningMeta.getPartitioner().loadRep((Repository)proxy, null);
                }
                stepPartitioningMeta.hasChanged(true);
            }
            stepMeta.setStepPartitioningMeta(stepPartitioningMeta);
            stepMeta.getStepPartitioningMeta().setPartitionSchemaAfterLoading(transMeta.getPartitionSchemas());
            String clusterSchemaName = this.getString(stepNode, PROP_CLUSTER_SCHEMA);
            stepMeta.setClusterSchemaName(clusterSchemaName);
            if (clusterSchemaName != null && transMeta.getClusterSchemas() != null) {
                for (ClusterSchema clusterSchema : transMeta.getClusterSchemas()) {
                    if (!clusterSchema.getName().equals(clusterSchemaName)) continue;
                    stepMeta.setClusterSchema(clusterSchema);
                    break;
                }
            }
            transMeta.addStep(stepMeta);
        }
        for (DataNode stepNode : stepsNode.getNodes()) {
            StringObjectId stepObjectId = new StringObjectId(stepNode.getId().toString());
            StepMeta stepMeta = StepMeta.findStep((List)transMeta.getSteps(), (ObjectId)stepObjectId);
            if (!stepNode.hasProperty(PROP_STEP_ERROR_HANDLING_SOURCE_STEP)) continue;
            StepErrorMeta meta = new StepErrorMeta((VariableSpace)transMeta, stepMeta);
            meta.setTargetStep(StepMeta.findStep((List)transMeta.getSteps(), (String)stepNode.getProperty(PROP_STEP_ERROR_HANDLING_TARGET_STEP).getString()));
            meta.setEnabled(stepNode.getProperty(PROP_STEP_ERROR_HANDLING_IS_ENABLED).getBoolean());
            meta.setNrErrorsValuename(this.getString(stepNode, PROP_STEP_ERROR_HANDLING_NR_VALUENAME));
            meta.setErrorDescriptionsValuename(this.getString(stepNode, PROP_STEP_ERROR_HANDLING_DESCRIPTIONS_VALUENAME));
            meta.setErrorFieldsValuename(this.getString(stepNode, PROP_STEP_ERROR_HANDLING_FIELDS_VALUENAME));
            meta.setErrorCodesValuename(this.getString(stepNode, PROP_STEP_ERROR_HANDLING_CODES_VALUENAME));
            meta.setMaxErrors(this.getString(stepNode, PROP_STEP_ERROR_HANDLING_MAX_ERRORS));
            meta.setMaxPercentErrors(this.getString(stepNode, PROP_STEP_ERROR_HANDLING_MAX_PCT_ERRORS));
            meta.setMinPercentRows(this.getString(stepNode, PROP_STEP_ERROR_HANDLING_MIN_PCT_ROWS));
            meta.getSourceStep().setStepErrorMeta(meta);
        }
        for (int i = 0; i < transMeta.nrSteps(); ++i) {
            StepMeta stepMeta = transMeta.getStep(i);
            StepMetaInterface sii = stepMeta.getStepMetaInterface();
            if (sii == null) continue;
            sii.searchInfoAndTargetSteps(transMeta.getSteps());
        }
        DataNode notesNode = rootNode.getNode(NODE_NOTES);
        int nrNotes = (int)notesNode.getProperty(PROP_NR_NOTES).getLong();
        for (DataNode noteNode : notesNode.getNodes()) {
            String xml = this.getString(noteNode, PROP_XML);
            transMeta.addNote(new NotePadMeta(XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)xml), (String)"notepad")));
        }
        if (transMeta.nrNotes() != nrNotes) {
            throw new KettleException("The number of notes read [" + transMeta.nrNotes() + "] was not the number we expected [" + nrNotes + "]");
        }
        DataNode hopsNode = rootNode.getNode(NODE_HOPS);
        int nrHops = (int)hopsNode.getProperty(PROP_NR_HOPS).getLong();
        for (DataNode hopNode : hopsNode.getNodes()) {
            String stepFromName = this.getString(hopNode, TRANS_HOP_FROM);
            String stepToName = this.getString(hopNode, TRANS_HOP_TO);
            boolean enabled = true;
            if (hopNode.hasProperty(TRANS_HOP_ENABLED)) {
                enabled = hopNode.getProperty(TRANS_HOP_ENABLED).getBoolean();
            }
            StepMeta stepFrom = StepMeta.findStep((List)transMeta.getSteps(), (String)stepFromName);
            StepMeta stepTo = StepMeta.findStep((List)transMeta.getSteps(), (String)stepToName);
            if (stepFrom == null || stepTo == null) continue;
            transMeta.addTransHop(new TransHopMeta(stepFrom, stepTo, enabled));
        }
        if (transMeta.nrTransHops() != nrHops) {
            throw new KettleException("The number of hops read [" + transMeta.nrTransHops() + "] was not the number we expected [" + nrHops + "]");
        }
        this.loadTransformationDetails(rootNode, transMeta);
        transMeta.eraseParameters();
        DataNode paramsNode = rootNode.getNode(NODE_PARAMETERS);
        int count = (int)paramsNode.getProperty(PROP_NR_PARAMETERS).getLong();
        for (int idx = 0; idx < count; ++idx) {
            DataNode paramNode = paramsNode.getNode(TRANS_PARAM_PREFIX + idx);
            String key = this.getString(paramNode, PARAM_KEY);
            String def = this.getString(paramNode, PARAM_DEFAULT);
            String desc = this.getString(paramNode, PARAM_DESC);
            transMeta.addParameterDefinition(key, def, desc);
        }
        transMeta.activateParameters();
    }

    private void readRepCompatibleStepMeta(StepMetaInterface stepMetaInterface, Repository repository, ObjectId objectId, List<DatabaseMeta> databases) throws KettleException {
        stepMetaInterface.readRep(repository, objectId, databases, null);
    }

    protected void loadTransformationDetails(DataNode rootNode, TransMeta transMeta) throws KettleException {
        String id;
        transMeta.setExtendedDescription(this.getString(rootNode, PROP_EXTENDED_DESCRIPTION));
        transMeta.setTransversion(this.getString(rootNode, PROP_TRANS_VERSION));
        transMeta.setTransstatus((int)rootNode.getProperty(PROP_TRANS_STATUS).getLong());
        if (rootNode.hasProperty(PROP_STEP_READ)) {
            transMeta.getTransLogTable().setStepRead(StepMeta.findStep((List)transMeta.getSteps(), (String)this.getString(rootNode, PROP_STEP_READ)));
        }
        if (rootNode.hasProperty(PROP_STEP_WRITE)) {
            transMeta.getTransLogTable().setStepWritten(StepMeta.findStep((List)transMeta.getSteps(), (String)this.getString(rootNode, PROP_STEP_WRITE)));
        }
        if (rootNode.hasProperty(PROP_STEP_INPUT)) {
            transMeta.getTransLogTable().setStepInput(StepMeta.findStep((List)transMeta.getSteps(), (String)this.getString(rootNode, PROP_STEP_INPUT)));
        }
        if (rootNode.hasProperty(PROP_STEP_OUTPUT)) {
            transMeta.getTransLogTable().setStepOutput(StepMeta.findStep((List)transMeta.getSteps(), (String)this.getString(rootNode, PROP_STEP_OUTPUT)));
        }
        if (rootNode.hasProperty(PROP_STEP_UPDATE)) {
            transMeta.getTransLogTable().setStepUpdate(StepMeta.findStep((List)transMeta.getSteps(), (String)this.getString(rootNode, PROP_STEP_UPDATE)));
        }
        if (rootNode.hasProperty(PROP_STEP_REJECTED)) {
            transMeta.getTransLogTable().setStepRejected(StepMeta.findStep((List)transMeta.getSteps(), (String)this.getString(rootNode, PROP_STEP_REJECTED)));
        }
        if (rootNode.hasProperty(PROP_DATABASE_LOG)) {
            id = rootNode.getProperty(PROP_DATABASE_LOG).getRef().getId().toString();
            DatabaseMeta conn = DatabaseMeta.findDatabase((List)transMeta.getDatabases(), (ObjectId)new StringObjectId(id));
            transMeta.getTransLogTable().setConnectionName(conn.getName());
        }
        transMeta.getTransLogTable().setTableName(this.getString(rootNode, PROP_TABLE_NAME_LOG));
        transMeta.getTransLogTable().setBatchIdUsed(rootNode.getProperty(PROP_USE_BATCHID).getBoolean());
        transMeta.getTransLogTable().setLogFieldUsed(rootNode.getProperty(PROP_USE_LOGFIELD).getBoolean());
        if (rootNode.hasProperty(PROP_ID_DATABASE_MAXDATE)) {
            id = rootNode.getProperty(PROP_ID_DATABASE_MAXDATE).getRef().getId().toString();
            transMeta.setMaxDateConnection(DatabaseMeta.findDatabase((List)transMeta.getDatabases(), (ObjectId)new StringObjectId(id)));
        }
        transMeta.setMaxDateTable(this.getString(rootNode, PROP_TABLE_NAME_MAXDATE));
        transMeta.setMaxDateField(this.getString(rootNode, PROP_FIELD_NAME_MAXDATE));
        transMeta.setMaxDateOffset(rootNode.getProperty(PROP_OFFSET_MAXDATE).getDouble());
        transMeta.setMaxDateDifference(rootNode.getProperty(PROP_DIFF_MAXDATE).getDouble());
        transMeta.setCreatedUser(this.getString(rootNode, PROP_CREATED_USER));
        transMeta.setCreatedDate(this.getDate(rootNode, PROP_CREATED_DATE));
        transMeta.setModifiedUser(this.getString(rootNode, PROP_MODIFIED_USER));
        transMeta.setModifiedDate(this.getDate(rootNode, PROP_MODIFIED_DATE));
        transMeta.setSizeRowset(10000);
        long val_size_rowset = rootNode.getProperty(PROP_SIZE_ROWSET).getLong();
        if (val_size_rowset > 0L) {
            transMeta.setSizeRowset((int)val_size_rowset);
        }
        if (rootNode.hasProperty(PROP_ID_DIRECTORY)) {
            String id_directory = this.getString(rootNode, PROP_ID_DIRECTORY);
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), new Object[]{"ID_DIRECTORY=" + id_directory});
            }
            transMeta.setRepositoryDirectory(this.repo.findDirectory((ObjectId)new StringObjectId(id_directory)));
        }
        transMeta.setUsingUniqueConnections(rootNode.getProperty(PROP_UNIQUE_CONNECTIONS).getBoolean());
        boolean feedbackShown = true;
        if (rootNode.hasProperty(PROP_FEEDBACK_SHOWN)) {
            feedbackShown = rootNode.getProperty(PROP_FEEDBACK_SHOWN).getBoolean();
        }
        transMeta.setFeedbackShown(feedbackShown);
        transMeta.setFeedbackSize((int)rootNode.getProperty(PROP_FEEDBACK_SIZE).getLong());
        boolean usingThreadPriorityManagement = true;
        if (rootNode.hasProperty(PROP_USING_THREAD_PRIORITIES)) {
            usingThreadPriorityManagement = rootNode.getProperty(PROP_USING_THREAD_PRIORITIES).getBoolean();
        }
        transMeta.setUsingThreadPriorityManagment(usingThreadPriorityManagement);
        transMeta.setSharedObjectsFile(this.getString(rootNode, PROP_SHARED_FILE));
        String transTypeCode = this.getString(rootNode, PROP_TRANSFORMATION_TYPE);
        transMeta.setTransformationType(TransMeta.TransformationType.getTransformationTypeByCode((String)transTypeCode));
        boolean capturingStepPerformanceSnapShots = true;
        if (rootNode.hasProperty(PROP_CAPTURE_STEP_PERFORMANCE)) {
            capturingStepPerformanceSnapShots = rootNode.getProperty(PROP_CAPTURE_STEP_PERFORMANCE).getBoolean();
        }
        transMeta.setCapturingStepPerformanceSnapShots(capturingStepPerformanceSnapShots);
        transMeta.setStepPerformanceCapturingDelay(this.getLong(rootNode, PROP_STEP_PERFORMANCE_CAPTURING_DELAY));
        transMeta.setStepPerformanceCapturingSizeLimit(this.getString(rootNode, PROP_STEP_PERFORMANCE_CAPTURING_SIZE_LIMIT));
        transMeta.getPerformanceLogTable().setTableName(this.getString(rootNode, PROP_STEP_PERFORMANCE_LOG_TABLE));
        transMeta.getTransLogTable().setLogSizeLimit(this.getString(rootNode, PROP_LOG_SIZE_LIMIT));
        PurRepositoryAttribute attributeInterface = new PurRepositoryAttribute(rootNode, transMeta.getDatabases());
        for (LogTableInterface logTable : transMeta.getLogTables()) {
            logTable.loadFromRepository((RepositoryAttributeInterface)attributeInterface);
        }
        AttributesMapUtil.loadAttributesMap(rootNode, (AttributesInterface)transMeta);
    }

    @Override
    public DataNode elementToDataNode(RepositoryElementInterface element) throws KettleException {
        TransMeta transMeta = (TransMeta)element;
        DataNode rootNode = new DataNode(NODE_TRANS);
        if (transMeta.getPrivateDatabases() != null) {
            DataNode privateDatabaseNode = rootNode.addNode(NODE_TRANS_PRIVATE_DATABASES);
            for (String privateDatabase : transMeta.getPrivateDatabases()) {
                privateDatabaseNode.addNode(privateDatabase);
            }
        }
        DataNode stepsNode = rootNode.addNode(NODE_STEPS);
        int stepNr = 0;
        for (StepMeta step : transMeta.getSteps()) {
            DataNode stepNode = stepsNode.addNode(this.sanitizeNodeName(step.getName()) + "_" + ++stepNr + EXT_STEP);
            stepNode.setProperty("NAME", step.getName());
            stepNode.setProperty("DESCRIPTION", step.getDescription());
            stepNode.setProperty(PROP_STEP_TYPE, step.getStepID());
            stepNode.setProperty(PROP_STEP_DISTRIBUTE, step.isDistributes());
            stepNode.setProperty(PROP_STEP_ROW_DISTRIBUTION, step.getRowDistribution() == null ? null : step.getRowDistribution().getCode());
            stepNode.setProperty(PROP_STEP_COPIES, (long)step.getCopies());
            stepNode.setProperty(PROP_STEP_COPIES_STRING, step.getCopiesString());
            stepNode.setProperty(PROP_STEP_GUI_LOCATION_X, (long)step.getLocation().x);
            stepNode.setProperty(PROP_STEP_GUI_LOCATION_Y, (long)step.getLocation().y);
            stepNode.setProperty(PROP_STEP_GUI_DRAW, step.isDrawn());
            AttributesMapUtil.saveAttributesMap(stepNode, (AttributesInterface)step);
            StepMetaInterface stepMetaInterface = step.getStepMetaInterface();
            DataNode stepCustomNode = new DataNode(NODE_STEP_CUSTOM);
            RepositoryProxy proxy = new RepositoryProxy(stepCustomNode);
            this.compatibleSaveRep(stepMetaInterface, (Repository)proxy, null, null);
            stepMetaInterface.saveRep((Repository)proxy, proxy.getMetaStore(), null, null);
            stepNode.addNode(stepCustomNode);
            StepPartitioningMeta partitioningMeta = step.getStepPartitioningMeta();
            if (partitioningMeta != null && partitioningMeta.getPartitionSchema() != null && partitioningMeta.isPartitioned()) {
                DataNodeRef ref = new DataNodeRef((Serializable)((Object)partitioningMeta.getPartitionSchema().getObjectId().getId()));
                stepNode.setProperty(PROP_PARTITIONING_SCHEMA, ref);
                stepNode.setProperty(PROP_PARTITIONING_METHOD, partitioningMeta.getMethodCode());
                if (partitioningMeta.getPartitioner() != null) {
                    DataNode partitionerCustomNode = new DataNode(NODE_PARTITIONER_CUSTOM);
                    proxy = new RepositoryProxy(partitionerCustomNode);
                    partitioningMeta.getPartitioner().saveRep((Repository)proxy, null, null);
                    stepNode.addNode(partitionerCustomNode);
                }
            }
            stepNode.setProperty(PROP_CLUSTER_SCHEMA, step.getClusterSchema() == null ? "" : step.getClusterSchema().getName());
            StepErrorMeta stepErrorMeta = step.getStepErrorMeta();
            if (stepErrorMeta == null) continue;
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_SOURCE_STEP, stepErrorMeta.getSourceStep() != null ? stepErrorMeta.getSourceStep().getName() : "");
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_TARGET_STEP, stepErrorMeta.getTargetStep() != null ? stepErrorMeta.getTargetStep().getName() : "");
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_IS_ENABLED, stepErrorMeta.isEnabled());
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_NR_VALUENAME, stepErrorMeta.getNrErrorsValuename());
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_DESCRIPTIONS_VALUENAME, stepErrorMeta.getErrorDescriptionsValuename());
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_FIELDS_VALUENAME, stepErrorMeta.getErrorFieldsValuename());
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_CODES_VALUENAME, stepErrorMeta.getErrorCodesValuename());
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_MAX_ERRORS, stepErrorMeta.getMaxErrors());
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_MAX_PCT_ERRORS, stepErrorMeta.getMaxPercentErrors());
            stepNode.setProperty(PROP_STEP_ERROR_HANDLING_MIN_PCT_ROWS, stepErrorMeta.getMinPercentRows());
        }
        DataNode notesNode = rootNode.addNode(NODE_NOTES);
        notesNode.setProperty(PROP_NR_NOTES, (long)transMeta.nrNotes());
        for (int i = 0; i < transMeta.nrNotes(); ++i) {
            NotePadMeta note = transMeta.getNote(i);
            DataNode noteNode = notesNode.addNode(NOTE_PREFIX + i);
            noteNode.setProperty(PROP_XML, note.getXML());
        }
        DataNode hopsNode = rootNode.addNode(NODE_HOPS);
        hopsNode.setProperty(PROP_NR_HOPS, (long)transMeta.nrTransHops());
        for (int i = 0; i < transMeta.nrTransHops(); ++i) {
            TransHopMeta hop = transMeta.getTransHop(i);
            DataNode hopNode = hopsNode.addNode(TRANS_HOP_PREFIX + i);
            hopNode.setProperty(TRANS_HOP_FROM, hop.getFromStep().getName());
            hopNode.setProperty(TRANS_HOP_TO, hop.getToStep().getName());
            hopNode.setProperty(TRANS_HOP_ENABLED, hop.isEnabled());
        }
        String[] paramKeys = transMeta.listParameters();
        DataNode paramsNode = rootNode.addNode(NODE_PARAMETERS);
        paramsNode.setProperty(PROP_NR_PARAMETERS, paramKeys == null ? 0L : (long)paramKeys.length);
        for (int idx = 0; idx < paramKeys.length; ++idx) {
            DataNode paramNode = paramsNode.addNode(TRANS_PARAM_PREFIX + idx);
            String key = paramKeys[idx];
            String description = transMeta.getParameterDescription(paramKeys[idx]);
            String defaultValue = transMeta.getParameterDefault(paramKeys[idx]);
            paramNode.setProperty(PARAM_KEY, key != null ? key : "");
            paramNode.setProperty(PARAM_DEFAULT, defaultValue != null ? defaultValue : "");
            paramNode.setProperty(PARAM_DESC, description != null ? description : "");
        }
        this.saveTransformationDetails(rootNode, transMeta);
        return rootNode;
    }

    private void compatibleSaveRep(StepMetaInterface stepMetaInterface, Repository repository, ObjectId id_transformation, ObjectId objectId) throws KettleException {
        stepMetaInterface.saveRep(repository, id_transformation, objectId);
    }

    private void saveTransformationDetails(DataNode rootNode, TransMeta transMeta) throws KettleException {
        DataNodeRef ref;
        rootNode.setProperty(PROP_EXTENDED_DESCRIPTION, transMeta.getExtendedDescription());
        rootNode.setProperty(PROP_TRANS_VERSION, transMeta.getTransversion());
        rootNode.setProperty(PROP_TRANS_STATUS, transMeta.getTransstatus() < 0 ? -1L : (long)transMeta.getTransstatus());
        rootNode.setProperty(PROP_STEP_READ, transMeta.getTransLogTable().getStepnameRead());
        rootNode.setProperty(PROP_STEP_WRITE, transMeta.getTransLogTable().getStepnameWritten());
        rootNode.setProperty(PROP_STEP_INPUT, transMeta.getTransLogTable().getStepnameInput());
        rootNode.setProperty(PROP_STEP_OUTPUT, transMeta.getTransLogTable().getStepnameOutput());
        rootNode.setProperty(PROP_STEP_UPDATE, transMeta.getTransLogTable().getStepnameUpdated());
        rootNode.setProperty(PROP_STEP_REJECTED, transMeta.getTransLogTable().getStepnameRejected());
        if (transMeta.getTransLogTable().getDatabaseMeta() != null) {
            ref = new DataNodeRef((Serializable)((Object)transMeta.getTransLogTable().getDatabaseMeta().getObjectId().getId()));
            rootNode.setProperty(PROP_DATABASE_LOG, ref);
        }
        rootNode.setProperty(PROP_TABLE_NAME_LOG, transMeta.getTransLogTable().getTableName());
        rootNode.setProperty(PROP_USE_BATCHID, Boolean.valueOf(transMeta.getTransLogTable().isBatchIdUsed()).booleanValue());
        rootNode.setProperty(PROP_USE_LOGFIELD, Boolean.valueOf(transMeta.getTransLogTable().isLogFieldUsed()).booleanValue());
        if (transMeta.getMaxDateConnection() != null) {
            ref = new DataNodeRef((Serializable)((Object)transMeta.getMaxDateConnection().getObjectId().getId()));
            rootNode.setProperty(PROP_ID_DATABASE_MAXDATE, ref);
        }
        rootNode.setProperty(PROP_TABLE_NAME_MAXDATE, transMeta.getMaxDateTable());
        rootNode.setProperty(PROP_FIELD_NAME_MAXDATE, transMeta.getMaxDateField());
        rootNode.setProperty(PROP_OFFSET_MAXDATE, new Double(transMeta.getMaxDateOffset()).doubleValue());
        rootNode.setProperty(PROP_DIFF_MAXDATE, new Double(transMeta.getMaxDateDifference()).doubleValue());
        rootNode.setProperty(PROP_CREATED_USER, transMeta.getCreatedUser());
        rootNode.setProperty(PROP_CREATED_DATE, transMeta.getCreatedDate());
        rootNode.setProperty(PROP_MODIFIED_USER, transMeta.getModifiedUser());
        rootNode.setProperty(PROP_MODIFIED_DATE, transMeta.getModifiedDate());
        rootNode.setProperty(PROP_SIZE_ROWSET, (long)transMeta.getSizeRowset());
        rootNode.setProperty(PROP_UNIQUE_CONNECTIONS, transMeta.isUsingUniqueConnections());
        rootNode.setProperty(PROP_FEEDBACK_SHOWN, transMeta.isFeedbackShown());
        rootNode.setProperty(PROP_FEEDBACK_SIZE, (long)transMeta.getFeedbackSize());
        rootNode.setProperty(PROP_USING_THREAD_PRIORITIES, transMeta.isUsingThreadPriorityManagment());
        rootNode.setProperty(PROP_SHARED_FILE, transMeta.getSharedObjectsFile());
        rootNode.setProperty(PROP_CAPTURE_STEP_PERFORMANCE, transMeta.isCapturingStepPerformanceSnapShots());
        rootNode.setProperty(PROP_STEP_PERFORMANCE_CAPTURING_DELAY, transMeta.getStepPerformanceCapturingDelay());
        rootNode.setProperty(PROP_STEP_PERFORMANCE_CAPTURING_SIZE_LIMIT, transMeta.getStepPerformanceCapturingSizeLimit());
        rootNode.setProperty(PROP_STEP_PERFORMANCE_LOG_TABLE, transMeta.getPerformanceLogTable().getTableName());
        rootNode.setProperty(PROP_LOG_SIZE_LIMIT, transMeta.getTransLogTable().getLogSizeLimit());
        rootNode.setProperty(PROP_LOG_INTERVAL, transMeta.getTransLogTable().getLogInterval());
        rootNode.setProperty(PROP_TRANSFORMATION_TYPE, transMeta.getTransformationType().getCode());
        PurRepositoryAttribute attributeInterface = new PurRepositoryAttribute(rootNode, transMeta.getDatabases());
        for (LogTableInterface logTable : transMeta.getLogTables()) {
            logTable.saveToRepository((RepositoryAttributeInterface)attributeInterface);
        }
        AttributesMapUtil.saveAttributesMap(rootNode, (AttributesInterface)transMeta);
    }

    @Override
    public SharedObjects loadSharedObjects(RepositoryElementInterface element, Map<RepositoryObjectType, List<? extends SharedObjectInterface>> sharedObjectsByType) throws KettleException {
        TransMeta transMeta = (TransMeta)element;
        transMeta.setSharedObjects(transMeta.readSharedObjects());
        this.readDatabases(transMeta, true, sharedObjectsByType.get(RepositoryObjectType.DATABASE));
        this.readPartitionSchemas(transMeta, true, sharedObjectsByType.get(RepositoryObjectType.PARTITION_SCHEMA));
        this.readSlaves(transMeta, true, sharedObjectsByType.get(RepositoryObjectType.SLAVE_SERVER));
        this.readClusters(transMeta, true, sharedObjectsByType.get(RepositoryObjectType.CLUSTER_SCHEMA));
        return transMeta.getSharedObjects();
    }

    protected void readDatabases(TransMeta transMeta, boolean overWriteShared, List<DatabaseMeta> databaseMetas) {
        for (DatabaseMeta databaseMeta : databaseMetas) {
            if (!overWriteShared && transMeta.findDatabase(databaseMeta.getName()) != null || databaseMeta.getName() == null) continue;
            databaseMeta.shareVariablesWith((VariableSpace)transMeta);
            transMeta.addOrReplaceDatabase(databaseMeta);
            if (overWriteShared) continue;
            databaseMeta.setChanged(false);
        }
        transMeta.clearChangedDatabases();
    }

    protected void readClusters(TransMeta transMeta, boolean overWriteShared, List<ClusterSchema> clusterSchemas) {
        for (ClusterSchema clusterSchema : clusterSchemas) {
            if (!overWriteShared && transMeta.findClusterSchema(clusterSchema.getName()) != null || Const.isEmpty((String)clusterSchema.getName())) continue;
            clusterSchema.shareVariablesWith((VariableSpace)transMeta);
            transMeta.addOrReplaceClusterSchema(clusterSchema);
            if (overWriteShared) continue;
            clusterSchema.setChanged(false);
        }
    }

    protected void readPartitionSchemas(TransMeta transMeta, boolean overWriteShared, List<PartitionSchema> partitionSchemas) {
        for (PartitionSchema partitionSchema : partitionSchemas) {
            if (!overWriteShared && transMeta.findPartitionSchema(partitionSchema.getName()) != null || Const.isEmpty((String)partitionSchema.getName())) continue;
            transMeta.addOrReplacePartitionSchema(partitionSchema);
            if (overWriteShared) continue;
            partitionSchema.setChanged(false);
        }
    }

    protected void readSlaves(TransMeta transMeta, boolean overWriteShared, List<SlaveServer> slaveServers) {
        for (SlaveServer slaveServer : slaveServers) {
            if (!overWriteShared && transMeta.findSlaveServer(slaveServer.getName()) != null || Const.isEmpty((String)slaveServer.getName())) continue;
            slaveServer.shareVariablesWith((VariableSpace)transMeta);
            transMeta.addOrReplaceSlaveServer(slaveServer);
            if (overWriteShared) continue;
            slaveServer.setChanged(false);
        }
    }

    @Override
    public void saveSharedObjects(RepositoryElementInterface element, String versionComment) throws KettleException {
        TransMeta transMeta = (TransMeta)element;
        for (DatabaseMeta databaseMeta : transMeta.getDatabases()) {
            if (!databaseMeta.hasChanged() && databaseMeta.getObjectId() != null) continue;
            if (databaseMeta.getObjectId() == null || this.unifiedRepositoryConnectionAclService.hasAccess(databaseMeta.getObjectId(), RepositoryFilePermission.WRITE)) {
                this.repo.save((RepositoryElementInterface)databaseMeta, versionComment, null);
                continue;
            }
            this.log.logError(BaseMessages.getString(PKG, (String)"PurRepository.ERROR_0004_DATABASE_UPDATE_ACCESS_DENIED", (String[])new String[]{databaseMeta.getName()}));
        }
        for (SlaveServer slaveServer : transMeta.getSlaveServers()) {
            if (!slaveServer.hasChanged() && slaveServer.getObjectId() != null) continue;
            this.repo.save((RepositoryElementInterface)slaveServer, versionComment, null);
        }
        for (ClusterSchema clusterSchema : transMeta.getClusterSchemas()) {
            if (!clusterSchema.hasChanged() && clusterSchema.getObjectId() != null) continue;
            this.repo.save((RepositoryElementInterface)clusterSchema, versionComment, null);
        }
        for (PartitionSchema partitionSchema : transMeta.getPartitionSchemas()) {
            if (!partitionSchema.hasChanged() && partitionSchema.getObjectId() != null) continue;
            this.repo.save((RepositoryElementInterface)partitionSchema, versionComment, null);
        }
    }
}

