/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.vfs;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class MapRFSFileChooserDialog
extends CustomVfsUiPanel {
    private VfsFileChooserDialog vfsFileChooserDialog;

    public MapRFSFileChooserDialog(String schemeName, String displayName, VfsFileChooserDialog vfsFileChooserDialog) {
        super(schemeName, displayName, vfsFileChooserDialog, 0);
        this.vfsFileChooserDialog = vfsFileChooserDialog;
    }

    public void activate() {
        this.vfsFileChooserDialog.setRootFile(null);
        this.vfsFileChooserDialog.setInitialFile(null);
        this.vfsFileChooserDialog.openFileCombo.setText("maprfs://");
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        super.activate();
        try {
            FileObject newRoot = this.resolveFile(this.vfsFileChooserDialog.openFileCombo.getText());
            this.vfsFileChooserDialog.vfsBrowser.resetVfsRoot(newRoot);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        return opts;
    }

    private VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }
}

