/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractTupleCursor;
import mondrian.calc.impl.AbstractTupleIterable;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.util.CancellationChecker;

class FilterFunDef
extends FunDefBase {
    private static final String TIMING_NAME = FilterFunDef.class.getSimpleName();
    static final FilterFunDef instance = new FilterFunDef();

    private FilterFunDef() {
        super("Filter", "Returns the set resulting from filtering a set based on a search condition.", "fxxb");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        List<ResultStyle> styles = compiler.getAcceptableResultStyles();
        if (call.getArg(0) instanceof ResolvedFunCall && ((ResolvedFunCall)call.getArg(0)).getFunName().equals("AS")) {
            styles = ResultStyle.ITERABLE_ONLY;
        }
        if (styles.contains((Object)ResultStyle.ITERABLE) || styles.contains((Object)ResultStyle.ANY)) {
            return this.compileCallIterable(call, compiler);
        }
        if (styles.contains((Object)ResultStyle.LIST) || styles.contains((Object)ResultStyle.MUTABLE_LIST)) {
            return this.compileCallList(call, compiler);
        }
        throw ResultStyleException.generate(ResultStyle.ITERABLE_LIST_MUTABLELIST_ANY, styles);
    }

    protected IterCalc compileCallIterable(ResolvedFunCall call, ExpCompiler compiler) {
        Calc imlcalc = compiler.compileAs(call.getArg(0), null, ResultStyle.ITERABLE_LIST_MUTABLELIST);
        BooleanCalc bcalc = compiler.compileBoolean(call.getArg(1));
        Calc[] calcs = new Calc[]{imlcalc, bcalc};
        FilterFunDef.checkIterListResultStyles(imlcalc);
        if (imlcalc.getResultStyle() == ResultStyle.ITERABLE) {
            return new IterIterCalc(call, calcs);
        }
        if (imlcalc.getResultStyle() == ResultStyle.LIST) {
            return new ImmutableIterCalc(call, calcs);
        }
        return new MutableIterCalc(call, calcs);
    }

    protected ListCalc compileCallList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc ilcalc = compiler.compileList(call.getArg(0), false);
        BooleanCalc bcalc = compiler.compileBoolean(call.getArg(1));
        Calc[] calcs = new Calc[]{ilcalc, bcalc};
        switch (ilcalc.getResultStyle()) {
            case LIST: {
                return new ImmutableListCalc(call, calcs);
            }
            case MUTABLE_LIST: {
                return new MutableListCalc(call, calcs);
            }
        }
        throw ResultStyleException.generateBadType(ResultStyle.MUTABLELIST_LIST, ilcalc.getResultStyle());
    }

    private static class ImmutableListCalc
    extends BaseListCalc {
        ImmutableListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof ListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TupleList makeList(Evaluator evaluator) {
            evaluator.getTiming().markStart(TIMING_NAME);
            int savepoint = evaluator.savepoint();
            try {
                Calc[] calcs = this.getCalcs();
                ListCalc lcalc = (ListCalc)calcs[0];
                BooleanCalc bcalc = (BooleanCalc)calcs[1];
                TupleList members0 = lcalc.evaluateList(evaluator);
                TupleList result = members0.cloneList(members0.size() / 2);
                evaluator.setNonEmpty(false);
                TupleCursor cursor = members0.tupleCursor();
                int currentIteration = 0;
                Execution execution = evaluator.getQuery().getStatement().getCurrentExecution();
                while (cursor.forward()) {
                    CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
                    cursor.setContext(evaluator);
                    if (!bcalc.evaluateBoolean(evaluator)) continue;
                    result.addCurrent(cursor);
                }
                TupleList tupleList = result;
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
                evaluator.getTiming().markEnd(TIMING_NAME);
            }
        }
    }

    private static class MutableListCalc
    extends BaseListCalc {
        MutableListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof ListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TupleList makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            TupleList members0 = lcalc.evaluateList(evaluator);
            TupleList result = members0.cloneList(members0.size() / 2);
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setNonEmpty(false);
                TupleCursor cursor = members0.tupleCursor();
                int currentIteration = 0;
                Execution execution = evaluator.getQuery().getStatement().getCurrentExecution();
                while (cursor.forward()) {
                    CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
                    cursor.setContext(evaluator);
                    if (!bcalc.evaluateBoolean(evaluator)) continue;
                    result.addCurrent(cursor);
                }
                TupleList tupleList = result;
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }
    }

    private static abstract class BaseListCalc
    extends AbstractListCalc {
        protected BaseListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (TupleList)nativeEvaluator.execute(ResultStyle.ITERABLE);
            }
            return this.makeList(evaluator);
        }

        protected abstract TupleList makeList(Evaluator var1);

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return BaseListCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }

    private static class IterIterCalc
    extends BaseIterCalc {
        IterIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof IterCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        @Override
        protected TupleIterable makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            IterCalc icalc = (IterCalc)calcs[0];
            final BooleanCalc bcalc = (BooleanCalc)calcs[1];
            final TupleIterable iterable = icalc.evaluateIterable(evaluator);
            final Evaluator evaluator2 = evaluator.push();
            evaluator2.setNonEmpty(false);
            return new AbstractTupleIterable(iterable.getArity()){

                @Override
                public TupleCursor tupleCursor() {
                    return new AbstractTupleCursor(iterable.getArity()){
                        final TupleCursor cursor;
                        {
                            this.cursor = iterable.tupleCursor();
                        }

                        @Override
                        public boolean forward() {
                            int currentIteration = 0;
                            Execution execution = Locus.peek().execution;
                            while (this.cursor.forward()) {
                                CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
                                this.cursor.setContext(evaluator2);
                                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public List<Member> current() {
                            return this.cursor.current();
                        }
                    };
                }
            };
        }
    }

    private static class ImmutableIterCalc
    extends BaseIterCalc {
        ImmutableIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof ListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TupleIterable makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            TupleList members = lcalc.evaluateList(evaluator);
            TupleList result = members.cloneList(members.size() / 2);
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setNonEmpty(false);
                TupleCursor cursor = members.tupleCursor();
                int currentIteration = 0;
                Execution execution = evaluator.getQuery().getStatement().getCurrentExecution();
                while (cursor.forward()) {
                    CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
                    cursor.setContext(evaluator);
                    if (!bcalc.evaluateBoolean(evaluator)) continue;
                    result.addCurrent(cursor);
                }
                TupleList tupleList = result;
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }
    }

    private static class MutableIterCalc
    extends BaseIterCalc {
        MutableIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof ListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TupleIterable makeIterable(Evaluator evaluator) {
            evaluator.getTiming().markStart(TIMING_NAME);
            int savepoint = evaluator.savepoint();
            try {
                Calc[] calcs = this.getCalcs();
                ListCalc lcalc = (ListCalc)calcs[0];
                BooleanCalc bcalc = (BooleanCalc)calcs[1];
                TupleList list = lcalc.evaluateList(evaluator);
                TupleList result = TupleCollections.createList(list.getArity(), list.size() / 2);
                evaluator.setNonEmpty(false);
                TupleCursor cursor = list.tupleCursor();
                int currentIteration = 0;
                Execution execution = evaluator.getQuery().getStatement().getCurrentExecution();
                while (cursor.forward()) {
                    CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
                    cursor.setContext(evaluator);
                    if (!bcalc.evaluateBoolean(evaluator)) continue;
                    result.addCurrent(cursor);
                }
                TupleList tupleList = result;
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
                evaluator.getTiming().markEnd(TIMING_NAME);
            }
        }
    }

    private static abstract class BaseIterCalc
    extends AbstractIterCalc {
        protected BaseIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TupleIterable evaluateIterable(Evaluator evaluator) {
            evaluator.getTiming().markStart(TIMING_NAME);
            try {
                ResolvedFunCall call = (ResolvedFunCall)this.exp;
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    TupleIterable tupleIterable = (TupleIterable)nativeEvaluator.execute(ResultStyle.ITERABLE);
                    return tupleIterable;
                }
                TupleIterable tupleIterable = this.makeIterable(evaluator);
                return tupleIterable;
            }
            finally {
                evaluator.getTiming().markEnd(TIMING_NAME);
            }
        }

        protected abstract TupleIterable makeIterable(Evaluator var1);

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return BaseIterCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }
}

