/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.TupleIterable;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AndPredicate;
import mondrian.rolap.agg.OrPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;
import mondrian.util.Pair;

public class CompoundPredicateInfo {
    private final Pair<BitKey, StarPredicate> predicate;
    private final String predicateString;
    private final RolapMeasure measure;
    private boolean satisfiable = true;

    public CompoundPredicateInfo(List<List<Member>> tupleList, RolapMeasure measure, Evaluator evaluator) {
        this.measure = measure;
        this.predicate = this.predicateFromTupleList(tupleList, measure, evaluator);
        this.predicateString = CompoundPredicateInfo.getPredicateString(CompoundPredicateInfo.getStar(measure), this.getPredicate());
        assert (measure != null);
    }

    public StarPredicate getPredicate() {
        return this.predicate == null ? null : (StarPredicate)this.predicate.right;
    }

    public BitKey getBitKey() {
        return this.predicate == null ? null : (BitKey)this.predicate.left;
    }

    public String getPredicateString() {
        return this.predicateString;
    }

    public boolean isSatisfiable() {
        return this.satisfiable;
    }

    public RolapCube getCube() {
        return this.measure.isCalculated() ? null : ((RolapStoredMeasure)this.measure).getCube();
    }

    public static String getPredicateString(RolapStar star, StarPredicate predicate) {
        if (star == null || predicate == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        SqlQuery query = new SqlQuery(star.getSqlQueryDialect());
        buf.setLength(0);
        predicate.toSql(query, buf);
        return buf.toString();
    }

    private static RolapStar getStar(RolapMeasure measure) {
        if (measure.isCalculated()) {
            return null;
        }
        RolapStoredMeasure storedMeasure = (RolapStoredMeasure)measure;
        RolapStar.Measure starMeasure = (RolapStar.Measure)storedMeasure.getStarMeasure();
        assert (starMeasure != null);
        return starMeasure.getStar();
    }

    private Pair<BitKey, StarPredicate> predicateFromTupleList(List<List<Member>> tupleList, RolapMeasure measure, Evaluator evaluator) {
        if (measure.isCalculated()) {
            return null;
        }
        RolapCube cube = ((RolapStoredMeasure)measure).getCube();
        int starColumnCount = CompoundPredicateInfo.getStar(measure).getColumnCount();
        BitKey compoundBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        compoundBitKey.clear();
        LinkedHashMap<BitKey, List<RolapCubeMember[]>> compoundGroupMap = new LinkedHashMap<BitKey, List<RolapCubeMember[]>>();
        boolean unsatisfiable = this.makeCompoundGroup(starColumnCount, cube, tupleList, compoundGroupMap);
        if (unsatisfiable) {
            this.satisfiable = false;
            return null;
        }
        StarPredicate compoundPredicate = this.makeCompoundPredicate(compoundGroupMap, cube, evaluator);
        if (compoundPredicate != null) {
            for (BitKey bitKey : compoundGroupMap.keySet()) {
                compoundBitKey = compoundBitKey.or(bitKey);
            }
        }
        return Pair.of(compoundBitKey, compoundPredicate);
    }

    private boolean makeCompoundGroup(int starColumnCount, RolapCube baseCube, List<List<Member>> aggregationList, Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap) {
        int unsatisfiableTupleCount = 0;
        for (List<Member> aggregation : aggregationList) {
            if (aggregation.size() <= 0 || !(aggregation.get(0) instanceof RolapCubeMember) && !(aggregation.get(0) instanceof VisualTotalsFunDef.VisualTotalMember)) {
                ++unsatisfiableTupleCount;
                continue;
            }
            BitKey bitKey = BitKey.Factory.makeBitKey(starColumnCount);
            RolapCubeMember[] tuple = new RolapCubeMember[aggregation.size()];
            int i = 0;
            for (Member member : aggregation) {
                tuple[i] = member instanceof VisualTotalsFunDef.VisualTotalMember ? (RolapCubeMember)((VisualTotalsFunDef.VisualTotalMember)member).getMember() : (RolapCubeMember)member;
                ++i;
            }
            boolean tupleUnsatisfiable = false;
            for (RolapCubeMember member : tuple) {
                tupleUnsatisfiable = this.makeCompoundGroupForMember(member, baseCube, bitKey);
                if (!tupleUnsatisfiable) continue;
                ++unsatisfiableTupleCount;
                break;
            }
            if (tupleUnsatisfiable || bitKey.isEmpty()) continue;
            this.addTupleToCompoundGroupMap(tuple, bitKey, compoundGroupMap);
        }
        return unsatisfiableTupleCount == aggregationList.size();
    }

    private void addTupleToCompoundGroupMap(RolapCubeMember[] tuple, BitKey bitKey, Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap) {
        List<RolapCubeMember[]> compoundGroup = compoundGroupMap.get(bitKey);
        if (compoundGroup == null) {
            compoundGroup = new ArrayList<RolapCubeMember[]>();
            compoundGroupMap.put(bitKey, compoundGroup);
        }
        compoundGroup.add(tuple);
    }

    private boolean makeCompoundGroupForMember(RolapCubeMember member, RolapCube baseCube, BitKey bitKey) {
        boolean memberUnsatisfiable = false;
        for (RolapCubeMember levelMember = member; levelMember != null; levelMember = levelMember.getParentMember()) {
            RolapCubeLevel level = levelMember.getLevel();
            if (level.isAll()) continue;
            RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
            if (column != null) {
                bitKey.set(column.getBitPosition());
                continue;
            }
            memberUnsatisfiable = true;
            break;
        }
        return memberUnsatisfiable;
    }

    private StarPredicate makeCompoundPredicate(Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap, RolapCube baseCube, Evaluator evaluator) {
        ArrayList<StarPredicate> compoundPredicateList = new ArrayList<StarPredicate>();
        for (List<RolapCubeMember[]> group : compoundGroupMap.values()) {
            StarPredicate compoundGroupPredicate = null;
            for (RolapCubeMember[] tuple : group) {
                StarPredicate tuplePredicate = null;
                for (RolapCubeMember member : tuple) {
                    tuplePredicate = this.makePredicateForMember(member, baseCube, tuplePredicate, evaluator);
                }
                if (tuplePredicate == null) continue;
                if (compoundGroupPredicate == null) {
                    compoundGroupPredicate = tuplePredicate;
                    continue;
                }
                compoundGroupPredicate = compoundGroupPredicate.or(tuplePredicate);
            }
            if (compoundGroupPredicate == null) continue;
            compoundPredicateList.add(compoundGroupPredicate);
        }
        StarPredicate compoundPredicate = null;
        if (compoundPredicateList.size() > 1) {
            compoundPredicate = new OrPredicate(compoundPredicateList);
        } else if (compoundPredicateList.size() == 1) {
            compoundPredicate = (StarPredicate)compoundPredicateList.get(0);
        }
        return compoundPredicate;
    }

    private StarPredicate makePredicateForMember(RolapCubeMember member, RolapCube baseCube, StarPredicate memberPredicate, Evaluator evaluator) {
        while (member != null) {
            RolapCubeLevel level = member.getLevel();
            if (!level.isAll()) {
                RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
                StarPredicate addPredicate = null;
                addPredicate = !member.isCalculated() ? new ValueColumnPredicate(column, member.getKey()) : this.makeCalculatedMemberPredicate(member, baseCube, evaluator);
                memberPredicate = memberPredicate == null ? addPredicate : memberPredicate.and(addPredicate);
            }
            if (member.getLevel().isUnique()) break;
            member = member.getParentMember();
        }
        return memberPredicate;
    }

    private StarPredicate makeCalculatedMemberPredicate(RolapCubeMember member, RolapCube baseCube, Evaluator evaluator) {
        assert (member.getExpression() instanceof ResolvedFunCall);
        ResolvedFunCall fun = (ResolvedFunCall)member.getExpression();
        Exp exp = fun.getArg(0);
        Type type = exp.getType();
        if (type instanceof SetType) {
            return this.makeSetPredicate(exp, evaluator);
        }
        if (type.getArity() == 1) {
            return this.makeUnaryPredicate(member, baseCube, evaluator);
        }
        throw MondrianResource.instance().UnsupportedCalculatedMember.ex(member.getName(), null);
    }

    private StarPredicate makeUnaryPredicate(RolapCubeMember member, RolapCube baseCube, Evaluator evaluator) {
        List<Member> expandedMemberList = SqlConstraintUtils.expandSupportedCalculatedMember(member, evaluator);
        for (Member checkMember : expandedMemberList) {
            if (checkMember != null && !checkMember.isCalculated() && checkMember instanceof RolapCubeMember) continue;
            throw MondrianResource.instance().UnsupportedCalculatedMember.ex(member.getName(), null);
        }
        ArrayList<StarPredicate> predicates = new ArrayList<StarPredicate>(expandedMemberList.size());
        for (Member iMember : expandedMemberList) {
            RolapCubeMember iCubeMember = (RolapCubeMember)iMember;
            RolapCubeLevel iLevel = iCubeMember.getLevel();
            RolapStar.Column iColumn = iLevel.getBaseStarKeyColumn(baseCube);
            Object iKey = iCubeMember.getKey();
            ValueColumnPredicate iPredicate = new ValueColumnPredicate(iColumn, iKey);
            predicates.add(iPredicate);
        }
        StarPredicate r = null;
        r = predicates.size() == 1 ? (StarPredicate)predicates.get(0) : new OrPredicate(predicates);
        return r;
    }

    private StarPredicate makeSetPredicate(Exp exp, Evaluator evaluator) {
        TupleIterable evaluatedSet = evaluator.getSetEvaluator(exp, true).evaluateTupleIterable();
        ArrayList<StarPredicate> orList = new ArrayList<StarPredicate>();
        OrPredicate orPredicate = null;
        for (List complexSetItem : evaluatedSet) {
            ArrayList<StarPredicate> andList = new ArrayList<StarPredicate>();
            for (Member singleSetItem : complexSetItem) {
                List<List<Member>> singleItemList = Collections.singletonList(Collections.singletonList(singleSetItem));
                StarPredicate singlePredicate = this.predicateFromTupleList(singleItemList, this.measure, evaluator).getValue();
                andList.add(singlePredicate);
            }
            AndPredicate andPredicate = new AndPredicate(andList);
            orList.add(andPredicate);
            orPredicate = new OrPredicate(orList);
        }
        return orPredicate;
    }
}

