/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.changed.PDIObserver;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.core.listeners.FilenameChangedListener;
import org.pentaho.di.core.listeners.NameChangedListener;
import org.pentaho.di.core.logging.ChannelLogTable;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;

public class AbstractMetaTest {
    AbstractMeta meta;
    ObjectId objectId;
    Repository repo;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)DatabasePluginType.getInstance());
        PluginRegistry.init();
    }

    @Before
    public void setUp() throws Exception {
        this.meta = new AbstractMetaStub();
        this.objectId = (ObjectId)Mockito.mock(ObjectId.class);
        this.repo = (Repository)Mockito.mock(Repository.class);
    }

    @Test
    public void testGetParent() {
        Assert.assertNull((Object)this.meta.getParent());
    }

    @Test
    public void testGetSetObjectId() throws Exception {
        Assert.assertNull((Object)this.meta.getObjectId());
        this.meta.setObjectId(this.objectId);
        Assert.assertEquals((Object)this.objectId, (Object)this.meta.getObjectId());
    }

    @Test
    public void testGetSetContainerObjectId() throws Exception {
        Assert.assertNull((Object)this.meta.getContainerObjectId());
        this.meta.setCarteObjectId("myObjectId");
        Assert.assertEquals((Object)"myObjectId", (Object)this.meta.getContainerObjectId());
    }

    @Test
    public void testGetSetName() throws Exception {
        Assert.assertNull((Object)this.meta.getName());
        this.meta.setName("myName");
        Assert.assertEquals((Object)"myName", (Object)this.meta.getName());
    }

    @Test
    public void testGetSetDescription() throws Exception {
        Assert.assertNull((Object)this.meta.getDescription());
        this.meta.setDescription("I am a meta");
        Assert.assertEquals((Object)"I am a meta", (Object)this.meta.getDescription());
    }

    @Test
    public void testGetSetExtendedDescription() throws Exception {
        Assert.assertNull((Object)this.meta.getExtendedDescription());
        this.meta.setExtendedDescription("I am a meta");
        Assert.assertEquals((Object)"I am a meta", (Object)this.meta.getExtendedDescription());
    }

    @Test
    public void testNameFromFilename() throws Exception {
        Assert.assertNull((Object)this.meta.getName());
        Assert.assertNull((Object)this.meta.getFilename());
        this.meta.nameFromFilename();
        Assert.assertNull((Object)this.meta.getName());
        this.meta.setFilename("/path/to/my/file 2.ktr");
        this.meta.nameFromFilename();
        Assert.assertEquals((Object)"file 2", (Object)this.meta.getName());
    }

    @Test
    public void testGetSetFilename() throws Exception {
        Assert.assertNull((Object)this.meta.getFilename());
        this.meta.setFilename("myfile");
        Assert.assertEquals((Object)"myfile", (Object)this.meta.getFilename());
    }

    @Test
    public void testGetSetRepositoryDirectory() throws Exception {
        Assert.assertNull((Object)this.meta.getRepositoryDirectory());
        RepositoryDirectoryInterface dir = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        this.meta.setRepositoryDirectory(dir);
        Assert.assertEquals((Object)dir, (Object)this.meta.getRepositoryDirectory());
    }

    @Test
    public void testGetSetRepository() throws Exception {
        Assert.assertNull((Object)this.meta.getRepository());
        this.meta.setRepository(this.repo);
        Assert.assertEquals((Object)this.repo, (Object)this.meta.getRepository());
    }

    @Test
    public void testGetSetDatabase() throws Exception {
        Assert.assertEquals((long)0L, (long)this.meta.nrDatabases());
        Assert.assertNull((Object)this.meta.getDatabases());
        Assert.assertFalse((boolean)this.meta.haveConnectionsChanged());
        this.meta.clear();
        Assert.assertTrue((boolean)this.meta.getDatabases().isEmpty());
        Assert.assertEquals((long)0L, (long)this.meta.nrDatabases());
        Assert.assertFalse((boolean)this.meta.haveConnectionsChanged());
        DatabaseMeta db1 = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)db1.getName()).thenReturn((Object)"db1");
        Mockito.when((Object)db1.getDisplayName()).thenReturn((Object)"db1");
        this.meta.addDatabase(db1);
        Assert.assertEquals((long)1L, (long)this.meta.nrDatabases());
        Assert.assertFalse((boolean)this.meta.getDatabases().isEmpty());
        Assert.assertTrue((boolean)this.meta.haveConnectionsChanged());
        DatabaseMeta db2 = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)db2.getName()).thenReturn((Object)"db2");
        Mockito.when((Object)db2.getDisplayName()).thenReturn((Object)"db2");
        this.meta.addDatabase(db2);
        Assert.assertEquals((long)2L, (long)this.meta.nrDatabases());
        this.meta.addDatabase(db1, true);
        Assert.assertEquals((long)2L, (long)this.meta.nrDatabases());
        this.meta.addOrReplaceDatabase(db1);
        Assert.assertEquals((long)2L, (long)this.meta.nrDatabases());
        this.meta.addDatabase(db2, false);
        Assert.assertEquals((long)2L, (long)this.meta.nrDatabases());
        DatabaseMeta db3 = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)db3.getName()).thenReturn((Object)"db3");
        this.meta.addDatabase(db3, false);
        Assert.assertEquals((long)3L, (long)this.meta.nrDatabases());
        Assert.assertEquals((Object)db1, (Object)this.meta.getDatabase(0));
        Assert.assertEquals((long)0L, (long)this.meta.indexOfDatabase(db1));
        Assert.assertEquals((Object)db2, (Object)this.meta.getDatabase(1));
        Assert.assertEquals((long)1L, (long)this.meta.indexOfDatabase(db2));
        Assert.assertEquals((Object)db3, (Object)this.meta.getDatabase(2));
        Assert.assertEquals((long)2L, (long)this.meta.indexOfDatabase(db3));
        DatabaseMeta db4 = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)db4.getName()).thenReturn((Object)"db4");
        this.meta.addDatabase(3, db4);
        Assert.assertEquals((long)4L, (long)this.meta.nrDatabases());
        Assert.assertEquals((Object)db4, (Object)this.meta.getDatabase(3));
        Assert.assertEquals((long)3L, (long)this.meta.indexOfDatabase(db4));
        this.meta.removeDatabase(3);
        Assert.assertEquals((long)3L, (long)this.meta.nrDatabases());
        Assert.assertTrue((boolean)this.meta.haveConnectionsChanged());
        this.meta.clearChangedDatabases();
        Assert.assertFalse((boolean)this.meta.haveConnectionsChanged());
        List<DatabaseMeta> list = Arrays.asList(db2, db1);
        this.meta.setDatabases(list);
        Assert.assertEquals((long)2L, (long)this.meta.nrDatabases());
        Assert.assertEquals((Object)"db1", (Object)this.meta.getDatabaseNames()[0]);
        Assert.assertEquals((long)0L, (long)this.meta.indexOfDatabase(db1));
        this.meta.removeDatabase(-1);
        Assert.assertEquals((long)2L, (long)this.meta.nrDatabases());
        this.meta.removeDatabase(2);
        Assert.assertEquals((long)2L, (long)this.meta.nrDatabases());
        Assert.assertEquals((Object)db1, (Object)this.meta.findDatabase("db1"));
        Assert.assertNull((Object)this.meta.findDatabase(""));
    }

    @Test(expected=KettlePluginException.class)
    public void testGetSetImportMetaStore() throws Exception {
        Assert.assertNull((Object)this.meta.getMetaStore());
        this.meta.importFromMetaStore();
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.meta.setMetaStore(metastore);
        Assert.assertEquals((Object)metastore, (Object)this.meta.getMetaStore());
        this.meta.importFromMetaStore();
        IMetaStoreElementType elementType = (IMetaStoreElementType)Mockito.mock(IMetaStoreElementType.class);
        Mockito.when((Object)metastore.getElementTypeByName("pentaho", "Database connection")).thenReturn((Object)elementType);
        Mockito.when((Object)metastore.getElements("pentaho", elementType)).thenReturn(new ArrayList());
        this.meta.importFromMetaStore();
        IMetaStoreElement element = (IMetaStoreElement)Mockito.mock(IMetaStoreElement.class);
        Mockito.when((Object)metastore.getElements("pentaho", elementType)).thenReturn(Arrays.asList(element));
        this.meta.importFromMetaStore();
    }

    @Test
    public void testAddNameChangedListener() throws Exception {
        this.meta.fireNameChangedListeners("a", "a");
        this.meta.fireNameChangedListeners("a", "b");
        this.meta.addNameChangedListener(null);
        this.meta.fireNameChangedListeners("a", "b");
        NameChangedListener listener = (NameChangedListener)Mockito.mock(NameChangedListener.class);
        this.meta.addNameChangedListener(listener);
        this.meta.fireNameChangedListeners("b", "a");
        ((NameChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).nameChanged((Object)this.meta, "b", "a");
        this.meta.removeNameChangedListener(null);
        this.meta.removeNameChangedListener(listener);
        this.meta.fireNameChangedListeners("b", "a");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testAddFilenameChangedListener() throws Exception {
        this.meta.fireFilenameChangedListeners("a", "a");
        this.meta.fireFilenameChangedListeners("a", "b");
        this.meta.addFilenameChangedListener(null);
        this.meta.fireFilenameChangedListeners("a", "b");
        FilenameChangedListener listener = (FilenameChangedListener)Mockito.mock(FilenameChangedListener.class);
        this.meta.addFilenameChangedListener(listener);
        this.meta.fireFilenameChangedListeners("b", "a");
        ((FilenameChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).filenameChanged((Object)this.meta, "b", "a");
        this.meta.removeFilenameChangedListener(null);
        this.meta.removeFilenameChangedListener(listener);
        this.meta.fireFilenameChangedListeners("b", "a");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testAddRemoveFireContentChangedListener() throws Exception {
        Assert.assertTrue((boolean)this.meta.getContentChangedListeners().isEmpty());
        ContentChangedListener listener = (ContentChangedListener)Mockito.mock(ContentChangedListener.class);
        this.meta.addContentChangedListener(listener);
        Assert.assertFalse((boolean)this.meta.getContentChangedListeners().isEmpty());
        this.meta.fireContentChangedListeners();
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).contentChanged(Matchers.anyObject());
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).contentSafe(Matchers.anyObject());
        this.meta.fireContentChangedListeners(true);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.anyObject());
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).contentSafe(Matchers.anyObject());
        this.meta.fireContentChangedListeners(false);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.anyObject());
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).contentSafe(Matchers.anyObject());
        this.meta.removeContentChangedListener(listener);
        Assert.assertTrue((boolean)this.meta.getContentChangedListeners().isEmpty());
    }

    @Test
    public void testAddOrReplaceSlaveServer() throws Exception {
        Assert.assertNull((Object)this.meta.getSlaveServers());
        ArrayList slaveServers = new ArrayList();
        this.meta.setSlaveServers(slaveServers);
        Assert.assertNotNull((Object)this.meta.getSlaveServers());
        SlaveServer slaveServer = (SlaveServer)Mockito.mock(SlaveServer.class);
        this.meta.addOrReplaceSlaveServer(slaveServer);
        Assert.assertFalse((boolean)this.meta.getSlaveServers().isEmpty());
        this.meta.addOrReplaceSlaveServer(slaveServer);
        Assert.assertEquals((long)1L, (long)this.meta.getSlaveServerNames().length);
        Assert.assertNull((Object)this.meta.findSlaveServer(null));
        Assert.assertNull((Object)this.meta.findSlaveServer(""));
        Mockito.when((Object)slaveServer.getName()).thenReturn((Object)"ss1");
        Assert.assertEquals((Object)slaveServer, (Object)this.meta.findSlaveServer("ss1"));
    }

    @Test
    public void testAddRemoveViewUndo() throws Exception {
        Assert.assertEquals((long)0L, (long)this.meta.getUndoSize());
        this.meta.clearUndo();
        Assert.assertEquals((long)0L, (long)this.meta.getUndoSize());
        Assert.assertEquals((long)0L, (long)this.meta.getMaxUndo());
        this.meta.setMaxUndo(3);
        Assert.assertEquals((long)3L, (long)this.meta.getMaxUndo());
        Assert.assertNull((Object)this.meta.viewThisUndo());
        Assert.assertNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNull((Object)this.meta.viewNextUndo());
        Assert.assertNull((Object)this.meta.previousUndo());
        Assert.assertNull((Object)this.meta.nextUndo());
        StepMeta fromMeta = (StepMeta)Mockito.mock(StepMeta.class);
        StepMeta toMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Object[] from = new Object[]{fromMeta};
        Object[] to = new Object[]{toMeta};
        int[] pos = new int[]{};
        Point[] prev = new Point[]{};
        Point[] curr = new Point[]{};
        this.meta.addUndo(from, to, pos, prev, curr, 2, false);
        Assert.assertNotNull((Object)this.meta.viewThisUndo());
        Assert.assertNotNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNull((Object)this.meta.viewNextUndo());
        this.meta.addUndo(from, to, pos, prev, curr, 1, false);
        Assert.assertNotNull((Object)this.meta.viewThisUndo());
        Assert.assertNotNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNull((Object)this.meta.viewNextUndo());
        TransAction action = this.meta.previousUndo();
        Assert.assertNotNull((Object)action);
        Assert.assertEquals((long)1L, (long)action.getType());
        Assert.assertNotNull((Object)this.meta.viewThisUndo());
        Assert.assertNotNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNotNull((Object)this.meta.viewNextUndo());
        this.meta.addUndo(from, to, pos, prev, curr, 3, false);
        this.meta.addUndo(from, to, pos, prev, curr, 4, false);
        Assert.assertNotNull((Object)this.meta.previousUndo());
        Assert.assertNotNull((Object)this.meta.nextUndo());
        this.meta.setMaxUndo(1);
        Assert.assertEquals((long)1L, (long)this.meta.getUndoSize());
        this.meta.addUndo(from, to, pos, prev, curr, 2, false);
    }

    @Test
    public void testGetSetAttributes() throws Exception {
        Assert.assertNull((Object)this.meta.getAttributesMap());
        HashMap attributesMap = new HashMap();
        this.meta.setAttributesMap(attributesMap);
        Assert.assertNull((Object)this.meta.getAttributes("group1"));
        HashMap<String, String> group1Attributes = new HashMap<String, String>();
        attributesMap.put("group1", group1Attributes);
        Assert.assertEquals(group1Attributes, (Object)this.meta.getAttributes("group1"));
        Assert.assertNull((Object)this.meta.getAttribute("group1", "attr1"));
        group1Attributes.put("attr1", "value1");
        Assert.assertEquals((Object)"value1", (Object)this.meta.getAttribute("group1", "attr1"));
        Assert.assertNull((Object)this.meta.getAttribute("group1", "attr2"));
        this.meta.setAttribute("group1", "attr2", "value2");
        Assert.assertEquals((Object)"value2", (Object)this.meta.getAttribute("group1", "attr2"));
        this.meta.setAttributes("group2", null);
        Assert.assertNull((Object)this.meta.getAttributes("group2"));
        this.meta.setAttribute("group2", "attr3", "value3");
        Assert.assertNull((Object)this.meta.getAttribute("group3", "attr4"));
    }

    @Test
    public void testNotes() throws Exception {
        Assert.assertNull((Object)this.meta.getNotes());
        this.meta.clear();
        Assert.assertNotNull((Object)this.meta.getNotes());
        Assert.assertTrue((boolean)this.meta.getNotes().isEmpty());
        IndexOutOfBoundsException e = null;
        try {
            Assert.assertNull((Object)this.meta.getNote(0));
        }
        catch (IndexOutOfBoundsException ioobe) {
            e = ioobe;
        }
        Assert.assertNotNull((Object)e);
        Assert.assertNull((Object)this.meta.getNote(20, 20));
        NotePadMeta note1 = (NotePadMeta)Mockito.mock(NotePadMeta.class);
        this.meta.removeNote(0);
        Assert.assertFalse((boolean)this.meta.hasChanged());
        this.meta.addNote(note1);
        Assert.assertTrue((boolean)this.meta.hasChanged());
        NotePadMeta note2 = (NotePadMeta)Mockito.mock(NotePadMeta.class);
        Mockito.when((Object)note2.getLocation()).thenReturn((Object)new Point(0, 0));
        Mockito.when((Object)note2.isSelected()).thenReturn((Object)true);
        this.meta.addNote(1, note2);
        Assert.assertEquals((Object)note2, (Object)this.meta.getNote(0, 0));
        List selectedNotes = this.meta.getSelectedNotes();
        Assert.assertNotNull((Object)selectedNotes);
        Assert.assertEquals((long)1L, (long)selectedNotes.size());
        Assert.assertEquals((Object)note2, selectedNotes.get(0));
        Assert.assertEquals((long)1L, (long)this.meta.indexOfNote(note2));
        this.meta.removeNote(2);
        Assert.assertEquals((long)2L, (long)this.meta.nrNotes());
        this.meta.removeNote(1);
        Assert.assertEquals((long)1L, (long)this.meta.nrNotes());
        Assert.assertTrue((boolean)this.meta.haveNotesChanged());
        this.meta.clearChanged();
        Assert.assertFalse((boolean)this.meta.haveNotesChanged());
        this.meta.addNote(1, note2);
        this.meta.lowerNote(1);
        Assert.assertTrue((boolean)this.meta.haveNotesChanged());
        this.meta.clearChanged();
        Assert.assertFalse((boolean)this.meta.haveNotesChanged());
        this.meta.raiseNote(0);
        Assert.assertTrue((boolean)this.meta.haveNotesChanged());
        this.meta.clearChanged();
        Assert.assertFalse((boolean)this.meta.haveNotesChanged());
        int[] indexes = this.meta.getNoteIndexes(Arrays.asList(note1, note2));
        Assert.assertNotNull((Object)indexes);
        Assert.assertEquals((long)2L, (long)indexes.length);
    }

    @Test
    public void testCopyVariablesFrom() throws Exception {
        Assert.assertNull((Object)this.meta.getVariable("var1"));
        VariableSpace vars = (VariableSpace)Mockito.mock(VariableSpace.class);
        Mockito.when((Object)vars.getVariable("var1")).thenReturn((Object)"x");
        Mockito.when((Object)vars.listVariables()).thenReturn((Object)new String[]{"var1"});
        this.meta.copyVariablesFrom(vars);
        Assert.assertEquals((Object)"x", (Object)this.meta.getVariable("var1", "y"));
    }

    @Test
    public void testEnvironmentSubstitute() throws Exception {
        VariableSpace vars = (VariableSpace)Mockito.mock(VariableSpace.class);
        this.meta.setInternalKettleVariables(vars);
        this.meta.environmentSubstitute("${param}");
        ((VariableSpace)Mockito.verify((Object)vars, (VerificationMode)Mockito.times((int)1))).environmentSubstitute("${param}");
        String[] params = new String[]{"${param}"};
        this.meta.environmentSubstitute(params);
        ((VariableSpace)Mockito.verify((Object)vars, (VerificationMode)Mockito.times((int)1))).environmentSubstitute(params);
    }

    @Test
    public void testFieldSubstitute() throws Exception {
        VariableSpace vars = (VariableSpace)Mockito.mock(VariableSpace.class);
        this.meta.setInternalKettleVariables(vars);
        RowMetaInterface rowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Object[] data = new Object[]{};
        this.meta.fieldSubstitute("?{param}", rowMeta, data);
        ((VariableSpace)Mockito.verify((Object)vars, (VerificationMode)Mockito.times((int)1))).fieldSubstitute("?{param}", rowMeta, data);
    }

    @Test
    public void testGetSetParentVariableSpace() throws Exception {
        Assert.assertNull((Object)this.meta.getParentVariableSpace());
        VariableSpace variableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        this.meta.setParentVariableSpace(variableSpace);
        Assert.assertEquals((Object)variableSpace, (Object)this.meta.getParentVariableSpace());
    }

    @Test
    public void testGetSetVariable() throws Exception {
        Assert.assertNull((Object)this.meta.getVariable("var1"));
        Assert.assertEquals((Object)"x", (Object)this.meta.getVariable("var1", "x"));
        this.meta.setVariable("var1", "y");
        Assert.assertEquals((Object)"y", (Object)this.meta.getVariable("var1", "x"));
    }

    @Test
    public void testGetSetParameterValue() throws Exception {
        Assert.assertNull((Object)this.meta.getParameterValue("var1"));
        Assert.assertNull((Object)this.meta.getParameterDefault("var1"));
        Assert.assertNull((Object)this.meta.getParameterDescription("var1"));
        this.meta.setParameterValue("var1", "y");
        Assert.assertNull((Object)this.meta.getParameterValue("var1"));
        Assert.assertNull((Object)this.meta.getParameterDefault("var1"));
        Assert.assertNull((Object)this.meta.getParameterDescription("var1"));
        this.meta.addParameterDefinition("var2", "z", "My Description");
        Assert.assertEquals((Object)"", (Object)this.meta.getParameterValue("var2"));
        Assert.assertEquals((Object)"z", (Object)this.meta.getParameterDefault("var2"));
        Assert.assertEquals((Object)"My Description", (Object)this.meta.getParameterDescription("var2"));
        this.meta.setParameterValue("var2", "y");
        Assert.assertEquals((Object)"y", (Object)this.meta.getParameterValue("var2"));
        Assert.assertEquals((Object)"z", (Object)this.meta.getParameterDefault("var2"));
        String[] params = this.meta.listParameters();
        Assert.assertNotNull((Object)params);
        this.meta.clearParameters();
        Assert.assertEquals((Object)"", (Object)this.meta.getParameterValue("var2"));
        this.meta.eraseParameters();
        Assert.assertNull((Object)this.meta.getParameterValue("var1"));
        NamedParamsDefault newParams = new NamedParamsDefault();
        newParams.addParameterDefinition("var3", "default", "description");
        newParams.setParameterValue("var3", "a");
        this.meta.copyParametersFrom((NamedParams)newParams);
        this.meta.activateParameters();
        Assert.assertEquals((Object)"default", (Object)this.meta.getParameterDefault("var3"));
    }

    @Test
    public void testGetSetLogLevel() throws Exception {
        Assert.assertEquals((Object)LogLevel.BASIC, (Object)this.meta.getLogLevel());
        this.meta.setLogLevel(LogLevel.DEBUG);
        Assert.assertEquals((Object)LogLevel.DEBUG, (Object)this.meta.getLogLevel());
    }

    @Test
    public void testGetSetSharedObjectsFile() throws Exception {
        Assert.assertNull((Object)this.meta.getSharedObjectsFile());
        this.meta.setSharedObjectsFile("mySharedObjects");
        Assert.assertEquals((Object)"mySharedObjects", (Object)this.meta.getSharedObjectsFile());
    }

    @Test
    public void testGetSetSharedObjects() throws Exception {
        Assert.assertNotNull((Object)this.meta.getSharedObjects());
        SharedObjects sharedObjects = (SharedObjects)Mockito.mock(SharedObjects.class);
        this.meta.setSharedObjects(sharedObjects);
        Assert.assertEquals((Object)sharedObjects, (Object)this.meta.getSharedObjects());
        this.meta.setSharedObjects(null);
        AbstractMeta spyMeta = (AbstractMeta)Mockito.spy((Object)this.meta);
        Mockito.when((Object)spyMeta.environmentSubstitute(Matchers.anyString())).thenThrow(new Class[]{KettleException.class});
        Assert.assertNull((Object)spyMeta.getSharedObjects());
    }

    @Test
    public void testGetSetCreatedDate() throws Exception {
        Assert.assertNull((Object)this.meta.getCreatedDate());
        Date now = Calendar.getInstance().getTime();
        this.meta.setCreatedDate(now);
        Assert.assertEquals((Object)now, (Object)this.meta.getCreatedDate());
    }

    @Test
    public void testGetSetCreatedUser() throws Exception {
        Assert.assertNull((Object)this.meta.getCreatedUser());
        this.meta.setCreatedUser("joe");
        Assert.assertEquals((Object)"joe", (Object)this.meta.getCreatedUser());
    }

    @Test
    public void testGetSetModifiedDate() throws Exception {
        Assert.assertNull((Object)this.meta.getModifiedDate());
        Date now = Calendar.getInstance().getTime();
        this.meta.setModifiedDate(now);
        Assert.assertEquals((Object)now, (Object)this.meta.getModifiedDate());
    }

    @Test
    public void testGetSetModifiedUser() throws Exception {
        Assert.assertNull((Object)this.meta.getModifiedUser());
        this.meta.setModifiedUser("joe");
        Assert.assertEquals((Object)"joe", (Object)this.meta.getModifiedUser());
    }

    @Test
    public void testAddDeleteModifyObserver() throws Exception {
        this.meta.deleteObserver(null);
        PDIObserver observer = (PDIObserver)Mockito.mock(PDIObserver.class);
        this.meta.addObserver(observer);
        Object event = new Object();
        this.meta.notifyObservers(event);
        ((PDIObserver)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).update((ChangedFlagInterface)this.meta, event);
        this.meta.setChanged(true);
        this.meta.notifyObservers(event);
        ((PDIObserver)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).update((ChangedFlagInterface)Matchers.any(ChangedFlagInterface.class), Matchers.anyObject());
    }

    @Test
    public void testGetRegistrationDate() throws Exception {
        Assert.assertNull((Object)this.meta.getRegistrationDate());
    }

    @Test
    public void testGetObjectNameCopyRevision() throws Exception {
        Assert.assertNull((Object)this.meta.getObjectName());
        this.meta.setName("x");
        Assert.assertEquals((Object)"x", (Object)this.meta.getObjectName());
        Assert.assertNull((Object)this.meta.getObjectCopy());
        Assert.assertNull((Object)this.meta.getObjectRevision());
        ObjectRevision rev = (ObjectRevision)Mockito.mock(ObjectRevision.class);
        this.meta.setObjectRevision(rev);
        Assert.assertEquals((Object)rev, (Object)this.meta.getObjectRevision());
    }

    @Test
    public void testHasMissingPlugins() throws Exception {
        Assert.assertFalse((boolean)this.meta.hasMissingPlugins());
    }

    @Test
    public void testGetSetPrivateDatabases() throws Exception {
        Assert.assertNull((Object)this.meta.getPrivateDatabases());
        HashSet dbs = new HashSet();
        this.meta.setPrivateDatabases(dbs);
        Assert.assertEquals(dbs, (Object)this.meta.getPrivateDatabases());
    }

    @Test
    public void testGetSetChannelLogTable() throws Exception {
        Assert.assertNull((Object)this.meta.getChannelLogTable());
        ChannelLogTable table = (ChannelLogTable)Mockito.mock(ChannelLogTable.class);
        this.meta.setChannelLogTable(table);
        Assert.assertEquals((Object)table, (Object)this.meta.getChannelLogTable());
    }

    @Test
    public void testGetEmbeddedMetaStore() {
        Assert.assertNotNull((Object)this.meta.getEmbeddedMetaStore());
    }

    @Test
    public void testGetBooleanValueOfVariable() {
        Assert.assertFalse((boolean)this.meta.getBooleanValueOfVariable(null, false));
        Assert.assertTrue((boolean)this.meta.getBooleanValueOfVariable("", true));
        Assert.assertTrue((boolean)this.meta.getBooleanValueOfVariable("true", true));
        Assert.assertFalse((boolean)this.meta.getBooleanValueOfVariable("${myVar}", false));
        this.meta.setVariable("myVar", "Y");
        Assert.assertTrue((boolean)this.meta.getBooleanValueOfVariable("${myVar}", false));
    }

    @Test
    public void testInitializeShareInjectVariables() {
        this.meta.initializeVariablesFrom(null);
        VariableSpace parent = (VariableSpace)Mockito.mock(VariableSpace.class);
        Mockito.when((Object)parent.getVariable("var1")).thenReturn((Object)"x");
        Mockito.when((Object)parent.listVariables()).thenReturn((Object)new String[]{"var1"});
        this.meta.initializeVariablesFrom(parent);
        Assert.assertEquals((Object)"x", (Object)this.meta.getVariable("var1"));
        Assert.assertNotNull((Object)this.meta.listVariables());
        VariableSpace newVars = (VariableSpace)Mockito.mock(VariableSpace.class);
        Mockito.when((Object)newVars.getVariable("var2")).thenReturn((Object)"y");
        Mockito.when((Object)newVars.listVariables()).thenReturn((Object)new String[]{"var2"});
        this.meta.shareVariablesWith(newVars);
        Assert.assertEquals((Object)"y", (Object)this.meta.getVariable("var2"));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("var3", "a");
        props.put("var4", "b");
        this.meta.shareVariablesWith((VariableSpace)new Variables());
        this.meta.injectVariables(props);
        this.meta.initializeVariablesFrom(null);
        Assert.assertEquals((Object)"a", (Object)this.meta.getVariable("var3"));
        Assert.assertEquals((Object)"b", (Object)this.meta.getVariable("var4"));
    }

    @Test
    public void testCanSave() {
        Assert.assertTrue((boolean)this.meta.canSave());
    }

    @Test
    public void testHasChanged() {
        this.meta.clear();
        Assert.assertFalse((boolean)this.meta.hasChanged());
        this.meta.setChanged(true);
        Assert.assertTrue((boolean)this.meta.hasChanged());
    }

    @Test
    public void testShouldOverwrite() {
        Assert.assertTrue((boolean)this.meta.shouldOverwrite(null, null, null, null));
        Props.init((int)0);
        Assert.assertTrue((boolean)this.meta.shouldOverwrite(null, Props.getInstance(), "message", "remember"));
        Props.getInstance().setProperty("AskAboutReplacingDatabases", "Y");
        OverwritePrompter prompter = (OverwritePrompter)Mockito.mock(OverwritePrompter.class);
        Mockito.when((Object)prompter.overwritePrompt("message", "remember", "AskAboutReplacingDatabases")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.meta.shouldOverwrite(prompter, Props.getInstance(), "message", "remember"));
    }

    public static class AbstractMetaStub
    extends AbstractMeta {
        public void setInternalKettleVariables(VariableSpace var) {
            this.variables = var;
        }

        protected void setInternalFilenameKettleVariables(VariableSpace var) {
        }

        protected void setInternalNameKettleVariable(VariableSpace var) {
        }

        public String getXML() throws KettleException {
            return null;
        }

        public String getFileType() {
            return null;
        }

        public String[] getFilterNames() {
            return new String[0];
        }

        public String[] getFilterExtensions() {
            return new String[0];
        }

        public String getDefaultExtension() {
            return null;
        }

        public void saveSharedObjects() throws KettleException {
        }

        public String getLogChannelId() {
            return null;
        }

        public LoggingObjectType getObjectType() {
            return null;
        }

        public boolean isGatheringMetrics() {
            return false;
        }

        public void setGatheringMetrics(boolean b) {
        }

        public void setForcingSeparateLogging(boolean b) {
        }

        public boolean isForcingSeparateLogging() {
            return false;
        }

        public RepositoryObjectType getRepositoryElementType() {
            return null;
        }
    }
}

