/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.attributes.metastore;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.attributes.metastore.EmbeddedMetaStore;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.test.MetaStoreTestBase;

public class EmbeddedMetaStoreTest
extends MetaStoreTestBase {
    private EmbeddedMetaStore metaStore;

    protected void setUp() throws Exception {
        super.setUp();
        this.metaStore = new EmbeddedMetaStore((AttributesInterface)new TestStorage());
        this.metaStore.setName(META_STORE_NAME);
    }

    public void test() throws Exception {
        super.testFunctionality((IMetaStore)this.metaStore);
    }

    public void testParrallelRetrive() throws Exception {
        super.testParallelOneStore((IMetaStore)this.metaStore);
    }

    private class TestStorage
    implements AttributesInterface {
        private Map<String, Map<String, String>> attributesMap = Maps.newHashMap();

        private TestStorage() {
        }

        public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
            this.attributesMap = attributesMap;
        }

        public Map<String, Map<String, String>> getAttributesMap() {
            return this.attributesMap;
        }

        public void setAttribute(String groupName, String key, String value) {
            HashMap attributes = this.getAttributes(groupName);
            if (attributes == null) {
                attributes = Maps.newHashMap();
                this.attributesMap.put(groupName, attributes);
            }
            attributes.put(key, value);
        }

        public void setAttributes(String groupName, Map<String, String> attributes) {
            this.attributesMap.put(groupName, attributes);
        }

        public Map<String, String> getAttributes(String groupName) {
            return this.attributesMap.get(groupName);
        }

        public String getAttribute(String groupName, String key) {
            Map<String, String> attributes = this.attributesMap.get(groupName);
            if (attributes == null) {
                return null;
            }
            return attributes.get(key);
        }
    }
}

