/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionOutputStream;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class CompressionOutputStreamTest {
    public static final String PROVIDER_NAME = "None";
    public CompressionProviderFactory factory = null;
    public CompressionOutputStream outStream = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        CompressionProvider provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(in, provider);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.outStream);
    }

    @Test
    public void getCompressionProvider() {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testClose() throws IOException {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(out, provider);
        this.outStream.close();
    }

    @Test
    public void testWrite() throws IOException {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(out, provider);
        this.outStream.write("Test".getBytes());
    }

    @Test
    public void testAddEntry() throws IOException {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(out, provider);
        this.outStream.addEntry(null, null);
    }

    private static class DummyCompressionOS
    extends CompressionOutputStream {
        public DummyCompressionOS(OutputStream out, CompressionProvider provider) {
            super(out, provider);
        }
    }
}

