/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.gzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.gzip.GZIPCompressionInputStream;
import org.pentaho.di.core.compress.gzip.GZIPCompressionOutputStream;
import org.pentaho.di.core.compress.gzip.GZIPCompressionProvider;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class GZIPCompressionProviderTest {
    public static final String PROVIDER_NAME = "GZip";
    public CompressionProviderFactory factory = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        GZIPCompressionProvider ncp = new GZIPCompressionProvider();
        Assert.assertNotNull((Object)ncp);
    }

    @Test
    public void testGetName() {
        GZIPCompressionProvider provider = (GZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)provider.getName());
    }

    @Test
    public void testGetProviderAttributes() {
        GZIPCompressionProvider provider = (GZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertEquals((Object)"GZIP compression", (Object)provider.getDescription());
        Assert.assertTrue((boolean)provider.supportsInput());
        Assert.assertTrue((boolean)provider.supportsOutput());
        Assert.assertEquals((Object)"gz", (Object)provider.getDefaultExtension());
    }

    @Test
    public void testCreateInputStream() throws IOException {
        GZIPCompressionProvider provider = (GZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        byte[] testBytes = "Test".getBytes();
        gos.write(testBytes);
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        GZIPInputStream gis = new GZIPInputStream(in);
        in = new ByteArrayInputStream(baos.toByteArray());
        GZIPCompressionInputStream ncis = provider.createInputStream((InputStream)in);
        Assert.assertNotNull((Object)ncis);
        GZIPCompressionInputStream ncis2 = provider.createInputStream((InputStream)gis);
        Assert.assertNotNull((Object)ncis2);
    }

    @Test
    public void testCreateOutputStream() throws IOException {
        GZIPCompressionProvider provider = (GZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(out);
        GZIPCompressionOutputStream outStream = new GZIPCompressionOutputStream((OutputStream)out, (CompressionProvider)provider);
        Assert.assertNotNull((Object)outStream);
        out = new ByteArrayOutputStream();
        GZIPCompressionOutputStream ncis = provider.createOutputStream((OutputStream)out);
        Assert.assertNotNull((Object)ncis);
        GZIPCompressionOutputStream ncis2 = provider.createOutputStream((OutputStream)gos);
        Assert.assertNotNull((Object)ncis2);
    }
}

