/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.base.PrivateDatabasesTestTemplate;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.shared.SharedObjects;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JobMetaPrivateDbTest
extends PrivateDatabasesTestTemplate<JobMeta> {
    @Override
    public JobMeta createMeta() {
        return new JobMeta();
    }

    @Override
    public JobMeta fromXml(String xml, SharedObjects fakeSharedObjects) throws Exception {
        JobMeta meta = (JobMeta)Mockito.spy((Object)new JobMeta());
        ((JobMeta)Mockito.doAnswer(this.createInjectingAnswer(meta, fakeSharedObjects)).when((Object)meta)).readSharedObjects();
        Document doc = XMLHandler.loadXMLFile((InputStream)new ByteArrayInputStream(xml.getBytes()), null, (boolean)false, (boolean)false);
        meta.loadXML(XMLHandler.getSubNode((Node)doc, (String)"job"), null, null);
        return meta;
    }

    @Override
    public String toXml(JobMeta meta) {
        return meta.getXML();
    }

    @BeforeClass
    public static void initKettle() throws Exception {
        if (Props.isInitialized()) {
            Props.getInstance().setOnlyUsedConnectionsSavedToXML(false);
        }
        KettleEnvironment.init();
    }

    @Test
    public void onePrivate_TwoShared() throws Exception {
        this.doTest_OnePrivate_TwoShared();
    }

    @Test
    public void noPrivate() throws Exception {
        this.doTest_NoPrivate();
    }

    @Test
    public void onePrivate_NoShared() throws Exception {
        this.doTest_OnePrivate_NoShared();
    }
}

